/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.operator;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Operator;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CursorUtil;
import com.scudata.util.Variant;

public class Mod
extends Operator {
    public Mod() {
        this.priority = 14;
    }

    public void checkValidity() {
        if (this.left == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"%\"" + mm.getMessage("operator.missingLeftOperation"));
        }
        if (this.right == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"%\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this.left.checkValidity();
        this.right.checkValidity();
    }

    public Object calculate(Context ctx) {
        Object o1 = this.left.calculate(ctx);
        Object o2 = this.right.calculate(ctx);
        if (o1 instanceof Sequence) {
            if (o2 instanceof Sequence) {
                return CursorUtil.xor((Sequence)o1, (Sequence)o2);
            }
            if (o2 == null) {
                return o1;
            }
            Sequence seq2 = new Sequence(1);
            seq2.add(o2);
            return CursorUtil.xor((Sequence)o1, seq2);
        }
        if (o2 instanceof Sequence) {
            if (o1 == null) {
                return o2;
            }
            Sequence seq1 = new Sequence(1);
            seq1.add(o1);
            return CursorUtil.xor(seq1, (Sequence)o2);
        }
        return Variant.mod(o1, o2);
    }

    public IArray calculateAll(Context ctx) {
        IArray leftArray = this.left.calculateAll(ctx);
        IArray rightArray = this.right.calculateAll(ctx);
        return leftArray.memberMod(rightArray);
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        IArray leftArray = this.left.calculateAll(ctx, signArray, sign);
        IArray rightArray = this.right.calculateAll(ctx, signArray, sign);
        return leftArray.memberMod(rightArray);
    }

    public IArray calculateRange(Context ctx) {
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray.isMemberEquals(1, 2)) {
            IArray rightArray = this.right.calculateAll(ctx);
            return leftArray.memberMod(rightArray);
        }
        return null;
    }
}

