/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.operator;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Operator;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.Date;

public class Negative
extends Operator {
    public Negative() {
        this.priority = 17;
    }

    public void checkValidity() {
        if (this.right == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"-\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this.right.checkValidity();
    }

    public Object calculate(Context ctx) {
        Object rightResult = this.right.calculate(ctx);
        if (rightResult instanceof Number) {
            return Variant.negate((Number)rightResult);
        }
        if (rightResult == null) {
            return null;
        }
        if (rightResult instanceof Date) {
            return Variant.negate((Date)rightResult);
        }
        if (rightResult instanceof String) {
            return Variant.negate((String)rightResult);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("\"-\"" + mm.getMessage("operator.numberRightOperation"));
    }

    public boolean canCalculateAll() {
        return this.right.canCalculateAll();
    }

    public IArray calculateAll(Context ctx) {
        IArray array = this.right.calculateAll(ctx);
        return array.negate();
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        IArray array = this.right.calculateAll(ctx, signArray, sign);
        return array.negate();
    }
}

