/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.operator;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Operator;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Subtract
extends Operator {
    public Subtract() {
        this.priority = 13;
    }

    public void checkValidity() {
        if (this.left == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"-\"" + mm.getMessage("operator.missingLeftOperation"));
        }
        if (this.right == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"-\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this.left.checkValidity();
        this.right.checkValidity();
    }

    public Object calculate(Context ctx) {
        return Variant.subtract(this.left.calculate(ctx), this.right.calculate(ctx));
    }

    public IArray calculateAll(Context ctx) {
        IArray leftArray = this.left.calculateAll(ctx);
        IArray rightArray = this.right.calculateAll(ctx);
        return leftArray.memberSubtract(rightArray);
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        IArray leftArray = this.left.calculateAll(ctx, signArray, sign);
        IArray rightArray = this.right.calculateAll(ctx, signArray, sign);
        return leftArray.memberSubtract(rightArray);
    }
}

