/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.operator;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Operator;
import com.scudata.resources.EngineMessage;

public class Union
extends Operator {
    public Union() {
        this.priority = 14;
    }

    public void checkValidity() {
        if (this.left == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"&\"" + mm.getMessage("operator.missingLeftOperation"));
        }
        if (this.right == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"&\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this.left.checkValidity();
        this.right.checkValidity();
    }

    public Object calculate(Context ctx) {
        Sequence s2;
        Sequence s1;
        Object o1 = this.left.calculate(ctx);
        Object o2 = this.right.calculate(ctx);
        if (o1 == null) {
            s1 = new Sequence(0);
        } else if (o1 instanceof Sequence) {
            s1 = (Sequence)o1;
        } else {
            s1 = new Sequence(1);
            s1.add(o1);
        }
        if (o2 == null) {
            s2 = new Sequence(0);
        } else if (o2 instanceof Sequence) {
            s2 = (Sequence)o2;
        } else {
            s2 = new Sequence(1);
            s2.add(o2);
        }
        return s1.union(s2, false);
    }
}

