/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.app.common.Segment;
import com.scudata.common.DBConfig;
import com.scudata.common.DBInfo;
import com.scudata.common.DBSession;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class DataSource
implements Serializable {
    private static final long serialVersionUID = -264281029494437404L;
    public static final String ODBC_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final byte DS_RELATIONAL = 0;
    public static final byte DS_ODBC = 1;
    public static final byte DS_ESSBASE = 2;
    public static final byte FROM_LOCAL = 0;
    public static final byte FROM_SYSTEM = 1;
    public static final byte FROM_REMOTE = 2;
    private transient byte fromType = 0;
    public static final String DB_TYPE = "type";
    public static final String DB_TITLE = "title";
    public static final String DB_CHARSET = "charset";
    public static final String DB_CLIENTCHARSET = "clientcharset";
    public static final String DB_CONVERTSQL = "convertsql";
    public static final String DB_CONVERTDATA = "convertdata";
    public static final String DB_DRIVER = "driver";
    public static final String DB_URL = "url";
    public static final String DB_USER = "user";
    public static final String DB_PASSWORD = "password";
    public static final String DB_USESCHEMA = "useschema";
    public static final String DB_EXTEND = "extend";
    public static final String DB_CASESENTENCE = "casesentence";
    public static final String DB_ISADDTILDE = "isaddtilde";
    public static final String ESSBASE_IP = "IP";
    public static final String ESSBASE_USER = "User";
    public static final String ESSBASE_PASSWORD = "Password";
    private DBInfo dbInfo;
    private transient DBSession dbs = null;

    public DataSource(DBConfig dbConfig) {
        this.dbInfo = dbConfig;
    }

    public DBConfig getDBConfig() {
        return (DBConfig)this.dbInfo;
    }

    public DataSource(DBInfo dbInfo) {
        this.dbInfo = dbInfo;
    }

    public DBInfo getDBInfo() {
        return this.dbInfo;
    }

    public String getName() {
        return this.dbInfo.getName();
    }

    public void setName(String name) {
        this.dbInfo.setName(name);
    }

    public DataSource(String config) {
        if (!StringUtils.isValidString(config)) {
            return;
        }
        Segment seg = new Segment(config);
        String val = seg.get(DB_TYPE);
        int dbType = Integer.parseInt(val);
        DBConfig dc = new DBConfig();
        dc.setDBType(dbType);
        dc.setDBCharset(seg.get(DB_CHARSET));
        dc.setClientCharset(seg.get(DB_CLIENTCHARSET));
        dc.setNeedTranSentence(new Boolean(seg.get(DB_CONVERTSQL)));
        dc.setNeedTranContent(new Boolean(seg.get(DB_CONVERTDATA)));
        dc.setDriver(seg.get(DB_DRIVER));
        dc.setUrl(seg.get(DB_URL));
        dc.setUser(seg.get(DB_USER));
        dc.setPassword(seg.get(DB_PASSWORD));
        dc.setUseSchema(new Boolean(seg.get(DB_USESCHEMA)));
        dc.setCaseSentence(new Boolean(seg.get(DB_CASESENTENCE)));
        dc.setExtend(seg.get(DB_EXTEND));
        dc.setAddTilde(new Boolean(seg.get(DB_ISADDTILDE)));
        this.dbInfo = dc;
    }

    public String toString() {
        Segment seg = new Segment();
        DBConfig dc = (DBConfig)this.dbInfo;
        seg.put(DB_TYPE, Integer.toString(dc.getDBType()));
        seg.put(DB_CHARSET, dc.getDBCharset());
        seg.put(DB_CLIENTCHARSET, dc.getClientCharset());
        seg.put(DB_CONVERTSQL, Boolean.toString(dc.getNeedTranSentence()));
        seg.put(DB_CONVERTDATA, Boolean.toString(dc.getNeedTranContent()));
        seg.put(DB_DRIVER, dc.getDriver());
        seg.put(DB_URL, dc.getUrl());
        seg.put(DB_USER, dc.getUser());
        seg.put(DB_PASSWORD, dc.getPassword());
        seg.put(DB_USESCHEMA, Boolean.toString(dc.isUseSchema()));
        seg.put(DB_CASESENTENCE, Boolean.toString(dc.isCaseSentence()));
        seg.put(DB_EXTEND, dc.getExtend());
        seg.put(DB_ISADDTILDE, Boolean.toString(dc.isAddTilde()));
        return seg.toString();
    }

    public DBSession getDBSession() throws Throwable {
        if (this.dbs == null) {
            this.dbs = this.dbInfo.createSessionFactory().getSession();
        }
        if (GV.appMenu != null) {
            GV.appMenu.refreshRecentConn(this.dbInfo.getName());
        }
        return this.dbs;
    }

    public boolean isOLAP() {
        return false;
    }

    public Vector<String> listSchemas() throws Throwable {
        Vector<String> schemas = new Vector<String>();
        if (this.isClosed() || this.isOLAP()) {
            return schemas;
        }
        DatabaseMetaData md = ((Connection)this.getDBSession().getSession()).getMetaData();
        String dbcs = this.dbInfo.getDBCharset();
        String ccs = this.dbInfo.getClientCharset();
        boolean convert = dbcs != null && !dbcs.equals(ccs);
        try (ResultSet rs = null;){
            try {
                rs = md.getSchemas();
                while (rs.next()) {
                    String schema = rs.getString(1);
                    if (convert) {
                        try {
                            schema = new String(schema.getBytes(dbcs), ccs);
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    schemas.add(schema);
                }
            }
            catch (SQLException se) {
                if (se != null) {
                    Logger.debug("Exception occurred while getSchemas():" + se.getMessage());
                }
                if (rs != null) {
                    rs.close();
                }
            }
        }
        return schemas;
    }

    public void close() {
        if (this.dbs == null) {
            return;
        }
        try {
            this.dbs.close();
            this.dbs = null;
            GM.resetFrameTitle("", "");
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        if (this.dbs == null) {
            return true;
        }
        try {
            boolean lb = this.dbs.isClosed();
            return lb;
        }
        catch (Exception x) {
            this.dbs = null;
            return true;
        }
    }

    public void setDSFrom(byte fromType) {
        this.fromType = fromType;
    }

    public byte getDSFrom() {
        return this.fromType;
    }

    public boolean isLocal() {
        return this.fromType == 0;
    }

    public boolean isSystem() {
        return this.fromType == 1;
    }

    public boolean isRemote() {
        return this.fromType == 2;
    }

    public boolean isUseSchema() {
        if (this.dbInfo instanceof DBConfig) {
            return ((DBConfig)this.dbInfo).isUseSchema();
        }
        return false;
    }
}

