/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.common.MessageManager;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IPrjxSheet;
import com.scudata.ide.common.control.JWindowList;
import com.scudata.ide.common.resources.IdeCommonMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class ToolBarWindow
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SheetButton[] buttons = null;
    private final int BUTTON_WIDTH = 180;
    private JLabel bMore = new JLabel();
    private JWindowList winList;
    private boolean preventChange = false;
    private JButton bMin = new JButton();
    private JButton bResume = new JButton();
    private JButton bClose = new JButton();
    private MessageManager mm = IdeCommonMessage.get();
    private static Color SELECTED_BACK_COLOR = Color.WHITE;
    private static Color DEFAULT_BACK_COLOR = new JPanel().getBackground().darker();

    public ToolBarWindow() {
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(0, 30));
        this.setPreferredSize(new Dimension(1, 30));
        this.setVisible(false);
        this.bMin.setToolTipText(this.mm.getMessage("toolbarwindow.min"));
        this.bResume.setToolTipText(this.mm.getMessage("toolbarwindow.resume"));
        this.bClose.setToolTipText(this.mm.getMessage("toolbarwindow.close"));
        this.bMin.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_min1.gif"));
        this.bResume.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_resume1.gif"));
        this.bClose.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_close1.gif"));
        this.bMin.setBorder(null);
        this.bResume.setBorder(null);
        this.bClose.setBorder(null);
        Dimension d = new Dimension(25, 25);
        this.bMin.setMaximumSize(d);
        this.bMin.setPreferredSize(d);
        this.bResume.setMaximumSize(d);
        this.bResume.setPreferredSize(d);
        this.bClose.setMaximumSize(d);
        this.bClose.setPreferredSize(d);
        this.bMore.setBorder(null);
        this.bMin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GV.appSheet.setIcon(true);
                }
                catch (PropertyVetoException e1) {
                    e1.printStackTrace();
                }
                ToolBarWindow.this.refresh();
            }
        });
        this.bMin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolBarWindow.this.bMin.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_min2.gif"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolBarWindow.this.bMin.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_min1.gif"));
            }
        });
        this.bResume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GV.appSheet.setMaximum(false);
                }
                catch (PropertyVetoException e1) {
                    e1.printStackTrace();
                }
                ToolBarWindow.this.refreshTitleButton();
            }
        });
        this.bResume.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolBarWindow.this.bResume.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_resume2.gif"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolBarWindow.this.bResume.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_resume1.gif"));
            }
        });
        this.bClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBarWindow.this.closeSheet(GV.appSheet);
            }
        });
        this.bClose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolBarWindow.this.bClose.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_close2.gif"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolBarWindow.this.bClose.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_close1.gif"));
            }
        });
        this.bMore.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                try {
                    if (e.getButton() != 1) {
                        return;
                    }
                    ToolBarWindow.this.preventChange = true;
                    if (ToolBarWindow.this.winList != null && ToolBarWindow.this.winList.isVisible()) {
                        ToolBarWindow.this.winList.dispose();
                        return;
                    }
                    ToolBarWindow.this.winList = new JWindowList(ToolBarWindow.this.buttons.length){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public boolean showSheet(String filePath) {
                            JInternalFrame[] sheets = GV.appFrame.getAllSheets();
                            if (sheets != null) {
                                int i = 0;
                                while (i < sheets.length) {
                                    IPrjxSheet sheet = (IPrjxSheet)sheets[i];
                                    if (sheet.getSheetTitle().equals(filePath)) {
                                        try {
                                            ToolBarWindow.this.dispSheet(sheet);
                                            ToolBarWindow.this.refreshSheet(sheet);
                                        }
                                        catch (Exception e1) {
                                            GM.showException(GV.appFrame, e1);
                                        }
                                        return true;
                                    }
                                    ++i;
                                }
                            }
                            return false;
                        }

                        @Override
                        public boolean isClickButton() {
                            return ToolBarWindow.this.preventChange;
                        }

                        @Override
                        public ImageIcon getSheetIcon(JInternalFrame sheet) {
                            return ToolBarWindow.this.getSheetIconName(sheet);
                        }
                    };
                    Rectangle rect = ToolBarWindow.this.bMore.getBounds();
                    int x = GM.getAbsolutePos(ToolBarWindow.this.bMore, true);
                    int y = GM.getAbsolutePos(ToolBarWindow.this.bMore, false);
                    ToolBarWindow.this.winList.setPos(x, y + rect.height);
                    ToolBarWindow.this.winList.setVisible(true);
                }
                finally {
                    ToolBarWindow.this.preventChange = false;
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolBarWindow.this.bMore.setBorder(BorderFactory.createEtchedBorder());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolBarWindow.this.bMore.setBorder(null);
            }
        });
    }

    public abstract ImageIcon getSheetIconName(JInternalFrame var1);

    public abstract void closeSheet(IPrjxSheet var1);

    public abstract void dispSheet(IPrjxSheet var1) throws Exception;

    public abstract ImageIcon getLogoImage();

    public boolean isButtonClicking() {
        return this.preventChange;
    }

    public void refresh() {
        GridBagConstraints gbc;
        int size;
        JInternalFrame[] sheets = GV.appFrame.getAllSheets();
        this.removeAll();
        if (sheets == null || sheets.length == 0) {
            this.buttons = null;
            return;
        }
        int width = GV.appFrame.getWidth();
        if (width - 85 > 180 * sheets.length) {
            size = sheets.length;
        } else {
            size = (width - 210) / 180;
            if (size < 0) {
                size = 0;
            }
        }
        JInternalFrame appSheet = GV.appFrame.getActiveSheet();
        size = Math.min(size, sheets.length);
        this.buttons = new SheetButton[size];
        Insets bInsets = new Insets(0, 0, 0, 0);
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i] = new SheetButton(sheets[i]);
            gbc = GM.getGBC(0, i);
            gbc.insets = bInsets;
            if (i == 0) {
                gbc.insets.left = 2;
            }
            this.add((Component)this.buttons[i], gbc);
            this.buttons[i].setSelected(sheets[i] == appSheet);
            ++i;
        }
        int otherSize = sheets.length - size;
        if (otherSize > 0) {
            this.bMore.setText(">>" + otherSize);
            this.bMore.setMaximumSize(new Dimension(100, 24));
            this.bMore.setPreferredSize(new Dimension(40, 24));
            gbc = GM.getGBC(0, this.buttons.length);
            gbc.insets = new Insets(3, 2, 3, 0);
            this.add((Component)this.bMore, gbc);
        }
        this.add((Component)new JPanel(), GM.getGBC(0, this.buttons.length + 1, true));
        gbc = GM.getGBC(0, this.buttons.length + 2);
        gbc.insets = bInsets;
        this.add((Component)this.bMin, gbc);
        gbc = GM.getGBC(0, this.buttons.length + 3);
        gbc.insets = bInsets;
        this.add((Component)this.bResume, gbc);
        gbc = GM.getGBC(0, this.buttons.length + 4);
        gbc.insets = bInsets;
        gbc.insets.right = 2;
        this.add((Component)this.bClose, gbc);
        if (this.winList != null && this.winList.isVisible()) {
            if (otherSize == 0) {
                this.winList.dispose();
            } else {
                Rectangle rect = this.bMore.getBounds();
                int x = GM.getAbsolutePos(this.bMore, true);
                int y = GM.getAbsolutePos(this.bMore, false);
                this.winList.setBounds(x, y + rect.height, 200, 300);
            }
        }
        this.refreshTitleButton();
        this.revalidate();
        this.repaint();
    }

    private void refreshTitleButton() {
        boolean vis = false;
        if (GV.appSheet != null) {
            vis = GV.appSheet.isMaximum() && !GV.appSheet.isIcon();
        }
        this.bMin.setVisible(vis);
        this.bResume.setVisible(vis);
        this.bClose.setVisible(vis);
    }

    public void refreshSheet(JInternalFrame sheet) {
        if (sheet != null && this.buttons != null) {
            int i = 0;
            while (i < this.buttons.length) {
                if (this.buttons[i] != null && this.buttons[i].getSheet() == sheet) {
                    int j = 0;
                    while (j < this.buttons.length) {
                        this.buttons[j].setSelected(false);
                        ++j;
                    }
                    this.buttons[i].setSelected(true);
                    this.refreshTitleButton();
                    return;
                }
                ++i;
            }
        }
        this.refresh();
    }

    public void changeFileName(IPrjxSheet sheet, String newFile) {
        if (this.buttons != null) {
            int i = 0;
            while (i < this.buttons.length) {
                if (this.buttons[i].getSheet() == sheet) {
                    this.buttons[i].rename(newFile);
                    break;
                }
                ++i;
            }
        }
    }

    class SheetButton
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JInternalFrame sheet;
        private JLabel labelText = new JLabel();
        private JLabel labelIcon = new JLabel();
        private JLabel labelClose = new JLabel();
        private JPanel panelIcon;

        public SheetButton(final JInternalFrame sheet) {
            String filePath;
            this.sheet = sheet;
            this.setLayout(new BorderLayout());
            ImageIcon image = ((IPrjxSheet)sheet).getSheetImageIcon();
            if (image == null) {
                image = ToolBarWindow.this.getLogoImage();
            }
            if (image != null) {
                image.setImage(image.getImage().getScaledInstance(20, 20, 4));
            }
            this.labelIcon.setIcon(image);
            String fileName = filePath = ((IPrjxSheet)sheet).getSheetTitle();
            try {
                File f = new File(filePath);
                fileName = f.getName();
            }
            catch (Exception f) {
                // empty catch block
            }
            this.labelText.setText(fileName);
            this.setTip(filePath);
            this.add((Component)this.labelText, "Center");
            this.panelIcon = new JPanel(new BorderLayout(2, 2));
            this.panelIcon.add(this.labelIcon);
            Dimension di = new Dimension(25, 25);
            this.panelIcon.setPreferredSize(di);
            this.add((Component)this.panelIcon, "West");
            this.add((Component)this.labelClose, "East");
            MouseAdapter showSheetListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    try {
                        if (!GV.appFrame.showSheet(sheet)) {
                            return;
                        }
                    }
                    catch (Exception e1) {
                        GM.showException(GV.appFrame, e1);
                    }
                    ToolBarWindow.this.refreshSheet(sheet);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        try {
                            GV.appSheet.setMaximum(!GV.appSheet.isMaximum());
                        }
                        catch (PropertyVetoException e1) {
                            e1.printStackTrace();
                        }
                        ToolBarWindow.this.refreshTitleButton();
                    }
                }
            };
            this.labelIcon.addMouseListener(showSheetListener);
            this.labelText.addMouseListener(showSheetListener);
            MouseAdapter closeSheetListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    SheetButton.this.labelClose.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_closesheet.gif"));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SheetButton.this.labelClose.setIcon(null);
                }
            };
            this.labelIcon.addMouseListener(closeSheetListener);
            this.labelText.addMouseListener(closeSheetListener);
            this.labelClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    SheetButton.this.labelClose.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_delete.gif"));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SheetButton.this.labelClose.setIcon(null);
                }
            });
            this.labelClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    ToolBarWindow.this.closeSheet((IPrjxSheet)sheet);
                }
            });
            Dimension d = new Dimension(180, 25);
            this.setMaximumSize(d);
            this.setMinimumSize(d);
            this.setPreferredSize(d);
        }

        public void setSelected(boolean isSelected) {
            Color bc;
            if (isSelected) {
                this.setBorder(BorderFactory.createRaisedBevelBorder());
                bc = SELECTED_BACK_COLOR;
            } else {
                this.setBorder(BorderFactory.createEtchedBorder());
                bc = DEFAULT_BACK_COLOR;
            }
            this.setBackground(bc);
            this.panelIcon.setBackground(bc);
        }

        public JInternalFrame getSheet() {
            return this.sheet;
        }

        public void rename(String newName) {
            String fileName = newName;
            try {
                File f = new File(newName);
                fileName = f.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.labelText.setText(fileName);
            this.setTip(newName);
            this.repaint();
        }

        private void setTip(String filePath) {
            this.labelText.setToolTipText(filePath);
            this.setToolTipText(filePath);
            this.labelIcon.setToolTipText(filePath);
            this.labelClose.setToolTipText(filePath);
        }
    }
}

