/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.control;

import com.scudata.common.MessageManager;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.Console;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.PanelConsole_jBClean_actionAdapter;
import com.scudata.ide.common.control.PanelConsole_jBCopy_actionAdapter;
import com.scudata.ide.common.resources.IdeCommonMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PanelConsole
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Console console;
    private JButton jBCopy = new JButton();
    private JButton jBClean = new JButton();
    private JCheckBox jCBAutoClean = new JCheckBox(IdeCommonMessage.get().getMessage("panelconsole.autoclean"));
    private boolean isSPL = false;

    public PanelConsole(Console console) {
        this(console, false);
    }

    public PanelConsole(Console console, boolean isSPL) {
        super(new BorderLayout());
        this.init(GV.appFrame, console, isSPL);
    }

    public PanelConsole(Component parent, Console console, boolean isSPL) {
        super(new BorderLayout());
        this.init(parent, console, isSPL);
    }

    private void init(Component parent, Console console, boolean isSPL) {
        this.console = console;
        this.isSPL = isSPL;
        try {
            this.initUI();
            this.jCBAutoClean.setSelected(ConfigOptions.bAutoCleanOutput);
            this.resetLangText();
            this.setMinimumSize(new Dimension(1, 1));
        }
        catch (Exception ex) {
            GM.showException(parent, ex);
        }
    }

    public void autoClean() {
        if (this.jCBAutoClean.isSelected()) {
            this.console.clear();
        }
    }

    private void resetLangText() {
        MessageManager mm = IdeCommonMessage.get();
        this.jBCopy.setText(mm.getMessage("public.copy"));
        this.jBClean.setText(mm.getMessage("public.clean"));
    }

    private void initUI() throws Exception {
        this.jBCopy.addActionListener(new PanelConsole_jBCopy_actionAdapter(this));
        this.jBClean.setVerticalAlignment(0);
        this.jBClean.addActionListener(new PanelConsole_jBClean_actionAdapter(this));
        JTextArea jTextArea1 = this.console.getTextArea();
        jTextArea1.setEditable(false);
        jTextArea1.setBackground(Color.WHITE);
        if (this.isSPL) {
            this.jBCopy.setPreferredSize(new Dimension(65, 25));
            this.jBClean.setPreferredSize(new Dimension(65, 25));
        }
        this.add((Component)new JScrollPane(jTextArea1), "Center");
        JPanel panelNorth = new JPanel(new GridBagLayout());
        this.add((Component)panelNorth, "North");
        if (!this.isSPL) {
            panelNorth.add((Component)new JLabel(IdeCommonMessage.get().getMessage("dialogconsole.title")), GM.getGBC(0, 0, true));
        } else {
            panelNorth.add((Component)this.jCBAutoClean, GM.getGBC(0, 0, false, false, 4));
            panelNorth.add((Component)new JPanel(), GM.getGBC(0, 1, true, false, 0));
        }
        panelNorth.add((Component)this.jBCopy, GM.getGBC(0, 2, false, false, 4));
        panelNorth.add((Component)this.jBClean, GM.getGBC(0, 3, false, false, 4));
        this.jCBAutoClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigOptions.bAutoCleanOutput = PanelConsole.this.jCBAutoClean.isSelected();
                try {
                    ConfigOptions.save();
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    void jBCopy_actionPerformed(ActionEvent e) {
        this.console.getTextArea().copy();
    }

    void jBClean_actionPerformed(ActionEvent e) {
        this.console.clearCaseSelection();
    }
}

