/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.DBConfig;
import com.scudata.common.DBInfo;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.DataSourceList;
import com.scudata.ide.common.DataSourceListModel;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IDataSourceEditor;
import com.scudata.ide.common.dialog.DialogDataSourcePara;
import com.scudata.ide.common.dialog.DialogDataSourceType;
import com.scudata.ide.common.dialog.DialogDataSource_jBClose_actionAdapter;
import com.scudata.ide.common.dialog.DialogDataSource_jBConnect_actionAdapter;
import com.scudata.ide.common.dialog.DialogDataSource_jBDelete_actionAdapter;
import com.scudata.ide.common.dialog.DialogDataSource_jBDisconnect_actionAdapter;
import com.scudata.ide.common.dialog.DialogDataSource_jBEdit_actionAdapter;
import com.scudata.ide.common.dialog.DialogDataSource_jBNew_actionAdapter;
import com.scudata.ide.common.dialog.DialogDataSource_this_windowAdapter;
import com.scudata.ide.common.dialog.DialogODBCDataSource;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.VFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DialogDataSource
extends JDialog
implements IDataSourceEditor {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private DataSourceList jListDS;
    private JButton jBNew = new JButton();
    private JButton jBDelete = new JButton();
    private JButton jBConnect = new JButton();
    private JButton jBDisconnect = new JButton();
    private JButton jBClose = new JButton();
    private JButton jBEdit = new JButton();
    private JLabel labelEncryptyLevel = new JLabel(this.mm.getMessage("dialogdatasource.encryptlevel"));
    private JComboBoxEx jCBEncryptLevel = new JComboBoxEx();
    private JLabel jLPwdClass = new JLabel(this.mm.getMessage("dialogdatasource.pwdclass"));
    private JTextField jTFPwdClass = new JTextField();
    private final String LABEL_ENCRYPT_NONE = this.mm.getMessage("dialogdatasource.encryptnone");
    private final String LABEL_ENCRYPT_PASSWORD = this.mm.getMessage("dialogdatasource.encryptpwd");
    private final String LABEL_ENCRYPT_URL_USER_PWD = this.mm.getMessage("dialogdatasource.encrypturluserpwd");
    private DataSourceListModel dsModel;

    public DialogDataSource(DataSourceListModel dslm) {
        this(GV.appFrame, dslm);
    }

    public DialogDataSource(JFrame parent, DataSourceListModel dslm) {
        super(parent, "Data source", true);
        this.init(dslm);
    }

    public DialogDataSource(JDialog parent, DataSourceListModel dslm) {
        super(parent, "Data source", true);
        this.init(dslm);
    }

    private void resetLangText() {
        this.setTitle(this.mm.getMessage("dialogdatasource.title"));
        this.jBNew.setText(this.mm.getMessage("button.new"));
        this.jBDelete.setText(this.mm.getMessage("button.delete"));
        this.jBConnect.setText(this.mm.getMessage("button.connect"));
        this.jBDisconnect.setText(this.mm.getMessage("button.disconnect"));
        this.jBClose.setText(this.mm.getMessage("button.close"));
        this.jBEdit.setText(this.mm.getMessage("button.edit"));
    }

    protected void serverSelected(String serverName) {
    }

    private void initUI() throws Exception {
        JPanel panel1 = new JPanel(new BorderLayout());
        this.jBNew.setMnemonic('N');
        this.jBNew.setText("\u65b0\u5efa(N)");
        this.jBNew.addActionListener(new DialogDataSource_jBNew_actionAdapter(this));
        this.jBDelete.setMnemonic('D');
        this.jBDelete.setText("\u5220\u9664(D)");
        this.jBDelete.addActionListener(new DialogDataSource_jBDelete_actionAdapter(this));
        JPanel jPanel1 = new JPanel(new VFlowLayout());
        this.jBConnect.setMnemonic('O');
        this.jBConnect.setText("\u8fde\u63a5(O)");
        this.jBConnect.addActionListener(new DialogDataSource_jBConnect_actionAdapter(this));
        this.jBDisconnect.setMnemonic('K');
        this.jBDisconnect.setText("\u65ad\u5f00(K)");
        this.jBDisconnect.addActionListener(new DialogDataSource_jBDisconnect_actionAdapter(this));
        JLabel jLabel1 = new JLabel();
        jLabel1.setText(" ");
        this.jBClose.setMnemonic('C');
        this.jBClose.setText("\u5173\u95ed(C)");
        this.jBClose.addActionListener(new DialogDataSource_jBClose_actionAdapter(this));
        this.jBEdit.setVerifyInputWhenFocusTarget(true);
        this.jBEdit.setMnemonic('E');
        this.jBEdit.setText("\u7f16\u8f91(E)");
        this.jBEdit.addActionListener(new DialogDataSource_jBEdit_actionAdapter(this));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogDataSource_this_windowAdapter(this));
        this.getContentPane().add(panel1);
        JPanel panelCenter = new JPanel();
        panel1.add((Component)panelCenter, "Center");
        panel1.add((Component)jPanel1, "East");
        panelCenter.setLayout(new BorderLayout());
        panelCenter.add((Component)new JScrollPane(this.jListDS), "Center");
        JPanel panelEncrypt = new JPanel();
        panelEncrypt.setLayout(new GridBagLayout());
        panelEncrypt.add((Component)this.labelEncryptyLevel, GM.getGBC(0, 0));
        this.jCBEncryptLevel.setListData(new Object[]{this.LABEL_ENCRYPT_NONE, this.LABEL_ENCRYPT_PASSWORD, this.LABEL_ENCRYPT_URL_USER_PWD});
        panelEncrypt.add((Component)this.jCBEncryptLevel, GM.getGBC(0, 1, true));
        panelEncrypt.add((Component)this.jLPwdClass, GM.getGBC(1, 0));
        panelEncrypt.add((Component)this.jTFPwdClass, GM.getGBC(1, 1, true));
        panelCenter.add((Component)panelEncrypt, "South");
        if (GV.config != null) {
            this.jCBEncryptLevel.setSelectedIndex(GV.config.getEncryptLevel());
            this.jTFPwdClass.setText(GV.config.getPwdClass());
        } else {
            this.jCBEncryptLevel.setSelectedIndex(0);
        }
        this.jCBEncryptLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogDataSource.this.encryptLevelChanged();
            }
        });
        this.encryptLevelChanged();
        jPanel1.add((Component)this.jBConnect, null);
        jPanel1.add((Component)this.jBDisconnect, null);
        jPanel1.add((Component)this.jBNew, null);
        jPanel1.add((Component)this.jBDelete, null);
        jPanel1.add((Component)this.jBEdit, null);
        jPanel1.add((Component)jLabel1, null);
        jPanel1.add((Component)this.jBClose, null);
        this.jListDS.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DialogDataSource.this.jBEdit.doClick();
                }
            }
        });
        this.jListDS.setSelectedIndex(0);
        this.jListDS.setSelectionMode(0);
    }

    protected Byte selectDataSourceType() {
        DialogDataSourceType dct = new DialogDataSourceType(this);
        dct.setVisible(true);
        if (dct.getOption() != 0) {
            return null;
        }
        return dct.getDataSourceType();
    }

    protected DialogDataSourcePara newDialogDataSourcePara(JDialog parent) {
        DialogDataSourcePara ddp = new DialogDataSourcePara(parent);
        return ddp;
    }

    void jBNew_actionPerformed(ActionEvent e) {
        DataSource ds;
        Byte bType = this.selectDataSourceType();
        if (bType == null) {
            return;
        }
        byte dsType = bType;
        if (dsType == 0) {
            DialogDataSourcePara ddp = this.newDialogDataSourcePara(this);
            ddp.setVisible(true);
            if (ddp.getOption() != 0) {
                return;
            }
            ds = ddp.get();
        } else if (dsType == 1) {
            DialogODBCDataSource dods = new DialogODBCDataSource(this);
            dods.setVisible(true);
            if (dods.getOption() != 0) {
                return;
            }
            ds = dods.get();
        } else {
            return;
        }
        int index = this.jListDS.getSelectedIndex();
        int size = this.dsModel.getSize();
        if (this.dsModel.existDSName(ds.getName())) {
            GM.messageDialog(this, this.mm.getMessage("dialogdatasource.existdsname", ds.getName()), this.mm.getMessage("public.closenote"), 0);
            return;
        }
        if (index == -1 || index == size || index == 0) {
            this.dsModel.addElement(ds);
            this.jListDS.setSelectedIndex(size);
        } else {
            this.dsModel.insertElementAt(ds, index + 1);
            this.jListDS.setSelectedIndex(index + 1);
        }
    }

    void jBDelete_actionPerformed(ActionEvent e) {
        int index = this.jListDS.getSelectedIndex();
        int size = this.dsModel.getSize();
        if (index > -1 && index < size) {
            DataSource ds = (DataSource)this.dsModel.get(index);
            if (ds.isSystem()) {
                GM.messageDialog(this, this.mm.getMessage("dialogdatasource.notdelds", ds.getName()), this.mm.getMessage("public.note"), 2);
                return;
            }
            if (ds.isRemote()) {
                GM.messageDialog(this, this.mm.getMessage("dialogdatasource.delremote", ds.getName()), this.mm.getMessage("public.note"), 2);
                return;
            }
            Object[] options = new Object[]{this.mm.getMessage("public.delete"), this.mm.getMessage("public.cancel")};
            int option = GM.optionDialog(this, this.mm.getMessage("dialogdatasource.mustdelds", ds.getName()), this.mm.getMessage("public.note"), 2, 3, options);
            if (option == 0) {
                this.dsModel.removeElementAt(index);
                size = this.dsModel.size();
                if (index < size) {
                    this.jListDS.setSelectedIndex(index);
                } else {
                    this.jListDS.setSelectedIndex(size - 1);
                }
                Env.deleteDBSessionFactory(ds.getName());
            }
        }
    }

    void jBConnect_actionPerformed(ActionEvent e) {
        int index = this.jListDS.getSelectedIndex();
        int size = this.dsModel.getSize();
        if (index <= -1 || index >= size) {
            return;
        }
        DataSource ds = (DataSource)this.dsModel.getElementAt(index);
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            try {
                this.connect(ds);
            }
            catch (Throwable x) {
                GM.showException(this, GM.handleDSException(ds, x));
                this.repaint();
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        finally {
            this.repaint();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void connect(DataSource ds) throws Throwable {
        ds.getDBSession();
    }

    protected void disconnect(DataSource ds) {
        ds.close();
    }

    void jBDisconnect_actionPerformed(ActionEvent e) {
        try {
            int index = this.jListDS.getSelectedIndex();
            int size = this.dsModel.getSize();
            if (index > -1 && index < size) {
                DataSource ds = (DataSource)this.dsModel.getElementAt(index);
                this.disconnect(ds);
                this.repaint();
            }
        }
        catch (Exception x) {
            GM.showException(this, x);
        }
    }

    protected void closeWindow() {
        if (!this.saveEncryprtLevel()) {
            this.setDefaultCloseOperation(0);
            return;
        }
        this.setDefaultCloseOperation(2);
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBClose_actionPerformed(ActionEvent e) {
        this.closeWindow();
    }

    void jBEdit_actionPerformed(ActionEvent e) {
        int index = this.jListDS.getSelectedIndex();
        int size = this.dsModel.getSize();
        if (index > -1 && index < size) {
            DataSource ds = (DataSource)this.dsModel.getElementAt(index);
            if (!DialogDataSource.isLocalDataSource(this, ds, true)) {
                return;
            }
            int option = 2;
            DBInfo info = ds.getDBInfo();
            if (info instanceof DBConfig) {
                if (((DBConfig)info).getDriver().equals("sun.jdbc.odbc.JdbcOdbcDriver")) {
                    DialogODBCDataSource dodbc = new DialogODBCDataSource(this);
                    dodbc.set((DBConfig)info);
                    dodbc.setVisible(true);
                    option = dodbc.getOption();
                    ds = dodbc.get();
                } else {
                    DialogDataSourcePara ddp = this.newDialogDataSourcePara(this);
                    ddp.set((DBConfig)info);
                    ddp.setVisible(true);
                    option = ddp.getOption();
                    ds = ddp.get();
                }
            }
            if (option != 0) {
                return;
            }
            this.dsModel.setElementAt(ds, index);
        }
    }

    public static boolean isLocalDataSource(Component parent, DataSource ds, boolean showMessage) {
        if (ds.isSystem()) {
            if (showMessage) {
                GM.messageDialog(parent, IdeCommonMessage.get().getMessage("dialogdatasource.canteditds", ds.getName()), IdeCommonMessage.get().getMessage("public.note"), 2);
            }
            return false;
        }
        if (ds.isRemote()) {
            if (showMessage) {
                GM.messageDialog(parent, IdeCommonMessage.get().getMessage("dialogdatasource.editremote", ds.getName()), IdeCommonMessage.get().getMessage("public.note"), 2);
            }
            return false;
        }
        return true;
    }

    void this_windowClosing(WindowEvent e) {
        this.closeWindow();
    }

    private boolean saveEncryprtLevel() {
        byte encryptLevel;
        if (GV.config == null) {
            GV.config = new RaqsoftConfig();
        }
        if ((encryptLevel = (byte)this.jCBEncryptLevel.getSelectedIndex()) < 0) {
            encryptLevel = 0;
        }
        RaqsoftConfig config = GV.config;
        config.setEncryptLevel(encryptLevel);
        String pwdClass = this.jTFPwdClass.getText();
        if (StringUtils.isValidString(pwdClass)) {
            try {
                ConfigUtil.setPwdClass(pwdClass);
            }
            catch (Exception e) {
                if (e instanceof ClassNotFoundException) {
                    GM.showException(this, e, true, null, this.mm.getMessage("dialogdatasource.classnotfound"));
                } else {
                    GM.showException(this, e);
                }
                return false;
            }
            GV.config.setPwdClass(this.jTFPwdClass.getText());
        } else {
            try {
                ConfigUtil.setPwdClass(null);
            }
            catch (Exception e) {
                GM.showException(this, e);
            }
            GV.config.setPwdClass(null);
        }
        return true;
    }

    private void encryptLevelChanged() {
        int level = this.jCBEncryptLevel.getSelectedIndex();
        boolean encrypt = level == 1 || level == 2;
        this.jLPwdClass.setEnabled(encrypt);
        this.jTFPwdClass.setEnabled(encrypt);
        if (!encrypt) {
            this.jTFPwdClass.setText(null);
        }
    }

    @Override
    public void init(DataSourceListModel dslm) {
        try {
            this.dsModel = dslm;
            this.jListDS = new DataSourceList(this, dslm);
            this.initUI();
            this.resetLangText();
            this.setSize(GM.isChineseLanguage() ? 400 : 500, 300);
            GM.setDialogDefaultButton(this, this.jBConnect, this.jBClose);
            this.setResizable(true);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    @Override
    public void showEditor() {
        this.setVisible(true);
    }

    @Override
    public boolean isCommitted() {
        return true;
    }

    @Override
    public DataSourceListModel getDataSourceListModel() {
        return this.dsModel;
    }
}

