/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.DateFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.DialogEditConst_jBAdd_actionAdapter;
import com.scudata.ide.common.dialog.DialogEditConst_jBCancel_actionAdapter;
import com.scudata.ide.common.dialog.DialogEditConst_jBDel_actionAdapter;
import com.scudata.ide.common.dialog.DialogEditConst_jBOK_actionAdapter;
import com.scudata.ide.common.dialog.DialogEditConst_this_windowAdapter;
import com.scudata.ide.common.dialog.DialogEditSeries;
import com.scudata.ide.common.dialog.DialogEditTable;
import com.scudata.ide.common.dialog.DialogInputText;
import com.scudata.ide.common.dialog.DialogMaxmizable;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.AllPurposeEditor;
import com.scudata.ide.common.swing.AllPurposeRenderer;
import com.scudata.ide.common.swing.DateChooser;
import com.scudata.ide.common.swing.DatetimeChooser;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.util.Variant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.sql.Date;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;

public class DialogEditConst
extends DialogMaxmizable {
    private static final long serialVersionUID = 1L;
    private JButton jBOK = new JButton();
    private JButton jBCancel = new JButton();
    private SimpleDateFormat dateFormatter = new SimpleDateFormat(Env.getDateFormat());
    private SimpleDateFormat timeFormatter = new SimpleDateFormat(Env.getDateTimeFormat());
    private MessageManager mm = IdeCommonMessage.get();
    private final String STR_STR = this.mm.getMessage("dialogeditconst.str");
    private final String STR_INT = this.mm.getMessage("dialogeditconst.int");
    private final String STR_DOUBLE = this.mm.getMessage("dialogeditconst.double");
    private final String STR_DATE = this.mm.getMessage("dialogeditconst.date");
    private final String STR_DATE_TIME = this.mm.getMessage("dialogeditconst.datetime");
    private final String STR_SERIES = this.mm.getMessage("dialogeditconst.series");
    private final String STR_TABLE = this.mm.getMessage("dialogeditconst.table");
    private final String STR_EXP = this.mm.getMessage("dialogeditconst.exp");
    private final byte COL_INDEX = 0;
    private final byte COL_NAME = 1;
    private final byte COL_KIND = (byte)2;
    private final byte COL_VALUE = (byte)3;
    private final byte COL_CONFIG = (byte)4;
    private final String STR_PARAM = "COL_CONFIG";
    private JTableEx tableConst = new JTableEx(String.valueOf(this.mm.getMessage("dialogeditconst.tableconst")) + "COL_CONFIG"){
        private static final long serialVersionUID = 1L;

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (!this.isItemDataChanged(row, column, aValue)) {
                return;
            }
            super.setValueAt(aValue, row, column);
            switch (column) {
                case 2: {
                    this.data.setValueAt(null, row, 3);
                    this.data.setValueAt(null, row, 4);
                    this.acceptText();
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            block28: {
                block2 : switch (col) {
                    case 1: {
                        GM.dialogEditTableText(DialogEditConst.this, DialogEditConst.this.tableConst, row, col);
                        return;
                    }
                    case 3: {
                        Object val = this.data.getValueAt(row, 3);
                        byte kind = (Byte)this.data.getValueAt(row, 2);
                        Param p = new Param();
                        if (StringUtils.isValidString(((DialogEditConst)DialogEditConst.this).tableConst.data.getValueAt(row, 1))) {
                            p.setName(((DialogEditConst)DialogEditConst.this).tableConst.data.getValueAt(row, 1) == null ? "" : (String)((DialogEditConst)DialogEditConst.this).tableConst.data.getValueAt(row, 1));
                        }
                        p.setKind(DialogEditConst.this.getParamKind(kind));
                        p.setValue(val);
                        this.acceptText();
                        switch (kind) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 7: {
                                String title = p.getName();
                                if (StringUtils.isValidString(title)) {
                                    title = String.valueOf(title) + " : ";
                                }
                                title = kind == 0 ? String.valueOf(title) + DialogEditConst.this.STR_STR : (kind == 1 ? String.valueOf(title) + DialogEditConst.this.STR_INT : (kind == 2 ? String.valueOf(title) + DialogEditConst.this.STR_DOUBLE : String.valueOf(title) + DialogEditConst.this.STR_EXP));
                                DialogInputText dit = new DialogInputText((Dialog)DialogEditConst.this, true);
                                dit.setText(val == null ? null : (String)val);
                                dit.setTitle(title);
                                dit.setVisible(true);
                                if (dit.getOption() != 0) return;
                                this.data.setValueAt(dit.getText(), row, 3);
                                this.acceptText();
                                break block28;
                            }
                            case 3: {
                                String title = p.getName();
                                if (StringUtils.isValidString(title)) {
                                    title = String.valueOf(title) + " : ";
                                }
                                title = String.valueOf(title) + DialogEditConst.this.STR_DATE;
                                DateChooser dc = new DateChooser((Dialog)DialogEditConst.this, true);
                                dc.setTitle(title);
                                Calendar selectedCalendar = Calendar.getInstance();
                                try {
                                    if (StringUtils.isValidString(this.data.getValueAt(row, 3))) {
                                        selectedCalendar.setTime(DialogEditConst.this.dateFormatter.parse((String)this.data.getValueAt(row, 3)));
                                    }
                                    dc.initDate(selectedCalendar);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                GM.centerWindow(dc);
                                dc.setVisible(true);
                                selectedCalendar = dc.getSelectedDate() != null ? dc.getSelectedDate() : null;
                                if (selectedCalendar == null) {
                                    dc.dispose();
                                    return;
                                }
                                long time = selectedCalendar.getTimeInMillis();
                                Date date = new Date(time);
                                this.data.setValueAt(DialogEditConst.this.dateFormatter.format(date), row, 3);
                                dc.dispose();
                                break block2;
                            }
                            case 4: {
                                String title = p.getName();
                                if (StringUtils.isValidString(title)) {
                                    title = String.valueOf(title) + " : ";
                                }
                                title = String.valueOf(title) + DialogEditConst.this.STR_DATE_TIME;
                                DatetimeChooser dtc = new DatetimeChooser((Dialog)DialogEditConst.this, true);
                                dtc.setTitle(title);
                                Calendar selectedCalendar = Calendar.getInstance();
                                try {
                                    if (StringUtils.isValidString(this.data.getValueAt(row, 3))) {
                                        selectedCalendar.setTime(DialogEditConst.this.timeFormatter.parse((String)this.data.getValueAt(row, 3)));
                                    }
                                    dtc.initDate(selectedCalendar);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                GM.centerWindow(dtc);
                                dtc.setVisible(true);
                                selectedCalendar = dtc.getSelectedDatetime() != null ? dtc.getSelectedDatetime() : null;
                                if (selectedCalendar == null) {
                                    dtc.dispose();
                                    return;
                                }
                                long time = selectedCalendar.getTimeInMillis();
                                Time datetime = new Time(time);
                                this.data.setValueAt(DialogEditConst.this.timeFormatter.format(datetime), row, 3);
                                dtc.dispose();
                                break block2;
                            }
                            case 5: {
                                DialogEditSeries des = new DialogEditSeries(DialogEditConst.this);
                                des.setSequence(val == null ? null : (Sequence)val);
                                String title = p.getName();
                                if (StringUtils.isValidString(title)) {
                                    title = String.valueOf(title) + " : ";
                                }
                                title = String.valueOf(title) + DialogEditConst.this.STR_SERIES;
                                des.setTitle(title);
                                des.setVisible(true);
                                if (des.getOption() != 0) return;
                                p.setValue(des.getSequence());
                                ((DialogEditConst)DialogEditConst.this).tableConst.data.setValueAt(p.getValue(), row, 3);
                                this.acceptText();
                                break block28;
                            }
                            case 6: {
                                DialogEditTable det = new DialogEditTable(DialogEditConst.this, p);
                                String title = p.getName();
                                if (StringUtils.isValidString(title)) {
                                    title = String.valueOf(title) + " : ";
                                }
                                title = String.valueOf(title) + DialogEditConst.this.STR_TABLE;
                                det.setTitle(title);
                                det.setVisible(true);
                                if (det.getOption() != 0) return;
                                p = det.getParam();
                                ((DialogEditConst)DialogEditConst.this).tableConst.data.setValueAt(p.getValue(), row, 3);
                                this.acceptText();
                            }
                        }
                    }
                }
            }
        }
    };
    private JButton jBAdd = new JButton();
    private JButton jBDel = new JButton();
    private ParamList pl;
    private int m_option = 2;
    private Vector<String> usedNames = new Vector();
    private Vector<String> otherNames;

    public DialogEditConst(boolean isGlobal) {
        super(GV.appFrame, "\u5e38\u91cf\u7f16\u8f91", true);
        try {
            this.initUI();
            this.init(isGlobal);
            this.setSize(450, 300);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
            this.resetText(isGlobal);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    private void resetText(boolean isGlobal) {
        this.setTitle(isGlobal ? this.mm.getMessage("dialogeditconst.title") : this.mm.getMessage("dialogeditconst.title1"));
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
        this.jBAdd.setText(this.mm.getMessage("button.add"));
        this.jBDel.setText(this.mm.getMessage("button.delete"));
    }

    public int getOption() {
        return this.m_option;
    }

    public void setUsedNames(Vector<String> usedNames) {
        this.otherNames = usedNames;
    }

    public void setParamList(ParamList pl) {
        if (pl == null) {
            return;
        }
        this.pl = pl;
        this.setParamList2Table(pl);
        ParamList otherList = new ParamList();
        if (pl != null) {
            pl.getAllVarParams(otherList);
            int count = otherList.count();
            int i = 0;
            while (i < count) {
                this.usedNames.add(otherList.get(i).getName());
                ++i;
            }
        }
    }

    private void setParamList2Table(ParamList pl) {
        ParamList constList = new ParamList();
        pl.getAllConsts(constList);
        int count = constList.count();
        int i = 0;
        while (i < count) {
            Param p = constList.get(i);
            int row = this.tableConst.addRow();
            this.tableConst.data.setValueAt(p.getName(), row, 1);
            byte kind = this.getKind(p);
            this.tableConst.data.setValueAt(new Byte(kind), row, 2);
            Object val = p.getValue();
            switch (kind) {
                case 1: 
                case 2: 
                case 3: {
                    val = Variant.toString(val);
                    break;
                }
                case 4: {
                    val = this.timeFormatter.format((java.util.Date)val);
                }
            }
            this.tableConst.data.setValueAt(val, row, 3);
            ++i;
        }
    }

    public ParamList getParamList() {
        return this.getParamList(true);
    }

    private ParamList getParamList(boolean containTsx) {
        ParamList otherList = new ParamList();
        if (this.pl == null) {
            this.pl = new ParamList();
        } else if (containTsx) {
            this.pl.getAllVarParams(otherList);
        }
        ParamList newList = new ParamList();
        int count = this.tableConst.getRowCount();
        int i = 0;
        while (i < count) {
            Param p = new Param();
            p.setName((String)this.tableConst.data.getValueAt(i, 1));
            byte kind = (Byte)this.tableConst.data.getValueAt(i, 2);
            p.setKind(this.getParamKind(kind));
            Object val = this.tableConst.data.getValueAt(i, 3);
            switch (kind) {
                case 1: {
                    p.setValue(new Integer(Integer.parseInt((String)val)));
                    break;
                }
                case 2: {
                    p.setValue(new Double(Double.parseDouble((String)val)));
                    break;
                }
                case 3: {
                    try {
                        p.setValue(DateFactory.parseDate((String)val));
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case 4: {
                    try {
                        p.setValue(new Time(this.timeFormatter.parse((String)val).getTime()));
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case 5: {
                    if (val instanceof String) {
                        val = PgmNormalCell.parseConstValue((String)val);
                    }
                    p.setValue(val);
                    break;
                }
                default: {
                    p.setValue(val);
                }
            }
            newList.add(p);
            ++i;
        }
        count = otherList.count();
        i = 0;
        while (i < count) {
            newList.add(otherList.get(i));
            ++i;
        }
        return newList;
    }

    private byte getParamKind(byte kind) {
        switch (kind) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return 3;
            }
        }
        return -1;
    }

    private byte getKind(Param p) {
        Object val = p.getValue();
        if (val instanceof Integer) {
            return 1;
        }
        if (val instanceof Double) {
            return 2;
        }
        if (val instanceof Time) {
            return 4;
        }
        if (val instanceof java.util.Date) {
            return 3;
        }
        if (val instanceof Sequence) {
            Sequence s = (Sequence)val;
            if (s.isPmt()) {
                return 6;
            }
            return 5;
        }
        if (val instanceof String && p.getKind() == 3) {
            return 0;
        }
        return -1;
    }

    private void init(boolean isGlobal) {
        this.tableConst.setIndexCol(0);
        this.tableConst.setRowHeight(20);
        Vector<Byte> code = new Vector<Byte>();
        code.add(new Byte(0));
        code.add(new Byte(1));
        code.add(new Byte(2));
        code.add(new Byte(3));
        code.add(new Byte(4));
        code.add(new Byte(5));
        code.add(new Byte(6));
        Vector<String> disp = new Vector<String>();
        disp.add(this.STR_STR);
        disp.add(this.STR_INT);
        disp.add(this.STR_DOUBLE);
        disp.add(this.STR_DATE);
        disp.add(this.STR_DATE_TIME);
        disp.add(this.STR_SERIES);
        disp.add(this.STR_TABLE);
        JComboBoxEx combo = this.tableConst.setColumnDropDown(2, code, disp);
        combo.setMaximumRowCount(10);
        this.tableConst.setColumnVisible("COL_CONFIG", false);
        TableColumn tc = this.tableConst.getColumn(3);
        tc.setCellEditor(new AllPurposeEditor(new JTextField(), this.tableConst));
        tc.setCellRenderer(new AllPurposeRenderer());
        this.tableConst.getTableHeader().setReorderingAllowed(false);
        this.tableConst.setColumnWidth(1, 120);
        this.tableConst.setColumnWidth(2, 100);
        this.tableConst.setColumnWidth(3, 120);
    }

    private void initUI() throws Exception {
        JPanel jPanel2 = new JPanel();
        VFlowLayout vFlowLayout1 = new VFlowLayout();
        jPanel2.setLayout(vFlowLayout1);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogEditConst_jBOK_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogEditConst_jBCancel_actionAdapter(this));
        this.jBAdd.addActionListener(new DialogEditConst_jBAdd_actionAdapter(this));
        this.jBDel.addActionListener(new DialogEditConst_jBDel_actionAdapter(this));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogEditConst_this_windowAdapter(this));
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.getViewport().add(this.tableConst);
        JPanel jPanel3 = new JPanel();
        BorderLayout borderLayout1 = new BorderLayout();
        JButton jButton1 = new JButton();
        jButton1.setMaximumSize(new Dimension(450, 1));
        jButton1.setBorder(null);
        jPanel3.setLayout(borderLayout1);
        this.jBAdd.setMnemonic('A');
        this.jBAdd.setText("\u589e\u52a0(A)");
        this.jBDel.setMnemonic('D');
        this.jBDel.setText("\u5220\u9664(D)");
        this.getContentPane().add((Component)jPanel3, "Center");
        this.getContentPane().add((Component)jPanel2, "East");
        jPanel2.add((Component)this.jBOK, null);
        jPanel2.add((Component)this.jBCancel, null);
        JPanel jPanel1 = new JPanel();
        jPanel2.add((Component)jPanel1, null);
        jPanel2.add((Component)this.jBAdd, null);
        jPanel2.add((Component)this.jBDel, null);
        GridBagConstraints gbc = GM.getGBC(2, 1, true, true);
        gbc.gridwidth = 3;
        jPanel3.add((Component)jScrollPane1, "Center");
        jPanel3.add((Component)jButton1, "North");
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkData() {
        this.tableConst.acceptText();
        if (!this.tableConst.verifyColumnData(1, this.mm.getMessage("public.name"), true, this)) {
            return false;
        }
        int count = this.tableConst.getRowCount();
        int i = 0;
        while (i < count) {
            String name = (String)this.tableConst.data.getValueAt(i, 1);
            if (this.usedNames.contains(name)) {
                GM.messageDialog(this, this.mm.getMessage("dialogeditconst.existname", String.valueOf(i + 1), name));
                return false;
            }
            byte kind = (Byte)this.tableConst.data.getValueAt(i, 2);
            Object val = this.tableConst.data.getValueAt(i, 3);
            if (val == null) {
                GM.messageDialog(this, this.mm.getMessage("dialogeditconst.emptyval", String.valueOf(i + 1)));
                return false;
            }
            String strKind = "";
            String message = this.mm.getMessage("dialogeditconst.notvalid", String.valueOf(i + 1));
            try {
                switch (kind) {
                    case 1: {
                        strKind = this.STR_INT;
                        Integer.parseInt((String)val);
                        break;
                    }
                    case 2: {
                        strKind = this.STR_DOUBLE;
                        Double.parseDouble((String)val);
                        break;
                    }
                    case 3: {
                        strKind = this.STR_DATE;
                        DateFactory.parseDate((String)val);
                        break;
                    }
                    case 5: {
                        strKind = this.STR_SERIES;
                        if (StringUtils.isValidString(val)) {
                            val = PgmNormalCell.parseConstValue((String)val);
                        }
                        if (!(val instanceof Sequence)) {
                            GM.messageDialog(this, String.valueOf(message) + this.STR_SERIES);
                            return false;
                        }
                        break;
                    }
                    case 6: {
                        if (!(val instanceof Table)) {
                            GM.messageDialog(this, String.valueOf(message) + this.STR_TABLE);
                            return false;
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                GM.messageDialog(this, String.valueOf(message) + strKind);
                return false;
            }
            ++i;
        }
        return true;
    }

    void jBOK_actionPerformed(ActionEvent ae) {
        if (!this.checkData()) {
            return;
        }
        this.m_option = 0;
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBAdd_actionPerformed(ActionEvent e) {
        int row = this.tableConst.addRow();
        this.tableConst.acceptText();
        Vector<String> names = new Vector<String>();
        int i = 0;
        while (i < this.tableConst.getRowCount()) {
            if (this.tableConst.data.getValueAt(i, 1) != null) {
                names.add((String)this.tableConst.data.getValueAt(i, 1));
            }
            ++i;
        }
        names.addAll(this.otherNames);
        int index = 1;
        while (names.contains("param" + index)) {
            ++index;
        }
        this.tableConst.data.setValueAt("param" + index, row, 1);
        this.tableConst.data.setValueAt(new Byte(0), row, 2);
    }

    void jBDel_actionPerformed(ActionEvent e) {
        this.tableConst.deleteSelectedRows();
    }
}

