/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.RQDialog;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JListEx;
import com.scudata.ide.spl.GMSpl;
import com.scudata.util.CellSetUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public abstract class DialogFileReplace
extends RQDialog {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private String searchString = "";
    private String replaceString = "";
    private int searchFlag = 0;
    protected LinkedHashMap<String, String> fileResultMap = new LinkedHashMap();
    protected Map<String, String> passwordMap = new HashMap<String, String>();
    private final String[] FILE_TYPES = "splx,spl,dfx".split(",");
    private JLabel jLDir = new JLabel(this.mm.getMessage("dialogfilereplace.dir"));
    private JTextField jTFDir = new JTextField();
    private JButton jBDir = new JButton(this.mm.getMessage("dialogfilereplace.dirbutton"));
    private JCheckBox jCBSub = new JCheckBox(this.mm.getMessage("dialogfilereplace.containssub"));
    private JLabel jLSearch = new JLabel(this.mm.getMessage("dialogfilereplace.searchstr"));
    private JTextField jTFSearch = new JTextField();
    private JButton jBSearch = new JButton(this.mm.getMessage("dialogfilereplace.searchbutton"));
    private JLabel jLReplace = new JLabel(this.mm.getMessage("dialogfilereplace.replaceto"));
    private JTextField jTFReplace = new JTextField();
    private JButton jBReplace = new JButton(this.mm.getMessage("dialogfilereplace.replacebutton"));
    private JCheckBox jCBSensitive = new JCheckBox();
    private JCheckBox jCBWordOnly = new JCheckBox();
    private JCheckBox jCBQuote = new JCheckBox();
    private JCheckBox jCBPars = new JCheckBox();
    private JListEx jListResult = new JListEx();

    public DialogFileReplace(Frame owner) {
        super(owner, "\u5728\u6587\u4ef6\u4e2d\u67e5\u627e/\u66ff\u6362", 600, 500);
        try {
            this.setModal(false);
            this.setTitle(this.mm.getMessage("dialogfilereplace.title"));
            this.init();
            GM.centerWindow(this);
        }
        catch (Exception e) {
            GM.showException(this, e);
        }
    }

    public abstract PgmCellSet readEncryptedCellSet(String var1, String var2) throws Exception;

    private List<File> getFiles() {
        String sDir = this.jTFDir.getText();
        if (!StringUtils.isValidString(sDir)) {
            GM.messageDialog(this, this.mm.getMessage("dialogfilereplace.selectdir"));
            return null;
        }
        File dir = new File(sDir);
        if (!dir.exists()) {
            GM.messageDialog(this, this.mm.getMessage("dialogfilereplace.dirnotexists", sDir));
            return null;
        }
        if (!dir.isDirectory()) {
            GM.messageDialog(this, this.mm.getMessage("dialogfilereplace.notdir", sDir));
            return null;
        }
        File[] subFiles = dir.listFiles();
        if (subFiles == null || subFiles.length == 0) {
            GM.messageDialog(this, this.mm.getMessage("dialogfilereplace.nofilefound"));
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        this.getSubFiles(dir, files, this.jCBSub.isSelected());
        if (files.isEmpty()) {
            GM.messageDialog(this, this.mm.getMessage("dialogfilereplace.nofilefound"));
            return null;
        }
        return files;
    }

    private void getSubFiles(File dir, List<File> files, boolean isSub) {
        File[] subFiles = dir.listFiles();
        if (subFiles != null) {
            File[] fileArray = subFiles;
            int n = subFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    int i = 0;
                    while (i < this.FILE_TYPES.length) {
                        if (f.getAbsolutePath().endsWith("." + this.FILE_TYPES[i])) {
                            files.add(f);
                            break;
                        }
                        ++i;
                    }
                } else if (f.isDirectory() && isSub) {
                    this.getSubFiles(f, files, isSub);
                }
                ++n2;
            }
        }
    }

    private void setSearchConfig() {
        this.searchString = this.jTFSearch.getText();
        this.replaceString = this.jTFReplace.getText();
        this.searchFlag = 0;
        if (!this.jCBQuote.isSelected()) {
            this.searchFlag += 16;
        }
        if (!this.jCBPars.isSelected()) {
            this.searchFlag += 2;
        }
        if (!this.jCBSensitive.isSelected()) {
            ++this.searchFlag;
        }
        if (this.jCBWordOnly.isSelected()) {
            this.searchFlag += 8;
        }
    }

    private void search(boolean isReplace) {
        this.fileResultMap.clear();
        this.jListResult.setListData(new Object[0]);
        this.setSearchConfig();
        if (this.searchString == null || "".equals(this.searchString)) {
            GM.messageDialog(this, this.mm.getMessage("dialogfilereplace.searchnull"));
            return;
        }
        List<File> files = this.getFiles();
        if (files == null || files.isEmpty()) {
            return;
        }
        try {
            File dir = new File(this.jTFDir.getText());
            String sDir = dir.getAbsolutePath();
            for (File f : files) {
                PgmCellSet cellSet;
                String filePath = f.getAbsolutePath();
                if (filePath == null) continue;
                String fileName = this.getFileName(sDir, filePath);
                if (!f.canRead()) {
                    this.fileResultMap.put(filePath, this.mm.getMessage("dialogfilereplace.cannotread", fileName));
                    continue;
                }
                if (isReplace && !f.canWrite()) {
                    this.fileResultMap.put(filePath, this.mm.getMessage("dialogfilereplace.cannotwrite", fileName));
                    continue;
                }
                boolean isSplFile = filePath.toLowerCase().endsWith(".spl");
                if (isSplFile) {
                    cellSet = GMSpl.readSPL(filePath);
                } else if (CellSetUtil.isEncrypted(filePath)) {
                    cellSet = this.readEncryptedCellSet(filePath, fileName);
                    if (cellSet == null) {
                        continue;
                    }
                } else {
                    cellSet = CellSetUtil.readPgmCellSet(filePath);
                }
                if (cellSet == null) continue;
                if (filePath != null) {
                    cellSet.setName(filePath);
                }
                int searchCount = 0;
                int rc = cellSet.getRowCount();
                int cc = cellSet.getColCount();
                int r = 1;
                while (r <= rc) {
                    int c = 1;
                    while (c <= cc) {
                        int stringIndex;
                        String exp;
                        PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
                        if (cell != null && (exp = cell.getExpString()) != null && (stringIndex = Sentence.indexOf(exp, 0, this.searchString, this.searchFlag)) >= 0) {
                            if (isReplace) {
                                exp = Sentence.replace(exp, stringIndex, this.searchString, this.replaceString, this.searchFlag);
                                cell.setExpString(exp);
                            }
                            ++searchCount;
                        }
                        ++c;
                    }
                    ++r;
                }
                if (searchCount == 0) continue;
                if (isReplace) {
                    if (isSplFile) {
                        AppUtil.writeSPLFile(filePath, cellSet);
                    } else {
                        CellSetUtil.writePgmCellSet(filePath, cellSet);
                    }
                    this.fileResultMap.put(filePath, this.mm.getMessage("dialogfilereplace.replacecount", fileName, searchCount));
                    continue;
                }
                this.fileResultMap.put(filePath, this.mm.getMessage("dialogfilereplace.searchcount", fileName, searchCount));
            }
            Iterator<String> it = this.fileResultMap.keySet().iterator();
            Vector<String> codes = new Vector<String>();
            Vector<String> disps = new Vector<String>();
            while (it.hasNext()) {
                String key = it.next();
                String value = this.fileResultMap.get(key);
                codes.add(key);
                disps.add(value);
            }
            this.jListResult.x_setData(codes, disps);
        }
        catch (Exception e) {
            GM.showException(this, e);
        }
    }

    private String getFileName(String sDir, String filePath) {
        if (filePath == null) {
            return null;
        }
        String fileName = sDir != null ? filePath.substring(sDir.length()) : filePath;
        if (fileName != null) {
            int startIndex = -1;
            int i = 0;
            while (i < fileName.length()) {
                char c = fileName.charAt(i);
                if (c != '/' && c != '\\') break;
                startIndex = i++;
            }
            if (startIndex > -1) {
                fileName = fileName.substring(startIndex + 1);
            }
        }
        return fileName;
    }

    @Override
    protected void closeDialog(int option) {
        super.closeDialog(option);
        GM.setWindowDimension(this);
    }

    private void init() {
        this.panelCenter.setLayout(new GridBagLayout());
        this.panelCenter.add((Component)this.jLSearch, GM.getGBC(0, 0));
        this.panelCenter.add((Component)this.jTFSearch, GM.getGBC(0, 1, true));
        this.panelCenter.add((Component)this.jBSearch, GM.getGBC(0, 2));
        this.panelCenter.add((Component)this.jLReplace, GM.getGBC(1, 0));
        this.panelCenter.add((Component)this.jTFReplace, GM.getGBC(1, 1, true));
        this.panelCenter.add((Component)this.jBReplace, GM.getGBC(1, 2));
        this.panelCenter.add((Component)this.jLDir, GM.getGBC(2, 0));
        this.panelCenter.add((Component)this.jTFDir, GM.getGBC(2, 1, true));
        this.panelCenter.add((Component)this.jBDir, GM.getGBC(2, 2));
        GridBagConstraints gbc = GM.getGBC(3, 0);
        gbc.gridwidth = 2;
        JPanel panelDirOpt = new JPanel(new BorderLayout());
        panelDirOpt.add((Component)this.jCBSub, "West");
        panelDirOpt.add((Component)new JPanel(), "Center");
        this.panelCenter.add((Component)panelDirOpt, gbc);
        this.panelCenter.add((Component)this.jBCancel, GM.getGBC(3, 2));
        JPanel panelOpt = new JPanel(new GridLayout(2, 2));
        panelOpt.setBorder(BorderFactory.createTitledBorder(this.mm.getMessage("dialogfilereplace.option")));
        panelOpt.add(this.jCBSensitive);
        panelOpt.add(this.jCBWordOnly);
        panelOpt.add(this.jCBQuote);
        panelOpt.add(this.jCBPars);
        gbc = GM.getGBC(4, 0, true);
        gbc.gridwidth = 3;
        this.panelCenter.add((Component)panelOpt, gbc);
        gbc = GM.getGBC(5, 0, true, true);
        gbc.gridwidth = 3;
        this.panelCenter.add((Component)new JScrollPane(this.jListResult), gbc);
        this.remove(this.panelSouth);
        this.jCBSensitive.setText(this.mm.getMessage("dialogfilereplace.sensitive"));
        this.jCBWordOnly.setText(this.mm.getMessage("dialogfilereplace.wordonly"));
        this.jCBQuote.setText(this.mm.getMessage("dialogfilereplace.quote"));
        this.jCBPars.setText(this.mm.getMessage("dialogfilereplace.pars"));
        this.jBDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sDir;
                String lastDir = DialogFileReplace.this.jTFDir.getText();
                if (!StringUtils.isValidString(lastDir) && StringUtils.isValidString(Env.getMainPath())) {
                    lastDir = Env.getMainPath();
                }
                if ((sDir = GM.dialogSelectDirectory(DialogFileReplace.this, lastDir)) != null) {
                    DialogFileReplace.this.jTFDir.setText(sDir);
                }
            }
        });
        this.jBSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogFileReplace.this.search(false);
            }
        });
        this.jBReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogFileReplace.this.search(true);
            }
        });
        this.jListResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (DialogFileReplace.this.jListResult.isSelectionEmpty()) {
                        return;
                    }
                    try {
                        String disp = (String)DialogFileReplace.this.jListResult.getSelectedValue();
                        String filePath = (String)DialogFileReplace.this.jListResult.x_getCodeItem(disp);
                        DialogFileReplace.this.openSheet(filePath);
                    }
                    catch (Exception ex) {
                        GM.showException(DialogFileReplace.this, ex);
                    }
                }
            }
        });
    }

    protected void openSheet(String filePath) throws Exception {
        GV.appFrame.openSheetFile(filePath);
    }
}

