/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.DialogInputArgument_jBCancel_actionAdapter;
import com.scudata.ide.common.dialog.DialogInputArgument_jBOK_actionAdapter;
import com.scudata.ide.common.dialog.DialogInputArgument_this_windowAdapter;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogInputArgument
extends JDialog {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private final int COL_DISP = 0;
    private final int COL_VALUE = 1;
    private final int COL_NAME = 2;
    private final String TITLE_DISP = this.mm.getMessage("dialoginputargument.name");
    private final String TITLE_VALUE = this.mm.getMessage("dialoginputargument.value");
    private final String TITLE_NAME = "TITLE_NAME";
    private int m_option = -1;
    private JTableEx paraTable = new JTableEx(new String[]{this.TITLE_DISP, this.TITLE_VALUE, "TITLE_NAME"}){
        private static final long serialVersionUID = 1L;

        @Override
        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            if (col != 1) {
                return;
            }
            GM.dialogEditTableText(DialogInputArgument.this, DialogInputArgument.this.paraTable, row, col);
        }
    };
    private JButton jBOK = new JButton();
    private JButton jBCancel = new JButton();
    private HashMap<String, Object> paramMap = null;

    public DialogInputArgument(Context ctx) {
        super(GV.appFrame, "\u8bbe\u7f6e\u53c2\u6570\u503c\u3014\u53cc\u51fb\u6570\u503c\u5217\u5f39\u51fa\u7f16\u8f91\u7a97\u53e3\u3015", true);
        try {
            this.initUI();
            this.setSize(400, 300);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
            this.setResizable(true);
            this.resetText();
        }
        catch (Throwable t) {
            GM.showException(this, t);
        }
    }

    private void resetText() {
        this.setTitle(this.mm.getMessage("dialoginputargument.title"));
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
    }

    public int getOption() {
        return this.m_option;
    }

    public void setEditable(boolean editable) {
        if (!editable) {
            this.paraTable.setColumnEditable(1, false);
        }
    }

    private void initUI() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel1 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        panel1.setLayout(new VFlowLayout());
        panel1.setForeground(Color.black);
        this.paraTable.setCellSelectionEnabled(false);
        this.jBOK.setDefaultCapable(true);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogInputArgument_jBOK_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.setDefaultCapable(false);
        this.jBCancel.addActionListener(new DialogInputArgument_jBCancel_actionAdapter(this));
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.addWindowListener(new DialogInputArgument_this_windowAdapter(this));
        jScrollPane1.getViewport().add((Component)this.paraTable, null);
        panel1.add(this.jBOK);
        panel1.add(this.jBCancel);
        this.paraTable.setRowHeight(20);
        this.paraTable.setColumnEnable(this.TITLE_DISP, false);
        this.paraTable.setColumnWidth(this.TITLE_DISP, 75);
        this.paraTable.setColumnVisible("TITLE_NAME", false);
        this.getContentPane().add((Component)panel1, "East");
        this.getContentPane().add((Component)jScrollPane1, "Center");
    }

    public void setParam(ParamList paras) {
        try {
            int i = 0;
            while (i < paras.count()) {
                Param p = paras.get(i);
                if (p.getKind() == 0) {
                    int row = this.paraTable.addRow();
                    this.paraTable.data.setValueAt(StringUtils.isValidString(p.getRemark()) ? p.getRemark() : p.getName(), row, 0);
                    this.paraTable.data.setValueAt(p.getEditValue(), row, 1);
                    this.paraTable.data.setValueAt(p.getName(), row, 2);
                }
                ++i;
            }
        }
        catch (Exception e) {
            GM.showException(this, e);
        }
    }

    public HashMap<String, Object> getParamValue() {
        return this.paramMap;
    }

    private boolean checkParam() {
        this.paramMap = new HashMap();
        this.paraTable.acceptText();
        int i = 0;
        while (i < this.paraTable.getRowCount()) {
            Object o = this.paraTable.data.getValueAt(i, 2);
            if (o != null) {
                String name = o.toString();
                o = this.paraTable.data.getValueAt(i, 1);
                if (StringUtils.isValidString(o)) {
                    try {
                        o = PgmNormalCell.parseConstValue((String)o);
                    }
                    catch (Exception ex) {
                        this.paraTable.selectRow(i);
                        GM.showException(this, ex, true, GM.getLogoImage(this, true), IdeSplMessage.get().getMessage("dialoginputargument.parseerrorpre", name));
                        return false;
                    }
                } else {
                    o = null;
                }
                this.paramMap.put(name, o);
            }
            ++i;
        }
        return true;
    }

    void jBOK_actionPerformed(ActionEvent e) {
        if (!this.checkParam()) {
            this.paramMap = null;
            return;
        }
        GM.setWindowDimension(this);
        this.m_option = 0;
        this.dispose();
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.m_option = 2;
        this.dispose();
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

