/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.dialog.RQDialog;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JTableEx;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogMissingFormat
extends RQDialog {
    private static final long serialVersionUID = 1L;
    private JButton buttonAdd = GM.getCommonIconButton((byte)1);
    private JButton buttonDel = GM.getCommonIconButton((byte)2);
    private final int COL_EXP = 0;
    private JTableEx tableList;

    public DialogMissingFormat(Dialog parent) {
        super(parent, "\u7f3a\u5931\u503c\u5b9a\u4e49");
        try {
            this.init();
            GM.centerWindow(this);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    public void setMissingFormat(String missingExps) {
        this.tableList.removeAllRows();
        if (StringUtils.isValidString(missingExps)) {
            ArgumentTokenizer at = new ArgumentTokenizer(missingExps, ',');
            while (at.hasNext()) {
                String exp = at.next();
                if (!StringUtils.isValidString(exp)) continue;
                int r = this.tableList.addRow();
                this.tableList.data.setValueAt(exp, r, 0);
            }
        }
    }

    public String getMissingFormat() {
        this.tableList.acceptText();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.tableList.getRowCount()) {
            Object tmp = this.tableList.data.getValueAt(i, 0);
            if (StringUtils.isValidString(tmp)) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append((String)tmp);
            }
            ++i;
        }
        return buf.toString();
    }

    private void init() {
        MessageManager mm = IdeCommonMessage.get();
        this.setTitle(mm.getMessage("dialognullstrings.title"));
        this.tableList = new JTableEx(new String[]{mm.getMessage("dialognullstrings.nullstrings")});
        this.panelCenter.add((Component)new JScrollPane(this.tableList), "Center");
        JLabel labelNote = new JLabel(mm.getMessage("dialognullstrings.casesen"));
        JPanel panelNorth = new JPanel(new GridBagLayout());
        panelNorth.add((Component)labelNote, GM.getGBC(0, 0, true));
        panelNorth.add((Component)this.buttonAdd, GM.getGBC(0, 1, false, false, 0));
        panelNorth.add((Component)this.buttonDel, GM.getGBC(0, 2));
        this.panelCenter.add((Component)panelNorth, "North");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMissingFormat.this.tableList.addRow();
                DialogMissingFormat.this.tableList.requestFocusInWindow();
            }
        });
        this.buttonDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMissingFormat.this.tableList.acceptText();
                DialogMissingFormat.this.tableList.deleteSelectedRows();
            }
        });
    }

    @Override
    protected void closeDialog(int option) {
        super.closeDialog(option);
        GM.setWindowDimension(this);
    }
}

