/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.swing.RQTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DialogResourceSearch
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField textClass = new JTextField();
    private JButton buttonSearch = new JButton();
    private JButton buttonCancel = new JButton();
    private RQTextArea textResults = new RQTextArea();

    public DialogResourceSearch(JFrame frame) {
        super(frame, "Resource search", true);
        this.init();
    }

    public DialogResourceSearch(JDialog dialog) {
        super(dialog, "Resource search", true);
        this.init();
    }

    private void init() {
        this.setSize(600, 300);
        this.initUI();
        GM.setDialogDefaultButton(this, this.buttonSearch, this.buttonCancel);
    }

    private void initUI() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelCenter = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panelCenter, "Center");
        panelCenter.add((Component)new JLabel("Class name"), GM.getGBC(1, 1));
        panelCenter.add((Component)this.textClass, GM.getGBC(1, 2, true));
        panelCenter.add((Component)this.buttonSearch, GM.getGBC(1, 3));
        panelCenter.add((Component)new JLabel("Search results"), GM.getGBC(2, 1));
        GridBagConstraints gbc = GM.getGBC(3, 1, true, true);
        gbc.gridwidth = 3;
        panelCenter.add((Component)new JScrollPane(this.textResults), gbc);
        this.buttonSearch.setText("Search");
        this.buttonSearch.setMnemonic('S');
        this.buttonSearch.addActionListener(this);
        this.buttonCancel.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object c = e.getSource();
        if (this.buttonSearch == c) {
            this.textResults.setText(null);
            String clzName = this.textClass.getText();
            if (!StringUtils.isValidString(clzName)) {
                return;
            }
            try {
                String result = DialogResourceSearch.searchResource(clzName);
                this.textResults.setText(result);
            }
            catch (Exception ex) {
                GM.showException(this, ex);
                ex.printStackTrace();
            }
        } else if (this.buttonCancel == c) {
            this.dispose();
        }
    }

    public static String searchResource(String clzName) throws IOException {
        String src2;
        Class<?> clz2;
        if (!StringUtils.isValidString(clzName)) {
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ArrayList<String> resources = new ArrayList<String>();
        DialogResourceSearch.searchResource(cl, clzName, resources);
        DialogResourceSearch.searchResource(cl, clzName.concat(".class"), resources);
        DialogResourceSearch.searchResource(cl, clzName.replace('.', '/'), resources);
        try {
            clz2 = Class.forName(clzName);
            src2 = DialogResourceSearch.searchResource(clz2);
            if (!resources.contains(src2)) {
                resources.add(src2);
            }
        }
        catch (Exception clz2) {
            // empty catch block
        }
        try {
            clz2 = Class.forName(clzName.concat(".class"));
            src2 = DialogResourceSearch.searchResource(clz2);
            if (!resources.contains(src2)) {
                resources.add(src2);
            }
        }
        catch (Exception clz3) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer();
        for (String src2 : resources) {
            if (buf.length() > 0) {
                buf.append("\r\n");
            }
            buf.append(src2);
        }
        return buf.toString();
    }

    private static void searchResource(ClassLoader cl, String clzName, List<String> resources) throws IOException {
        Enumeration<URL> urls = cl.getResources(clzName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String path = url.getPath();
            if (!StringUtils.isValidString(path) || resources.contains(path)) continue;
            resources.add(path);
        }
    }

    public static String searchResource(Class cls) {
        URL result = null;
        String clsAsResource = cls.getName().replace('.', '/').concat(".class");
        ProtectionDomain pd = cls.getProtectionDomain();
        if (pd != null) {
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                result = cs.getLocation();
            }
            if (result != null && "file".equals(result.getProtocol())) {
                try {
                    if (result.toExternalForm().endsWith(".jar") || result.toExternalForm().endsWith(".zip")) {
                        result = new URL("jar:".concat(result.toExternalForm()).concat("!/").concat(clsAsResource));
                    } else if (new File(result.getFile()).isDirectory()) {
                        result = new URL(result, clsAsResource);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (result == null) {
            ClassLoader clsLoader = cls.getClassLoader();
            result = clsLoader != null ? clsLoader.getResource(clsAsResource) : ClassLoader.getSystemResource(clsAsResource);
        }
        return result.getPath();
    }
}

