/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.common.MessageManager;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.DialogRowHeight_jBCancel_actionAdapter;
import com.scudata.ide.common.dialog.DialogRowHeight_jBOK_actionAdapter;
import com.scudata.ide.common.dialog.DialogRowHeight_this_windowAdapter;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.VFlowLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class DialogRowHeight
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton jBOK = new JButton();
    private JButton jBCancel = new JButton();
    private JSpinner jSPSize = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 999.0, 5.0));
    private int m_option = 2;
    private boolean isRow;
    private MessageManager mm = IdeCommonMessage.get();

    public DialogRowHeight(boolean isRow, float size) {
        super(GV.appFrame, "", true);
        try {
            this.isRow = isRow;
            this.initUI();
            this.init(size);
            this.setSize(300, 100);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    public int getOption() {
        return this.m_option;
    }

    public float getRowHeight() {
        return ((Number)this.jSPSize.getValue()).floatValue();
    }

    private void init(float size) {
        if (this.isRow) {
            this.setTitle(this.mm.getMessage("dialogrowheight.rowheight"));
        } else {
            this.setTitle(this.mm.getMessage("dialogrowheight.colwidth"));
        }
        this.jSPSize.setValue(new Double(size));
        this.jSPSize.setPreferredSize(new Dimension(0, 25));
    }

    private void initUI() throws Exception {
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        VFlowLayout vFlowLayout1 = new VFlowLayout();
        VFlowLayout vFlowLayout2 = new VFlowLayout();
        jPanel2.setLayout(vFlowLayout1);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBOK.addActionListener(new DialogRowHeight_jBOK_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
        this.jBCancel.addActionListener(new DialogRowHeight_jBCancel_actionAdapter(this));
        jPanel1.setLayout(vFlowLayout2);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogRowHeight_this_windowAdapter(this));
        this.getContentPane().add((Component)jPanel1, "Center");
        this.getContentPane().add((Component)jPanel2, "East");
        jPanel2.add((Component)this.jBOK, null);
        jPanel2.add((Component)this.jBCancel, null);
        jPanel1.add((Component)this.jSPSize, null);
    }

    private void close() {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void this_windowClosing(WindowEvent e) {
        this.close();
    }

    void jBOK_actionPerformed(ActionEvent e) {
        if (this.jSPSize.getValue() == null || !(this.jSPSize.getValue() instanceof Number)) {
            String exp = this.isRow ? this.mm.getMessage("dialogrowheight.rowheight") : this.mm.getMessage("dialogrowheight.colwidth");
            GM.messageDialog(this, this.mm.getMessage("dialogrowheight.validval", exp));
            return;
        }
        this.m_option = 0;
        this.close();
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        this.close();
    }
}

