/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.common.DBConfig;
import com.scudata.common.MessageManager;
import com.scudata.common.ODBCUtil;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.DialogSelectDataSource_jBCancel_actionAdapter;
import com.scudata.ide.common.dialog.DialogSelectDataSource_jBOK_actionAdapter;
import com.scudata.ide.common.dialog.DialogSelectDataSource_this_windowAdapter;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JListEx;
import com.scudata.ide.common.swing.VFlowLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DialogSelectDataSource
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton jBCancel = new JButton();
    private JButton jBOK = new JButton();
    private JListEx listDS = new JListEx();
    private JTabbedPane tabMain = new JTabbedPane();
    private JListEx listODBC = new JListEx();
    private MessageManager mm = IdeCommonMessage.get();
    private int m_option = 2;
    private final byte TAB_CONFIG = 0;
    private final byte TAB_ODBC = 1;
    private JLabel labelUser = new JLabel();
    private JTextField jUser = new JTextField();
    private JLabel labelPwd = new JLabel();
    private JPasswordField jPassword = new JPasswordField();
    private boolean preventChange = false;
    private byte type = 0;
    public static final byte TYPE_ALL = 0;
    public static final byte TYPE_SQL = 1;
    public static final byte TYPE_DQL = 2;
    private DataSource ds;

    public DialogSelectDataSource() {
        this(0);
    }

    public DialogSelectDataSource(byte type) {
        super(GV.appFrame, "", true);
        try {
            try {
                this.type = type;
                this.preventChange = true;
                this.init();
                this.setSize(400, 300);
                GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
                this.resetLangText();
                this.setResizable(true);
            }
            catch (Exception ex) {
                GM.showException(this, ex);
                this.preventChange = false;
            }
        }
        finally {
            this.preventChange = false;
        }
    }

    private void resetLangText() {
        this.setTitle(this.mm.getMessage("dialogselectdatasource.title"));
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
        this.labelUser.setText(this.mm.getMessage("dialogodbcdatasource.user"));
        this.labelPwd.setText(this.mm.getMessage("dialogodbcdatasource.password"));
    }

    public int getOption() {
        return this.m_option;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void init() {
        Vector<String> disp;
        Vector<DataSource> code;
        block9: {
            Vector<String> dsNames;
            JPanel jPanel2 = new JPanel();
            VFlowLayout verticalFlowLayout1 = new VFlowLayout();
            JScrollPane jScrollPane1 = new JScrollPane();
            JScrollPane jScrollPane2 = new JScrollPane();
            jPanel2.setLayout(verticalFlowLayout1);
            this.jBCancel.setMnemonic('C');
            this.jBCancel.setText("Cancel");
            this.jBCancel.addActionListener(new DialogSelectDataSource_jBCancel_actionAdapter(this));
            this.jBOK.setMnemonic('O');
            this.jBOK.setText("OK");
            this.jBOK.addActionListener(new DialogSelectDataSource_jBOK_actionAdapter(this));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new DialogSelectDataSource_this_windowAdapter(this));
            this.tabMain.add((Component)jScrollPane1, this.mm.getMessage("dialogselectdatasource.tab1"));
            JSplitPane spODBC = new JSplitPane();
            spODBC.setOrientation(0);
            spODBC.setOneTouchExpandable(true);
            spODBC.setDividerSize(8);
            spODBC.setDividerLocation(175);
            if (this.type != 2 && GM.isWindowsOS()) {
                this.tabMain.add((Component)spODBC, "ODBC");
            }
            spODBC.add((Component)jScrollPane2, "top");
            JPanel panelBottom = new JPanel(new GridBagLayout());
            spODBC.add((Component)panelBottom, "bottom");
            panelBottom.add((Component)this.labelUser, GM.getGBC(1, 1));
            panelBottom.add((Component)this.jUser, GM.getGBC(1, 2, true));
            panelBottom.add((Component)this.labelPwd, GM.getGBC(2, 1));
            panelBottom.add((Component)this.jPassword, GM.getGBC(2, 2, true));
            jScrollPane2.getViewport().add((Component)this.listODBC, null);
            jScrollPane1.getViewport().add((Component)this.listDS, null);
            this.getContentPane().add((Component)jPanel2, "East");
            jPanel2.add((Component)this.jBOK, null);
            jPanel2.add((Component)this.jBCancel, null);
            this.getContentPane().add((Component)this.tabMain, "Center");
            this.listDS.setSelectionMode(0);
            this.listODBC.setSelectionMode(0);
            code = new Vector<DataSource>();
            disp = new Vector<String>();
            if (GV.dsModel == null || (dsNames = GV.dsModel.listNames()) == null) break block9;
            int i = 0;
            while (i < dsNames.size()) {
                block10: {
                    DataSource ds = (DataSource)GV.dsModel.get(i);
                    switch (this.type) {
                        case 1: {
                            if (!GM.isDataLogicDS(ds)) break;
                            break block10;
                        }
                        case 2: {
                            if (!GM.isDataLogicDS(ds)) break block10;
                        }
                    }
                    code.add(ds);
                    disp.add(dsNames.get(i));
                }
                ++i;
            }
        }
        this.listDS.x_setData(code, disp);
        if (code.size() > 0) {
            this.listDS.setSelectedIndex(0);
        }
        if (GM.isWindowsOS()) {
            ArrayList<String> dsList = ODBCUtil.getDataSourcesName(3);
            this.listODBC.setListData(dsList.toArray());
            if (dsList.size() > 0) {
                this.listODBC.setSelectedIndex(0);
            }
        }
        this.listODBC.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (DialogSelectDataSource.this.preventChange) {
                    return;
                }
                DialogSelectDataSource.this.odbcChanged();
            }
        });
        this.odbcChanged();
    }

    private void odbcChanged() {
        boolean isDSSelected = !this.listODBC.isSelectionEmpty();
        this.labelUser.setEnabled(isDSSelected);
        this.jUser.setEnabled(isDSSelected);
        this.labelPwd.setEnabled(isDSSelected);
        this.jPassword.setEnabled(isDSSelected);
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBOK_actionPerformed(ActionEvent e) {
        switch (this.tabMain.getSelectedIndex()) {
            case 0: {
                if (this.listDS.isSelectionEmpty()) {
                    GM.messageDialog(this, this.mm.getMessage("dialogselectdatasource.selectds"));
                    return;
                }
                this.ds = (DataSource)this.listDS.x_getSelectedValues()[0];
                break;
            }
            case 1: {
                if (this.listODBC.isSelectionEmpty()) {
                    GM.messageDialog(this, this.mm.getMessage("dialogselectdatasource.selectds"));
                    return;
                }
                String odbcName = this.listODBC.getSelectedItems();
                DBConfig config = new DBConfig();
                config.setName(odbcName);
                config.setDriver("sun.jdbc.odbc.JdbcOdbcDriver");
                config.setUrl("jdbc:odbc:" + odbcName);
                config.setUser(this.jUser.getText());
                config.setPassword(new String(this.jPassword.getPassword()));
                this.ds = new DataSource(config);
            }
        }
        try {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.ds.getDBSession();
            }
            catch (Throwable x) {
                GM.showException(this, GM.handleDSException(this.ds, x));
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.m_option = 0;
        GM.setWindowDimension(this);
        this.dispose();
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

