/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.function;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import com.scudata.ide.common.AppFrame;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.function.DialogFuncEditor_funcTree_mouseAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBAddFunc_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBAddOption_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBAddParam_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBClose_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBDelFunc_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBDelOption_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBDelParam_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBDownFunc_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBDownOption_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBDownParam_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBSave_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBUpFunc_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBUpOption_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jBUpParam_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jCBMajorType_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_jCBReturnType_actionAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_listFuncs_mouseAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_tableOption_mouseAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_tableParam_mouseAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_textDesc_keyAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_textName_keyAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_textPostfix_keyAdapter;
import com.scudata.ide.common.function.DialogFuncEditor_this_windowAdapter;
import com.scudata.ide.common.function.DialogFuncOption;
import com.scudata.ide.common.function.FuncInfo;
import com.scudata.ide.common.function.FuncManager;
import com.scudata.ide.common.function.FuncOption;
import com.scudata.ide.common.function.FuncParam;
import com.scudata.ide.common.function.FuncTreeNode;
import com.scudata.ide.common.function.FuncTreeRender;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.ButtonEditor;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.JComboBoxExRenderer;
import com.scudata.ide.common.swing.JListEx;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.VFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class DialogFuncEditor
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton jBSave = new JButton();
    private JButton jBClose = new JButton();
    private JSplitPane jSplitPane1 = new JSplitPane();
    private JTextField textPath = new JTextField();
    private JButton jBSort = new JButton();
    private JButton jBAddFunc = new JButton();
    private JButton jBDelFunc = new JButton();
    private JButton jBUpFunc = new JButton();
    private JButton jBDownFunc = new JButton();
    private JTextField textName = new JTextField();
    private JTextField textDesc = new JTextField();
    private JTextField textDisplayStr = new JTextField();
    private JTextField textPostfix = new JTextField();
    private JComboBoxEx jCBMajorType = new JComboBoxEx();
    private JComboBoxEx jCBReturnType = new JComboBoxEx();
    private JButton jBAddOption = new JButton();
    private JButton jBDelOption = new JButton();
    private JButton jBUpOption = new JButton();
    private JButton jBDownOption = new JButton();
    private JButton jBAddParam = new JButton();
    private JButton jBDelParam = new JButton();
    private JButton jBUpParam = new JButton();
    private JButton jBDownParam = new JButton();
    private JTree funcTree = new JTree();
    private DefaultTreeModel funcModel;
    private JScrollPane jSPFuncs = new JScrollPane();
    private JListEx listFuncs = new JListEx();
    private JPanel panelFunc = new JPanel();
    private final byte COL_INDEX = 0;
    private final byte COL_DESC = 1;
    private final byte COL_CHAR = (byte)2;
    private final byte COL_SELECT = (byte)3;
    private MessageManager mm = IdeCommonMessage.get();
    private JTableEx tableOption = new JTableEx(this.mm.getMessage("dialogfunceditor.tableoption")){
        private static final long serialVersionUID = 1L;

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (!this.isItemDataChanged(row, col, value)) {
                return;
            }
            super.setValueAt(value, row, col);
            if (DialogFuncEditor.this.preventChanged) {
                return;
            }
            DialogFuncEditor.this.dataChanged();
        }
    };
    private final byte COL_REPEAT = (byte)3;
    private final byte COL_IDENTIFY = (byte)4;
    private final byte COL_OPTION = (byte)5;
    private final byte COL_FILTER = (byte)6;
    private final byte COL_OPTIONS = (byte)7;
    private final String OPTIONS = "options";
    private JTableEx tableParam = new JTableEx(String.valueOf(this.mm.getMessage("dialogfunceditor.tableparam")) + "options"){
        private static final long serialVersionUID = 1L;

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (!this.isItemDataChanged(row, col, value)) {
                return;
            }
            super.setValueAt(value, row, col);
            if (DialogFuncEditor.this.preventChanged) {
                return;
            }
            DialogFuncEditor.this.dataChanged();
            switch (col) {
                case 2: {
                    if (value != ":") break;
                    this.data.setValueAt(Boolean.FALSE, row, 3);
                    break;
                }
                case 3: {
                    if (value == null || !((Boolean)value).booleanValue() || this.data.getValueAt(row, 2) == null || !this.data.getValueAt(row, 2).equals(":")) break;
                    this.data.setValueAt(" ", row, 2);
                    break;
                }
                case 4: {
                    if (value != null && ((Boolean)value).booleanValue()) break;
                    this.data.setValueAt(null, row, 7);
                    this.data.setValueAt("", row, 6);
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            switch (column) {
                case 5: 
                case 6: {
                    Object identify = ((DialogFuncEditor)DialogFuncEditor.this).tableParam.data.getValueAt(row, 4);
                    boolean editable = identify != null && (Boolean)identify != false;
                    return editable;
                }
            }
            return true;
        }
    };
    private final int DIVIDERSIZE = 5;
    private FuncManager funcManager = FuncManager.getManager();
    private FuncTreeNode root;
    private FuncTreeNode oldNode;
    private boolean preventChanged = false;
    private boolean quitWhenClosed = true;
    private Boolean isAsc = null;
    private boolean isCN = false;
    private final String FUNC_NAME = "func";

    public DialogFuncEditor() {
        this((JFrame)null, true);
    }

    public DialogFuncEditor(JFrame frame, boolean quitWhenClosed) {
        super(frame, IdeCommonMessage.get().getMessage("dialogfunceditor.title"), true);
        try {
            this.quitWhenClosed = quitWhenClosed;
            this.isCN = GM.isChineseLanguage();
            this.initUI();
            this.init();
            GM.setWindowToolSize(this);
            GM.setDialogDefaultButton(this, this.jBSave, this.jBClose);
            this.setResizable(true);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    private void initUI() throws Exception {
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        VFlowLayout VFlowLayout1 = new VFlowLayout();
        jPanel2.setLayout(VFlowLayout1);
        this.jBSave.setMnemonic('S');
        this.jBSave.setText(this.mm.getMessage("dialogfunceditor.buttonsave"));
        this.jBSave.addActionListener(new DialogFuncEditor_jBSave_actionAdapter(this));
        this.jBClose.setMnemonic('C');
        this.jBClose.setText(this.mm.getMessage("dialogfunceditor.buttonclose"));
        this.jBClose.addActionListener(new DialogFuncEditor_jBClose_actionAdapter(this));
        BorderLayout borderLayout1 = new BorderLayout();
        JPanel jPanel3 = new JPanel();
        jPanel1.setLayout(borderLayout1);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout2);
        JLabel jLabel1 = new JLabel();
        jLabel1.setText(this.mm.getMessage("dialogfunceditor.filepath"));
        JPanel jPanel4 = new JPanel();
        BorderLayout borderLayout3 = new BorderLayout();
        JPanel jPanel6 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        jPanel4.setLayout(borderLayout3);
        FlowLayout flowLayout1 = new FlowLayout();
        jPanel6.setLayout(flowLayout1);
        this.jBAddFunc.setToolTipText(this.mm.getMessage("dialogfunceditor.addfunc"));
        this.jBDelFunc.setToolTipText(this.mm.getMessage("dialogfunceditor.delfunc"));
        this.jBUpFunc.setToolTipText(this.mm.getMessage("dialogfunceditor.funcup"));
        this.jBDownFunc.setToolTipText(this.mm.getMessage("dialogfunceditor.funcdown"));
        this.jBSort.setToolTipText(this.mm.getMessage("dialogfunceditor.sort"));
        this.jBAddFunc.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/b_add.gif"));
        this.jBAddFunc.addActionListener(new DialogFuncEditor_jBAddFunc_actionAdapter(this));
        this.jBDelFunc.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/b_delete.gif"));
        this.jBDelFunc.addActionListener(new DialogFuncEditor_jBDelFunc_actionAdapter(this));
        this.jBUpFunc.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_shiftup.gif"));
        this.jBUpFunc.addActionListener(new DialogFuncEditor_jBUpFunc_actionAdapter(this));
        this.jBDownFunc.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_shiftdown.gif"));
        this.jBDownFunc.addActionListener(new DialogFuncEditor_jBDownFunc_actionAdapter(this));
        this.jBSort.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_sort.gif"));
        this.jBSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean asc = DialogFuncEditor.this.isAsc == null ? true : DialogFuncEditor.this.isAsc;
                FuncTreeNode activeNode = DialogFuncEditor.this.getSelectedNode();
                if (activeNode != null && !DialogFuncEditor.this.selectNode(activeNode)) {
                    return;
                }
                int count = DialogFuncEditor.this.root.getChildCount();
                if (count == 0) {
                    return;
                }
                DialogFuncEditor.this.isAsc = !asc;
                Sequence seq = new Sequence(count);
                Sequence seq1 = new Sequence(count);
                int i = 0;
                while (i < count) {
                    FuncTreeNode funcNode = (FuncTreeNode)DialogFuncEditor.this.root.getChildAt(i);
                    FuncInfo fi = (FuncInfo)funcNode.getUserObject();
                    seq.add(fi.getName());
                    seq1.add(funcNode);
                    ++i;
                }
                String opt = "o";
                if (!asc) {
                    opt = String.valueOf(opt) + "z";
                }
                Sequence psort = seq.psort(opt);
                DialogFuncEditor.this.root.removeAllChildren();
                int i2 = 1;
                while (i2 <= count) {
                    int index = (Integer)psort.get(i2);
                    FuncTreeNode funcNode = (FuncTreeNode)seq1.get(index);
                    DialogFuncEditor.this.root.add(funcNode);
                    ++i2;
                }
                DialogFuncEditor.this.funcModel.nodeStructureChanged(DialogFuncEditor.this.root);
                DialogFuncEditor.this.dataChanged();
            }
        });
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        BorderLayout borderLayout2 = new BorderLayout();
        BorderLayout borderLayout4 = new BorderLayout();
        JPanel jPanel10 = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        JPanel jPanel11 = new JPanel();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.panelFunc.setLayout(gridBagLayout3);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(this.mm.getMessage("dialogfunceditor.name"));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(this.mm.getMessage("dialogfunceditor.desc"));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText(this.mm.getMessage("dialogfunceditor.suf"));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(this.mm.getMessage("dialogfunceditor.maintype"));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(this.mm.getMessage("dialogfunceditor.returntype"));
        JPanel jPanel7 = new JPanel();
        GridLayout gridLayout1 = new GridLayout();
        jPanel7.setLayout(gridLayout1);
        gridLayout1.setColumns(1);
        gridLayout1.setRows(2);
        jPanel8.setLayout(borderLayout2);
        jPanel9.setLayout(borderLayout4);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(this.mm.getMessage("dialogfunceditor.option"));
        this.jBAddOption.setToolTipText(this.mm.getMessage("dialogfunceditor.addopt"));
        this.jBDelOption.setToolTipText(this.mm.getMessage("dialogfunceditor.delopt"));
        this.jBUpOption.setToolTipText(this.mm.getMessage("dialogfunceditor.optup"));
        this.jBDownOption.setToolTipText(this.mm.getMessage("dialogfunceditor.optdown"));
        this.jBAddOption.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/b_add.gif"));
        this.jBAddOption.addActionListener(new DialogFuncEditor_jBAddOption_actionAdapter(this));
        this.jBDelOption.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/b_delete.gif"));
        this.jBDelOption.addActionListener(new DialogFuncEditor_jBDelOption_actionAdapter(this));
        this.jBUpOption.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_shiftup.gif"));
        this.jBUpOption.addActionListener(new DialogFuncEditor_jBUpOption_actionAdapter(this));
        this.jBDownOption.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_shiftdown.gif"));
        this.jBDownOption.addActionListener(new DialogFuncEditor_jBDownOption_actionAdapter(this));
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        jPanel10.setLayout(gridBagLayout4);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("\u53c2\u6570");
        this.jBAddParam.setToolTipText(this.mm.getMessage("dialogfunceditor.addparam"));
        this.jBDelParam.setToolTipText(this.mm.getMessage("dialogfunceditor.delparam"));
        this.jBUpParam.setToolTipText(this.mm.getMessage("dialogfunceditor.paramup"));
        this.jBDownParam.setToolTipText(this.mm.getMessage("dialogfunceditor.paramdown"));
        this.jBAddParam.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/b_add.gif"));
        this.jBAddParam.addActionListener(new DialogFuncEditor_jBAddParam_actionAdapter(this));
        this.jBDelParam.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/b_delete.gif"));
        this.jBDelParam.addActionListener(new DialogFuncEditor_jBDelParam_actionAdapter(this));
        this.jBUpParam.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_shiftup.gif"));
        this.jBUpParam.addActionListener(new DialogFuncEditor_jBUpParam_actionAdapter(this));
        this.jBDownParam.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_shiftdown.gif"));
        this.jBDownParam.addActionListener(new DialogFuncEditor_jBDownParam_actionAdapter(this));
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        jPanel11.setLayout(gridBagLayout5);
        this.listFuncs.addMouseListener(new DialogFuncEditor_listFuncs_mouseAdapter(this));
        this.addWindowListener(new DialogFuncEditor_this_windowAdapter(this));
        flowLayout1.setAlignment(2);
        this.setDefaultCloseOperation(0);
        this.funcTree.addMouseListener(new DialogFuncEditor_funcTree_mouseAdapter(this));
        this.textName.addKeyListener(new DialogFuncEditor_textName_keyAdapter(this));
        this.textDesc.addKeyListener(new DialogFuncEditor_textDesc_keyAdapter(this));
        this.textDisplayStr.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!DialogFuncEditor.this.preventChanged) {
                    DialogFuncEditor.this.dataChanged();
                }
            }
        });
        this.jCBMajorType.addActionListener(new DialogFuncEditor_jCBMajorType_actionAdapter(this));
        this.jCBReturnType.addActionListener(new DialogFuncEditor_jCBReturnType_actionAdapter(this));
        this.tableOption.addMouseListener(new DialogFuncEditor_tableOption_mouseAdapter(this));
        this.tableParam.addMouseListener(new DialogFuncEditor_tableParam_mouseAdapter(this));
        this.textPostfix.addKeyListener(new DialogFuncEditor_textPostfix_keyAdapter(this));
        this.getContentPane().add((Component)jPanel1, "Center");
        jPanel1.add((Component)jPanel3, "North");
        jPanel3.add((Component)jLabel1, GM.getGBC(1, 1));
        jPanel3.add((Component)this.textPath, GM.getGBC(1, 2, true));
        jPanel1.add((Component)this.jSplitPane1, "Center");
        this.getContentPane().add((Component)jPanel2, "East");
        jPanel2.add((Component)this.jBSave, null);
        jPanel2.add((Component)this.jBClose, null);
        this.jSplitPane1.add((Component)jPanel4, "left");
        jPanel4.add((Component)jPanel6, "North");
        jPanel6.add((Component)this.jBAddFunc, null);
        jPanel6.add((Component)this.jBDelFunc, null);
        jPanel6.add((Component)this.jBUpFunc, null);
        jPanel6.add((Component)this.jBDownFunc, null);
        jPanel6.add((Component)this.jBSort, null);
        jPanel4.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.funcTree, null);
        this.jSplitPane1.add((Component)this.panelFunc, "right");
        this.panelFunc.add((Component)jLabel3, GM.getGBC(0, 1));
        this.panelFunc.add((Component)this.textName, GM.getGBC(0, 2, true));
        this.panelFunc.add((Component)jLabel4, GM.getGBC(1, 1));
        this.panelFunc.add((Component)this.textDesc, GM.getGBC(1, 2, true));
        this.panelFunc.add((Component)new JLabel(this.mm.getMessage("dialogfunceditor.dispstr")), GM.getGBC(2, 1));
        this.panelFunc.add((Component)this.textDisplayStr, GM.getGBC(2, 2, true));
        this.panelFunc.add((Component)jLabel9, GM.getGBC(3, 1));
        this.panelFunc.add((Component)this.textPostfix, GM.getGBC(3, 2, true));
        this.panelFunc.add((Component)jLabel5, GM.getGBC(4, 1));
        this.panelFunc.add((Component)this.jCBMajorType, GM.getGBC(4, 2, true));
        this.panelFunc.add((Component)jLabel6, GM.getGBC(5, 1));
        this.panelFunc.add((Component)this.jCBReturnType, GM.getGBC(5, 2, true));
        GridBagConstraints gbc1 = GM.getGBC(6, 1, true, true);
        gbc1.gridwidth = 2;
        this.panelFunc.add((Component)jPanel7, gbc1);
        jPanel7.add((Component)jPanel8, null);
        jPanel8.add((Component)jPanel10, "North");
        jPanel10.add((Component)jLabel7, GM.getGBC(1, 1, true));
        jPanel10.add((Component)this.jBAddOption, GM.getGBC(1, 2));
        jPanel10.add((Component)this.jBDelOption, GM.getGBC(1, 3));
        jPanel10.add((Component)this.jBUpOption, GM.getGBC(1, 4));
        jPanel10.add((Component)this.jBDownOption, GM.getGBC(1, 5));
        jPanel8.add((Component)jScrollPane2, "Center");
        jScrollPane2.getViewport().add((Component)this.tableOption, null);
        jPanel7.add((Component)jPanel9, null);
        jPanel9.add((Component)jPanel11, "North");
        jPanel11.add((Component)jLabel8, GM.getGBC(1, 1, true));
        jPanel11.add((Component)this.jBAddParam, GM.getGBC(1, 2));
        jPanel11.add((Component)this.jBDelParam, GM.getGBC(1, 3));
        jPanel11.add((Component)this.jBUpParam, GM.getGBC(1, 4));
        jPanel11.add((Component)this.jBDownParam, GM.getGBC(1, 5));
        jPanel9.add((Component)jScrollPane3, "Center");
        jScrollPane3.getViewport().add((Component)this.tableParam, null);
        this.jSplitPane1.setDividerSize(5);
        this.jSplitPane1.setDividerLocation(200);
        this.jSPFuncs.getViewport().add((Component)this.listFuncs, null);
    }

    private void init() {
        this.preventChanged = true;
        this.initButton(this.jBAddFunc);
        this.initButton(this.jBDelFunc);
        this.initButton(this.jBUpFunc);
        this.initButton(this.jBDownFunc);
        this.initButton(this.jBSort);
        this.initButton(this.jBAddOption);
        this.initButton(this.jBDelOption);
        this.initButton(this.jBUpOption);
        this.initButton(this.jBDownOption);
        this.initButton(this.jBAddParam);
        this.initButton(this.jBDelParam);
        this.initButton(this.jBUpParam);
        this.initButton(this.jBDownParam);
        if (this.funcManager.readOnly()) {
            this.textName.setEditable(false);
            this.textDesc.setEditable(false);
            this.textDisplayStr.setEditable(false);
            this.textPostfix.setEditable(false);
            this.jCBMajorType.setEnabled(false);
            this.jCBReturnType.setEnabled(false);
            this.tableOption.setEnabled(false);
            this.tableParam.setEnabled(false);
        }
        this.jBSave.setEnabled(false);
        this.textPath.setEditable(false);
        this.textPath.setText(FuncManager.getFileName());
        this.initTree();
        this.jCBMajorType.x_setData(this.getCodeTypes(), this.getDispTypes());
        this.jCBReturnType.x_setData(this.getCodeTypes(), this.getDispTypes());
        this.tableOption.setIndexCol(0);
        this.tableOption.setRowHeight(20);
        TableColumn tc = this.tableOption.getColumn(2);
        int colWidth = 50;
        if (!this.isCN) {
            colWidth = 60;
        }
        tc.setMaxWidth(colWidth);
        tc.setPreferredWidth(colWidth);
        this.tableOption.setColumnCheckBox(3);
        tc = this.tableOption.getColumn(3);
        colWidth = 40;
        if (!this.isCN) {
            colWidth = 60;
        }
        tc.setMaxWidth(colWidth);
        tc.setMinWidth(colWidth);
        tc.setPreferredWidth(colWidth);
        this.tableParam.setIndexCol(0);
        this.tableParam.setRowHeight(20);
        this.tableParam.setColumnDropDown(2, this.getCodePreSigns(), this.getDispPreSigns());
        this.tableParam.setColumnCheckBox(3);
        tc = this.tableParam.getColumn(3);
        colWidth = 40;
        if (!this.isCN) {
            colWidth = 80;
        }
        tc.setMaxWidth(colWidth);
        tc.setMinWidth(colWidth);
        tc.setPreferredWidth(colWidth);
        this.tableParam.setColumnCheckBox(4);
        tc = this.tableParam.getColumn(4);
        colWidth = 40;
        if (!this.isCN) {
            colWidth = 60;
        }
        tc.setMaxWidth(colWidth);
        tc.setMinWidth(colWidth);
        tc.setPreferredWidth(colWidth);
        this.tableParam.setColumnVisible("options", false);
        this.tableParam.setColumnDropDown(6, this.getCodeFilter(), this.getDispFilter());
        tc = this.tableParam.getColumn(5);
        colWidth = 40;
        if (!this.isCN) {
            colWidth = 50;
        }
        tc.setMaxWidth(colWidth);
        tc.setMinWidth(colWidth);
        tc.setPreferredWidth(colWidth);
        tc.setCellEditor(new ButtonEditor(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void clicked() {
                DialogFuncOption dfo = new DialogFuncOption(DialogFuncEditor.this);
                int r = this.table.getEditingRow();
                Object optList = ((DialogFuncEditor)DialogFuncEditor.this).tableParam.data.getValueAt(r, 7);
                if (optList != null) {
                    dfo.setFuncOptions((ArrayList)optList);
                }
                dfo.setVisible(true);
                if (dfo.getOption() == 0) {
                    ((DialogFuncEditor)DialogFuncEditor.this).tableParam.data.setValueAt(dfo.getFuncOptions(), r, 7);
                    DialogFuncEditor.this.dataChanged();
                }
            }
        });
        tc.setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTextField tf = new JTextField();
                tf.setHorizontalAlignment(0);
                Object list = ((DialogFuncEditor)DialogFuncEditor.this).tableParam.data.getValueAt(row, 7);
                if (list != null) {
                    tf.setForeground(Color.BLUE);
                    tf.setText("\u25c6");
                } else {
                    tf.setForeground(Color.RED);
                    tf.setText("\u25c7");
                }
                tf.setBorder(BorderFactory.createEmptyBorder());
                if (isSelected) {
                    tf.setBackground(table.getSelectionBackground());
                } else {
                    tf.setBackground(table.getBackground());
                }
                Object identify = ((DialogFuncEditor)DialogFuncEditor.this).tableParam.data.getValueAt(row, 4);
                tf.setEditable(identify != null && (Boolean)identify != false);
                return tf;
            }
        });
        tc = this.tableParam.getColumn(6);
        tc.setCellRenderer(new EachFilterRender());
        this.preventChanged = false;
    }

    private void initTree() {
        this.oldNode = this.root = new FuncTreeNode((JDialog)this, this.mm.getMessage("dialogfunceditor.funclist"));
        int count = this.funcManager.size();
        int i = 0;
        while (i < count) {
            FuncInfo fi = this.funcManager.getFunc(i);
            FuncTreeNode funcNode = new FuncTreeNode((JDialog)this, fi);
            this.root.add(funcNode);
            ++i;
        }
        this.funcModel = new DefaultTreeModel(this.root);
        this.funcTree.setModel(this.funcModel);
        this.funcTree.setCellRenderer(new FuncTreeRender());
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel();
        dtsm.setSelectionMode(1);
        this.funcTree.setSelectionModel(dtsm);
        this.showRightPanel();
    }

    private void showRightPanel() {
        if (this.oldNode.isRoot()) {
            this.jBUpFunc.setEnabled(false);
            this.jBDownFunc.setEnabled(false);
            this.jBDelFunc.setEnabled(false);
            int c = this.root.getChildCount();
            Vector<String> funcs = new Vector<String>();
            int i = 0;
            while (i < c) {
                FuncTreeNode funcNode = (FuncTreeNode)this.root.getChildAt(i);
                funcs.add(funcNode.getName());
                ++i;
            }
            this.listFuncs.setListData(funcs);
            this.jSplitPane1.add((Component)this.jSPFuncs, "right");
        } else {
            if (!this.funcManager.readOnly()) {
                this.jBUpFunc.setEnabled(true);
                this.jBDownFunc.setEnabled(true);
                this.jBDelFunc.setEnabled(true);
            }
            this.setFuncInfo((FuncInfo)this.oldNode.getUserObject());
            this.jSplitPane1.add((Component)this.panelFunc, "right");
        }
        this.jSplitPane1.setDividerLocation(this.jSplitPane1.getDividerLocation());
    }

    private void dataChanged() {
        if (!this.funcManager.readOnly()) {
            this.jBSave.setEnabled(true);
        }
    }

    private FuncInfo getFuncInfo() {
        String name = this.textName.getText();
        if (!StringUtils.isValidString(name)) {
            JOptionPane.showMessageDialog(this, this.mm.getMessage("dialogfunceditor.emptyname"));
            return null;
        }
        if (!this.tableOption.verifyColumnData(2, this.mm.getMessage("dialogfunceditor.symbol"), true, this)) {
            return null;
        }
        this.tableParam.acceptText();
        FuncInfo fi = new FuncInfo();
        fi.setName(name);
        fi.setDesc(this.textDesc.getText());
        fi.setDisplayStr(this.textDisplayStr.getText());
        fi.setPostfix(this.textPostfix.getText());
        fi.setMajorType((Byte)this.jCBMajorType.x_getSelectedItem());
        fi.setReturnType((Byte)this.jCBReturnType.x_getSelectedItem());
        int count = this.tableOption.getRowCount();
        ArrayList<FuncOption> optList = new ArrayList<FuncOption>();
        int i = 0;
        while (i < count) {
            FuncOption fo = new FuncOption();
            fo.setOptionChar((String)this.tableOption.data.getValueAt(i, 2));
            if (this.tableOption.data.getValueAt(i, 1) != null) {
                fo.setDescription((String)this.tableOption.data.getValueAt(i, 1));
            } else {
                fo.setDescription(null);
            }
            if (this.tableOption.data.getValueAt(i, 3) != null) {
                fo.setDefaultSelect((Boolean)this.tableOption.data.getValueAt(i, 3));
            }
            optList.add(fo);
            ++i;
        }
        fi.setOptions(optList);
        count = this.tableParam.getRowCount();
        ArrayList<FuncParam> paramList = new ArrayList<FuncParam>();
        int i2 = 0;
        while (i2 < count) {
            FuncParam fp = new FuncParam();
            if (this.tableParam.data.getValueAt(i2, 1) != null) {
                fp.setDesc((String)this.tableParam.data.getValueAt(i2, 1));
            } else {
                fp.setDesc(null);
            }
            if (this.tableParam.data.getValueAt(i2, 2) == null || !StringUtils.isValidString(this.tableParam.data.getValueAt(i2, 2))) {
                fp.setPreSign(' ');
            } else {
                char preSign = ((String)this.tableParam.data.getValueAt(i2, 2)).charAt(0);
                fp.setPreSign(preSign);
                fp.setSubParam(preSign == ':');
            }
            if (this.tableParam.data.getValueAt(i2, 3) != null) {
                fp.setRepeatable((Boolean)this.tableParam.data.getValueAt(i2, 3));
            }
            boolean identify = false;
            if (this.tableParam.data.getValueAt(i2, 4) != null) {
                identify = (Boolean)this.tableParam.data.getValueAt(i2, 4);
                fp.setIdentifierOnly(identify);
            }
            if (identify) {
                if (this.tableParam.data.getValueAt(i2, 7) != null) {
                    fp.setOptions((ArrayList)this.tableParam.data.getValueAt(i2, 7));
                } else {
                    fp.setOptions(null);
                }
                if (this.tableParam.data.getValueAt(i2, 6) != null) {
                    fp.setFilterType((Byte)this.tableParam.data.getValueAt(i2, 6));
                }
            } else {
                fp.setOptions(null);
            }
            paramList.add(fp);
            ++i2;
        }
        fi.setParams(paramList);
        return fi;
    }

    private boolean selectNode(FuncTreeNode activeNode) {
        if (!this.oldNode.isRoot()) {
            FuncInfo fi = this.getFuncInfo();
            if (fi == null) {
                Object[] path = this.oldNode.getPath();
                this.funcTree.setSelectionPath(new TreePath(path));
                this.funcTree.scrollPathToVisible(new TreePath(path));
                return false;
            }
            this.oldNode.setUserObject(fi);
        }
        this.funcModel.nodeStructureChanged(activeNode);
        Object[] path = activeNode.getPath();
        this.funcTree.setSelectionPath(new TreePath(path));
        this.funcTree.scrollPathToVisible(new TreePath(path));
        this.funcTree.repaint();
        if (this.oldNode.equals(activeNode)) {
            return true;
        }
        this.oldNode = activeNode;
        this.showRightPanel();
        return true;
    }

    private void setFuncInfo(FuncInfo fi) {
        this.preventChanged = true;
        this.textName.setText(fi.getName());
        this.textDesc.setText(fi.getDesc());
        this.textDisplayStr.setText(fi.getDisplayStr());
        this.textPostfix.setText(fi.getPostfix());
        this.jCBMajorType.x_setSelectedCodeItem(new Byte(fi.getMajorType()));
        this.jCBReturnType.x_setSelectedCodeItem(new Byte(fi.getReturnType()));
        this.tableOption.data.setRowCount(0);
        ArrayList<FuncOption> optList = fi.getOptions();
        if (optList != null) {
            int i = 0;
            while (i < optList.size()) {
                FuncOption fo = optList.get(i);
                int r = this.tableOption.addRow();
                this.tableOption.data.setValueAt(fo.getDescription(), r, 1);
                this.tableOption.data.setValueAt(fo.getOptionChar(), r, 2);
                this.tableOption.data.setValueAt(new Boolean(fo.isDefaultSelect()), r, 3);
                ++i;
            }
        }
        this.tableParam.data.setRowCount(0);
        ArrayList<FuncParam> paramList = fi.getParams();
        if (paramList != null) {
            int i = 0;
            while (i < paramList.size()) {
                FuncParam fp = paramList.get(i);
                this.tableParam.addRow();
                this.tableParam.data.setValueAt(fp.getDesc(), i, 1);
                this.tableParam.data.setValueAt(String.valueOf(fp.getPreSign()), i, 2);
                this.tableParam.data.setValueAt(new Boolean(fp.isRepeatable()), i, 3);
                this.tableParam.data.setValueAt(new Boolean(fp.isIdentifierOnly()), i, 4);
                if (fp.isIdentifierOnly()) {
                    this.tableParam.data.setValueAt(fp.getOptions(), i, 7);
                    this.tableParam.data.setValueAt(new Byte(fp.getFilterType()), i, 6);
                }
                ++i;
            }
        }
        this.preventChanged = false;
    }

    private void initButton(JButton button) {
        Dimension d = new Dimension(20, 20);
        button.setPreferredSize(d);
        button.setMaximumSize(d);
        button.setEnabled(!this.funcManager.readOnly());
    }

    private Vector<String> getCodePreSigns() {
        Vector<String> v = new Vector<String>();
        v.add("");
        v.add(";");
        v.add(",");
        v.add(":");
        return v;
    }

    private Vector<String> getDispPreSigns() {
        Vector<String> v = new Vector<String>();
        v.add(this.mm.getMessage("dialogfunceditor.none"));
        v.add(this.mm.getMessage("dialogfunceditor.semicolon"));
        v.add(this.mm.getMessage("dialogfunceditor.comma"));
        v.add(this.mm.getMessage("dialogfunceditor.colon"));
        return v;
    }

    private Vector<Byte> getCodeTypes() {
        Vector<Byte> v = new Vector<Byte>();
        v.add(new Byte(1));
        v.add(new Byte(2));
        v.add(new Byte(101));
        v.add(new Byte(102));
        return v;
    }

    private Vector<String> getDispTypes() {
        Vector<String> v = new Vector<String>();
        v.add(this.mm.getMessage("dialogfunceditor.db"));
        v.add(this.mm.getMessage("dialogfunceditor.file"));
        v.add(this.mm.getMessage("dialogfunceditor.other"));
        v.add(this.mm.getMessage("dialogfunceditor.none"));
        return v;
    }

    private Vector<Byte> getCodeFilter() {
        Vector<Byte> v = new Vector<Byte>();
        v.add(new Byte(3));
        v.add(new Byte(1));
        v.add(new Byte(2));
        v.add(new Byte(0));
        return v;
    }

    private Vector<String> getDispFilter() {
        Vector<String> v = new Vector<String>();
        v.add(this.mm.getMessage("dialogfunceditor.consts"));
        v.add(this.mm.getMessage("dialogfunceditor.majorfield"));
        v.add(this.mm.getMessage("dialogfunceditor.firstparafield"));
        v.add(this.mm.getMessage("dialogfunceditor.empty"));
        return v;
    }

    private FuncTreeNode getSelectedNode() {
        if (this.funcTree.isSelectionEmpty()) {
            return null;
        }
        return (FuncTreeNode)this.funcTree.getSelectionPath().getLastPathComponent();
    }

    private String getNewFuncName() {
        int count = this.root.getChildCount();
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < count) {
            FuncTreeNode fNode = (FuncTreeNode)this.root.getChildAt(i);
            names.add(fNode.getName());
            ++i;
        }
        int index = 0;
        while (names.contains("func" + index)) {
            ++index;
        }
        return "func" + index;
    }

    void jBAddOption_actionPerformed(ActionEvent e) {
        this.tableOption.addRow();
        this.dataChanged();
    }

    void jBDelOption_actionPerformed(ActionEvent e) {
        this.tableOption.deleteSelectedRows();
        this.dataChanged();
    }

    void jBUpOption_actionPerformed(ActionEvent e) {
        int row = this.tableOption.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.tableOption.shiftRowUp(row);
        this.dataChanged();
    }

    void jBDownOption_actionPerformed(ActionEvent e) {
        int row = this.tableOption.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.tableOption.shiftRowDown(row);
        this.dataChanged();
    }

    void jBAddParam_actionPerformed(ActionEvent e) {
        this.tableParam.addRow();
        this.dataChanged();
    }

    void jBDelParam_actionPerformed(ActionEvent e) {
        this.tableParam.deleteSelectedRows();
        this.dataChanged();
    }

    void jBUpParam_actionPerformed(ActionEvent e) {
        int row = this.tableParam.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.tableParam.shiftRowUp(row);
        this.dataChanged();
    }

    void jBDownParam_actionPerformed(ActionEvent e) {
        int row = this.tableParam.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.tableParam.shiftRowDown(row);
        this.dataChanged();
    }

    void jBAddFunc_actionPerformed(ActionEvent e) {
        FuncInfo fi = new FuncInfo();
        fi.setName(this.getNewFuncName());
        FuncTreeNode funcNode = new FuncTreeNode((JDialog)this, fi);
        this.root.add(funcNode);
        this.funcModel.nodeStructureChanged(this.root);
        this.selectNode(funcNode);
        this.dataChanged();
    }

    void jBDelFunc_actionPerformed(ActionEvent e) {
        FuncTreeNode funcNode = this.getSelectedNode();
        if (funcNode == null) {
            JOptionPane.showMessageDialog(this, this.mm.getMessage("dialogfunceditor.nofuncnode"));
            return;
        }
        int index = this.root.getIndex(funcNode);
        this.root.remove(funcNode);
        this.funcModel.nodeStructureChanged(this.root);
        if (this.root.getChildCount() == 0) {
            this.selectNode(this.root);
        } else {
            int newPos = 0;
            if (index > 0) {
                newPos = index - 1;
            }
            this.selectNode((FuncTreeNode)this.root.getChildAt(newPos));
        }
        this.dataChanged();
    }

    void jBUpFunc_actionPerformed(ActionEvent e) {
        FuncTreeNode funcNode = this.getSelectedNode();
        if (funcNode == null) {
            JOptionPane.showMessageDialog(this, this.mm.getMessage("dialogfunceditor.nofuncup"));
            return;
        }
        int index = this.root.getIndex(this.oldNode);
        if (index < 1 || index > this.root.getChildCount() - 1) {
            return;
        }
        this.root.insert((FuncTreeNode)this.root.getChildAt(index - 1), index);
        this.root.insert(this.oldNode, index - 1);
        this.funcModel.nodeStructureChanged(this.oldNode);
        this.funcModel.nodeStructureChanged(this.root.getChildAt(index - 1));
        Object[] path = this.oldNode.getPath();
        this.funcTree.setSelectionPath(new TreePath(path));
        this.funcTree.scrollPathToVisible(new TreePath(path));
        this.dataChanged();
    }

    void jBDownFunc_actionPerformed(ActionEvent e) {
        FuncTreeNode funcNode = this.getSelectedNode();
        if (funcNode == null) {
            JOptionPane.showMessageDialog(this, this.mm.getMessage("dialogfunceditor.nofuncdown"));
            return;
        }
        int index = this.root.getIndex(this.oldNode);
        if (index < 0 || index > this.root.getChildCount() - 2) {
            return;
        }
        this.root.insert((FuncTreeNode)this.root.getChildAt(index + 1), index);
        this.root.insert(this.oldNode, index + 1);
        this.funcModel.nodeStructureChanged(this.oldNode);
        this.funcModel.nodeStructureChanged(this.root.getChildAt(index + 1));
        Object[] path = this.oldNode.getPath();
        this.funcTree.setSelectionPath(new TreePath(path));
        this.funcTree.scrollPathToVisible(new TreePath(path));
        this.dataChanged();
    }

    void listFuncs_mouseClicked(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        int index = this.listFuncs.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.selectNode((FuncTreeNode)this.root.getChildAt(index));
    }

    private boolean save() {
        FuncTreeNode activeNode = this.getSelectedNode();
        if (activeNode != null && !this.selectNode(activeNode)) {
            return false;
        }
        this.funcManager.clear();
        int count = this.root.getChildCount();
        int i = 0;
        while (i < count) {
            FuncTreeNode funcNode = (FuncTreeNode)this.root.getChildAt(i);
            FuncInfo fi = (FuncInfo)funcNode.getUserObject();
            this.funcManager.addFunc(fi);
            ++i;
        }
        if (this.funcManager.save()) {
            this.jBSave.setEnabled(false);
            return true;
        }
        return false;
    }

    void jBSave_actionPerformed(ActionEvent e) {
        this.save();
    }

    private void close() {
        if (this.jBSave.isEnabled()) {
            String title;
            String message = this.mm.getMessage("dialogfunceditor.savemodify");
            int option = JOptionPane.showConfirmDialog(null, message, title = this.mm.getMessage("dialogfunceditor.close"), 1);
            if (option == 0) {
                if (this.save()) {
                    return;
                }
            } else {
                if (option == 2) {
                    return;
                }
                if (option == -1) {
                    return;
                }
            }
        }
        GM.setWindowDimension(this);
        this.dispose();
        if (this.quitWhenClosed) {
            System.exit(0);
        }
    }

    void jBClose_actionPerformed(ActionEvent e) {
        this.close();
    }

    void this_windowClosing(WindowEvent e) {
        this.close();
    }

    void funcTree_mousePressed(MouseEvent e) {
        TreePath path = this.funcTree.getClosestPathForLocation(e.getX(), e.getY());
        FuncTreeNode node = (FuncTreeNode)path.getLastPathComponent();
        this.selectNode(node);
    }

    void jCBMajorType_actionPerformed(ActionEvent e) {
        if (!this.preventChanged) {
            this.dataChanged();
        }
    }

    void jCBReturnType_actionPerformed(ActionEvent e) {
        if (!this.preventChanged) {
            this.dataChanged();
        }
    }

    void textName_keyReleased(KeyEvent e) {
        this.oldNode.setName(this.textName.getText());
        this.funcModel.nodeStructureChanged(this.oldNode);
        if (!this.preventChanged) {
            this.dataChanged();
        }
    }

    void textDesc_keyReleased(KeyEvent e) {
        if (!this.preventChanged) {
            this.dataChanged();
        }
    }

    void tableOption_mousePressed(MouseEvent e) {
        this.tableParam.acceptText();
    }

    void tableParam_mousePressed(MouseEvent e) {
        this.tableOption.acceptText();
    }

    void funcTree_mouseReleased(MouseEvent e) {
        if (e.getButton() != 3) {
            return;
        }
        if (this.oldNode.isRoot()) {
            return;
        }
        JPopupMenu pop = new JPopupMenu();
        JMenuItem menu = new JMenuItem(this.mm.getMessage("dialogfunceditor.insertfunc"));
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = DialogFuncEditor.this.root.getIndex(DialogFuncEditor.this.oldNode);
                FuncInfo fi = new FuncInfo();
                fi.setName(DialogFuncEditor.this.getNewFuncName());
                FuncTreeNode funcNode = new FuncTreeNode((JDialog)DialogFuncEditor.this, fi);
                DialogFuncEditor.this.root.insert(funcNode, index);
                DialogFuncEditor.this.funcModel.nodeStructureChanged(DialogFuncEditor.this.root);
                DialogFuncEditor.this.selectNode(funcNode);
                DialogFuncEditor.this.dataChanged();
            }
        });
        pop.add(menu);
        pop.show(e.getComponent(), e.getX(), e.getY());
    }

    void textPostfix_keyReleased(KeyEvent e) {
        if (!this.preventChanged) {
            this.dataChanged();
        }
    }

    public static void main(String[] args) {
        AppFrame.resetInstallDirectories();
        new DialogFuncEditor().setVisible(true);
    }

    class EachFilterRender
    implements TableCellRenderer {
        TableCellRenderer cellRenderer;

        public EachFilterRender() {
            JComboBoxEx combo = new JComboBoxEx();
            combo.x_setData(DialogFuncEditor.this.getCodeFilter(), DialogFuncEditor.this.getDispFilter());
            this.cellRenderer = new JComboBoxExRenderer(combo);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean enable;
            Object identify = ((DialogFuncEditor)DialogFuncEditor.this).tableParam.data.getValueAt(row, 4);
            boolean bl = enable = identify != null && (Boolean)identify != false;
            if (!enable) {
                return new JPanel();
            }
            return this.cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

