/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.function;

import com.scudata.app.common.Section;
import com.scudata.common.Logger;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.XMLFile;
import com.scudata.ide.common.function.FuncInfo;
import com.scudata.ide.common.function.FuncOption;
import com.scudata.ide.common.function.FuncParam;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class FuncManager {
    private static String fileName = null;
    private static FuncManager fm = new FuncManager();
    private ArrayList<FuncInfo> funcList;
    private final String ROOT = "funcs";
    private final String NORMAL = "normal";
    private static String relativeFile = null;
    private boolean readonly;

    public static FuncManager getManager() {
        return fm;
    }

    private FuncManager() {
        block4: {
            this.ROOT = "funcs";
            this.NORMAL = "normal";
            this.readonly = false;
            this.funcList = new ArrayList();
            try {
                this.load(FuncManager.getFileName());
            }
            catch (Throwable x) {
                fileName = FuncManager.getRelativeFile();
                this.readonly = true;
                InputStream is = FuncManager.class.getResourceAsStream(FuncManager.getRelativeFile());
                if (is == null) break block4;
                try {
                    this.load(is);
                }
                catch (Throwable t) {
                    Logger.debug(t);
                }
            }
        }
    }

    private static String getRelativeFile() {
        if (relativeFile == null) {
            String pre = "esProc";
            String suf = GM.getLanguageSuffix();
            relativeFile = "config/" + pre + "Functions" + suf + "." + "xml";
        }
        return relativeFile;
    }

    public boolean readOnly() {
        return this.readonly;
    }

    public static String getFileName() {
        if (fileName == null) {
            fileName = GM.getAbsolutePath(FuncManager.getRelativeFile());
        }
        return fileName;
    }

    public void load(String fileName) throws Throwable {
        XMLFile xml = new XMLFile(fileName);
        this.load(xml);
    }

    public void load(InputStream is) throws Throwable {
        XMLFile xml = new XMLFile(is);
        this.load(xml);
    }

    private void load(XMLFile xml) throws Throwable {
        this.funcList.clear();
        Section funcIDs = xml.listElement("funcs/normal");
        int i = 0;
        while (i < funcIDs.size()) {
            String fID = funcIDs.get(i);
            String path = "funcs/normal/" + fID + "/";
            FuncInfo fi = new FuncInfo();
            fi.setName(xml.getAttribute(String.valueOf(path) + "name"));
            fi.setDesc(xml.getAttribute(String.valueOf(path) + "desc"));
            fi.setDisplayStr(xml.getAttribute(String.valueOf(path) + "displaystr"));
            try {
                fi.setPostfix(xml.getAttribute(String.valueOf(path) + "postfix"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String tmp = xml.getAttribute(String.valueOf(path) + "majortype");
            fi.setMajorType(Byte.parseByte(tmp));
            tmp = xml.getAttribute(String.valueOf(path) + "returntype");
            fi.setReturnType(Byte.parseByte(tmp));
            fi.setOptions(this.loadOptions(xml, String.valueOf(path) + "options"));
            fi.setParams(this.loadParams(xml, String.valueOf(path) + "params"));
            this.funcList.add(fi);
            ++i;
        }
    }

    ArrayList<FuncOption> loadOptions(XMLFile xml, String rootPath) {
        Section options;
        block5: {
            options = xml.listElement(rootPath);
            if (options.size() >= 1) break block5;
            return null;
        }
        try {
            ArrayList<FuncOption> al = new ArrayList<FuncOption>(options.size());
            int i = 0;
            while (i < options.size()) {
                String opKey = options.get(i);
                FuncOption fo = new FuncOption();
                fo.setOptionChar(xml.getAttribute(String.valueOf(rootPath) + "/" + opKey + "/optionchar"));
                fo.setDescription(xml.getAttribute(String.valueOf(rootPath) + "/" + opKey + "/description"));
                String select = xml.getAttribute(String.valueOf(rootPath) + "/" + opKey + "/defaultselect");
                if (StringUtils.isValidString(select)) {
                    fo.setDefaultSelect(Boolean.valueOf(select));
                }
                al.add(fo);
                ++i;
            }
            return al;
        }
        catch (Exception exception) {
            return null;
        }
    }

    void storeOptions(XMLFile xml, String rootPath, ArrayList<FuncOption> options) {
        try {
            if (options.size() < 1) {
                return;
            }
            int i = 0;
            while (i < options.size()) {
                FuncOption fo = options.get(i);
                String opKey = "O" + Integer.toString(i + 1);
                xml.newElement(rootPath, opKey);
                String path = String.valueOf(rootPath) + "/" + opKey + "/";
                xml.setAttribute(String.valueOf(path) + "optionchar", fo.getOptionChar());
                xml.setAttribute(String.valueOf(path) + "description", this.removeTab(fo.getDescription()));
                xml.setAttribute(String.valueOf(path) + "defaultselect", String.valueOf(fo.isDefaultSelect()));
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    ArrayList<FuncParam> loadParams(XMLFile xml, String rootPath) {
        Section params;
        block10: {
            params = xml.listElement(rootPath);
            if (params.size() >= 1) break block10;
            return null;
        }
        try {
            ArrayList<FuncParam> al = new ArrayList<FuncParam>(params.size());
            int i = 0;
            while (i < params.size()) {
                String paraKey = params.get(i);
                FuncParam fp = new FuncParam();
                String path = String.valueOf(rootPath) + "/" + paraKey + "/";
                fp.setDesc(xml.getAttribute(String.valueOf(path) + "desc"));
                String tmp = xml.getAttribute(String.valueOf(path) + "presign");
                if (!StringUtils.isValidString(tmp)) {
                    fp.setPreSign(' ');
                } else {
                    fp.setPreSign(tmp.charAt(0));
                }
                tmp = xml.getAttribute(String.valueOf(path) + "subparam");
                if (StringUtils.isValidString(tmp)) {
                    fp.setSubParam(Boolean.valueOf(tmp));
                }
                if (StringUtils.isValidString(tmp = xml.getAttribute(String.valueOf(path) + "repeatable"))) {
                    fp.setRepeatable(Boolean.valueOf(tmp));
                }
                if (StringUtils.isValidString(tmp = xml.getAttribute(String.valueOf(path) + "identifieronly"))) {
                    fp.setIdentifierOnly(Boolean.valueOf(tmp));
                }
                fp.setOptions(this.loadOptions(xml, String.valueOf(path) + "options"));
                tmp = xml.getAttribute(String.valueOf(path) + "filtertype");
                if (StringUtils.isValidString(tmp)) {
                    fp.setFilterType(Byte.parseByte(tmp));
                }
                al.add(fp);
                ++i;
            }
            return al;
        }
        catch (Exception exception) {
            return null;
        }
    }

    void storeParams(XMLFile xml, String rootPath, ArrayList<FuncParam> params) {
        try {
            if (params.size() < 1) {
                return;
            }
            int i = 0;
            while (i < params.size()) {
                FuncParam fp = params.get(i);
                String pKey = "P" + Integer.toString(i + 1);
                xml.newElement(rootPath, pKey);
                String path = String.valueOf(rootPath) + "/" + pKey;
                xml.setAttribute(String.valueOf(path) + "/desc", this.removeTab(fp.getDesc()));
                xml.setAttribute(String.valueOf(path) + "/presign", String.valueOf(fp.getPreSign()));
                xml.setAttribute(String.valueOf(path) + "/subparam", String.valueOf(fp.isSubParam()));
                xml.setAttribute(String.valueOf(path) + "/repeatable", String.valueOf(fp.isRepeatable()));
                xml.setAttribute(String.valueOf(path) + "/identifieronly", String.valueOf(fp.isIdentifierOnly()));
                xml.setAttribute(String.valueOf(path) + "/valuestring", fp.getParamValue());
                xml.newElement(path, "options");
                this.storeOptions(xml, String.valueOf(path) + "/options", fp.getOptions());
                xml.setAttribute(String.valueOf(path) + "/filtertype", String.valueOf(fp.getFilterType()));
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<FuncInfo> getFuncList() {
        return this.funcList;
    }

    public FuncInfo getFunc(int index) {
        return this.funcList.get(index);
    }

    public ArrayList<FuncInfo> getFunc(String funcName) {
        ArrayList<FuncInfo> al = null;
        int i = 0;
        while (i < this.funcList.size()) {
            FuncInfo fi = this.funcList.get(i);
            if (fi.getName().equalsIgnoreCase(funcName)) {
                if (al == null) {
                    al = new ArrayList<FuncInfo>();
                }
                al.add(fi);
            }
            ++i;
        }
        return al;
    }

    public int size() {
        return this.funcList.size();
    }

    public void clear() {
        this.funcList.clear();
    }

    public void addFunc(FuncInfo fi) {
        this.funcList.add(fi);
    }

    private String removeTab(String str) {
        if (str == null) {
            return str;
        }
        return Sentence.replace(str, "\t", "        ", 0);
    }

    public boolean save() {
        try {
            if (ConfigOptions.bAutoBackup.booleanValue()) {
                String backName = String.valueOf(fileName) + ".bak";
                File fb = new File(backName);
                fb.deleteOnExit();
                File old = new File(fileName);
                if (old.exists()) {
                    old.renameTo(fb);
                }
            }
            XMLFile xml = XMLFile.newXML(fileName, "funcs");
            xml.newElement("funcs", "normal");
            int i = 0;
            while (i < this.funcList.size()) {
                FuncInfo fi = this.getFunc(i);
                String fID = "F" + Integer.toString(i + 1);
                xml.newElement("funcs/normal", fID);
                String path = "funcs/normal/" + fID;
                xml.setAttribute(String.valueOf(path) + "/name", fi.getName());
                xml.setAttribute(String.valueOf(path) + "/desc", this.removeTab(fi.getDesc()));
                xml.setAttribute(String.valueOf(path) + "/displaystr", this.removeTab(fi.getDisplayStr()));
                xml.setAttribute(String.valueOf(path) + "/postfix", this.removeTab(fi.getPostfix()));
                xml.setAttribute(String.valueOf(path) + "/majortype", String.valueOf(fi.getMajorType()));
                xml.setAttribute(String.valueOf(path) + "/returntype", String.valueOf(fi.getReturnType()));
                xml.newElement(path, "options");
                this.storeOptions(xml, String.valueOf(path) + "/options", fi.getOptions());
                xml.newElement(path, "params");
                this.storeParams(xml, String.valueOf(path) + "/params", fi.getParams());
                ++i;
            }
            xml.save();
        }
        catch (Throwable t) {
            GM.showException(GV.appFrame, t);
            return false;
        }
        return true;
    }
}

