/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.function;

import com.scudata.cellset.ICellSet;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.expression.Expression;
import com.scudata.ide.common.function.EditingFuncInfo;
import com.scudata.ide.common.function.EditingFuncParam;
import com.scudata.ide.common.function.FuncInfo;
import com.scudata.ide.common.function.FuncParam;
import com.scudata.ide.common.function.IParamTreeNode;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.text.JTextComponent;

public final class ParamUtil {
    private static EditingFuncInfo lastEFI = null;

    public static IParamTreeNode parse(String paramStr) {
        return ParamUtil.parse(paramStr, '\u0000');
    }

    static String getFuncName(String exp, int p) {
        Point point = ParamUtil.pFuncName(exp, p);
        if (point == null) {
            return "";
        }
        String allName = exp.substring(point.x, point.y);
        int at = allName.indexOf(64);
        if (at >= 0) {
            return allName.substring(0, at);
        }
        return allName;
    }

    static Point pFuncName(String exp, int p) {
        int i;
        if (p >= exp.length()) {
            return null;
        }
        if (p > 1 && (exp.charAt(p - 1) == '@' || Sentence.isWordChar(exp.charAt(p - 1)))) {
            i = p;
            while (i < exp.length()) {
                if (exp.charAt(i) == '(') {
                    p = i + 1;
                    break;
                }
                if (exp.charAt(i) != '@' && !Sentence.isWordChar(exp.charAt(i))) break;
                ++i;
            }
        }
        i = p - 1;
        while (i >= 0) {
            int r;
            if (exp.charAt(i) == '(' && (r = Sentence.scanParenthesis(exp, i)) > 0 && r >= p) {
                int start = ParamUtil.scanPreIdentifier(exp, i);
                return new Point(start, i);
            }
            --i;
        }
        return null;
    }

    static String getFuncOption(String exp, int p) {
        Point point = ParamUtil.pFuncName(exp, p);
        if (point == null) {
            return "";
        }
        String allName = exp.substring(point.x, point.y);
        int at = allName.indexOf(64);
        if (at >= 0) {
            return allName.substring(at + 1);
        }
        return "";
    }

    public static EditingFuncInfo getEditingFunc(JTextComponent editor, ICellSet cellSet, Context context) {
        String editingFuncName;
        String exp = editor.getText();
        boolean addEqual = !exp.startsWith("=");
        int caretPosition = editor.getCaretPosition();
        if (addEqual) {
            exp = "=" + exp;
            ++caretPosition;
        }
        if ((editingFuncName = ParamUtil.getFuncName(exp, caretPosition)) == null) {
            return null;
        }
        String funcParam = ParamUtil.getFuncParams(exp, caretPosition);
        if (lastEFI != null && editingFuncName.equals(lastEFI.getFuncName()) && lastEFI.getFuncParam() != null && lastEFI.getFuncParam().getParamString() != null && lastEFI.getFuncParam().getParamString().equals(funcParam)) {
            return lastEFI;
        }
        Point p = ParamUtil.pFuncName(exp, caretPosition);
        if (p == null) {
            return null;
        }
        int start = p.x;
        int end = p.y + 1;
        String editingFuncOption = ParamUtil.getFuncOption(exp, caretPosition);
        EditingFuncParam editingFuncParam = new EditingFuncParam();
        editingFuncParam.setParamString(funcParam);
        editingFuncParam.setBoldPos(editor.getSelectionStart(), editor.getSelectionEnd());
        EditingFuncInfo efi = new EditingFuncInfo(editor, editingFuncName, editingFuncOption, editingFuncParam, addEqual ? start - 1 : start, addEqual ? end - 1 : end);
        String majorExp = exp.substring(0, start);
        try {
            Expression major = new Expression(cellSet, context, majorExp);
            byte majorType = major.getExpValueType(context);
            efi.setMajorType(majorType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return efi;
    }

    public static FuncInfo matchFuncInfoParams(FuncInfo srcFunc, String params) {
        if (!(StringUtils.isValidString(params) || srcFunc.getParams() != null && srcFunc.getParams().size() != 0)) {
            return (FuncInfo)srcFunc.deepClone();
        }
        IParamTreeNode paramTree = ParamUtil.parse(params);
        if (paramTree == null) {
            return null;
        }
        ArrayList<FuncParam> paramMatchResult = ParamUtil.match1(srcFunc.getParams(), paramTree);
        if (paramMatchResult != null) {
            FuncInfo cloneFunc = (FuncInfo)srcFunc.deepClone();
            cloneFunc.setParams(paramMatchResult);
            return cloneFunc;
        }
        return null;
    }

    private static ArrayList<FuncParam> match1(ArrayList<FuncParam> paramDefine, IParamTreeNode rootExp) {
        ArrayList<ArrayList<FuncParam>> defineLevel1 = ParamUtil.splitParamList(paramDefine, ';');
        ArrayList<IParamTreeNode> inputLevel1 = ParamUtil.getSubLevelParams(rootExp, ';');
        if (inputLevel1.size() > defineLevel1.size()) {
            return null;
        }
        ArrayList<FuncParam> al = new ArrayList<FuncParam>();
        int i = 0;
        while (i < inputLevel1.size()) {
            IParamTreeNode subParam = inputLevel1.get(i);
            ArrayList<FuncParam> subList = ParamUtil.match2(defineLevel1.get(i), subParam);
            if (subList == null) {
                return null;
            }
            al.addAll(subList);
            ++i;
        }
        i = inputLevel1.size();
        while (i < defineLevel1.size()) {
            al.addAll((Collection<FuncParam>)defineLevel1.get(i));
            ++i;
        }
        return al;
    }

    private static ArrayList<IParamTreeNode> getSubLevelParams(IParamTreeNode root, char levelChar) {
        ArrayList<IParamTreeNode> al = new ArrayList<IParamTreeNode>();
        if (root == null) {
            return al;
        }
        if (root.getType() == levelChar) {
            int i = 0;
            while (i < root.getSubSize()) {
                IParamTreeNode sub = root.getSub(i);
                al.add(sub);
                ++i;
            }
        } else {
            al.add(root);
        }
        return al;
    }

    private static ArrayList<FuncParam> match2(ArrayList<FuncParam> paramDefine, IParamTreeNode rootExp) {
        ArrayList<ArrayList<FuncParam>> defineLevel2 = ParamUtil.splitParamList(paramDefine, ',');
        ArrayList<IParamTreeNode> inputLevel2 = ParamUtil.getSubLevelParams(rootExp, ',');
        int repIndex = -1;
        int i = 0;
        while (i < defineLevel2.size()) {
            ArrayList<FuncParam> subDef = defineLevel2.get(i);
            if (subDef.isEmpty()) {
                repIndex = i;
                break;
            }
            FuncParam fp = subDef.get(0);
            if (fp.isRepeatable()) {
                repIndex = i;
                break;
            }
            ++i;
        }
        if (inputLevel2.size() > defineLevel2.size() && repIndex < 0) {
            return null;
        }
        ArrayList<FuncParam> al = new ArrayList<FuncParam>();
        ArrayList<FuncParam> subDefine = new ArrayList();
        ArrayList<Object> subList = new ArrayList();
        int i2 = 0;
        while (i2 < inputLevel2.size()) {
            IParamTreeNode subParam = inputLevel2.get(i2);
            if (repIndex == 0 && defineLevel2.size() > 1) {
                if (i2 != 0 && i2 == inputLevel2.size() - 1) {
                    subDefine = defineLevel2.get(defineLevel2.size() - 1);
                    subList = ParamUtil.match3(subDefine, subParam);
                    if (subList == null) {
                        subDefine = defineLevel2.get(repIndex);
                        subList = ParamUtil.match3(subDefine, subParam);
                    }
                } else {
                    subDefine = defineLevel2.get(repIndex);
                    subList = ParamUtil.match3(subDefine, subParam);
                    if (subList == null) {
                        subDefine = defineLevel2.get(defineLevel2.size() - 1);
                        subList = ParamUtil.match3(subDefine, subParam);
                    }
                }
            } else {
                subDefine = i2 >= defineLevel2.size() ? defineLevel2.get(repIndex) : defineLevel2.get(i2);
                subList = ParamUtil.match3(subDefine, subParam);
            }
            if (subList == null) {
                return null;
            }
            al.addAll(subList);
            ++i2;
        }
        i2 = inputLevel2.size();
        while (i2 < defineLevel2.size()) {
            al.addAll((Collection<FuncParam>)defineLevel2.get(i2));
            ++i2;
        }
        return al;
    }

    private static ArrayList<FuncParam> match3(ArrayList<FuncParam> paramDefine, IParamTreeNode rootExp) {
        FuncParam cloneDefine;
        ArrayList<FuncParam> subDefine;
        ArrayList<ArrayList<FuncParam>> defineLevel3 = ParamUtil.splitParamList(paramDefine, ':');
        ArrayList<IParamTreeNode> inputLevel3 = ParamUtil.getSubLevelParams(rootExp, ',');
        if (inputLevel3.size() > defineLevel3.size()) {
            return null;
        }
        ArrayList<FuncParam> al = new ArrayList<FuncParam>();
        int i = 0;
        while (i < inputLevel3.size()) {
            subDefine = defineLevel3.get(i);
            if (!subDefine.isEmpty()) {
                cloneDefine = (FuncParam)subDefine.get(0).deepClone();
                IParamTreeNode subParam = inputLevel3.get(i);
                if (subParam != null) {
                    cloneDefine.setParamValue(subParam.getContent());
                }
                al.add(cloneDefine);
            }
            ++i;
        }
        i = inputLevel3.size();
        while (i < defineLevel3.size()) {
            subDefine = defineLevel3.get(i);
            if (!subDefine.isEmpty()) {
                cloneDefine = (FuncParam)subDefine.get(0).deepClone();
                al.add(cloneDefine);
            }
            ++i;
        }
        return al;
    }

    private static ArrayList<ArrayList<FuncParam>> splitParamList(ArrayList<FuncParam> params, char sign) {
        ArrayList<ArrayList<FuncParam>> al = new ArrayList<ArrayList<FuncParam>>();
        ArrayList<FuncParam> sub = new ArrayList<FuncParam>();
        al.add(sub);
        if (params != null) {
            int i = 0;
            while (i < params.size()) {
                FuncParam fp = params.get(i);
                if (fp.getPreSign() == sign && i != 0) {
                    sub = new ArrayList();
                    al.add(sub);
                }
                sub.add(fp);
                ++i;
            }
        }
        return al;
    }

    static String getFuncParams(String exp, int p) {
        Point point = ParamUtil.pFuncParams(exp, p);
        if (point == null) {
            return "";
        }
        return exp.substring(point.x, point.y);
    }

    private static Point pFuncParams(String exp, int p) {
        int i;
        if (p >= exp.length()) {
            return null;
        }
        if (p > 1 && (exp.charAt(p - 1) == '@' || Sentence.isWordChar(exp.charAt(p - 1)))) {
            i = p;
            while (i < exp.length()) {
                if (exp.charAt(i) == '(') {
                    p = i + 1;
                    break;
                }
                if (exp.charAt(i) != '@' && !Sentence.isWordChar(exp.charAt(i))) break;
                ++i;
            }
        }
        i = p - 1;
        while (i >= 0) {
            int r;
            if (exp.charAt(i) == '(' && (r = Sentence.scanParenthesis(exp, i)) > 0 && r >= p) {
                return new Point(i + 1, r);
            }
            --i;
        }
        return null;
    }

    static int scanPreIdentifier(String str, int end) {
        char ch;
        int i = end;
        while (i > 0) {
            if ((ch = str.charAt(--i)) == '\u0000' || ch == '\u0001' || ch != '@' && !Character.isJavaIdentifierPart(ch)) break;
        }
        while (i < end) {
            ch = str.charAt(i);
            if (Character.isJavaIdentifierStart(ch)) break;
            ++i;
        }
        return i;
    }

    private static IParamTreeNode parse(String paramStr, char prevLevel) {
        if (paramStr == null) {
            return null;
        }
        if ((paramStr = paramStr.trim()).length() == 0) {
            return null;
        }
        if (prevLevel == ':') {
            return new LeafParam(paramStr);
        }
        char level = ParamUtil.getNextLevel(prevLevel);
        while (!ParamUtil.hasSeparator(paramStr, level)) {
            if (level == ':') {
                return new LeafParam(paramStr);
            }
            level = ParamUtil.getNextLevel(level);
        }
        SymbolParam param = new SymbolParam(level);
        ArgumentTokenizer arg = new ArgumentTokenizer(paramStr, level);
        while (arg.hasMoreElements()) {
            param.addSub(ParamUtil.parse(arg.nextToken(), level));
        }
        return param;
    }

    private static char getNextLevel(char prevLevel) {
        switch (prevLevel) {
            case '\u0000': {
                return ';';
            }
            case ';': {
                return ',';
            }
            case ',': {
                return ':';
            }
        }
        throw new RQException();
    }

    private static boolean hasSeparator(String str, char separator) {
        int len = str.length();
        int index = 0;
        while (index < len) {
            int tmp;
            char ch = str.charAt(index);
            if (ch == separator) {
                return true;
            }
            if (ch == '\\') {
                index += 2;
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                tmp = Sentence.scanQuotation(str, index);
                if (tmp < 0) {
                    return false;
                }
                index = tmp + 1;
                continue;
            }
            if (ch == '(') {
                tmp = Sentence.scanParenthesis(str, index);
                if (tmp < 0) {
                    return false;
                }
                index = tmp + 1;
                continue;
            }
            if (ch == '[') {
                tmp = Sentence.scanBracket(str, index);
                if (tmp < 0) {
                    return false;
                }
                index = tmp + 1;
                continue;
            }
            if (ch == '{') {
                tmp = Sentence.scanBrace(str, index);
                if (tmp < 0) {
                    return false;
                }
                index = tmp + 1;
                continue;
            }
            ++index;
        }
        return false;
    }

    private static class LeafParam
    implements IParamTreeNode {
        private String content;

        public LeafParam(String content) {
            this.content = content;
        }

        @Override
        public char getType() {
            return '\u0000';
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public int getSubSize() {
            return 0;
        }

        @Override
        public IParamTreeNode getSub(int index) {
            throw new RuntimeException();
        }

        @Override
        public void getAllParam(List<IParamTreeNode> list) {
            list.add(this);
        }

        @Override
        public void getAllLeafParam(List<IParamTreeNode> list) {
            list.add(this);
        }
    }

    private static class SymbolParam
    implements IParamTreeNode {
        private List<IParamTreeNode> paramList = new ArrayList<IParamTreeNode>(3);
        private String content;
        private char type;

        public SymbolParam(char type) {
            this.type = type;
            switch (type) {
                case ';': {
                    this.content = ";";
                    break;
                }
                case ',': {
                    this.content = ",";
                    break;
                }
                case ':': {
                    this.content = ":";
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }

        @Override
        public char getType() {
            return this.type;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getSubSize() {
            return this.paramList.size();
        }

        @Override
        public IParamTreeNode getSub(int index) {
            return this.paramList.get(index);
        }

        @Override
        public void getAllParam(List<IParamTreeNode> list) {
            int i = 0;
            int size = this.getSubSize();
            while (i < size) {
                IParamTreeNode sub;
                if (i > 0) {
                    list.add(this);
                }
                if ((sub = this.getSub(i)) == null) {
                    list.add(null);
                } else {
                    sub.getAllParam(list);
                }
                ++i;
            }
        }

        @Override
        public void getAllLeafParam(List<IParamTreeNode> list) {
            int i = 0;
            int size = this.getSubSize();
            while (i < size) {
                IParamTreeNode sub = this.getSub(i);
                if (sub == null) {
                    list.add(null);
                } else {
                    sub.getAllLeafParam(list);
                }
                ++i;
            }
        }

        void addSub(IParamTreeNode param) {
            this.paramList.add(param);
        }
    }
}

