/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.control.ControlUtilsBase;
import com.scudata.ide.common.swing.JLabelUnderLine;
import com.scudata.util.Variant;
import java.awt.Component;
import java.awt.Font;
import java.math.BigDecimal;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class AllPurposeRenderer
implements TableCellRenderer {
    private JLabelUnderLine textField = new JLabelUnderLine();
    private boolean hasIndex = false;
    private String format;

    public AllPurposeRenderer() {
        this(false);
    }

    public AllPurposeRenderer(boolean hasIndex) {
        this.hasIndex = hasIndex;
    }

    public AllPurposeRenderer(String format) {
        this(format, false);
    }

    public AllPurposeRenderer(String format, boolean hasIndex) {
        this.format = format;
        this.hasIndex = hasIndex;
        this.textField.setBorder(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isDate;
        if (isSelected) {
            this.textField.setForeground(table.getSelectionForeground());
            if (ConfigOptions.getCellColor() != null) {
                this.textField.setBackground(ConfigOptions.getCellColor());
            } else {
                this.textField.setBackground(table.getSelectionBackground());
            }
        } else {
            this.textField.setBackground(table.getBackground());
            this.textField.setForeground(table.getForeground());
        }
        Font font = table.getFont();
        this.textField.setFont(font);
        this.textField.setOpaque(true);
        this.textField.setValue(value);
        if (GM.isRefVal(value)) {
            this.textField.setForeground(ConfigOptions.COLOR_REF);
        }
        boolean isNumber = value != null && value instanceof Number;
        boolean bl = isDate = value != null && value instanceof Date;
        if (isNumber) {
            this.textField.setHorizontalAlignment(4);
        } else {
            this.textField.setHorizontalAlignment(2);
        }
        String strText = null;
        try {
            Pattern p;
            Matcher m;
            boolean numFormat;
            if (StringUtils.isValidString(this.format) && ((numFormat = (m = (p = Pattern.compile("[#\\.0]")).matcher(this.format)).find()) && isNumber || isDate && !numFormat)) {
                strText = Variant.format(value, this.format);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (strText == null && value != null) {
            strText = GM.renderValueText(value);
        }
        if (value != null) {
            if (value instanceof BigDecimal) {
                this.textField.setForeground(ConfigOptions.COLOR_DECIMAL);
            } else if (value instanceof Double) {
                this.textField.setForeground(ConfigOptions.COLOR_DOUBLE);
            } else if (value instanceof Integer && (!this.hasIndex || column > 0)) {
                this.textField.setForeground(ConfigOptions.COLOR_INTEGER);
            }
            if (!ControlUtilsBase.canDisplayText(table.getFont(), strText)) {
                font = new Font("Dialog", font.getStyle(), font.getSize());
                this.textField.setFont(font);
            }
            this.textField.setDispText(strText);
        } else {
            this.textField.setDispText(GC.DISP_NULL);
            this.textField.setHorizontalAlignment(0);
            this.textField.setForeground(ConfigOptions.COLOR_NULL);
        }
        return this.textField;
    }
}

