/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.cellset.graph.config.Palette;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.ColorIcon;
import com.scudata.ide.common.swing.ColorRendererer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class ColorComboBox
extends JComboBox<Integer> {
    private static final long serialVersionUID = 1L;
    private boolean canEditExp = false;
    public static Integer transparentColor = new Integer(0xFFFFFF);
    static final Integer[] defColors = new Integer[]{new Integer(Color.black.getRGB()), new Integer(Color.gray.getRGB()), new Integer(Color.orange.getRGB()), new Integer(Color.red.getRGB()), new Integer(Color.blue.getRGB()), new Integer(Color.yellow.getRGB()), new Integer(Color.magenta.getRGB()), new Integer(Color.green.getRGB()), new Integer(Color.lightGray.getRGB()), new Integer(Color.white.getRGB()), transparentColor};

    public ColorComboBox() {
        this(true);
    }

    public ColorComboBox(Palette palette) {
        if (palette == null) {
            return;
        }
        this.removeAllItems();
        int i = 0;
        while (i < palette.size()) {
            int c = palette.getColor(i);
            this.addItem(c);
            ++i;
        }
    }

    private void init(boolean withTransparentColor) {
        if (!withTransparentColor) {
            this.removeItemAt(defColors.length - 1);
        }
        this.setEditor(new ColorComboBoxEditor(this));
        this.setRenderer(new ColorRendererer());
        this.setEditable(true);
        this.setPreferredSize(new Dimension(70, 25));
    }

    public ColorComboBox(boolean withTransparentColor) {
        super(defColors);
        this.init(withTransparentColor);
    }

    public void setWithTransparentColor(boolean withTransparentColor) {
        if (withTransparentColor) {
            Object lastColor = this.getItemAt(this.getItemCount() - 1);
            if (lastColor.equals(transparentColor)) {
                this.addItem(transparentColor);
            }
        } else {
            Object lastColor = this.getItemAt(this.getItemCount() - 1);
            if (lastColor.equals(transparentColor)) {
                this.removeItem(transparentColor);
                this.setSelectedIndex(this.getItemCount() - 1);
            }
        }
    }

    public Integer getColor() {
        return (Integer)this.getSelectedItem();
    }

    boolean isCanEditExp() {
        return this.canEditExp;
    }

    public void setAllowEditExp() {
        this.canEditExp = true;
    }

    class ColorComboBoxEditor
    extends BasicComboBoxEditor
    implements FocusListener {
        ColorComboBox parentContainer = null;
        ColorIcon editorIcon = new ColorIcon();
        JLabel editorLabel = new JLabel(this.editorIcon);
        Border lowerBorder;
        Border etchedBorder;
        Object color;
        Dialog dialog = null;
        JTextField colorExpField;
        JTextField colorValueDec;
        JTextField colorValueHex;
        JColorChooser colorChooser = new JColorChooser();

        public ColorComboBoxEditor(ColorComboBox p) {
            this.parentContainer = p;
            this.lowerBorder = BorderFactory.createLoweredBevelBorder();
            this.etchedBorder = BorderFactory.createEtchedBorder();
            this.editorLabel.setBorder(this.etchedBorder);
            this.editorLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ColorComboBoxEditor.this.editorLabel.setBorder(ColorComboBoxEditor.this.lowerBorder);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    ColorComboBoxEditor.this.editorLabel.setBorder(ColorComboBoxEditor.this.etchedBorder);
                    if (ColorComboBoxEditor.this.parentContainer.isEnabled()) {
                        if (ColorComboBoxEditor.this.dialog == null) {
                            if (ColorComboBoxEditor.this.parentContainer.isCanEditExp()) {
                                ColorComboBoxEditor.this.colorExpField = new JTextField();
                            }
                            ActionListener okListener = new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if ((this).ColorComboBoxEditor.this.parentContainer.isCanEditExp() && StringUtils.isValidString((this).ColorComboBoxEditor.this.colorExpField.getText())) {
                                        ColorComboBoxEditor.this.setColor((this).ColorComboBoxEditor.this.colorExpField.getText());
                                    } else {
                                        ColorComboBoxEditor.this.setColor((this).ColorComboBoxEditor.this.colorChooser.getColor());
                                    }
                                }
                            };
                            ColorComboBoxEditor.this.dialog = JColorChooser.createDialog(ColorComboBoxEditor.this.parentContainer, IdeCommonMessage.get().getMessage("colorcombobox.selectcolor"), true, ColorComboBoxEditor.this.colorChooser, okListener, null);
                            if (ColorComboBoxEditor.this.parentContainer.isCanEditExp()) {
                                JRootPane rp = (JRootPane)ColorComboBoxEditor.this.dialog.getComponent(0);
                                JPanel tmp = new JPanel(new GridBagLayout());
                                tmp.add((Component)new JLabel("Expression: "), GM.getGBC(1, 1));
                                tmp.add((Component)ColorComboBoxEditor.this.colorExpField, GM.getGBC(1, 2, true, false, 0));
                                JButton bt = new JButton("C");
                                bt.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        (this).ColorComboBoxEditor.this.colorExpField.setText("");
                                    }
                                });
                                tmp.add((Component)bt, GM.getGBC(1, 3));
                                rp.getContentPane().add((Component)tmp, "North");
                            }
                        }
                        if (ColorComboBoxEditor.this.color instanceof Integer) {
                            ColorComboBoxEditor.this.colorChooser.setColor(new Color((Integer)ColorComboBoxEditor.this.color, true));
                        } else if (ColorComboBoxEditor.this.parentContainer.isCanEditExp() && ColorComboBoxEditor.this.color instanceof String) {
                            ColorComboBoxEditor.this.colorExpField.setText((String)ColorComboBoxEditor.this.color);
                        }
                        ColorComboBoxEditor.this.dialog.setVisible(true);
                        ColorComboBoxEditor.this.dialog.dispose();
                        ColorComboBoxEditor.this.dialog = null;
                    }
                }
            });
        }

        @Override
        public Component getEditorComponent() {
            return this.editorLabel;
        }

        @Override
        public Object getItem() {
            return this.color;
        }

        @Override
        public void setItem(Object itemToSet) {
            this.editorLabel.setText("");
            this.color = itemToSet;
            this.editorIcon.setColor(itemToSet);
        }

        public void setColor(Object itemToSet) {
            if (itemToSet instanceof Color) {
                itemToSet = new Integer(((Color)itemToSet).getRGB());
            }
            this.setItem(itemToSet);
            this.parentContainer.setSelectedItem(itemToSet);
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

