/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.app.common.Section;
import com.scudata.common.MessageManager;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.MonthlyCalendar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DateChooser
extends JDialog {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private Calendar calendar;
    private Calendar retCal;
    private JComboBox jComboBox1;
    private JSpinner jSpinner1;
    private MonthlyCalendar monthCalendar;

    public DateChooser() {
        this.init();
    }

    public DateChooser(Dialog owner) {
        super(owner);
        this.init();
    }

    public DateChooser(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public DateChooser(Dialog owner, String title) {
        super(owner, title);
        this.init();
    }

    public DateChooser(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public DateChooser(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public DateChooser(Frame owner) {
        super(owner);
        this.init();
    }

    public DateChooser(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public DateChooser(Frame owner, String title) {
        super(owner, title);
        this.init();
    }

    public DateChooser(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public DateChooser(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public void initDate(Calendar calendar) {
        int m = calendar.get(2);
        this.jComboBox1.setSelectedIndex(m);
        this.jSpinner1.setValue(calendar.getTime());
        this.monthCalendar.setYearMonth(calendar);
    }

    private void init() {
        this.initComponents();
        this.calendar = Calendar.getInstance();
        this.initDate(this.calendar);
    }

    private void initComponents() {
        JPanel basePanel = new JPanel();
        JPanel containerPanel = new JPanel();
        JPanel controlPanel = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jSpinner1 = new JSpinner();
        JPanel viewPanel = new JPanel();
        this.monthCalendar = new MonthlyCalendar(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void dateSelected() {
                DateChooser.this.doSelection();
            }
        };
        this.setDefaultCloseOperation(2);
        this.setTitle(this.mm.getMessage("datechooser.selectdate"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DateChooser.this.formWindowClosing(evt);
            }
        });
        basePanel.setLayout(new FlowLayout(1, 10, 10));
        basePanel.setBackground(new Color(252, 250, 252));
        containerPanel.setLayout(new BorderLayout());
        containerPanel.setBorder(new TitledBorder(this.mm.getMessage("datechooser.date")));
        containerPanel.setOpaque(false);
        controlPanel.setLayout(new FlowLayout(1, 12, 0));
        controlPanel.setBorder(new EmptyBorder(new Insets(5, 0, 10, 0)));
        controlPanel.setOpaque(false);
        this.jComboBox1.setMaximumRowCount(7);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new Section(this.mm.getMessage("datechooser.month")).toStringArray()));
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DateChooser.this.jComboBox1ItemStateChanged(evt);
            }
        });
        controlPanel.add(this.jComboBox1);
        this.jSpinner1.setModel(new SpinnerDateModel());
        this.jSpinner1.setEditor(new JSpinner.DateEditor(this.jSpinner1, "yyyy"));
        this.jSpinner1.setPreferredSize(this.jComboBox1.getPreferredSize());
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DateChooser.this.jSpinner1StateChanged(evt);
            }
        });
        controlPanel.add(this.jSpinner1);
        containerPanel.add((Component)controlPanel, "North");
        viewPanel.setLayout(new FlowLayout(1, 0, 0));
        viewPanel.setBorder(new EmptyBorder(new Insets(0, 0, 10, 0)));
        viewPanel.setOpaque(false);
        this.monthCalendar.setBorder(new BevelBorder(1));
        viewPanel.add(this.monthCalendar);
        containerPanel.add((Component)viewPanel, "Center");
        basePanel.add(containerPanel);
        this.getContentPane().add((Component)basePanel, "Center");
        this.pack();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        Date date = (Date)this.jSpinner1.getValue();
        this.calendar.setTime(date);
        this.monthCalendar.setYear(this.calendar.get(1));
        this.monthCalendar.repaint();
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        this.monthCalendar.setMonth(this.jComboBox1.getSelectedIndex() + 1);
        this.monthCalendar.repaint();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.retCal = null;
    }

    @Override
    public void setVisible(boolean b) {
        this.monthCalendar.resetHighlight();
        super.setVisible(b);
    }

    private void doSelection() {
        this.retCal = this.monthCalendar.getSelectedDate();
        super.setVisible(false);
        this.dispose();
    }

    public Calendar getSelectedDate() {
        return this.retCal;
    }

    public void setYearMonth(int y, int m) {
        if (y < 1970) {
            throw new IllegalArgumentException(this.mm.getMessage("datechooser.err1"));
        }
        if (m < 1 || m > 12) {
            throw new IllegalArgumentException(this.mm.getMessage("datechooser.err2"));
        }
        this.jComboBox1.setSelectedIndex(m - 1);
        this.calendar.set(1, y);
        this.jSpinner1.setValue(this.calendar.getTime());
        this.monthCalendar.setYearMonth(y, m);
    }

    public void setWeekStartOnSunday(boolean b) {
        this.monthCalendar.setWeekStartOnSunday(b);
    }

    public boolean getWeekStartOnSunday() {
        return this.monthCalendar.getWeekStartOnSunday();
    }
}

