/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.common.ArgumentTokenizer;
import com.scudata.ide.common.swing.JListExHandler;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;

public class JListEx
extends JList {
    private static final long serialVersionUID = 1L;
    public DefaultListModel data = new DefaultListModel();
    private Vector<Object> codeData = new Vector();

    public JListEx() {
        super.setModel(this.data);
        this.setTransferHandler(new JListExHandler(this));
        this.addKeyListener(new KeyListener(){
            private StringBuffer buf = new StringBuffer();
            private int lastTypeTime = -1;

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                JList list = (JList)e.getSource();
                ListModel model = list.getModel();
                char key = e.getKeyChar();
                int now = (int)(System.currentTimeMillis() / 1000L);
                if (this.lastTypeTime > 0 && now - this.lastTypeTime > 2) {
                    this.buf.delete(0, this.buf.length());
                }
                this.lastTypeTime = now;
                this.buf.append(key);
                int i = 0;
                int size = model.getSize();
                boolean doubleSearch = false;
                while (i < size) {
                    String s = (String)model.getElementAt(i);
                    if (s != null && s.length() > 0 && s.startsWith(this.buf.toString())) {
                        list.setSelectedIndex(i);
                        list.ensureIndexIsVisible(i);
                        break;
                    }
                    if (!doubleSearch && i == size - 1) {
                        doubleSearch = true;
                        this.buf.delete(0, this.buf.length());
                        this.buf.append(key);
                        i = 0;
                    }
                    ++i;
                }
            }
        });
    }

    public JListEx(String items, char delim) {
        this();
        this.setListData(items, delim);
    }

    public JListEx(String items) {
        this(items, ',');
    }

    public JListEx(Object[] items) {
        this();
        this.setListData(items);
    }

    public JListEx(Vector items) {
        this();
        this.setListData(items);
    }

    public JListEx(DefaultListModel model) {
        this();
        if (model == null) {
            return;
        }
        this.setModel(model);
    }

    public boolean moveDropTarget(String moveData, JComponent dropedControl) {
        return false;
    }

    public void setListData(String items, char delim) {
        if (items == null) {
            return;
        }
        this.data.removeAllElements();
        ArgumentTokenizer at = new ArgumentTokenizer(items, delim);
        while (at.hasMoreTokens()) {
            this.data.addElement(at.nextToken());
        }
    }

    public void setListData(String items) {
        this.setListData(items, ',');
    }

    public void setListData(Object[] listData) {
        if (listData == null) {
            return;
        }
        this.data.removeAllElements();
        int i = 0;
        while (i < listData.length) {
            this.data.addElement(listData[i]);
            ++i;
        }
    }

    public void setListData(List listData) {
        if (listData == null) {
            return;
        }
        this.setListData(listData.toArray());
    }

    public void setModel(DefaultListModel model) {
        if (model == null) {
            return;
        }
        this.data = model;
        super.setModel(model);
    }

    public void removeSelectedItems() {
        if (this.data.size() == 0) {
            return;
        }
        int[] iSelects = this.getSelectedIndices();
        int i = iSelects.length - 1;
        while (i >= 0) {
            this.data.removeElementAt(iSelects[i]);
            --i;
        }
    }

    public String totalItems() {
        if (this.data.getSize() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.data.getSize()) {
            sb.append(this.data.get(i) + ",");
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public String selectedItems() {
        StringBuffer sb = new StringBuffer();
        Object[] sItems = this.getSelectedValues();
        if (sItems.length == 0) {
            return "";
        }
        int i = 0;
        while (i < sItems.length) {
            sb.append(sItems[i] + ",");
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public String getSelectedItems() {
        return this.selectedItems();
    }

    public boolean sort(boolean ascend) {
        int i = 0;
        while (i < this.data.size()) {
            if (!(this.data.get(i) instanceof Comparable)) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.data.size() - 1) {
            int j = i + 1;
            while (j < this.data.size()) {
                boolean lb_exchange;
                Comparable ci = (Comparable)this.data.get(i);
                Comparable cj = (Comparable)this.data.get(j);
                if (ascend) {
                    lb_exchange = ci.compareTo(cj) > 0;
                } else {
                    boolean bl = lb_exchange = ci.compareTo(cj) < 0;
                }
                if (lb_exchange) {
                    this.data.setElementAt(cj, i);
                    this.data.setElementAt(ci, j);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public synchronized void x_setData(List codeData, List dispData) {
        this.data.removeAllElements();
        this.setListData(dispData);
        this.codeData.removeAllElements();
        this.codeData.addAll(codeData);
    }

    public boolean x_sort(boolean sortByDisp, boolean ascend) {
        int i;
        if (sortByDisp) {
            i = 0;
            while (i < this.data.size()) {
                if (!(this.data.get(i) instanceof Comparable)) {
                    return false;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.data.size()) {
                if (!(this.codeData.get(i) instanceof Comparable)) {
                    return false;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.data.size() - 1) {
            int j = i + 1;
            while (j < this.data.size()) {
                boolean lb_exchange;
                Comparable cj;
                Comparable ci;
                if (sortByDisp) {
                    ci = (Comparable)this.data.get(i);
                    cj = (Comparable)this.data.get(j);
                } else {
                    ci = (Comparable)this.codeData.get(i);
                    cj = (Comparable)this.codeData.get(j);
                }
                if (ascend) {
                    lb_exchange = ci.compareTo(cj) > 0;
                } else {
                    boolean bl = lb_exchange = ci.compareTo(cj) < 0;
                }
                if (lb_exchange) {
                    Object o = this.data.get(i);
                    Object o2 = this.data.get(j);
                    this.data.setElementAt(o2, i);
                    this.data.setElementAt(o, j);
                    o = this.codeData.get(i);
                    o2 = this.codeData.get(j);
                    this.codeData.setElementAt(o2, i);
                    this.codeData.setElementAt(o, j);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public Object x_getCodeItem(String dispItem) {
        if (this.codeData == null || this.data == null) {
            return dispItem;
        }
        int i = 0;
        i = 0;
        while (i < this.data.size()) {
            String disp = (String)this.data.get(i);
            if (disp.equalsIgnoreCase(dispItem)) break;
            ++i;
        }
        if (i >= this.codeData.size()) {
            return dispItem;
        }
        return this.codeData.get(i);
    }

    public String x_getDispItem(Object codeItem) {
        if (this.codeData == null || this.data == null) {
            return codeItem.toString();
        }
        int i = 0;
        i = 0;
        while (i < this.codeData.size()) {
            Object code = this.codeData.get(i);
            if (code.equals(codeItem)) break;
            ++i;
        }
        if (i >= this.data.size()) {
            return codeItem.toString();
        }
        return (String)this.data.get(i);
    }

    public String x_SelectedItems() {
        StringBuffer sb = new StringBuffer();
        Object[] sItems = this.getSelectedValues();
        if (sItems.length == 0) {
            return "";
        }
        int i = 0;
        while (i < sItems.length) {
            sb.append(this.x_getCodeItem((String)sItems[i]) + ",");
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public void x_setModel(Vector codeData, DefaultListModel dispModel) {
        this.data = dispModel;
        super.setModel(dispModel);
        this.codeData = codeData;
    }

    public void x_removeAllElements() {
        this.data.removeAllElements();
        this.codeData.removeAllElements();
    }

    public void x_removeElement(int i) {
        if (this.data.getSize() > i) {
            this.data.removeElementAt(i);
        }
        if (this.codeData.size() > i) {
            this.codeData.removeElementAt(i);
        }
    }

    public void x_removeSelectedItems() {
        int[] ii = this.getSelectedIndices();
        int i = ii.length - 1;
        while (i >= 0) {
            this.x_removeElement(ii[i]);
            --i;
        }
    }

    public Object[] x_getSelectedValues() {
        Object[] d = this.getSelectedValues();
        Object[] c = new Object[d.length];
        int i = 0;
        while (i < d.length) {
            c[i] = this.x_getCodeItem((String)d[i]);
            ++i;
        }
        return c;
    }

    public void x_addElement(Object code, String disp) {
        this.codeData.addElement(code);
        this.data.addElement(disp);
    }

    public void x_insertElement(int index, Object code, String disp) {
        this.codeData.insertElementAt(code, index);
        this.data.insertElementAt(disp, index);
    }

    public void x_setElementAt(int index, Object code, String disp) {
        this.codeData.setElementAt(code, index);
        this.data.setElementAt(disp, index);
    }

    public void x_shiftElement(int index, boolean shiftUp) {
        if (index < 0) {
            return;
        }
        if (shiftUp && index <= 0) {
            return;
        }
        if (!shiftUp && index >= this.data.size() - 1) {
            return;
        }
        if (shiftUp) {
            Object tmp = this.codeData.get(index - 1);
            this.codeData.set(index - 1, this.codeData.get(index));
            this.codeData.set(index, tmp);
            tmp = this.data.get(index - 1);
            this.data.set(index - 1, this.data.get(index));
            this.data.set(index, tmp);
            this.setSelectedIndex(index - 1);
        } else {
            Object tmp = this.codeData.get(index + 1);
            this.codeData.set(index + 1, this.codeData.get(index));
            this.codeData.set(index, tmp);
            tmp = this.data.get(index + 1);
            this.data.set(index + 1, this.data.get(index));
            this.data.set(index, tmp);
            this.setSelectedIndex(index + 1);
        }
    }
}

