/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.app.common.Section;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.swing.JListEx;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.ListModel;
import javax.swing.TransferHandler;

class JListExHandler
extends TransferHandler {
    JListEx home;

    public JListExHandler(JListEx home) {
        this.home = home;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return c instanceof JListEx || c instanceof JTextArea || c instanceof JList || c instanceof JTextPane;
    }

    public static int getItemIndex(ListModel listData, String item) {
        int c = listData.getSize();
        int i = 0;
        while (i < c) {
            if (item.equalsIgnoreCase(listData.getElementAt(i).toString())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        String items;
        block15: {
            items = (String)t.getTransferData(DataFlavor.stringFlavor);
            if (!this.home.moveDropTarget(items, c)) break block15;
            return true;
        }
        try {
            Section sItems = new Section(items);
            if (c instanceof JListEx) {
                JListEx tList = (JListEx)c;
                int i = 0;
                while (i < sItems.size()) {
                    if (JListExHandler.getItemIndex(tList.data, sItems.get(i)) == -1) {
                        tList.data.addElement(sItems.get(i));
                    }
                    ++i;
                }
            } else if (c instanceof JList) {
                JList list = (JList)c;
                DefaultListModel lm = (DefaultListModel)list.getModel();
                int i = 0;
                while (i < sItems.size()) {
                    if (JListExHandler.getItemIndex(lm, sItems.get(i)) == -1) {
                        lm.addElement(sItems.get(i));
                    }
                    ++i;
                }
            } else if (c instanceof JTextArea) {
                JTextArea tta = (JTextArea)c;
                tta.setText(String.valueOf(tta.getText()) + " " + items);
            } else if (c instanceof JTextPane) {
                JTextPane ttp = (JTextPane)c;
                ttp.setText(String.valueOf(ttp.getText()) + " " + items);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception x) {
            GM.showException(GV.appFrame, x);
            return false;
        }
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JListEx list = (JListEx)c;
        Object[] items = list.getSelectedValues();
        Section sItems = new Section(items);
        return new StringSelection(sItems.toString());
    }
}

