/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.ide.common.swing.JTableExListener;
import com.scudata.ide.common.swing.JTextFieldReadOnly;
import com.scudata.util.Variant;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;

public class JTextAreaEditor
extends DefaultCellEditor
implements MouseListener {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_TEXT_SIMPLE = 1;
    public static final int TYPE_TEXT_WRAP = 2;
    public static final int TYPE_UNSIGNED_INTEGER = 3;
    public static final int TYPE_SIGNED_INTEGER = 4;
    public static final int TYPE_UNSIGNED_DOUBLE = 5;
    public static final int TYPE_SIGNED_DOUBLE = 6;
    public static final int TYPE_TEXT_READONLY = 7;
    private int editorType;
    private JScrollPane jsp;
    private JTableExListener parent;
    private JTextField textSimple = null;
    private JTextPane textWrap = null;
    private JTextField uInteger = null;
    private JTextField sInteger = null;
    private JTextField sNumber = null;
    private Object oldValue = null;

    public JTextAreaEditor(JTableExListener parent) {
        this(parent, 1);
    }

    public JTextAreaEditor(final JTableExListener parent, int editorType) {
        super(new JTextField(""));
        this.editorType = editorType;
        this.parent = parent;
        KeyAdapter kl = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e != null) {
                    JTextField txt;
                    Object src = e.getSource();
                    if (src instanceof JTextField && !(txt = (JTextField)src).isEditable()) {
                        return;
                    }
                    parent.stateChanged(new ChangeEvent(src));
                }
            }
        };
        switch (editorType) {
            case 2: {
                this.textWrap = new JTextPane();
                this.textWrap.addMouseListener(this);
                this.textWrap.addKeyListener(kl);
                this.textWrap.setBorder(BorderFactory.createEmptyBorder());
                this.jsp = new JScrollPane(this.textWrap);
                break;
            }
            case 4: {
                this.sInteger = new JTextField();
                this.sInteger.addKeyListener(kl);
                this.sInteger.addMouseListener(this);
                this.sInteger.setBorder(BorderFactory.createEmptyBorder());
                break;
            }
            case 3: {
                this.uInteger = new JTextField();
                this.uInteger.addMouseListener(this);
                this.uInteger.addKeyListener(kl);
                this.uInteger.setBorder(BorderFactory.createEmptyBorder());
                break;
            }
            case 5: {
                this.textSimple = new JTextField("");
                this.textSimple.addKeyListener(kl);
                this.textSimple.setBorder(BorderFactory.createEmptyBorder());
                break;
            }
            case 6: {
                this.sNumber = new JTextField();
                this.sNumber.addMouseListener(this);
                this.sNumber.addKeyListener(kl);
                this.sNumber.setBorder(BorderFactory.createEmptyBorder());
                break;
            }
            case 7: {
                this.textSimple = new JTextFieldReadOnly("");
                this.textSimple.addMouseListener(this);
                this.textSimple.setBorder(BorderFactory.createEmptyBorder());
                break;
            }
            default: {
                this.textSimple = new JTextField("");
                this.textSimple.addKeyListener(kl);
                this.textSimple.addMouseListener(this);
                this.textSimple.setBorder(BorderFactory.createEmptyBorder());
            }
        }
        this.setClickCountToStart(1);
    }

    public Component setValue(Object value) {
        JComponent o;
        this.oldValue = value;
        switch (this.editorType) {
            case 2: {
                if (value == null) {
                    this.textWrap.setText("");
                } else {
                    this.textWrap.setText(value.toString());
                }
                o = this.jsp;
                break;
            }
            case 4: {
                if (value == null || !(value instanceof Integer)) {
                    this.sInteger.setText("0");
                } else {
                    this.sInteger.setText(value.toString());
                }
                o = this.sInteger;
                break;
            }
            case 3: {
                if (value == null || !(value instanceof Integer)) {
                    this.uInteger.setText("0");
                } else {
                    this.uInteger.setText(value.toString());
                }
                o = this.uInteger;
                break;
            }
            case 5: {
                if (value == null) {
                    this.textSimple.setText("");
                } else {
                    this.textSimple.setText(value.toString());
                }
                o = this.textSimple;
                break;
            }
            case 6: {
                if (value == null) {
                    this.sNumber.setText("0");
                } else {
                    this.sNumber.setText(value.toString());
                }
                o = this.sNumber;
                break;
            }
            default: {
                if (value == null) {
                    this.textSimple.setText("");
                } else {
                    this.textSimple.setText(value.toString());
                }
                o = this.textSimple;
            }
        }
        return o;
    }

    @Override
    public Object getCellEditorValue() {
        Object value = null;
        switch (this.editorType) {
            case 2: {
                value = this.textWrap.getText();
                break;
            }
            case 4: {
                String tmp = this.sInteger.getText();
                value = Variant.parse(tmp);
                if (value instanceof Integer) break;
                value = this.oldValue;
                break;
            }
            case 3: {
                String tmp = this.uInteger.getText();
                value = Variant.parse(tmp);
                if (value instanceof Integer) break;
                value = this.oldValue;
                break;
            }
            case 5: {
                value = this.textSimple.getText();
                break;
            }
            case 6: {
                String tmp = this.sNumber.getText();
                value = Variant.parse(tmp);
                if (value instanceof Number) break;
                value = this.oldValue;
                break;
            }
            default: {
                value = this.textSimple.getText();
            }
        }
        return value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.setValue(value);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JComponent editor = (JComponent)e.getSource();
        Container ct = editor.getTopLevelAncestor();
        int absoluteX = e.getX() + editor.getX();
        int absoluteY = e.getY() + editor.getY();
        Container p = editor.getParent();
        while (p != ct) {
            absoluteX += p.getX();
            absoluteY += p.getY();
            p = p.getParent();
        }
        if (this.parent != null) {
            this.parent.fireClicked(absoluteX, absoluteY, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setArrange(int min, int max, int step) {
    }

    public void setArrange(double min, double max, double step) {
    }
}

