/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.ide.common.resources.IdeCommonMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MemoryMonitor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private static JCheckBox dateStampCB = new JCheckBox(IdeCommonMessage.get().getMessage("memorymonitor.outputdate"));
    public Surface surf;

    public MemoryMonitor() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), this.mm.getMessage("memorymonitor.mm")));
        this.surf = new Surface();
        this.add(this.surf);
        JPanel controls = new JPanel();
        controls.setPreferredSize(new Dimension(135, 80));
        Font font = new Font("Dialog", 0, 12);
        JLabel label = new JLabel(this.mm.getMessage("memorymonitor.samplerate"));
        label.setFont(font);
        label.setForeground(Color.black);
        controls.add(label);
        final JTextField tf = new JTextField("1000");
        tf.setPreferredSize(new Dimension(45, 20));
        controls.add(tf);
        label = new JLabel(this.mm.getMessage("memorymonitor.ms"));
        controls.add(label);
        label.setFont(font);
        label.setForeground(Color.black);
        controls.add(dateStampCB);
        dateStampCB.setFont(font);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MemoryMonitor.this.removeAll();
                try {
                    MemoryMonitor.this.surf.sleepAmount = Long.parseLong(tf.getText().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MemoryMonitor.this.surf.start();
                MemoryMonitor.this.add(MemoryMonitor.this.surf);
                MemoryMonitor.this.validate();
                MemoryMonitor.this.repaint();
            }
        });
    }

    public class Surface
    extends JPanel
    implements Runnable {
        private static final long serialVersionUID = 1L;
        public Thread thread;
        public long sleepAmount = 1000L;
        private volatile int w;
        private volatile int h;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font = new Font("Dialog", 0, 10);
        private Runtime r = Runtime.getRuntime();
        private int columnInc;
        private int[] pts;
        private int ptNum;
        private volatile int ascent;
        private volatile int descent;
        private Rectangle graphOutlineRect = new Rectangle();
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);
        private String usedStr;

        public Surface() {
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Surface.this.thread == null) {
                        Surface.this.start();
                    } else {
                        Surface.this.stop();
                    }
                }
            });
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(135, 80);
        }

        @Override
        public void paint(Graphics g) {
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            float freeMemory = this.r.freeMemory();
            float totalMemory = this.r.totalMemory();
            this.big.setColor(Color.green);
            this.big.drawString(String.valueOf(String.valueOf((int)totalMemory / 1024)) + "K " + MemoryMonitor.this.mm.getMessage("memorymonitor.allocated"), 4.0f, (float)this.ascent + 0.5f);
            this.usedStr = String.valueOf(String.valueOf((int)(totalMemory - freeMemory) / 1024)) + "K " + MemoryMonitor.this.mm.getMessage("memorymonitor.used");
            this.big.drawString(this.usedStr, 4, this.h - this.descent);
            float ssH = this.ascent + this.descent;
            float remainingHeight = (float)this.h - ssH * 2.0f - 0.5f;
            float blockHeight = remainingHeight / 10.0f;
            float blockWidth = 20.0f;
            this.big.setColor(this.mfColor);
            int MemUsage = (int)(freeMemory / totalMemory * 10.0f);
            int i = 0;
            while (i < MemUsage) {
                this.mfRect.setRect(5.0, ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.big.fill(this.mfRect);
                ++i;
            }
            this.big.setColor(Color.green);
            while (i < 10) {
                this.muRect.setRect(5.0, ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.big.fill(this.muRect);
                ++i;
            }
            this.big.setColor(this.graphColor);
            int graphX = 30;
            int graphY = (int)ssH;
            int graphW = this.w - graphX - 5;
            int graphH = (int)remainingHeight;
            this.graphOutlineRect.setRect(graphX, graphY, graphW, graphH);
            this.big.draw(this.graphOutlineRect);
            int graphRow = graphH / 10;
            int j = graphY;
            while (j <= graphH + graphY) {
                this.graphLine.setLine(graphX, j, graphX + graphW, j);
                this.big.draw(this.graphLine);
                j += graphRow;
            }
            int graphColumn = graphW / 15;
            if (this.columnInc == 0) {
                this.columnInc = graphColumn;
            }
            int j2 = graphX + this.columnInc;
            while (j2 < graphW + graphX) {
                this.graphLine.setLine(j2, graphY, j2, graphY + graphH);
                this.big.draw(this.graphLine);
                j2 += graphColumn;
            }
            --this.columnInc;
            if (this.pts == null) {
                this.pts = new int[graphW];
                this.ptNum = 0;
            } else if (this.pts.length != graphW) {
                int[] tmp = null;
                if (this.ptNum < graphW) {
                    tmp = new int[this.ptNum];
                    System.arraycopy(this.pts, 0, tmp, 0, tmp.length);
                } else {
                    tmp = new int[graphW];
                    System.arraycopy(this.pts, this.pts.length - tmp.length, tmp, 0, tmp.length);
                    this.ptNum = tmp.length - 2;
                }
                this.pts = new int[graphW];
                System.arraycopy(tmp, 0, this.pts, 0, tmp.length);
            } else {
                this.big.setColor(Color.yellow);
                this.pts[this.ptNum] = (int)((float)graphY + (float)graphH * (freeMemory / totalMemory));
                j2 = graphX + graphW - this.ptNum;
                int k = 0;
                while (k < this.ptNum) {
                    if (k != 0) {
                        if (this.pts[k] != this.pts[k - 1]) {
                            this.big.drawLine(j2 - 1, this.pts[k - 1], j2, this.pts[k]);
                        } else {
                            this.big.fillRect(j2, this.pts[k], 1, 1);
                        }
                    }
                    ++k;
                    ++j2;
                }
                if (this.ptNum + 2 == this.pts.length) {
                    j2 = 1;
                    while (j2 < this.ptNum) {
                        this.pts[j2 - 1] = this.pts[j2];
                        ++j2;
                    }
                    --this.ptNum;
                } else {
                    ++this.ptNum;
                }
            }
            g.drawImage(this.bimg, 0, 0, this);
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            while (this.thread == me && this.isShowing()) {
                Dimension d = this.getSize();
                if (d.width != this.w || d.height != this.h) {
                    this.w = d.width;
                    this.h = d.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    this.big.setFont(this.font);
                    FontMetrics fm = this.big.getFontMetrics(this.font);
                    this.ascent = fm.getAscent();
                    this.descent = fm.getDescent();
                }
                this.repaint();
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (!dateStampCB.isSelected()) continue;
                Logger.debug(String.valueOf(new Date().toString()) + " " + this.usedStr);
            }
            this.thread = null;
        }
    }
}

