/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.app.common.Section;
import com.scudata.common.MessageManager;
import com.scudata.common.SegmentSet;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.EditListener;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.swing.DialogSearch_jBCancel_actionAdapter;
import com.scudata.ide.common.swing.DialogSearch_jBReplaceAll_actionAdapter;
import com.scudata.ide.common.swing.DialogSearch_jBReplace_actionAdapter;
import com.scudata.ide.common.swing.DialogSearch_jBSearch_actionAdapter;
import com.scudata.ide.common.swing.DialogSearch_this_windowAdapter;
import com.scudata.ide.common.swing.RSyntaxTextArea2;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class RSyntaxDialogSearch
extends JDialog {
    private static final long serialVersionUID = 1L;
    RSyntaxTextArea2 txtEditor = null;
    static Section searchKeys = new Section();
    static Section replaceKeys = new Section();
    static SegmentSet status = new SegmentSet("");
    JPanel panel1 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JComboBox jCBSearch = new JComboBox();
    JComboBox jCBReplace = new JComboBox();
    JButton jBSearch = new JButton();
    JButton jBReplace = new JButton();
    JButton jBReplaceAll = new JButton();
    JButton jBCancel = new JButton();
    JCheckBox jCBSensitive = new JCheckBox();
    JCheckBox jCBWordOnly = new JCheckBox();
    JCheckBox jCBQuote = new JCheckBox();
    JCheckBox jCBPars = new JCheckBox();
    TitledBorder titledBorder1;
    JPanel jPanel2 = new JPanel();
    Border border1;
    TitledBorder titledBorder2;
    ButtonGroup bg1 = new ButtonGroup();
    ButtonGroup bg2 = new ButtonGroup();
    private MessageManager splMM = IdeSplMessage.get();
    private static final String KEY_QUOTE = "quote";
    private static final String KEY_RARS = "pars";
    private static final String KEY_WORDONLY = "wordonly";
    private static final String KEY_CASE = "case";
    private boolean isReplace = false;
    boolean isSearchClicked = false;
    private String searchString = "";
    private String replaceString = "";
    private int searchFlag;
    private int stringIndex = -1;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    VFlowLayout vFlowLayout1 = new VFlowLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public RSyntaxDialogSearch(Frame parent) {
        super(parent, "\u67e5\u627e", false);
        try {
            this.rqInit();
            this.init();
            GM.setDialogDefaultButton(this, this.jBSearch, this.jBCancel);
            this.jCBSearch.requestFocus();
            this.resetLangText();
            this.setResizable(true);
            this.pack();
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    public void setSearch(String search) {
        this.jCBSearch.setSelectedItem(search);
    }

    private void resetLangText() {
        this.setTitle(this.splMM.getMessage("dialogsearch.title"));
        this.titledBorder1.setTitle(this.splMM.getMessage("dialogsearch.titleborder1"));
        this.titledBorder2.setTitle(this.splMM.getMessage("dialogsearch.titleborder2"));
        this.jLabel1.setText(this.splMM.getMessage("dialogsearch.searchcontent"));
        this.jLabel2.setText(this.splMM.getMessage("dialogsearch.replaceas"));
        this.jBSearch.setText(this.splMM.getMessage("button.search"));
        this.jBReplace.setText(this.splMM.getMessage("button.replace"));
        this.jBReplaceAll.setText(this.splMM.getMessage("button.replaceall"));
        this.jBCancel.setText(this.splMM.getMessage("button.close"));
        this.jCBSensitive.setText(this.splMM.getMessage("dialogsearch.casesensitive"));
        this.jCBWordOnly.setText(this.splMM.getMessage("dialogsearch.wordonly"));
        this.jCBQuote.setText(this.splMM.getMessage("dialogsearch.ignorequote"));
        this.jCBPars.setText(this.splMM.getMessage("dialogsearch.ignorepars"));
    }

    void init() {
        String sTmp = status.get(KEY_CASE);
        if (StringUtils.isValidString(sTmp)) {
            this.jCBSensitive.setSelected(new Boolean(sTmp));
        }
        if (StringUtils.isValidString(sTmp = status.get(KEY_WORDONLY))) {
            this.jCBWordOnly.setSelected(new Boolean(sTmp));
        }
        if (StringUtils.isValidString(sTmp = status.get(KEY_QUOTE))) {
            this.jCBQuote.setSelected(new Boolean(sTmp));
        }
        if (StringUtils.isValidString(sTmp = status.get(KEY_RARS))) {
            this.jCBPars.setSelected(new Boolean(sTmp));
        }
    }

    void rememberStatus() {
        status.put(KEY_CASE, new Boolean(this.jCBSensitive.isSelected()).toString());
        status.put(KEY_WORDONLY, new Boolean(this.jCBWordOnly.isSelected()).toString());
        status.put(KEY_QUOTE, new Boolean(this.jCBQuote.isSelected()).toString());
        status.put(KEY_RARS, new Boolean(this.jCBPars.isSelected()).toString());
    }

    void resetDropItems() {
        String sTmp = (String)this.jCBSearch.getSelectedItem();
        this.jCBSearch.removeAllItems();
        searchKeys.unionSection(sTmp);
        int i = searchKeys.size() - 1;
        while (i >= 0) {
            this.jCBSearch.addItem(searchKeys.getSection(i));
            --i;
        }
        this.jCBSearch.setSelectedItem(sTmp);
        sTmp = (String)this.jCBReplace.getSelectedItem();
        this.jCBReplace.removeAllItems();
        replaceKeys.unionSection(sTmp);
        i = replaceKeys.size() - 1;
        while (i >= 0) {
            this.jCBReplace.addItem(replaceKeys.getSection(i));
            --i;
        }
        this.jCBReplace.setSelectedItem(sTmp);
    }

    public void setControl(RSyntaxTextArea2 editor) {
        this.setControl(editor, this.isReplace);
    }

    public void setControl(RSyntaxTextArea2 editor, boolean replace) {
        this.txtEditor = editor;
        this.isReplace = replace;
        this.resetDropItems();
        if (!replace) {
            this.jCBReplace.setEnabled(false);
            this.jBReplace.setEnabled(false);
            this.jBReplaceAll.setEnabled(false);
        } else {
            this.setTitle(this.splMM.getMessage("dialogsearch.replace"));
        }
    }

    private void rqInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "\u641c\u7d22\u683c\u5b50\u8303\u56f4");
        this.border1 = BorderFactory.createEmptyBorder();
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "\u641c\u7d22\u5c5e\u6027\u8303\u56f4");
        this.panel1.setLayout(this.gridBagLayout1);
        this.jLabel1.setText("\u67e5\u627e\u5185\u5bb9");
        this.jLabel2.setText("\u66ff\u6362\u4e3a");
        this.jBSearch.setText("\u67e5\u627e(F)");
        this.jBSearch.setMnemonic('F');
        this.jBSearch.addActionListener(new DialogSearch_jBSearch_actionAdapter(this));
        this.jBReplace.setText("\u66ff\u6362(R)");
        this.jBReplace.setMnemonic('R');
        this.jBReplace.addActionListener(new DialogSearch_jBReplace_actionAdapter(this));
        this.jBReplaceAll.setText("\u5168\u90e8\u66ff\u6362(A)");
        this.jBReplaceAll.setMnemonic('A');
        this.jBReplaceAll.addActionListener(new DialogSearch_jBReplaceAll_actionAdapter(this));
        this.jBCancel.setText("\u5173\u95ed(C)");
        this.jBCancel.setMnemonic('C');
        this.jBCancel.addActionListener(new DialogSearch_jBCancel_actionAdapter(this));
        this.jCBSensitive.setMaximumSize(new Dimension(95, 27));
        this.jCBSensitive.setText("\u533a\u5206\u5927\u5c0f\u5199");
        this.jCBWordOnly.setText("\u4ec5\u641c\u7d22\u72ec\u7acb\u5355\u8bcd");
        this.jPanel2.setBorder(this.titledBorder2);
        this.jCBSearch.setEditable(true);
        this.jCBReplace.setEditable(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(this.borderLayout1);
        this.addWindowListener(new DialogSearch_this_windowAdapter(this));
        this.jPanel1.setLayout(this.vFlowLayout1);
        this.getContentPane().add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.jLabel1, GM.getGBC(1, 1));
        this.panel1.add((Component)this.jCBSearch, GM.getGBC(1, 2, true));
        this.panel1.add((Component)this.jLabel2, GM.getGBC(2, 1));
        this.panel1.add((Component)this.jCBReplace, GM.getGBC(2, 2, true));
        JPanel tmp = new JPanel(new GridLayout(2, 2));
        tmp.add(this.jCBSensitive);
        tmp.add(this.jCBWordOnly);
        tmp.add(this.jCBQuote);
        tmp.add(this.jCBPars);
        GridBagConstraints gbc = GM.getGBC(3, 1);
        gbc.gridwidth = 2;
        this.panel1.add((Component)tmp, gbc);
        gbc = GM.getGBC(4, 1, true, true);
        gbc.gridwidth = 2;
        this.panel1.add((Component)new JLabel(), gbc);
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jBSearch, null);
        this.jPanel1.add((Component)this.jBReplace, null);
        this.jPanel1.add((Component)this.jBReplaceAll, null);
        this.jPanel1.add((Component)this.jBCancel, null);
    }

    private void setSearchConfig(String searchString, String replaceString) {
        this.searchString = searchString;
        if (replaceString == null) {
            replaceString = "";
        }
        this.replaceString = replaceString;
        this.searchFlag = 0;
        if (!this.jCBQuote.isSelected()) {
            this.searchFlag += 16;
        }
        if (!this.jCBPars.isSelected()) {
            this.searchFlag += 2;
        }
        if (!this.jCBSensitive.isSelected()) {
            ++this.searchFlag;
        }
        if (this.jCBWordOnly.isSelected()) {
            this.searchFlag += 8;
        }
    }

    private int replaceAll() {
        int count = 0;
        while (this.replace()) {
            ++count;
        }
        this.stringIndex = -1;
        return count;
    }

    private boolean replace() {
        if (this.search()) {
            this.txtEditor.replaceSelection(this.replaceString);
            EditListener el = this.txtEditor.getEditListener();
            if (el != null) {
                el.editChanged(this.txtEditor.getText());
            }
            return true;
        }
        return false;
    }

    private boolean search() {
        boolean found = false;
        String exp = this.txtEditor.getText();
        if (exp == null) {
            this.stringIndex = -1;
            return false;
        }
        this.stringIndex = Sentence.indexOf(exp, this.stringIndex + 1, this.searchString, this.searchFlag);
        if (this.stringIndex >= 0) {
            found = true;
        }
        if (found) {
            this.txtEditor.setSelectionStart(this.stringIndex);
            this.txtEditor.setSelectionEnd(this.stringIndex + this.searchString.length());
            return true;
        }
        return false;
    }

    void jBSearch_actionPerformed(ActionEvent e) {
        this.resetDropItems();
        this.isSearchClicked = true;
        this.setSearchConfig((String)this.jCBSearch.getSelectedItem(), "");
        if (this.replace()) {
            this.search();
        } else {
            JOptionPane.showMessageDialog(this, this.splMM.getMessage("dialogsearch.cantfindword", this.jCBSearch.getSelectedItem()));
        }
    }

    void jBReplace_actionPerformed(ActionEvent e) {
        this.isSearchClicked = false;
        this.resetDropItems();
        String search = (String)this.jCBSearch.getSelectedItem();
        String replace = (String)this.jCBReplace.getSelectedItem();
        this.setSearchConfig(search, replace);
        this.stringIndex = -1;
        if (this.replace()) {
            this.search();
        } else {
            JOptionPane.showMessageDialog(this, this.splMM.getMessage("dialogsearch.cantfindword", this.jCBSearch.getSelectedItem()));
        }
    }

    void jBReplaceAll_actionPerformed(ActionEvent e) {
        this.resetDropItems();
        String search = (String)this.jCBSearch.getSelectedItem();
        String replace = (String)this.jCBReplace.getSelectedItem();
        this.setSearchConfig(search, replace);
        int i = this.replaceAll();
        JOptionPane.showMessageDialog(this, this.splMM.getMessage("dialogsearch.totalreplace", String.valueOf(i)));
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        this.rememberStatus();
        GM.setWindowDimension(this);
        this.dispose();
    }

    void this_windowClosing(WindowEvent e) {
        this.rememberStatus();
        GM.setWindowDimension(this);
        this.dispose();
    }
}

