/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.cellset.datamodel.ColCell;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.cellset.datamodel.RowCell;
import com.scudata.common.Area;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IAtomicCmd;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplEditor;
import java.util.Vector;

public class AtomicCell
implements IAtomicCmd,
Cloneable {
    public static final byte CELL_VALUE = 0;
    public static final byte CELL_EXP = 1;
    public static final byte CELL_TIPS = 2;
    public static final byte CELL_FUNC_OBJECT = 3;
    public static final byte COL_WIDTH = 100;
    public static final byte ROW_HEIGHT = 101;
    public static final byte COL_VISIBLE = 103;
    public static final byte ROW_VISIBLE = 104;
    private Object cell;
    private byte property;
    private Object value;
    private SplControl control;
    private Vector<Object> selectedAreas;
    private int row = 0;

    public AtomicCell(SplControl control, Object cell) {
        this.control = control;
        this.cell = cell;
        this.selectedAreas = new Vector();
        this.selectedAreas.addAll(control.getSelectedAreas());
    }

    public AtomicCell(SplControl control, int row) {
        this.control = control;
        this.row = row;
        this.selectedAreas = new Vector();
        this.selectedAreas.addAll(control.getSelectedAreas());
    }

    @Override
    public String toString() {
        return "cell:" + this.cell + "#key:" + this.property + "#val:" + this.value;
    }

    public void setProperty(byte property) {
        this.property = property;
    }

    public void setValue(Object value) {
        if (value instanceof String && !StringUtils.isValidString(value)) {
            this.value = null;
        }
        this.value = value;
    }

    public Object clone() {
        AtomicCell an = new AtomicCell(this.control, this.cell);
        an.setProperty(this.property);
        an.setValue(this.value);
        return an;
    }

    public static void setCellProperty(Object cell, byte property, Object newVal) {
        NormalCell nc = null;
        if (cell instanceof NormalCell) {
            nc = (NormalCell)cell;
            nc = (NormalCell)nc.getCellSet().getCell(nc.getRow(), nc.getCol());
        }
        switch (property) {
            case 0: {
                if (newVal == null) {
                    nc.reset();
                    break;
                }
                nc.setValue(GM.getOptionTrimChar0Value(newVal));
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                String newExp;
                String string = newExp = newVal == null ? null : GM.getOptionTrimChar0String((String)newVal);
                if (GV.appSheet != null && GV.appSheet instanceof SheetSpl) {
                    ((SheetSpl)GV.appSheet).expChanged(nc.getRow(), nc.getCol(), newExp);
                }
                nc.setExpString(newExp);
                break;
            }
            case 2: {
                nc.setTip((String)newVal);
                break;
            }
            case 100: {
                ((ColCell)cell).setWidth(((Float)newVal).floatValue());
                break;
            }
            case 101: {
                ((RowCell)cell).setHeight(((Float)newVal).floatValue());
                break;
            }
            case 103: {
                ((ColCell)cell).setVisible((Boolean)newVal != false ? (byte)0 : 1);
                break;
            }
            case 104: {
                ((RowCell)cell).setVisible((Boolean)newVal != false ? (byte)0 : 1);
            }
        }
    }

    public static Object getCellProperty(Object cell, byte property) {
        Object oldValue = null;
        switch (property) {
            case 0: {
                oldValue = ((NormalCell)cell).getValue();
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                oldValue = ((NormalCell)cell).getExpString();
                break;
            }
            case 2: {
                oldValue = ((NormalCell)cell).getTip();
                break;
            }
            case 100: {
                oldValue = new Float(((ColCell)cell).getWidth());
                break;
            }
            case 101: {
                oldValue = new Float(((RowCell)cell).getHeight());
                break;
            }
            case 103: {
                oldValue = new Boolean(((ColCell)cell).getVisible() != 1);
                break;
            }
            case 104: {
                oldValue = new Boolean(((RowCell)cell).getVisible() != 1);
            }
        }
        return oldValue;
    }

    private void setValue(AtomicCell undoAn, Object newVal) {
        Object oldValue = AtomicCell.getCellProperty(this.cell, this.property);
        if (newVal instanceof String && (!StringUtils.isValidString(newVal) || newVal.equals(new String("\u007f")))) {
            newVal = null;
        }
        AtomicCell.setCellProperty(this.cell, this.property, newVal);
        undoAn.setValue(oldValue);
    }

    @Override
    public IAtomicCmd execute() {
        SplEditor splEditor;
        if (this.cell == null && this.row > 0) {
            this.cell = this.control.cellSet.getRowCell(this.row);
        }
        AtomicCell undoAn = (AtomicCell)this.clone();
        if (this.cell == null) {
            return undoAn;
        }
        if (this.value != GC.NULL) {
            this.setValue(undoAn, this.value);
        }
        if (this.cell instanceof PgmNormalCell && this.selectedAreas.isEmpty()) {
            PgmNormalCell nc = (PgmNormalCell)this.cell;
            Vector<Area> v = new Vector<Area>();
            v.add(new Area(nc.getRow(), nc.getCol(), nc.getRow(), nc.getCol()));
            undoAn.selectedAreas = v;
        }
        if ((splEditor = ControlUtils.extractSplEditor(this.control)) != null) {
            splEditor.setSelectedAreas(this.selectedAreas);
        }
        return undoAn;
    }
}

