/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.app.common.AppUtil;
import com.scudata.app.common.Section;
import com.scudata.app.common.Segment;
import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.CellLocation;
import com.scudata.common.Logger;
import com.scudata.common.ScudataLogger;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.common.UUID;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.LocalFile;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.XMLFile;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.ServerConsole;
import com.scudata.ide.spl.Worker;
import com.scudata.resources.ParallelMessage;
import com.scudata.util.DatabaseUtil;
import com.scudata.util.Variant;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Esprocx {
    static RaqsoftConfig config;
    static Object remoteStore;
    static int finishedWorkers;

    static {
        finishedWorkers = 0;
    }

    public static void loadDataSource(Context ctx) throws Exception {
        ConfigFile cf = ConfigFile.getSystemConfigFile();
        if (cf == null) {
            return;
        }
        XMLFile configFile = cf.xmlFile();
        Section ss = new Section();
        ss = configFile.listElement(ConfigFile.PATH_DATASOURCE);
        int i = 0;
        while (i < ss.size()) {
            String sId = ss.getSection(i);
            String name = configFile.getAttribute(String.valueOf(ConfigFile.PATH_DATASOURCE) + "/" + sId + "/name");
            String sconfig = configFile.getAttribute(String.valueOf(ConfigFile.PATH_DATASOURCE) + "/" + sId + "/config");
            DataSource ds = new DataSource(sconfig);
            ds.setName(name);
            ctx.setDBSessionFactory(name, ds.getDBInfo().createSessionFactory());
            ++i;
        }
    }

    public static String getAbsolutePath(String path) {
        String home = System.getProperty("start.home");
        return Esprocx.getAbsolutePath(path, home);
    }

    public static String getAbsolutePath(String path, String home) {
        if (home != null && (home.endsWith("\\") || home.endsWith("/"))) {
            home = home.substring(0, home.length() - 1);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String filePath = String.valueOf(home) + path;
        String p = System.getProperty("file.separator");
        filePath = p.equals("\\") ? Sentence.replace(filePath, "/", p, 1) : Sentence.replace(filePath, "\\", p, 1);
        return filePath;
    }

    public static String getConfigValue(String key) {
        try {
            String configFile = Esprocx.getAbsolutePath("bin\\config.txt");
            FileReader fr = new FileReader(configFile);
            BufferedReader br = new BufferedReader(fr);
            String segValue = br.readLine();
            Segment seg = new Segment(segValue);
            return seg.get(key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void initEnv() throws Exception {
        String init;
        String startHome = System.getProperty("start.home");
        if (!StringUtils.isValidString(startHome)) {
            System.setProperty("raqsoft.home", System.getProperty("user.home"));
        } else {
            System.setProperty("raqsoft.home", String.valueOf(startHome));
        }
        String envFile = Esprocx.getAbsolutePath("/config/raqsoftConfig.xml");
        config = ConfigUtil.load(envFile);
        ServerConsole.setRaqsoftConfig(config);
        try {
            ConfigOptions.load2(false, false);
            if (StringUtils.isValidString(ConfigOptions.sLogFileName)) {
                String file = ConfigOptions.sLogFileName;
                File f = new File(file);
                File fp = f.getParentFile();
                if (!fp.exists()) {
                    fp.mkdirs();
                }
                String path = f.getAbsolutePath();
                ScudataLogger.FileHandler lfh = ScudataLogger.newFileHandler(path);
                ScudataLogger.addFileHandler(lfh);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (StringUtils.isValidString(init = Esprocx.getConfigValue("init"))) {
            StringTokenizer st = new StringTokenizer(init);
            while (st.hasMoreElements()) {
                String token = st.nextToken();
                int dot = token.lastIndexOf(46);
                if (dot <= 0) continue;
                String clsName = token.substring(0, dot);
                String method = token.substring(dot + 1);
                try {
                    Class<?> clz = Class.forName(clsName);
                    Method m = clz.getMethod(method, null);
                    remoteStore = m.invoke(clz, null);
                    Logger.info("Initial " + token + " ok.");
                }
                catch (Throwable t) {
                    Logger.info(t);
                }
            }
        }
    }

    public static void closeRemoteStore(Object remoteStore) {
        if (remoteStore == null) {
            return;
        }
        try {
            Class<?> clz = Class.forName("com.scudata.ecloud.ide.GMCloud");
            Method m = clz.getMethod("closeRemoteStore", Object.class);
            m.invoke(clz, remoteStore);
            Logger.info("Remote store is closed.");
        }
        catch (ClassNotFoundException clz) {
        }
        catch (Throwable t) {
            Logger.error(t);
        }
    }

    public static synchronized void addFinish() {
        Logger.debug(ParallelMessage.get().getMessage("esProc.taskFinish", ++finishedWorkers));
    }

    private static void checkMainPath() {
        String mainPath = Env.getMainPath();
        if (!StringUtils.isValidString(mainPath)) {
            mainPath = new File("").getAbsolutePath();
            Env.setMainPath(mainPath);
            Logger.debug("esProcx is using main path: " + mainPath);
        }
    }

    private static void exit() {
        Esprocx.closeRemoteStore(remoteStore);
        System.exit(0);
    }

    private static String toString(ArrayList<String> args) {
        if (args.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String str : args) {
            sb.append(String.valueOf(str) + " ");
        }
        return sb.toString().trim();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        debug = false;
        etlUsage = "esProcx [etlFile] [argN] ...\r\n [etlFile]   \u76f8\u5bf9\u4e8e\u5bfb\u5740\u8def\u5f84\u6216\u8005\u4e3b\u8def\u5f84\u7684etl\u6587\u4ef6\u540d\uff0c\u4e5f\u53ef\u4ee5\u662f\u7edd\u5bf9\u8def\u5f84\u3002\r\n [argN]      etlFile\u6709\u53c2\u6570\u65f6\uff0c\u53c2\u6570\u6309\u7167 \u53c2\u6570\u987a\u5e8f \u6307\u5b9a\u3002\r\n";
        fileExts = "splx,spl,dfx,etl";
        usage = "\u7528\u4e8e\u6267\u884c\u4e00\u4e2a" + fileExts + "\u6587\u4ef6\u3001\u4e00\u4e2a\u7b80\u6613\u7684\u8868\u8fbe\u5f0f\u3001\u7b80\u5355SQL\u6216\u4e00\u4e2a\u6587\u672c\u63cf\u8ff0\u7684dfx\u811a\u672c\u3002\r\n\r\n" + "esProcx [-r] [-c]\r\n" + " [-r]   \u6253\u5370\u8fd4\u56de\u7ed3\u679c\u5230\u63a7\u5236\u53f0\u3002\r\n" + " [-c]   \u4ece\u63a7\u5236\u53f0\u8bfb\u5165\u4e00\u4e2a\u5217\u7528Tab\u952e\u5206\u5f00\u7684\u591a\u884c\u5f0f\u7f51\u683c\u811a\u672c\u6765\u6267\u884c(Ctrl+C\u7ed3\u675f\u5f55\u5165)\u3002\r\n\r\n" + "esProcx [-r] [dfxFile] [arg0] [arg1]...\r\n" + " [splxFile]   \u76f8\u5bf9\u4e8e\u5bfb\u5740\u8def\u5f84\u6216\u8005\u4e3b\u8def\u5f84\u7684splx\u6587\u4ef6\u540d\uff0c\u4e5f\u53ef\u4ee5\u662f\u7edd\u5bf9\u8def\u5f84\u3002\r\n" + " [argN]      \u5982\u679c\u662fsplxFile\u4e14\u6709\u53c2\u6570\uff0c\u6309\u987a\u5e8f\u4f9d\u6b21\u5bf9\u5e94\u3002\r\n\r\n" + etlUsage + "esProcx [-r] [exp]\r\n" + " [exp]   \u4e00\u53e5dfx\u811a\u672c\u547d\u4ee4\u3002\r\n\r\n" + "\u793a\u4f8b:\r\n" + "  esProcx -r -c\r\n" + "    \u6267\u884c\u4e00\u4e2a\u5f85\u5f55\u5165\u7684\u6587\u672c\u5f0f\u7f51\u683c\u5e76\u6253\u5370\u8fd4\u56de\u7ed3\u679c\u3002\r\n" + "  esProcx -r demo.splx arg1 arg2\r\n" + "    \u7528\u53c2\u6570arg1\u3001arg2\u6267\u884c\u5bfb\u5740\u8def\u5f84\u4e0a\u7684demo.splx\uff0c\u6253\u5370\u8fd4\u56de\u7ed3\u679c\u3002\r\n" + "  esProcx SELECT count(*) FROM t.json\r\n" + "    \u6267\u884c\u4e00\u53e5\u7b80\u5355SQL\u3002\r\n" + "  esProcx demo.etl 1\r\n" + "    \u5bf9\u5e94\u53c2\u6570month\u4e3a1\u6708\uff0c\u6267\u884c\u5bfb\u5740\u8def\u5f84\u4e0a\u7684demo.etl\u3002\r\n";
        etlUsageEn = "esProcx [etlFile] [argN]...\r\n [etlFile]   An etl file name relative to a search path or a main path; can be an absolute path. \r\n [argN]      If etlFile contains parameters, pass values to them according to the order defined. \r\n";
        usageEn = "It is used to execute a " + fileExts + " file, a simple expression, a simple SQL statement, or a text formatting dfx script. \r\n\r\n" + "esProcx [-r] [-c]\r\n" + " [-r]   Print result to the console. \r\n" + " [-c]   Read from the console a multiline cellset script in which columns are separated by the Tab to execute (Ctrl+C for finishing  input).  \r\n\r\n" + "esProcx [-r] [splxFile] [arg0] [arg1]...\r\n" + " [splxFile]   A splx file name relative to a search path or a main path; can be an absolute path. \r\n" + " [argN]      If the splxFile contains parameters, pass values to them in order. \r\n\r\n" + "esProcx [-r] [exp]\r\n" + " [exp]   A dfx script command. \r\n\r\n" + etlUsageEn + "Example:\r\n" + "  esProcx -r -c\r\n" + "    Execute a to-be-input text formatting cellset and print the returned result. \r\n" + "  esProcx -r demo.splx arg1 arg2\r\n" + "    Execute demo.splx on a search path with parameters arg1 and arg2, and print the returned result. \r\n" + "  esProcx SELECT count(*) FROM t.json\r\n" + "    Execute a simple SQL statement. \r\n" + "  esProcx demo.etl 1\r\n" + "    Execute demo.etl on a search path by inputting January as the paramer value. \r\n";
        lang = System.getProperty("user.language");
        if (lang.equalsIgnoreCase("en")) {
            usage = usageEn;
        }
        if (!debug && args.length == 0) {
            System.err.println(usage);
            Thread.sleep(3000L);
            Esprocx.exit();
        }
        arg = "";
        dfxFile = null;
        fileArgs = new ArrayList<String>();
        loadArg = false;
        printResult = false;
        isParallel = true;
        threadCount = 1;
        if (args.length == 1 && (arg = args[0].trim()).trim().indexOf(" ") > 0) {
            st = new Section(arg, ' ');
            args = st.toStringArray();
        }
        existStar = false;
        isSql = false;
        if (args.length > 0) {
            i = 0;
            while (i < args.length) {
                arg = args[i];
                existSpace = false;
                argchars = arg.toCharArray();
                n = 0;
                while (n < argchars.length) {
                    if (argchars[n] == '\u0002') {
                        argchars[n] = 32;
                        existSpace = true;
                    } else if (argchars[n] == '\u0003') {
                        argchars[n] = 34;
                        existSpace = true;
                    }
                    ++n;
                }
                if (existSpace) {
                    arg = new String(argchars);
                }
                if (!arg.toLowerCase().equals("com.scudata.ide.spl.esprocx")) {
                    if (arg.toLowerCase().startsWith("-r")) {
                        printResult = true;
                    } else if (arg.toLowerCase().startsWith("-t")) {
                        tmp = args[++i];
                        threadCount = Integer.parseInt(tmp);
                    } else if (arg.toLowerCase().startsWith("-s")) {
                        tmp = args[++i];
                        threadCount = Integer.parseInt(tmp);
                        isParallel = false;
                    } else if (arg.toLowerCase().startsWith("-c")) {
                        dfxFile = null;
                        fileArgs.clear();
                        fileArgs.add("=");
                        row = 1;
                        while ((line = System.console().readLine("(%d): ", new Object[]{row++})) != null) {
                            if (!fileArgs.isEmpty()) {
                                fileArgs.add("\n");
                            }
                            fileArgs.add(line);
                        }
                    } else if (!arg.startsWith("-")) {
                        if (StringUtils.isValidString(arg)) {
                            if (loadArg) {
                                if (arg.equalsIgnoreCase("esProcx.exe")) {
                                    existStar = true;
                                } else if (arg.equalsIgnoreCase("esProcx.sh")) {
                                    existStar = true;
                                } else if (arg.equalsIgnoreCase("from")) {
                                    if (existStar) {
                                        fileArgs.clear();
                                        fileArgs.add("* from");
                                    } else {
                                        fileArgs.add(arg);
                                        isSql = true;
                                    }
                                } else {
                                    fileArgs.add(arg);
                                }
                            } else {
                                if (arg.equalsIgnoreCase("esProcx.sh")) {
                                    dfxFile = "$select";
                                    existStar = true;
                                } else {
                                    dfxFile = arg;
                                }
                                loadArg = true;
                            }
                        }
                    } else if (arg.toLowerCase().startsWith("-help") || arg.startsWith("-?")) {
                        System.err.println(usage);
                        Esprocx.exit();
                    }
                }
                ++i;
            }
        }
        try {
            if (debug) {
                dfxFile = "d:\\p2.splx";
            }
            Esprocx.initEnv();
            Esprocx.checkMainPath();
            workBegin = System.currentTimeMillis();
            isFile = false;
            isDfx = false;
            isEtl = false;
            isSplx = false;
            isSpl = false;
            if (dfxFile != null) {
                lower = dfxFile.toLowerCase();
                isDfx = lower.endsWith(".dfx");
                isSplx = lower.endsWith(".splx");
                isSpl = lower.endsWith(".spl");
                isEtl = lower.endsWith(".etl");
                v0 = isFile = isDfx != false || isEtl != false || isSplx != false || isSpl != false;
            }
            if (isFile) {
                fo = new FileObject(dfxFile, "s");
                if (isDfx || isEtl || isSplx || isSpl) {
                    pcs = null;
                    if (isDfx || isSplx) {
                        pcs = fo.readPgmCellSet();
                    } else if (isSpl) {
                        f = fo.getFile();
                        if (f instanceof LocalFile) {
                            lf = (LocalFile)f;
                            path = lf.getFile().getAbsolutePath();
                            pcs = GMSpl.readSPL(path);
                        } else {
                            System.err.println("Unsupported file:" + fo.getFileName());
                            Thread.sleep(3000L);
                            Esprocx.exit();
                        }
                    } else {
                        System.err.println("Unsupported file:" + fo.getFileName());
                        Thread.sleep(3000L);
                        Esprocx.exit();
                    }
                    workers = new ArrayList<Worker>();
                    i = 0;
                    while (i < threadCount) {
                        w = new Worker(pcs, fileArgs, printResult);
                        workers.add(w);
                        w.start();
                        if (!isParallel) {
                            w.join();
                        }
                        ++i;
                    }
                    if (isParallel) {
                        for (Worker w : workers) {
                            w.join();
                        }
                    }
                } else {
                    Logger.severe(ParallelMessage.get().getMessage("esProc.unsupportedfile", dfxFile));
                }
            } else {
                context = AppUtil.prepareEnv(Esprocx.config);
                Esprocx.loadDataSource(context);
                try {
                    if (dfxFile == null) {
                        cmd = Esprocx.toString(fileArgs);
                    } else {
                        if (dfxFile.equalsIgnoreCase("select") || dfxFile.equalsIgnoreCase("$select")) {
                            dfxFile = "$select";
                        } else if (isSql) {
                            dfxFile = "$select " + dfxFile;
                        }
                        cmd = String.valueOf(dfxFile) + " " + Esprocx.toString(fileArgs);
                    }
                    Logger.debug(ParallelMessage.get().getMessage("esProc.executecmd", cmd));
                    result = AppUtil.executeCmd(cmd, context);
                    if (!printResult) ** GOTO lbl184
                    Esprocx.printResult(result);
                }
                finally {
                    DatabaseUtil.closeAutoDBs(context);
                }
            }
lbl184:
            // 4 sources

            finishTime = System.currentTimeMillis();
            df = new DecimalFormat("###,###");
            lastTime = finishTime - workBegin;
            if (threadCount > 1 || isEtl) {
                Logger.debug(ParallelMessage.get().getMessage("esProc.taketimes", df.format(lastTime)));
            }
        }
        catch (Throwable x) {
            Logger.error(x.getMessage(), x);
        }
        Esprocx.exit();
    }

    public static synchronized String getUUID() {
        return UUID.randomUUID().toString();
    }

    static void print(Sequence atoms) {
        int i = 1;
        while (i <= atoms.length()) {
            Object element = atoms.get(i);
            if (element instanceof BaseRecord) {
                System.out.println(((BaseRecord)element).toString("t"));
            } else {
                System.out.println(Variant.toString(element));
            }
            ++i;
        }
    }

    private static void printStruct(DataStruct ds) {
        if (ds == null) {
            return;
        }
        String[] fields = ds.getFieldNames();
        int s = fields.length;
        int i = 0;
        while (i < s) {
            System.out.print(fields[i]);
            if (i < s - 1) {
                System.out.print("\t");
            }
            ++i;
        }
        System.out.println();
    }

    public static void printResult(Object result) {
        if (result instanceof Sequence) {
            Sequence atoms = (Sequence)result;
            Esprocx.printStruct(atoms.dataStruct());
            Esprocx.print(atoms);
        } else if (result instanceof ICursor) {
            ICursor cursor = (ICursor)result;
            Sequence seq = cursor.fetch(1024);
            Esprocx.printStruct(seq.dataStruct());
            while (seq != null) {
                Esprocx.print(seq);
                seq = cursor.fetch(1024);
            }
        } else if (result instanceof PgmCellSet) {
            PgmCellSet pcs = (PgmCellSet)result;
            while (pcs.hasNextResult()) {
                CellLocation cl = pcs.nextResultLocation();
                System.out.println();
                if (cl != null) {
                    String msg = cl + ":";
                    System.err.println(msg);
                }
                Object tmp = pcs.nextResult();
                Esprocx.printResult(tmp);
            }
        } else {
            System.out.println(Variant.toString(result));
        }
    }
}

