/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.app.common.AppUtil;
import com.scudata.app.common.Segment;
import com.scudata.cellset.datamodel.CellSet;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.Area;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.CellLocation;
import com.scudata.common.DBConfig;
import com.scudata.common.DBInfo;
import com.scudata.common.Escape;
import com.scudata.common.Logger;
import com.scudata.common.Matrix;
import com.scudata.common.StringUtils;
import com.scudata.dm.DBObject;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.ConfigUtilIde;
import com.scudata.ide.common.DBTypeEx;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IAtomicCmd;
import com.scudata.ide.common.control.CellRect;
import com.scudata.ide.common.control.CellSelection;
import com.scudata.ide.common.control.ControlUtilsBase;
import com.scudata.ide.common.dialog.DialogDataSource;
import com.scudata.ide.common.dialog.DialogFileReplace;
import com.scudata.ide.common.dialog.DialogMemory;
import com.scudata.ide.spl.AtomicSpl;
import com.scudata.ide.spl.GCSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.IDEBase;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.control.CellSetParser;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.SplEditor;
import com.scudata.ide.spl.dialog.DialogAbout;
import com.scudata.ide.spl.dialog.DialogOptions;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class GMSpl
extends GM {
    private static final String KEY_JVM = "jvm_args";
    public static final String KEY_XMX = "-Xmx";
    public static final String KEY_XMS = "-Xms";
    public static final String KEY_PRINT_GC_DETAILS = "-XX:+PrintGCDetails";
    public static final String KEY_PRINT_GC_TIMESTAMPS = "-XX:+PrintGCTimeStamps";
    public static final String KEY_PRINT_GC_DATESTAMPS = "-XX:+PrintGCDateStamps";
    public static final String KEY_GC_LOG = "-Xloggc:";
    public static final String KEY_PRINT_GC_HEAP = "-XX:+PrintHeapAtGC";

    public static void executeCmd(short cmd) throws Exception {
        switch (cmd) {
            case 5: {
                GV.appFrame.openSheetFile(null);
                return;
            }
            case 1003: {
                GV.appFrame.openSheetFile("");
                return;
            }
            case 10: {
                String ext = "\"splx,spl,dfx\"";
                File file = GM.dialogSelectFile(GV.appFrame, ext);
                if (file != null) {
                    GV.appFrame.openSheetFile(file.getAbsolutePath());
                }
                return;
            }
            case 50: {
                GV.appSheet.save();
                return;
            }
            case 55: {
                GV.appSheet.saveAs();
                return;
            }
            case 60: {
                ((IDEBase)GV.appFrame).saveAll();
                return;
            }
            case 25: 
            case 27: {
                if (GV.appSheet != null) {
                    GV.appFrame.closeSheet(GV.appSheet);
                }
                return;
            }
            case 30: {
                GV.appFrame.closeAll();
                return;
            }
            case 80: {
                GV.appFrame.quit();
                return;
            }
            case 105: {
                DialogDataSource dds = new DialogDataSource(GV.dsModel);
                dds.setVisible(true);
                try {
                    ConfigUtilIde.writeActiveConfig();
                }
                catch (Exception ex) {
                    Logger.debug(ex);
                }
                if (GVSpl.tabParam != null) {
                    GVSpl.tabParam.resetEnv();
                }
                return;
            }
            case 110: {
                boolean showDB = ConfigOptions.bShowDBStruct;
                float oldRowHeight = ConfigOptions.fRowHeight.floatValue();
                Font oldFont = GC.font;
                new DialogOptions().setVisible(true);
                ((IDEBase)GV.appFrame).refreshOptions();
                if (showDB != ConfigOptions.bShowDBStruct && GVSpl.tabParam != null) {
                    GVSpl.tabParam.resetEnv();
                }
                if (oldRowHeight != ConfigOptions.fRowHeight.floatValue() || oldFont.getSize() != GC.font.getSize() || oldFont.getStyle() != GC.font.getStyle() || !oldFont.getFontName().equals(GC.font.getFontName())) {
                    GVSpl.panelValue.tableValue.refreshOptions();
                }
                return;
            }
            case 1341: {
                DialogFileReplace dfr = new DialogFileReplace(GV.appFrame){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public PgmCellSet readEncryptedCellSet(String filePath, String fileName) throws Exception {
                        this.fileResultMap.put(filePath, IdeSplMessage.get().getMessage("spl.errorsplfile", fileName));
                        return null;
                    }
                };
                dfr.setVisible(true);
                return;
            }
            case 251: {
                ((IDEBase)GV.appFrame).switchWinList();
                GM.resetAllSheetStyle();
                return;
            }
            case 253: {
                ((IDEBase)GV.appFrame).viewLeft();
                return;
            }
            case 255: {
                ((IDEBase)GV.appFrame).viewRight();
                return;
            }
            case 205: 
            case 210: 
            case 215: 
            case 220: {
                GV.appFrame.arrangeSheet(cmd);
                GM.resetAllSheetStyle();
                return;
            }
            case 305: {
                DialogAbout da = new DialogAbout();
                da.init();
                da.setVisible(true);
                return;
            }
            case 310: {
                if (GV.dialogMemory == null) {
                    GV.dialogMemory = new DialogMemory(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        protected void cleanMemory() {
                            if (ControlUtilsBase.wrapStringBuffer != null) {
                                ControlUtilsBase.wrapStringBuffer.clear();
                            }
                        }
                    };
                }
                GV.dialogMemory.setVisible(true);
                return;
            }
        }
        GV.appSheet.executeCmd(cmd);
    }

    public static Matrix getMatrixCells(CellSet cellSet, CellRect rect) {
        return GMSpl.getMatrixCells(cellSet, rect, true);
    }

    public static Matrix getMatrixCells(CellSet cellSet, CellRect rect, boolean cloneCell) {
        if (rect == null) {
            return null;
        }
        int rowSize = 0;
        CellSetParser csp = new CellSetParser(cellSet);
        int i = 0;
        while (i < rect.getRowCount()) {
            if (csp.isRowVisible(rect.getBeginRow() + i)) {
                ++rowSize;
            }
            ++i;
        }
        int colSize = 0;
        int j = 0;
        while (j < rect.getColCount()) {
            if (csp.isColVisible(j + rect.getBeginCol())) {
                ++colSize;
            }
            ++j;
        }
        if (rowSize == 0 || colSize == 0) {
            return null;
        }
        Matrix m = new Matrix(rowSize, colSize);
        int rs = 0;
        int i2 = 0;
        while (i2 < rect.getRowCount()) {
            int row = rect.getBeginRow() + i2;
            if (csp.isRowVisible(row)) {
                int cs = 0;
                int j2 = 0;
                while (j2 < rect.getColCount()) {
                    int col = j2 + rect.getBeginCol();
                    if (csp.isColVisible(col)) {
                        NormalCell temp = (NormalCell)cellSet.getCell(row, col);
                        NormalCell nc = cloneCell ? (NormalCell)temp.deepClone() : temp;
                        nc.setValue(GM.getOptionTrimChar0Value(temp.getValue()));
                        m.set(rs, cs, nc);
                        ++cs;
                    }
                    ++j2;
                }
                ++rs;
            }
            ++i2;
        }
        return m;
    }

    public static Vector<IAtomicCmd> getMoveRectCmd(SplEditor editor, CellRect srcRect, CellRect tarRect) {
        int rows;
        if (editor == null) {
            return null;
        }
        if (srcRect.getColCount() == 0) {
            return null;
        }
        SheetSpl sheet = (SheetSpl)GV.appSheet;
        if (sheet != null) {
            try {
                sheet.moveRect(srcRect, tarRect);
            }
            catch (Exception ex) {
                GM.showException(GV.appFrame, ex);
                return null;
            }
        }
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        PgmCellSet ics = editor.getComponent().getCellSet();
        int cols = tarRect.getEndCol() - ics.getColCount();
        if (cols > 0) {
            cmds.add(editor.getAppendCols(cols));
        }
        if ((rows = tarRect.getEndRow() - ics.getRowCount()) > 0) {
            cmds.add(editor.getAppendRows(rows));
        }
        Matrix srcCells = GMSpl.getMatrixCells(ics, srcRect);
        CellSelection cs = new CellSelection(srcCells, srcRect, editor.getComponent().getCellSet());
        AtomicSpl ad = new AtomicSpl(editor.getComponent());
        ad.setType((byte)10);
        ad.setRect(tarRect);
        ad.setValue(cs);
        cmds.add(ad);
        return cmds;
    }

    public static float getMaxColWidth(CellSet cs, int col, float scale) {
        if (cs == null || cs.getColCount() < col || col < 1) {
            return -1.0f;
        }
        int rc = cs.getRowCount();
        float maxWidth = -1.0f;
        Font font = GM.getScaleFont(scale);
        int row = 1;
        while (row <= rc) {
            float temp;
            String cellText;
            NormalCell nc = (NormalCell)cs.getCell(row, col);
            if (nc != null && (cellText = nc.getExpString()) != null && maxWidth < (temp = (float)ControlUtils.getStringMaxWidth(cellText, font))) {
                maxWidth = temp;
            }
            ++row;
        }
        if (maxWidth < 30.0f) {
            return 30.0f;
        }
        return maxWidth;
    }

    public static float getMaxRowHeight(CellSet cs, int row, float scale) {
        if (cs == null || cs.getRowCount() < row || row < 1) {
            return -1.0f;
        }
        CellSetParser parser = new CellSetParser(cs);
        int cc = cs.getColCount();
        float maxHeight = -1.0f;
        int col = 1;
        while (col <= cc) {
            NormalCell nc = (NormalCell)cs.getCell(row, col);
            if (nc != null) {
                float width;
                float temp;
                Font font = GM.getScaleFont(scale);
                String cellText = nc.getExpString();
                if (cellText != null && maxHeight < (temp = ControlUtils.getStringHeight(cellText, width = (float)parser.getColWidth(col, scale), font))) {
                    maxHeight = temp;
                }
            }
            ++col;
        }
        if (maxHeight < 20.0f) {
            return 20.0f;
        }
        return maxHeight;
    }

    public static void invokeSheetChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GV.appSheet.setChanged(true);
            }
        });
    }

    public static PgmCellSet readSPL(String filePath) throws Exception {
        PgmCellSet cellSet = AppUtil.readSPL(filePath);
        if (cellSet == null) {
            cellSet = new PgmCellSet(ConfigOptions.iRowCount, ConfigOptions.iColCount);
        }
        cellSet.setName(filePath);
        return cellSet;
    }

    public static void setOptionLocale() {
        try {
            Byte ii;
            ConfigFile cf = ConfigFile.getConfigFile();
            cf.setConfigNode(ConfigFile.NODE_OPTIONS);
            String val = cf.getAttrValue("iLocale");
            if (StringUtils.isValidString(val) && (ii = Byte.valueOf(val)) != null) {
                ConfigOptions.iLocale = ii;
            }
            if (ConfigOptions.iLocale != null) {
                switch (ConfigOptions.iLocale) {
                    case 0: {
                        Locale.setDefault(Locale.SIMPLIFIED_CHINESE);
                        break;
                    }
                    default: {
                        Locale.setDefault(GMSpl.getDefaultEnLocale());
                    }
                }
                GC.initLocale();
            } else if (GC.LANGUAGE != 0 && GC.LANGUAGE != 4) {
                ConfigOptions.iLocale = new Byte(4);
                Locale.setDefault(GMSpl.getDefaultEnLocale());
                GC.initLocale();
            }
        }
        catch (Throwable e) {
            Locale.setDefault(GMSpl.getDefaultEnLocale());
            e.printStackTrace();
        }
        GC.resetLocal();
    }

    private static Locale getDefaultEnLocale() {
        Locale locale = new Locale("en", Locale.getDefault().getCountry());
        return locale;
    }

    public static String getNewName() {
        String pre = "p";
        return GMSpl.getNewName(pre);
    }

    public static String getNewName(String pre) {
        String[] titles = ((IDEBase)GV.appFrame).getSheetTitles();
        return StringUtils.getNewName(pre, titles);
    }

    public static void enableSave() {
        if (GVSpl.splEditor != null) {
            GVSpl.splEditor.setDataChanged(true);
        }
        GMSpl.enableSave(true);
    }

    public static void enableSave(boolean isDataChanged) {
        if (GV.appMenu != null) {
            GV.appMenu.enableSave(isDataChanged);
        }
        if (GV.appTool != null) {
            GV.appTool.enableSave(isDataChanged);
        }
    }

    private static String[] getJVMArgs() {
        String str = GMSpl.getConfigValue(KEY_JVM);
        if (str == null) {
            return null;
        }
        ArrayList<String> jvmArgs = new ArrayList<String>();
        ArgumentTokenizer at = new ArgumentTokenizer(str, ' ');
        while (at.hasNext()) {
            String arg = at.next();
            if (!StringUtils.isValidString(arg)) continue;
            jvmArgs.add(arg.trim());
        }
        return jvmArgs.toArray(new String[jvmArgs.size()]);
    }

    public static Map<String, String> getJVMArgs(String[] keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        String[] args = GMSpl.getJVMArgs();
        if (args == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            if (StringUtils.isValidString(args[i])) {
                args[i] = args[i].trim();
                String[] stringArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (args[i].toLowerCase().startsWith(key.toLowerCase())) {
                        map.put(key, args[i]);
                        break;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return map;
    }

    public static void setJVMArgs(Map<String, String> map) {
        if (map == null) {
            return;
        }
        String[] jvmArgs = GMSpl.getJVMArgs();
        ArrayList<String> args = new ArrayList<String>();
        if (jvmArgs != null) {
            String[] stringArray = jvmArgs;
            int n = jvmArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                args.add(arg);
                ++n2;
            }
        }
        for (String key : map.keySet()) {
            boolean containsKey = false;
            int i = 0;
            while (i < args.size()) {
                String arg = (String)args.get(i);
                if (arg.toLowerCase().startsWith(key.toLowerCase())) {
                    String value = map.get(key);
                    args.set(i, value);
                    containsKey = true;
                    break;
                }
                ++i;
            }
            if (containsKey) continue;
            String value = map.get(key);
            args.add(value);
        }
        StringBuffer buf = new StringBuffer();
        for (String arg : args) {
            if (!StringUtils.isValidString(arg)) continue;
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(arg);
        }
        GMSpl.setConfigValue(KEY_JVM, buf.toString());
    }

    private static String getConfigTxtFilePath() {
        String binPath = GM.getAbsolutePath("bin");
        String configFile = new File(binPath, "config.txt").getAbsolutePath();
        return configFile;
    }

    private static String readConfigTxt() {
        Object obj;
        block4: {
            try {
                String configFile = GMSpl.getConfigTxtFilePath();
                FileObject fo = new FileObject(configFile);
                obj = fo.read(0L, -1L, null);
                if (obj != null && obj instanceof Sequence) {
                    Sequence seq = (Sequence)obj;
                    obj = seq.ifn();
                }
                if (obj != null) break block4;
                return null;
            }
            catch (Exception x) {
                Logger.error(x);
                return null;
            }
        }
        return obj.toString().trim();
    }

    private static void writeConfigTxt(String contentStr) {
        try {
            String configFile = GMSpl.getConfigTxtFilePath();
            FileObject fo = new FileObject(configFile);
            fo.write(contentStr, null);
        }
        catch (Exception x) {
            Logger.error(x);
        }
    }

    public static String getConfigValue(String key) {
        try {
            String segValue = GMSpl.readConfigTxt();
            Segment seg = new Segment(segValue);
            return seg.getValueWithoutRemove(key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setConfigValue(String key, String value) {
        try {
            String segValue = GMSpl.readConfigTxt();
            Segment seg = new Segment(segValue);
            seg.put(key, value, false);
            String configFile = GMSpl.getConfigTxtFilePath();
            FileObject fo = new FileObject(configFile);
            fo.write(seg.toString(), null);
        }
        catch (Exception e) {
            GM.showException(GV.appFrame, e);
        }
    }

    public static String[][] getCellSetExps(PgmCellSet cellSet) {
        int rc = cellSet.getRowCount();
        int cc = cellSet.getColCount();
        String[][] cellExps = new String[rc][cc];
        int r = 1;
        while (r <= rc) {
            int c = 1;
            while (c <= cc) {
                PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
                if (cell != null) {
                    cellExps[r - 1][c - 1] = cell.getExpString();
                }
                ++c;
            }
            ++r;
        }
        return cellExps;
    }

    public static Map<String, String> getExpChangedMap(PgmCellSet cellSet, String[][] cellExps) {
        HashMap<String, String> map = new HashMap<String, String>();
        int rc = cellSet.getRowCount();
        int cc = cellSet.getColCount();
        int r = 1;
        while (r <= rc) {
            int c = 1;
            while (c <= cc) {
                PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
                String oldExp = null;
                if (cellExps.length >= r && cellExps[r - 1].length >= c) {
                    oldExp = cellExps[r - 1][c - 1];
                }
                String newExp = null;
                if (cell != null) {
                    newExp = cell.getExpString();
                }
                boolean expChanged = false;
                if (newExp == null) {
                    if (oldExp != null) {
                        expChanged = true;
                    }
                } else if (!newExp.equals(oldExp)) {
                    expChanged = true;
                }
                if (expChanged) {
                    map.put(CellLocation.getCellId(r, c), newExp);
                }
                ++c;
            }
            ++r;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public static Table getDBTable(DBObject dbo) {
        Table dbTable = new Table(new String[]{GCSpl.TITLE_NAME, GCSpl.TITLE_PROP});
        if (dbo == null) {
            return dbTable;
        }
        DBInfo info = dbo.getDbSession().getInfo();
        if (info == null) {
            return dbTable;
        }
        dbTable.newLast(new Object[]{GCSpl.DB_NAME, info.getName()});
        if (info instanceof DBConfig) {
            int type = info.getDBType();
            dbTable.newLast(new Object[]{GCSpl.DB_TYPE, DBTypeEx.getDBTypeName(type)});
            DBConfig dc = (DBConfig)info;
            dbTable.newLast(new Object[]{GCSpl.DRIVER, dc.getDriver()});
            dbTable.newLast(new Object[]{GCSpl.URL, dc.getUrl()});
            dbTable.newLast(new Object[]{GCSpl.USER, dc.getUser()});
            String pwd = dc.getPassword();
            dbTable.newLast(new Object[]{GCSpl.PASSWORD, pwd});
            dbTable.newLast(new Object[]{GCSpl.USE_SCHEMA, Boolean.toString(dc.isUseSchema())});
            dbTable.newLast(new Object[]{GCSpl.ADD_TILDE, Boolean.toString(dc.isAddTilde())});
        }
        return dbTable;
    }

    public static List<NormalCell> moveArea(PgmCellSet cellSet, Area fromArea, Area toArea) {
        NormalCell nc;
        int c;
        CellRect fromRect = new CellRect(fromArea);
        CellRect toRect = new CellRect(toArea);
        int toEndRow = toRect.getEndRow();
        int toEndCol = toRect.getEndCol();
        int rowCount = cellSet.getRowCount();
        int colCount = cellSet.getColCount();
        if (toEndRow > rowCount) {
            cellSet.addRow(toEndRow - rowCount);
        }
        if (toEndCol > colCount) {
            cellSet.addCol(toEndCol - colCount);
        }
        Matrix fromData = GMSpl.getMatrixCells(cellSet, fromRect);
        ArrayList<NormalCell> errorCells = new ArrayList<NormalCell>();
        int dr = toRect.getBeginRow() - fromRect.getBeginRow();
        int dc = toRect.getBeginCol() - fromRect.getBeginCol();
        int r = 0;
        while (r < fromRect.getRowCount()) {
            c = 0;
            while (c < fromRect.getColCount()) {
                nc = cellSet.newCell(r + 1, c + 1);
                cellSet.setCell(fromRect.getBeginRow() + r, fromRect.getBeginCol() + c, nc);
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < toRect.getRowCount()) {
            c = 0;
            while (c < toRect.getColCount()) {
                nc = (NormalCell)fromData.get(r, c);
                if (nc == null) {
                    cellSet.setCell(toRect.getBeginRow() + r, toRect.getBeginCol() + c, null);
                } else {
                    cellSet.setCell(toRect.getBeginRow() + r, toRect.getBeginCol() + c, (NormalCell)nc.deepClone());
                }
                ++c;
            }
            ++r;
        }
        if (dr >= 0) {
            if (dc >= 0) {
                r = toRect.getRowCount() - 1;
                while (r >= 0) {
                    c = toRect.getColCount() - 1;
                    while (c >= 0) {
                        List<NormalCell> tmp = AtomicSpl.exeAdjust(cellSet, fromRect, toRect, r, c, fromData == null ? null : (NormalCell)fromData.get(r, c));
                        if (tmp != null) {
                            errorCells.addAll(tmp);
                        }
                        --c;
                    }
                    --r;
                }
            } else {
                r = toRect.getRowCount() - 1;
                while (r >= 0) {
                    c = 0;
                    while (c < toRect.getColCount()) {
                        List<NormalCell> tmp = AtomicSpl.exeAdjust(cellSet, fromRect, toRect, r, c, fromData == null ? null : (NormalCell)fromData.get(r, c));
                        if (tmp != null) {
                            errorCells.addAll(tmp);
                        }
                        ++c;
                    }
                    --r;
                }
            }
        } else if (dc >= 0) {
            r = 0;
            while (r < toRect.getRowCount()) {
                c = toRect.getColCount() - 1;
                while (c >= 0) {
                    List<NormalCell> tmp = AtomicSpl.exeAdjust(cellSet, fromRect, toRect, r, c, fromData == null ? null : (NormalCell)fromData.get(r, c));
                    if (tmp != null) {
                        errorCells.addAll(tmp);
                    }
                    --c;
                }
                ++r;
            }
        } else {
            r = 0;
            while (r < toRect.getRowCount()) {
                c = 0;
                while (c < toRect.getColCount()) {
                    List<NormalCell> tmp = AtomicSpl.exeAdjust(cellSet, fromRect, toRect, r, c, fromData == null ? null : (NormalCell)fromData.get(r, c));
                    if (tmp != null) {
                        errorCells.addAll(tmp);
                    }
                    ++c;
                }
                ++r;
            }
        }
        return errorCells;
    }

    public static String cellSetToString(PgmCellSet cs) {
        StringBuffer sb = new StringBuffer(1024);
        boolean isFirstLine = true;
        int rowCount = cs.getRowCount();
        int colCount = cs.getColCount();
        int r = 1;
        while (r <= rowCount) {
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                sb.append('\n');
            }
            int c = 1;
            while (c <= colCount) {
                String exp;
                if (c > 1) {
                    sb.append('\t');
                }
                if ((exp = cs.getPgmNormalCell(r, c).getExpString()) != null) {
                    boolean isGridExp = GMSpl.isGridCellExp(exp);
                    if (isGridExp) {
                        exp = Escape.add(exp);
                    }
                    sb.append(exp);
                }
                ++c;
            }
            ++r;
        }
        return sb.toString();
    }

    public static boolean isGridCellExp(String exp) {
        if (exp == null) {
            return false;
        }
        exp = exp.replaceAll("\r\n", "\n");
        exp = exp.replaceAll("\r", "\n");
        ArgumentTokenizer rowDatas = new ArgumentTokenizer(exp, '\n', true, true, true);
        int rc = 0;
        while (rowDatas.hasMoreTokens()) {
            String sRowData = rowDatas.nextToken();
            int cc = 0;
            ArgumentTokenizer rowData = new ArgumentTokenizer(sRowData, '\t', true, true, true);
            while (rowData.hasMoreTokens()) {
                rowData.nextToken();
                if (++cc <= 1) continue;
                return true;
            }
            if (++rc <= 1) continue;
            return true;
        }
        return false;
    }
}

