/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.common.Pwd;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.GVSE;
import com.scudata.ide.common.ServiceUtil;
import com.scudata.ide.common.dialog.DialogSQLEditor;
import com.scudata.ide.common.dialog.DialogSelectDataSource;
import com.scudata.ide.spl.ExcelServer;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.GVSplSE;
import com.scudata.ide.spl.IDEBase;
import com.scudata.ide.spl.ProcessWatchThread;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.ide.spl.dialog.DialogAboutSE;
import com.scudata.ide.spl.dialog.DialogEncrypt;
import com.scudata.ide.spl.dialog.DialogExecCmd;
import com.scudata.ide.spl.dialog.DialogOptionsSE;
import com.scudata.ide.spl.dialog.DialogSerialNo;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.ide.spl.update.UpdateManager;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class GMSplSE {
    private static int excelRet = 0;
    private static final String DOWNLOAD_URL_DESK_EN = "https://www.scudata.com/download-Desktop";
    private static final String DOWNLOAD_URL_DESK_ZH = "http://www.raqsoft.com.cn/desktop-download";
    private static final String DOWNLOAD_URL_SE_EN = "https://c.scudata.com/article/1595817756260";
    private static final String DOWNLOAD_URL_SE_ZH = "http://www.raqsoft.com.cn/download/download-jsq";
    private static final String DOWNLOAD_URL_EE_EN = "https://c.scudata.com/article/1595817756260";
    private static final String DOWNLOAD_URL_EE_ZH = "http://www.raqsoft.com.cn/download/download-jsq";

    public static boolean executeCmd(short cmdId) throws Exception {
        switch (cmdId) {
            case 305: {
                DialogAboutSE da = new DialogAboutSE(true);
                da.setVisible(true);
                return true;
            }
            case 2451: {
                ImageIcon ii = GMSpl.getLogoImage(true);
                DialogSerialNo dsn = new DialogSerialNo(GV.appFrame, GV.config.getEsprocSerialNo(), null, ii == null ? null : ii.getImage(), true){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void updateSerialNo(String serialNo) throws Exception {
                        GMSplSE.updateSerialNo(serialNo);
                        IDEBase.checkExpirationSystem();
                    }

                    @Override
                    public String getDownloadUrl() {
                        return GMSplSE.getDownloadUrl();
                    }
                };
                dsn.setVisible(true);
                return true;
            }
            case 110: {
                boolean showDB = ConfigOptions.bShowDBStruct;
                float oldRowHeight = ConfigOptions.fRowHeight.floatValue();
                Font oldFont = GC.font;
                new DialogOptionsSE().setVisible(true);
                ((IDEBase)GV.appFrame).refreshOptions();
                if (showDB != ConfigOptions.bShowDBStruct && GVSpl.tabParam != null) {
                    GVSpl.tabParam.resetEnv();
                }
                if (oldRowHeight != ConfigOptions.fRowHeight.floatValue() || oldFont.getSize() != GC.font.getSize() || oldFont.getStyle() != GC.font.getStyle() || !oldFont.getFontName().equals(GC.font.getFontName())) {
                    GVSpl.panelValue.tableValue.refreshOptions();
                }
                if (ConfigOptions.bFuncNotice.booleanValue()) {
                    GVSE.getFuncWindow().setFuncEnabled(true);
                }
                return true;
            }
            case 2311: {
                String startHome = System.getProperty("start.home");
                File binDir = new File(startHome, "bin");
                if (!binDir.exists() || !binDir.isDirectory()) {
                    JOptionPane.showMessageDialog(GV.appFrame, IdeSplMessage.get().getMessage("dialogexeccmd.binnotexist", binDir.getAbsolutePath()));
                    return true;
                }
                File exeFile = new File(binDir, "ExcelVer.bat");
                if (!exeFile.isFile() || !exeFile.exists()) {
                    JOptionPane.showMessageDialog(GV.appFrame, IdeSplMessage.get().getMessage("dialogexeccmd.exenotexist", exeFile.getAbsolutePath()));
                    return true;
                }
                String[] cmds = new String[]{"cmd.exe", "/c", "start", "/b", " ", exeFile.getAbsolutePath()};
                try {
                    Process proc = Runtime.getRuntime().exec(cmds, null, binDir);
                    ProcessWatchThread wt = new ProcessWatchThread(proc.getInputStream()){

                        @Override
                        protected void outputLine(String line) {
                            if (line.startsWith("ret=")) {
                                try {
                                    excelRet = Integer.parseInt(line.substring(4));
                                    SwingUtilities.invokeLater(new Thread(){

                                        @Override
                                        public void run() {
                                            if (excelRet == 1) {
                                                JOptionPane.showMessageDialog(GV.appFrame, IdeSplMessage.get().getMessage("gmsplc.installexcelsucc"));
                                            } else if (excelRet == 0) {
                                                JOptionPane.showMessageDialog(GV.appFrame, IdeSplMessage.get().getMessage("gmsplc.installexcelfail"));
                                            }
                                        }
                                    });
                                }
                                catch (Exception ex) {
                                    System.out.println(line);
                                }
                            } else {
                                String S_F = "\f";
                                if (line.startsWith(S_F)) {
                                    line = line.substring(S_F.length());
                                }
                                System.out.println(line);
                            }
                        }
                    };
                    wt.start();
                    ProcessWatchThread wt1 = new ProcessWatchThread(proc.getErrorStream());
                    wt1.start();
                    proc.waitFor();
                    wt.setOver(true);
                    wt1.setOver(true);
                    if (GV.console != null) {
                        ((IDEBase)GV.appFrame).viewTabConsole();
                    }
                }
                catch (Exception e1) {
                    GM.showException(GV.appFrame, e1);
                    return true;
                }
                return true;
            }
            case 2321: {
                DialogSelectDataSource dsds = new DialogSelectDataSource(1);
                dsds.setVisible(true);
                if (dsds.getOption() != 0) {
                    return true;
                }
                DataSource ds = dsds.getDataSource();
                try {
                    DialogSQLEditor dse = new DialogSQLEditor(ds);
                    dse.setCopyMode();
                    dse.setVisible(true);
                }
                catch (Throwable ex) {
                    GM.showException(GV.appFrame, ex);
                }
                return true;
            }
            case 2313: {
                if (GV.appSheet == null) {
                    DialogExecCmd dec = new DialogExecCmd();
                    dec.setVisible(true);
                    return true;
                }
                return false;
            }
            case 2331: {
                try {
                    ExcelServer.start();
                }
                catch (Throwable ex) {
                    GM.showException(GV.appFrame, ex);
                }
                return true;
            }
            case 2341: {
                try {
                    SplEditorSE.checkEncrypt();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(GVSpl.appFrame, e.getMessage());
                    return true;
                }
                DialogEncrypt de = new DialogEncrypt();
                de.setVisible(true);
                return true;
            }
        }
        return false;
    }

    public static boolean isExcelName(String cellReference) {
        if (!StringUtils.isValidString(cellReference)) {
            return false;
        }
        String[] parts = cellReference.split("!");
        if (parts.length > 2) {
            return false;
        }
        String sheetName = "";
        String cellName = cellReference;
        if (parts.length == 2) {
            sheetName = parts[0].trim();
            cellName = parts[1].trim();
            if (!StringUtils.isValidString(sheetName)) {
                return false;
            }
        }
        if (GMSplSE.isExcelCellName(cellName)) {
            return true;
        }
        return GMSplSE.isExcelAreaName(cellName);
    }

    public static boolean isExcelSheetCellName(String name) {
        if (!StringUtils.isValidString(name)) {
            return false;
        }
        String[] names = name.split("!");
        if (names.length == 2) {
            String sheetName = names[0];
            if (!StringUtils.isValidString(sheetName)) {
                return false;
            }
            String cellName = names[1];
            if (GMSplSE.isExcelCellName(cellName)) {
                return true;
            }
            if (GMSplSE.isExcelAreaName(cellName)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isExcelAreaName(String cellReference) {
        if (!StringUtils.isValidString(cellReference)) {
            return false;
        }
        String[] cellNames = cellReference.split(":");
        return cellNames.length == 2 && GMSplSE.isExcelCellName(cellNames[0]) && GMSplSE.isExcelCellName(cellNames[1]);
    }

    public static boolean isExcelCellName(String cellName) {
        if (!StringUtils.isValidString(cellName)) {
            return false;
        }
        String cellNameRegex = "^[A-Z]+(\\$)?\\d+(\\$)?$";
        return cellName.matches(cellNameRegex);
    }

    public static boolean checkSerialNo() {
        return true;
    }

    public static void updateSerialNo(String serialNo) throws Exception {
        GMSplSE.updateSerialNo(serialNo, true);
    }

    public static void updateSerialNo(String serialNo, boolean isEsproc) throws Exception {
        if (!StringUtils.isValidString(serialNo)) {
            GV.config.setEsprocSerialNo(null);
            SplEditorSE.deleteSN();
            throw new Exception(SplEditorSE.getNoSNMessage());
        }
        String oldSN = GV.config.getEsprocSerialNo();
        SplEditorSE.setSerialNo(SplEditorSE.productIds, serialNo);
        GV.config.setEsprocSerialNo(serialNo);
        if (isEsproc && SplEditorSE.isTrial() && serialNo != null && !serialNo.equals(oldSN)) {
            String countStr;
            int count = 0;
            Pwd pwd = new Pwd();
            if (StringUtils.isValidString(ConfigOptions.sFileTip) && StringUtils.isValidString(countStr = pwd.decrypt(ConfigOptions.sFileTip))) {
                try {
                    count = Integer.parseInt(countStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ConfigOptions.sFileTip = pwd.encrypt(String.valueOf(count + 1));
        }
    }

    public static String getDownloadUrl() {
        String downloadUrl = null;
        try {
            downloadUrl = UpdateManager.getDownloadUrl();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isValidString(downloadUrl)) {
            return downloadUrl;
        }
        boolean isCN = GM.isChineseLanguage();
        int productId = GMSplSE.getActiveProductId();
        switch (productId) {
            case 4: {
                return isCN ? DOWNLOAD_URL_DESK_ZH : DOWNLOAD_URL_DESK_EN;
            }
            case 5: {
                return isCN ? "http://www.raqsoft.com.cn/download/download-jsq" : "https://c.scudata.com/article/1595817756260";
            }
            case 6: 
            case 7: {
                return isCN ? "http://www.raqsoft.com.cn/download/download-jsq" : "https://c.scudata.com/article/1595817756260";
            }
        }
        return null;
    }

    public static int getActiveProductId() {
        int productId = 4;
        if (SplEditorSE.productIds != null && SplEditorSE.productIds.length > 0) {
            productId = SplEditorSE.productIds[0];
        }
        return productId;
    }

    public static String getServiceProductId() {
        int productId = GMSplSE.getActiveProductId();
        switch (productId) {
            case 4: {
                return "esproc_desk";
            }
            case 6: 
            case 7: {
                return "esproc_ent";
            }
        }
        return "esproc_se";
    }

    public static boolean count(String productType) {
        try {
            ServiceUtil.count(productType);
            return true;
        }
        catch (Throwable t) {
            try {
                GMSplSE.getContent("http://www.baidu.com", true);
            }
            catch (Throwable t1) {
                try {
                    GMSplSE.getContent("http://www.google.com", true);
                }
                catch (Throwable tt) {
                    return false;
                }
            }
            return true;
        }
    }

    private static String getContent(String urlAddress, boolean oneline) throws Exception {
        String tmp;
        BufferedReader br = null;
        URL url = new URL(urlAddress);
        br = new BufferedReader(new InputStreamReader(url.openStream()));
        StringBuffer content = new StringBuffer();
        while ((tmp = br.readLine()) != null) {
            if (oneline) {
                String string = tmp;
                return string;
            }
            if (content.length() > 0) {
                content.append("\n");
            }
            content.append(tmp);
        }
        String string = content.toString();
        return string;
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isDevelop() {
        String isDev = System.getProperty("ide.develop");
        return "true".equalsIgnoreCase(isDev);
    }

    public static boolean isExcelXllEnabled() {
        return GM.isWindowsOS() && GVSplSE.isExcelXllEnabled != false;
    }

    public static boolean isOfficeAddinEnabled() {
        return GVSplSE.isOfficeAddinEnabled;
    }

    public static String getExcelAddinFuncName() {
        if (GMSplSE.isExcelXllEnabled() && GMSplSE.isOfficeAddinEnabled()) {
            if (ConfigOptions.bExcelXllType.booleanValue()) {
                return "spl";
            }
            return "SPL.X";
        }
        if (GMSplSE.isOfficeAddinEnabled()) {
            return "SPL.X";
        }
        return "spl";
    }
}

