/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.app.common.AppUtil;
import com.scudata.app.common.Section;
import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.Escape;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.ide.common.AppFrame;
import com.scudata.ide.common.AppMenu;
import com.scudata.ide.common.AppToolBar;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.ConfigUtilIde;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.DataSourceListModel;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IPrjxSheet;
import com.scudata.ide.common.LookAndFeelManager;
import com.scudata.ide.common.ServiceUtil;
import com.scudata.ide.common.TcpServer;
import com.scudata.ide.common.ToolBarPropertyBase;
import com.scudata.ide.common.ToolBarWindow;
import com.scudata.ide.common.control.PanelConsole;
import com.scudata.ide.common.control.TransferableObject;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.IDEBase_this_windowAdapter;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.StepInfo;
import com.scudata.ide.spl.ToolBarSpl;
import com.scudata.ide.spl.base.FileTree;
import com.scudata.ide.spl.base.JTabbedParam;
import com.scudata.ide.spl.base.PanelSplWatch;
import com.scudata.ide.spl.base.PanelValue;
import com.scudata.ide.spl.control.ContentPanel;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.ide.spl.dialog.DialogSplash;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.util.CellSetUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class IDEBase
extends AppFrame {
    private static final long serialVersionUID = 1L;
    private JPanel barPanel = new JPanel();
    private JSplitPane splitToolMain = new JSplitPane();
    private JSplitPane splitMain = new JSplitPane();
    private JSplitPane splitGridValue = new JSplitPane();
    private JSplitPane splitValueParam = new JSplitPane();
    private JTabbedParam tabParam;
    protected AppMenu currentMenu;
    private boolean terminalVM = true;
    private String[] startDsNames = null;
    protected JTabbedPane jTPLeft = new JTabbedPane();
    protected JTabbedPane jTPRight = new JTabbedPane();
    protected FileTree fileTree;
    protected JPanel jPFileTree = new JPanel(new BorderLayout());
    private MessageManager mm = IdeSplMessage.get();
    private boolean isInit = false;
    private volatile boolean preventChange = false;
    private Rectangle dropRect;
    private volatile boolean isValuePanelAtRight = true;
    private static int SPLIT_GAP;
    private volatile int lastLeftLocation;
    private volatile int lastRightLocation;
    private boolean autoConnect = false;
    private volatile Integer startDBCount = new Integer(0);
    private final int TOOL_MIN_LOCATION = 62;
    private final int TOOL_MAX_LOCATION = 200;
    public static DialogSplash splashWindow;
    public static final String ESPROC_PORT_KEY = "esproc_port";
    private AutoSaveThread autoSaveThread;
    private static Long systemTime;

    static {
        try {
            ImageIcon ii;
            if (GM.isMacOS() && (ii = GM.getLogoImage(false)) != null) {
                GM.setMacOSDockIcon(ii.getImage());
            }
        }
        catch (Throwable t) {
            GM.outputMessage(t);
        }
        SPLIT_GAP = 50;
        splashWindow = null;
        systemTime = null;
    }

    public IDEBase() {
        this((String)null);
    }

    public IDEBase(String openFile) {
        this(openFile, true);
    }

    public IDEBase(String openFile, boolean terminalVMwhileExit) {
        try {
            ConfigFile.getConfigFile().setConfigNode(ConfigFile.NODE_OPTIONS);
            GV.lastDirectory = ConfigFile.getConfigFile().getAttrValue("fileDirectory");
        }
        catch (Throwable t) {
            GM.outputMessage(t);
        }
        try {
            Env.getCollator();
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.setProgramPart();
        if (GV.config != null) {
            List<String> dsList = GV.config.getAutoConnectList();
            if (dsList != null && !dsList.isEmpty()) {
                this.startDsNames = new String[dsList.size()];
                int i = 0;
                while (i < dsList.size()) {
                    this.startDsNames[i] = dsList.get(i);
                    ++i;
                }
            } else {
                this.startDsNames = null;
            }
        }
        this.terminalVM = terminalVMwhileExit;
        try {
            PanelSplWatch panelSplWatch;
            AppMenu menuBase;
            GV.appFrame = this;
            GV.dsModel = new DataSourceListModel();
            GV.toolWin = new ToolBarWindow(){
                private static final long serialVersionUID = 1L;

                @Override
                public void closeSheet(IPrjxSheet sheet) {
                    ((IDEBase)GV.appFrame).closeSheet(sheet);
                }

                @Override
                public void dispSheet(IPrjxSheet sheet) throws Exception {
                    ((IDEBase)GV.appFrame).showSheet(sheet);
                }

                @Override
                public ImageIcon getSheetIconName(JInternalFrame sheet) {
                    return GM.getImageIcon("/com/scudata/ide/common/resources/file_spl.png");
                }

                @Override
                public ImageIcon getLogoImage() {
                    return GM.getLogoImage(true);
                }
            };
            this.desk = new JDesktopPane();
            this.desk.setDragMode(0);
            this.desk.revalidate();
            GV.directOpenFile = openFile;
            this.newResourceTree();
            this.newMenuSpl();
            GV.appMenu = menuBase = this.newMenuBase();
            this.currentMenu = menuBase;
            this.setJMenuBar(GV.appMenu);
            GM.resetEnvDataSource(GV.dsModel);
            PanelValue panelValue = new PanelValue();
            GVSpl.panelSplWatch = panelSplWatch = new PanelSplWatch(){
                private static final long serialVersionUID = 1L;

                @Override
                public Object watch(String expStr) {
                    if (GV.appSheet != null && GV.appSheet instanceof SheetSpl) {
                        return ((SheetSpl)GV.appSheet).calcExp(expStr);
                    }
                    return null;
                }
            };
            AppToolBar toolBase = null;
            ToolBarPropertyBase toolBarProperty = null;
            toolBase = GVSpl.newBaseTool();
            toolBarProperty = this.newToolBarProperty();
            GV.appTool = toolBase;
            GV.toolBarProperty = toolBarProperty;
            this.barPanel.setLayout(new BorderLayout());
            this.barPanel.add((Component)GV.appTool, "North");
            this.barPanel.add((Component)GV.toolBarProperty, "Center");
            JPanel panelCenter = new JPanel(new BorderLayout());
            panelCenter.add((Component)GV.toolWin, "North");
            panelCenter.add((Component)this.splitMain, "Center");
            this.splitMain.add((Component)this.jTPLeft, "left");
            this.splitMain.add((Component)this.splitGridValue, "right");
            int SPLIT_WIDTH = 8;
            this.splitMain.setOneTouchExpandable(true);
            this.splitMain.setDividerSize(8);
            this.splitMain.setOrientation(1);
            int MAIN_WIDTH = new Double(Toolkit.getDefaultToolkit().getScreenSize().getWidth()).intValue();
            int POS_MAIN = new Double(0.25 * (double)MAIN_WIDTH).intValue();
            this.splitMain.setDividerLocation(POS_MAIN);
            this.splitGridValue.setOneTouchExpandable(true);
            this.splitGridValue.setDividerSize(8);
            this.splitGridValue.setOrientation(1);
            this.lastLeftLocation = 0;
            this.jTPLeft.setMinimumSize(new Dimension(1, 1));
            this.jTPRight.setMinimumSize(new Dimension(1, 1));
            this.initFileTree();
            this.jTPLeft.addTab(this.mm.getMessage("public.file"), this.jPFileTree);
            this.jTPRight.addTab(this.mm.getMessage("dfx.tabvalue"), panelValue);
            this.tabParam = new JTabbedParam(){
                private static final long serialVersionUID = 1L;

                @Override
                public void selectVar(Object val, String varName, String spaceName) {
                    IDEBase.this.selectParam(varName, val, spaceName);
                }

                @Override
                public ParamList getCellSetParamList() {
                    IPrjxSheet sheet = GV.appSheet;
                    if (sheet != null && sheet instanceof SheetSpl) {
                        return ((SheetSpl)sheet).getContextParamList();
                    }
                    return null;
                }

                @Override
                public HashMap<String, Param[]> getSpaceParams() {
                    IPrjxSheet sheet = GV.appSheet;
                    if (sheet != null && sheet instanceof SheetSpl) {
                        return ((SheetSpl)sheet).listSpaceParams();
                    }
                    return JobSpaceManager.listSpaceParams();
                }

                @Override
                public ParamList getEnvParamList() {
                    IPrjxSheet sheet = GV.appSheet;
                    if (sheet != null && sheet instanceof SheetSpl) {
                        return ((SheetSpl)sheet).getEnvParamList();
                    }
                    return Env.getParamList();
                }
            };
            this.addDragListener(this.jTPRight);
            GVSpl.tabParam = this.tabParam;
            if (ConfigOptions.bIdeConsole.booleanValue()) {
                this.tabParam.consoleVisible(true);
            }
            this.splitMain.setLeftComponent(this.jTPLeft);
            this.splitMain.setRightComponent(this.splitGridValue);
            if (ConfigOptions.iConsoleLocation != null && ConfigOptions.iConsoleLocation > -1) {
                this.lastLeftLocation = ConfigOptions.iConsoleLocation;
                if (this.lastLeftLocation <= SPLIT_GAP) {
                    this.splitMain.setDividerLocation(POS_MAIN);
                } else {
                    this.splitMain.setDividerLocation(0);
                }
                this.splitMain.setDividerLocation(this.lastLeftLocation);
            } else {
                this.splitMain.setDividerLocation(0);
                this.isInit = true;
            }
            this.fileTree.changeMainPath(ConfigOptions.sMainPath);
            this.splitValueParam.setOneTouchExpandable(true);
            this.splitValueParam.setDividerSize(8);
            this.splitValueParam.setOrientation(0);
            int POS_RIGHT_SPL = new Double(0.45 * Toolkit.getDefaultToolkit().getScreenSize().getHeight()).intValue();
            this.splitValueParam.setDividerLocation(POS_RIGHT_SPL);
            this.splitValueParam.add((Component)this.jTPRight, "top");
            this.splitValueParam.add((Component)this.tabParam, "bottom");
            this.splitGridValue.add((Component)this.desk, "left");
            this.splitGridValue.add((Component)this.splitValueParam, "right");
            this.getContentPane().add((Component)this.splitToolMain, "Center");
            this.splitToolMain.setOrientation(0);
            this.splitToolMain.setDividerSize(4);
            this.splitToolMain.setTopComponent(this.barPanel);
            this.splitToolMain.setBottomComponent(panelCenter);
            this.splitToolMain.setDividerLocation(62);
            this.splitToolMain.setBorder(BorderFactory.createRaisedBevelBorder());
            this.splitToolMain.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    boolean isExpand = IDEBase.this.isToolBarExpand();
                    GV.toolBarProperty.setExtendButtonIcon(isExpand);
                }
            });
            this.pack();
            this.initUI();
            GV.allFrames.add(this);
            int rightWidth = MAIN_WIDTH - this.splitMain.getDividerLocation();
            if (ConfigOptions.bWindowSize.booleanValue()) {
                this.lastRightLocation = ConfigOptions.iGridLocation;
                if (this.lastRightLocation <= 1) {
                    this.lastRightLocation = 1;
                } else if (this.lastRightLocation >= this.splitGridValue.getWidth()) {
                    this.lastRightLocation = this.splitGridValue.getWidth() - 1;
                }
            } else {
                this.lastRightLocation = new Double((double)rightWidth * 0.7).intValue();
            }
            this.splitGridValue.setDividerLocation(this.lastRightLocation);
            this.splitMain.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (IDEBase.this.preventChange) {
                        return;
                    }
                    try {
                        try {
                            IDEBase.this.preventChange = true;
                            if (IDEBase.this.isValuePanelAtRight) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        int dlNew = IDEBase.this.splitMain.getDividerLocation();
                                        int dif = IDEBase.this.lastLeftLocation - dlNew;
                                        IDEBase.this.lastLeftLocation = dlNew;
                                        int dlRightNew = IDEBase.this.lastRightLocation + dif;
                                        if (dlRightNew <= 0) {
                                            IDEBase.this.splitGridValue.setDividerLocation(0.0);
                                        } else if (dlRightNew >= IDEBase.this.splitGridValue.getWidth()) {
                                            IDEBase.this.splitGridValue.setDividerLocation(1.0);
                                        } else {
                                            IDEBase.this.splitGridValue.setDividerLocation(dlRightNew);
                                        }
                                    }
                                });
                            }
                        }
                        catch (Exception exception) {
                            IDEBase.this.preventChange = false;
                        }
                    }
                    finally {
                        IDEBase.this.preventChange = false;
                    }
                }
            });
            this.splitGridValue.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (IDEBase.this.preventChange) {
                        return;
                    }
                    IDEBase.this.lastRightLocation = IDEBase.this.splitGridValue.getDividerLocation();
                }
            });
        }
        catch (Throwable e) {
            GM.showException(GV.appFrame, e);
            this.exit();
        }
    }

    protected void initFileTree() {
        this.jPFileTree.add((Component)new JScrollPane(this.fileTree), "Center");
    }

    protected void newResourceTree() {
        GV.fileTree = this.fileTree = new FileTree();
    }

    protected AppMenu newMenuBase() {
        return GVSpl.newBaseMenu();
    }

    protected AppMenu newMenuSpl() {
        return GVSpl.newSplMenu();
    }

    protected ToolBarPropertyBase newToolBarProperty() {
        return GVSpl.newSplProperty();
    }

    protected ToolBarSpl newToolBarSpl() {
        return GVSpl.newSplTool();
    }

    protected void selectParam(String varName, Object val, String spaceName) {
        GVSpl.panelValue.tableValue.setValue1(val, varName);
        GVSpl.panelValue.valueBar.refresh();
        this.repaint();
    }

    protected void addDragListener(final JTabbedPane tabbedPane) {
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    if (GVSpl.splEditor == null || GVSpl.splEditor.getComponent() == null) {
                        return;
                    }
                    BufferedImage image = new BufferedImage(tabbedPane.getWidth(), tabbedPane.getHeight(), 2);
                    tabbedPane.paint(image.getGraphics());
                    TransferableObject tf = new TransferableObject("");
                    dge.startDrag(Cursor.getPredefinedCursor(12), image, new Point(0, 0), tf, new DragSourceAdapter(){

                        @Override
                        public void dragOver(DragSourceDragEvent dsde) {
                            if (GVSpl.splEditor == null) {
                                return;
                            }
                            SplControl control = GVSpl.splEditor.getComponent();
                            if (control == null) {
                                return;
                            }
                            ContentPanel cp = control.getContentPanel();
                            Rectangle displayWin = control.getViewport().getViewRect();
                            if (displayWin == null) {
                                return;
                            }
                            int x = 0;
                            int y = 0;
                            int w = displayWin.width;
                            int h = displayWin.height;
                            if (IDEBase.this.isValuePanelAtRight) {
                                int bottomHeight = Math.max(GVSpl.tabParam.getHeight(), control.getHeight() / 5);
                                y = control.getHeight() - bottomHeight - IDEBase.this.splitGridValue.getDividerSize();
                                h = bottomHeight;
                            } else {
                                x = w - GVSpl.tabParam.getWidth();
                                w = GVSpl.tabParam.getWidth();
                                h = control.getHeight();
                                if (control.getVerticalScrollBar() != null && control.getVerticalScrollBar().isVisible()) {
                                    x = (int)((float)x + (float)control.getVerticalScrollBar().getWidth() * control.scale);
                                    w = (int)((float)w - (float)control.getVerticalScrollBar().getWidth() * control.scale);
                                }
                            }
                            IDEBase.this.dropRect = new Rectangle(x += displayWin.x, y += displayWin.y, w, h);
                            cp.setDropRect(IDEBase.this.dropRect);
                            cp.repaint();
                        }

                        @Override
                        public void dragDropEnd(DragSourceDropEvent dsde) {
                            if (GVSpl.splEditor == null) {
                                return;
                            }
                            SplControl control = GVSpl.splEditor.getComponent();
                            if (control == null) {
                                return;
                            }
                            ContentPanel cp = control.getContentPanel();
                            try {
                                try {
                                    Point dropPoint = SwingUtilities.convertPoint(GV.appFrame, dsde.getLocation(), cp);
                                    if (IDEBase.this.dropRect != null && IDEBase.this.dropRect.contains(dropPoint)) {
                                        if (IDEBase.this.isValuePanelAtRight) {
                                            int dlValueParam = control.getWidth();
                                            IDEBase.this.splitGridValue.setOrientation(0);
                                            IDEBase.this.splitGridValue.setDividerLocation(control.getHeight() - GVSpl.tabParam.getHeight() + IDEBase.this.splitGridValue.getDividerSize());
                                            IDEBase.this.splitValueParam.setOrientation(1);
                                            IDEBase.this.splitValueParam.setDividerLocation(dlValueParam);
                                        } else {
                                            int dlGridValue = IDEBase.this.splitValueParam.getDividerLocation() + IDEBase.this.splitValueParam.getDividerSize();
                                            int dlValueParam = control.getHeight();
                                            IDEBase.this.splitGridValue.setOrientation(1);
                                            IDEBase.this.splitGridValue.setDividerLocation(dlGridValue);
                                            IDEBase.this.splitValueParam.setOrientation(0);
                                            IDEBase.this.splitValueParam.setDividerLocation(dlValueParam);
                                        }
                                        IDEBase.this.isValuePanelAtRight = !IDEBase.this.isValuePanelAtRight;
                                        IDEBase.this.revalidate();
                                    }
                                }
                                catch (Exception exception) {
                                    if (cp != null) {
                                        cp.setDropRect(null);
                                    }
                                    IDEBase.this.repaint();
                                }
                            }
                            finally {
                                if (cp != null) {
                                    cp.setDropRect(null);
                                }
                                IDEBase.this.repaint();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(tabbedPane, 2, dgl);
    }

    private void initUI() {
        this.setDefaultCloseOperation(2);
        this.setEnabled(true);
        this.addWindowListener(new IDEBase_this_windowAdapter(this));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GV.toolWin.refresh();
            }
        });
    }

    public JInternalFrame[] getAllInternalFrames() {
        return this.desk.getAllFrames();
    }

    public String[] getSheetTitles() {
        JInternalFrame[] sheets = GV.appFrame.getDesk().getAllFrames();
        if (sheets == null || sheets.length == 0) {
            return null;
        }
        int len = sheets.length;
        String[] titles = new String[len];
        int i = 0;
        while (i < len) {
            titles[i] = ((IPrjxSheet)sheets[i]).getSheetTitle();
            ++i;
        }
        return titles;
    }

    @Override
    public boolean closeSheet(Object sheet) {
        return this.closeSheet(sheet, true);
    }

    public boolean closeSheet(Object sheet, boolean showSheet) {
        return this.closeSheet(sheet, showSheet, false);
    }

    public boolean closeSheet(Object sheet, boolean showSheet, boolean isQuit) {
        SheetSpl ss;
        if (sheet == null) {
            return false;
        }
        if (isQuit && sheet instanceof SheetSpl ? !(ss = (SheetSpl)sheet).close(isQuit) : !((IPrjxSheet)sheet).close()) {
            return false;
        }
        String sheetTitle = ((IPrjxSheet)sheet).getSheetTitle();
        GV.appMenu.removeLiveMenu(sheetTitle);
        this.desk.getDesktopManager().closeFrame((JInternalFrame)sheet);
        JInternalFrame[] frames = this.desk.getAllFrames();
        if (frames.length == 0) {
            this.changeMenuAndToolBar(this.newMenuBase(), GVSpl.newBaseTool());
            GV.appMenu.setEnable(GV.appMenu.getMenuItems(), false);
            GV.appTool.setBarEnabled(false);
            GV.toolWin.setVisible(false);
            GV.appSheet = null;
        } else if (showSheet) {
            try {
                if (frames.length > 0) {
                    this.showSheet(frames[0], false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                GV.appMenu.refreshRecentFileOnClose(sheetTitle, frames);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.resetTitle();
        GV.toolWin.refresh();
        return true;
    }

    @Override
    public boolean closeAll() {
        return this.closeAll(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean closeAll(boolean isQuit) {
        JInternalFrame[] frames = this.desk.getAllFrames();
        StringBuffer buf = new StringBuffer();
        try {
            int i = 0;
            while (true) {
                SheetSpl ss;
                if (i >= frames.length) {
                    if (!isQuit) return true;
                    ConfigOptions.sAutoOpenFileNames = buf.toString();
                    return true;
                }
                IPrjxSheet sheet = (IPrjxSheet)frames[i];
                if (!this.closeSheet(sheet, false, isQuit)) {
                    return false;
                }
                if (sheet instanceof SheetSpl && this.isLocalSheet(ss = (SheetSpl)sheet) && (ConfigOptions.bAutoSave.booleanValue() || !ss.isNewGrid())) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append(Escape.addEscAndQuote(ss.getFileName()));
                }
                ++i;
            }
        }
        catch (Exception x) {
            GM.showException(GV.appFrame, x);
            return false;
        }
    }

    protected boolean isLocalSheet(SheetSpl sheet) {
        return true;
    }

    @Override
    public boolean exit() {
        try {
            ArrayList<String> connectedDSNames = new ArrayList<String>();
            int size = GV.dsModel.size();
            int i = 0;
            while (i < size) {
                DataSource ds = (DataSource)GV.dsModel.get(i);
                if (!ds.isClosed()) {
                    connectedDSNames.add(ds.getName());
                }
                ++i;
            }
            if (connectedDSNames.isEmpty()) {
                connectedDSNames = null;
            }
            if (this.fileTree != null && this.fileTree instanceof FileTree) {
                this.fileTree.saveExpandState(this.splitMain.getDividerLocation());
            }
            GV.config.setAutoConnectList(connectedDSNames);
            ConfigUtilIde.writeActiveConfig(false);
        }
        catch (Exception e) {
            GM.outputMessage(e);
        }
        if (this.autoSaveThread != null) {
            this.autoSaveThread.stopThread();
        }
        try {
            if (!this.exitCustom()) {
                return false;
            }
        }
        catch (Throwable x) {
            GM.showException(GV.appFrame, x);
        }
        try {
            if (this.splitMain.getLeftComponent() == null) {
                ConfigOptions.iConsoleLocation = new Integer(-1);
            } else {
                int dl = this.splitMain.getDividerLocation();
                if (GV.toolWin != null) {
                    ConfigOptions.bViewWinList.booleanValue();
                }
                ConfigOptions.iConsoleLocation = new Integer(dl);
            }
            int dl = this.splitGridValue.getDividerLocation();
            ConfigOptions.iGridLocation = new Integer(dl);
            ConfigOptions.save(false, true);
            ConfigFile cf = ConfigFile.getConfigFile();
            cf.setConfigNode(ConfigFile.NODE_OPTIONS);
            cf.setAttrValue("fileDirectory", GV.lastDirectory);
            GM.setWindowDimension(GVSpl.panelValue);
            cf.save();
            if (GV.dsModel != null) {
                int i = 0;
                while (i < GV.dsModel.size()) {
                    DataSource ds = (DataSource)GV.dsModel.getElementAt(i);
                    if (ds != null && !ds.isClosed()) {
                        ds.close();
                    }
                    ++i;
                }
            }
        }
        catch (Throwable x) {
            GM.showException(GV.appFrame, x);
        }
        GV.allFrames.remove(this);
        if (this.terminalVM) {
            System.exit(0);
        } else {
            this.dispose();
        }
        return false;
    }

    protected boolean exitCustom() {
        return true;
    }

    @Override
    public void quit() {
        if (this.closeAll(true)) {
            this.exit();
        }
    }

    @Override
    public synchronized JInternalFrame openSheetFile(String filePath) throws Exception {
        JInternalFrame o = this.getSheet(filePath);
        if (o != null) {
            if (!this.showSheet(o)) {
                return null;
            }
            GV.toolWin.refresh();
            return null;
        }
        if (GV.appSheet != null && !GV.appSheet.submitEditor()) {
            return null;
        }
        PgmCellSet cs = null;
        if (!StringUtils.isValidString(filePath)) {
            String pre = filePath == null ? "p" : "s";
            filePath = GMSpl.getNewName(pre);
        } else {
            cs = this.readCellSet(filePath = filePath.trim());
            if (cs == null) {
                return null;
            }
        }
        JInternalFrame sheet = this.openSheet(filePath, cs);
        return sheet;
    }

    public synchronized JInternalFrame openSheet(String filePath, Object cellSet) {
        return this.openSheet(filePath, cellSet, cellSet != null);
    }

    protected SheetSpl newSheetSpl(String filePath, PgmCellSet cs) throws Exception {
        return this.newSheetSpl(filePath, cs, null);
    }

    protected SheetSpl newSheetSpl(String filePath, PgmCellSet cs, StepInfo stepInfo) throws Exception {
        return new SheetSpl(filePath, cs, stepInfo);
    }

    public synchronized JInternalFrame openSheet(String filePath, Object cellSet, boolean refreshRecentFile) {
        return this.openSheet(filePath, cellSet, refreshRecentFile, null);
    }

    public synchronized JInternalFrame openSheet(String filePath, Object cellSet, boolean refreshRecentFile, StepInfo stepInfo) {
        try {
            SheetSpl sheet = this.newSheetSpl(filePath, (PgmCellSet)cellSet, stepInfo);
            Dimension d = this.desk.getSize();
            boolean loadSheet = GM.loadWindowSize(sheet);
            if (!loadSheet) {
                sheet.setBounds(0, 0, d.width, d.height);
            }
            boolean setMax = false;
            if (GV.appSheet != null && GV.appSheet.isMaximum() && !GV.appSheet.isIcon()) {
                GV.appSheet.resumeSheet();
                if (loadSheet) {
                    sheet.setForceMax();
                }
                setMax = true;
            }
            sheet.setVisible(true);
            this.desk.add(sheet);
            if (setMax || !GM.loadWindowSize(sheet)) {
                sheet.setMaximum(true);
            }
            sheet.setSelected(true);
            if (refreshRecentFile) {
                GV.appMenu.refreshRecentFile(sheet.getTitle());
            }
            if (!GV.toolWin.isVisible() && ConfigOptions.bViewWinList.booleanValue()) {
                GV.toolWin.setVisible(true);
            }
            GV.toolWin.refresh();
            sheet.resetSheetStyle();
            return sheet;
        }
        catch (Throwable ex) {
            GM.showException(GV.appFrame, ex);
            return null;
        }
    }

    public PgmCellSet readCellSet(String filePath) throws Exception {
        filePath = filePath.trim();
        PgmCellSet cs = null;
        String path = filePath.toLowerCase();
        if (AppUtil.isSPLFile(path)) {
            try (BufferedInputStream bis = null;){
                FileObject fo = new FileObject(filePath, "s");
                bis = new BufferedInputStream(fo.getInputStream());
                cs = path.endsWith(".spl") ? GMSpl.readSPL(filePath) : this.readPgmCellSet(bis, filePath);
            }
        }
        return cs;
    }

    public PgmCellSet readPgmCellSet(InputStream is, String filePath) throws Exception {
        if (CellSetUtil.isEncrypted(filePath)) {
            throw new RQException(IdeSplMessage.get().getMessage("spl.errorsplfile", filePath));
        }
        PgmCellSet cellSet = CellSetUtil.readPgmCellSet(is);
        if (cellSet != null && filePath != null) {
            cellSet.setName(filePath);
        }
        return cellSet;
    }

    public void refreshOptions() {
        try {
            GV.appMenu.refreshRecentMainPath(ConfigOptions.sMainPath);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            GV.appMenu.refreshRecentConfigFile(ConfigOptions.sConfigFile);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fileTree.changeMainPath(ConfigOptions.sMainPath);
        if (ConfigOptions.bIdeConsole.booleanValue()) {
            IDEBase.holdConsole();
            this.tabParam.consoleVisible(true);
        } else if (this.splitGridValue.getLeftComponent() != null) {
            this.lastLeftLocation = this.splitGridValue.getDividerLocation();
            this.tabParam.consoleVisible(false);
        }
        if (GV.appSheet != null) {
            GM.setCurrentPath(GV.appSheet.getSheetTitle());
        }
        GM.fontMap.clear();
        this.autoSaveOption();
    }

    @Override
    protected void refreshToolBarWindow(JInternalFrame sheet) {
        GV.toolWin.refreshSheet(sheet);
    }

    public void switchWinList() {
        ConfigOptions.bViewWinList = new Boolean(ConfigOptions.bViewWinList == false);
        try {
            ConfigOptions.save();
        }
        catch (Throwable e) {
            GM.outputMessage(e);
        }
        GV.toolWin.setVisible(ConfigOptions.bViewWinList);
        if (GV.toolWin.isVisible()) {
            GV.toolWin.refresh();
        }
    }

    public void viewTabConsole() {
        this.tabParam.consoleVisible(true);
    }

    public void viewLeft() {
        int pos = this.splitMain.getDividerLocation();
        int width = this.splitMain.getWidth();
        if (pos <= 0 || 1 < pos && pos <= SPLIT_GAP) {
            this.lastLeftLocation = this.lastLeftLocation == 0 ? Math.round((float)width * 0.4f) : this.lastLeftLocation;
            this.splitMain.setDividerLocation(this.lastLeftLocation);
        } else {
            this.lastLeftLocation = pos;
            this.splitMain.setDividerLocation(0);
        }
    }

    public void viewRight() {
        int pos = this.splitGridValue.getDividerLocation();
        int width = this.splitGridValue.getWidth();
        if (width - pos <= SPLIT_GAP) {
            this.splitGridValue.setDividerLocation(this.lastRightLocation);
        } else {
            this.lastRightLocation = pos;
            this.splitGridValue.setDividerLocation(width);
        }
    }

    @Override
    public void resetRunStatus() {
    }

    public void startAutoRecent() {
        if (StringUtils.isValidString(GV.directOpenFile)) {
            try {
                this.openSheetFile(GV.directOpenFile);
            }
            catch (Throwable x) {
                GM.showException(GV.appFrame, x);
            }
        } else if (ConfigOptions.bAutoOpen.booleanValue() && ConfigOptions.sAutoOpenFileNames != null) {
            File backupDir = new File(GM.getAbsolutePath(ConfigOptions.sBackupDirectory));
            ArrayList<String> files = new ArrayList<String>();
            ArgumentTokenizer at = new ArgumentTokenizer(ConfigOptions.sAutoOpenFileNames);
            while (at.hasMoreTokens()) {
                String file = at.nextToken();
                if (file != null) {
                    file = Escape.removeEscAndQuote(file);
                    file = file.trim();
                }
                files.add(file);
            }
            int i = files.size() - 1;
            while (i >= 0) {
                block24: {
                    String filePath = (String)files.get(i);
                    try {
                        if (GM.isNewGrid(filePath, "p")) {
                            filePath = new File(backupDir, filePath).getAbsolutePath();
                            PgmCellSet cs = null;
                            try (BufferedInputStream bis = null;){
                                FileObject fo = new FileObject(filePath, "s");
                                bis = new BufferedInputStream(fo.getInputStream());
                                cs = this.readPgmCellSet(bis, filePath);
                            }
                            if (cs != null) {
                                SheetSpl ss = (SheetSpl)this.openSheet((String)files.get(i), cs, false);
                                String spl = CellSetUtil.toString(cs);
                                if (StringUtils.isValidString(spl)) {
                                    ss.setDataChanged(true);
                                }
                            }
                            break block24;
                        }
                        this.openSheetFile(filePath);
                    }
                    catch (Throwable x) {
                        Logger.error(x);
                    }
                }
                --i;
            }
        }
        try {
            if (ConfigOptions.bAutoConnect.booleanValue() && this.startDsNames != null) {
                int i = 0;
                while (i < this.startDsNames.length) {
                    final DataSource ds = GV.dsModel.getDataSource(this.startDsNames[i]);
                    if (ds != null) {
                        this.autoConnect = true;
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    ds.getDBSession();
                                }
                                catch (Throwable autox) {
                                    GM.outputMessage(autox);
                                }
                                IDEBase.this.startDBCount = new Integer(IDEBase.this.startDBCount + 1);
                                IDEBase.this.resetDBEnv();
                            }
                        }.start();
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.autoConnect) {
            this.calcInitSpl();
        }
        this.autoSaveOption();
    }

    private void calcInitSpl() {
        if (GV.config == null) {
            return;
        }
        String splPath = GV.config.getInitSpl();
        if (StringUtils.isValidString(splPath)) {
            try {
                Context ctx = GMSpl.prepareParentContext();
                ConfigUtil.calcInitSpl(splPath, ctx);
            }
            catch (Throwable t) {
                GM.showException(GV.appFrame, t, true, null, IdeCommonMessage.get().getMessage("dfx.calcinitdfx", splPath));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDBEnv() {
        Integer n = this.startDBCount;
        synchronized (n) {
            if (this.startDsNames != null && this.startDsNames.length == this.startDBCount) {
                GVSpl.tabParam.resetEnv();
                ConfigUtilIde.setTask();
                this.calcInitSpl();
            }
        }
    }

    public boolean saveAll() {
        JInternalFrame[] sheets = this.getAllInternalFrames();
        if (sheets == null) {
            return false;
        }
        int count = sheets.length;
        int i = 0;
        while (i < count) {
            if (!((IPrjxSheet)sheets[i]).save()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean autoSaveAll() {
        this.clearBackup();
        this.saveAutoOpenFileNames();
        JInternalFrame[] sheets = this.getAllInternalFrames();
        if (sheets == null) {
            return false;
        }
        int count = sheets.length;
        int i = 0;
        while (i < count) {
            SheetSpl sheet;
            if (sheets[i] instanceof SheetSpl && !(sheet = (SheetSpl)sheets[i]).autoSave()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void clearBackup() {
        File backupDir = new File(GM.getAbsolutePath(ConfigOptions.sBackupDirectory));
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        } else {
            try {
                File[] files = backupDir.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        GM.deleteFile(f);
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void swapRightTab() {
        if (this.splitGridValue.getDividerLocation() == this.splitGridValue.getMaximumDividerLocation()) {
            this.splitGridValue.setDividerLocation(this.splitGridValue.getLastDividerLocation());
        } else {
            this.splitGridValue.setDividerLocation(this.splitGridValue.getMaximumDividerLocation());
        }
    }

    @Override
    public void changeMenuAndToolBar(JMenuBar menu, JToolBar toolBar) {
        if (GV.appSheet == null) {
            return;
        }
        this.currentMenu = (AppMenu)menu;
        this.setJMenuBar(menu);
        this.barPanel.removeAll();
        this.barPanel.add((Component)toolBar, "North");
        this.barPanel.add((Component)GV.toolBarProperty, "Center");
        this.validate();
        this.repaint();
    }

    public void setToolBarExpand() {
        boolean isExt = this.isToolBarExpand();
        if (isExt) {
            this.splitToolMain.setDividerLocation(62);
        } else {
            int height = this.getHeight();
            int dl = Math.min(height - 100, 200);
            dl = Math.max(dl, 62);
            this.splitToolMain.setDividerLocation(dl);
        }
        GV.toolBarProperty.setExtendButtonIcon(isExt);
    }

    private boolean isToolBarExpand() {
        int dl = this.splitToolMain.getDividerLocation();
        return dl > 72;
    }

    public static String prepareEnv(String[] args) throws Throwable {
        String openSpl = "";
        String arg = "";
        String usage = "Usage: com.scudata.ide.spl.SPL\nwhere possible options include:\n-help                            Print out these messages\n-?                               Print out these messages\nwhere spl file option is to specify the default spl file to be openned\nExample:\njava com.scudata.ide.spl.SPL d:\\test.splx      Start IDE with default file d:\\test.splx\n";
        if (args.length == 1 && (arg = args[0].trim()).trim().indexOf(" ") > 0 && arg.charAt(1) != ':') {
            Section st = new Section(arg, ' ');
            args = st.toStringArray();
        }
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                arg = args[i].toLowerCase();
                if (!arg.equalsIgnoreCase("com.scudata.ide.spl.SPL")) {
                    if (!arg.startsWith("-")) {
                        if (!StringUtils.isValidString(openSpl)) {
                            openSpl = args[i];
                        }
                    } else if (arg.startsWith("-help") || arg.startsWith("-?")) {
                        Logger.debug(usage);
                        System.exit(0);
                    }
                }
                ++i;
            }
        }
        String sTmp = System.getProperty("java.version");
        String sPath = System.getProperty("java.home");
        MessageManager mm = IdeCommonMessage.get();
        if (sTmp.compareTo("1.4.1") < 0) {
            String t1 = mm.getMessage("prjx.jdkversion", "", sPath, sTmp);
            String t2 = mm.getMessage("public.prompt");
            GM.messageDialog(null, t1, t2, 0);
            System.exit(0);
        }
        return openSpl;
    }

    public static void mainInit() {
        IDEBase.resetInstallDirectories();
        GMSpl.setOptionLocale();
        GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        try {
            ConfigOptions.load2(false, false);
        }
        catch (Throwable e) {
            GM.outputMessage(e);
        }
        try {
            String configFile = GM.getAbsolutePath(ConfigOptions.sConfigFile);
            GV.config = ConfigUtilIde.loadConfig(configFile, true);
        }
        catch (Throwable e) {
            GM.outputMessage(e);
        }
        if (GV.config == null) {
            GV.config = new RaqsoftConfig();
        }
        try {
            ConfigOptions.load();
        }
        catch (Throwable e) {
            GM.outputMessage(e);
        }
        GMSpl.setOptionLocale();
    }

    public static void showSplash() {
        int port = IDEBase.getEsprocPort();
        if (TcpServer.checkExistInstance(port)) {
            return;
        }
        String splashFile = IDEBase.getSplashFile();
        splashWindow = new DialogSplash(splashFile);
        splashWindow.setVisible(true);
        splashWindow.revalidate();
        splashWindow.repaint();
    }

    public static String getSplashFile() {
        ConfigFile sysConfig = ConfigFile.getSystemConfigFile();
        String splashFile = null;
        if (sysConfig != null) {
            splashFile = sysConfig.getAttrValue("splashFile");
        }
        if (!StringUtils.isValidString(splashFile)) {
            return null;
        }
        splashFile = GM.getAbsolutePath(splashFile);
        return splashFile;
    }

    public static void loadExtLibs() {
        if (GV.config != null) {
            try {
                ConfigUtil.loadExtLibs(System.getProperty("start.home"), GV.config);
            }
            catch (Throwable t) {
                GM.outputMessage(t);
            }
        }
        try {
            ConfigFile sysConfig = ConfigFile.getSystemConfigFile();
            if (sysConfig != null) {
                ConfigOptions.fileColor = sysConfig.getAttrValue("fileColor");
                ConfigOptions.fileColorOpacity = sysConfig.getAttrValue("fileColorOpacity");
                ConfigOptions.headerColor = sysConfig.getAttrValue("headerColor");
                ConfigOptions.headerColorOpacity = sysConfig.getAttrValue("headerColorOpacity");
                ConfigOptions.cellColor = sysConfig.getAttrValue("cellColor");
                ConfigOptions.cellColorOpacity = sysConfig.getAttrValue("cellColorOpacity");
            }
        }
        catch (Throwable e) {
            GM.outputMessage(e);
        }
    }

    public static void initLNF() {
        try {
            int fontSize;
            if (IDEBase.isSubstanceUIEnabled()) {
                UIManager.setLookAndFeel(LookAndFeelManager.getLookAndFeelName());
                if (GM.isMacOS()) {
                    UIManager.put("ColorChooserUI", "javax.swing.plaf.basic.BasicColorChooserUI");
                }
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            if ((fontSize = GC.font.getSize()) > 14) {
                fontSize = 14;
            }
            if (fontSize < 11) {
                fontSize = 11;
            }
            Font font = new Font("Dialog", 0, fontSize);
            IDEBase.initGlobalFontSetting(font);
        }
        catch (Throwable x) {
            GM.outputMessage(x);
        }
    }

    public static int getEsprocPort() {
        return IDEBase.getPort(ESPROC_PORT_KEY);
    }

    public static int getPort(String portKey) {
        int iport = -1;
        if (!StringUtils.isValidString(portKey)) {
            return iport;
        }
        String port = GMSpl.getConfigValue(portKey);
        if (StringUtils.isValidString(port)) {
            try {
                iport = Integer.parseInt(port);
            }
            catch (Exception e1) {
                Logger.debug("Invalid esproc_port: " + port);
            }
        }
        return iport;
    }

    public static void startTcpServer(IDEBase frame) {
        int port = IDEBase.getEsprocPort();
        if (port > -1) {
            new TcpServer(port, frame, GV.directOpenFile).start();
        }
    }

    public static void showFrame(IDEBase frame) {
        IDEBase.startTcpServer(frame);
        frame.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        frame.setExtendedState(6);
        frame.setVisible(true);
        if (splashWindow != null) {
            splashWindow.closeWindow();
        }
        frame.startAutoRecent();
    }

    public PanelConsole getPanelConsole() {
        return this.tabParam.getPanelConsole();
    }

    protected void windowActivated(WindowEvent e) {
        Object clip;
        GV.appFrame = this;
        GV.appMenu = this.currentMenu;
        GV.appMenu.resetLiveMenu();
        GV.appMenu.resetPrivilegeMenu();
        if (GV.cellSelection != null && (clip = GV.cellSelection.systemClip) != null && !clip.equals(GM.clipBoard(false))) {
            GV.cellSelection = null;
        }
        GM.resetClipBoard();
        if (GV.appSheet != null) {
            GV.appSheet.refresh();
        }
    }

    void this_windowClosing(WindowEvent e) {
        if (!this.closeAll(true)) {
            this.setDefaultCloseOperation(0);
            return;
        }
        if (!this.exit()) {
            this.setDefaultCloseOperation(0);
            return;
        }
        this.setDefaultCloseOperation(2);
    }

    @Override
    public String getProductName() {
        return IdeSplMessage.get().getMessage("spl.productname");
    }

    private void autoSaveOption() {
        if (ConfigOptions.bAutoSave.booleanValue()) {
            if (this.autoSaveThread == null || this.autoSaveThread.isStopped()) {
                this.autoSaveThread = new AutoSaveThread();
                this.autoSaveThread.start();
            }
            this.saveAutoOpenFileNames();
        } else {
            if (this.autoSaveThread != null) {
                this.autoSaveThread.stopThread();
            }
            this.clearBackup();
        }
    }

    private void saveAutoOpenFileNames() {
        JInternalFrame[] frames = this.desk.getAllFrames();
        StringBuffer buf = new StringBuffer();
        if (frames != null) {
            int i = 0;
            while (i < frames.length) {
                IPrjxSheet sheet = (IPrjxSheet)frames[i];
                if (sheet instanceof SheetSpl) {
                    SheetSpl ss = (SheetSpl)sheet;
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append(Escape.addEscAndQuote(ss.getFileName()));
                }
                ++i;
            }
        }
        ConfigOptions.sAutoOpenFileNames = buf.toString();
        try {
            ConfigOptions.save(false, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void mixpanel() {
        GM.mixpanel();
    }

    private static boolean isSubstanceUIEnabled() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.compareTo("1.9") > 0) {
            return false;
        }
        return !IDEBase.isSUSEOS();
    }

    private static boolean isSUSEOS() {
        block8: {
            String osName;
            block7: {
                block6: {
                    osName = System.getProperty("os.name");
                    if (osName != null) break block6;
                    return false;
                }
                osName = osName.toLowerCase();
                if (osName.indexOf("suse") <= -1) break block7;
                return true;
            }
            if ("linux".equalsIgnoreCase(osName)) break block8;
            return false;
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("cat /etc/os-release");
            RuntimeReceiver g1 = new RuntimeReceiver(process.getErrorStream());
            RuntimeReceiver g2 = new RuntimeReceiver(process.getInputStream());
            g1.start();
            g2.start();
            int n = process.waitFor();
            g1.join();
            g2.join();
            if (g1.isSuse || g2.isSuse) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void checkExpirationSystem() throws Exception {
        if (SplEditorSE.isFree()) {
            return;
        }
        long expTime = SplEditorSE.getExpiration();
        if (expTime > 0L && !SplEditorSE.isSale()) {
            if (systemTime == null) {
                try {
                    systemTime = ServiceUtil.getSystemTime();
                }
                catch (Exception e) {
                    return;
                }
            }
            if (systemTime != null && systemTime > expTime) {
                throw new Exception(IdeCommonMessage.get().getMessage("sn.exp"));
            }
        }
    }

    class AutoSaveThread
    extends Thread {
        private volatile boolean isStopped = false;

        @Override
        public void run() {
            while (!this.isStopped) {
                try {
                    AutoSaveThread.sleep(ConfigOptions.iAutoSaveMinutes * 60 * 1000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.isStopped) break;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IDEBase.this.autoSaveAll();
                    }
                });
            }
        }

        public void stopThread() {
            this.isStopped = true;
        }

        public boolean isStopped() {
            return this.isStopped;
        }
    }

    static class RuntimeReceiver
    extends Thread {
        InputStream in;
        boolean isSuse = false;

        public RuntimeReceiver(InputStream in) {
            this.in = in;
        }

        @Override
        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.in);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    if (line.toLowerCase().indexOf("suse") <= -1) continue;
                    this.isSuse = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

