/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.spl.GMSplSE;
import com.scudata.ide.spl.GVSplSE;
import com.scudata.ide.spl.MenuSpl;
import com.scudata.ide.spl.control.SplEditorSE;
import java.awt.Component;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class MenuSplSE
extends MenuSpl {
    private static final long serialVersionUID = 1L;
    protected JMenuItem pswMenuItem;

    @Override
    protected void init() {
        this.add(this.getFileMenu());
        this.add(this.getEditMenu());
        this.add(this.getProgramMenu());
        this.add(this.getToolMenu());
        this.tmpLiveMenu = this.getWindowMenu();
        this.add(this.tmpLiveMenu);
        this.add(this.getHelpMenu());
        this.setEnable(this.getMenuItems(), false);
        this.resetLiveMenu();
    }

    @Override
    protected JMenu getEditMenu() {
        JMenu editMenu = super.getEditMenu();
        JMenuItem miCmd = this.newSplMenuItem((short)2325, "edit.funcassist", 'A', 8, false);
        editMenu.insert(miCmd, 14);
        this.pasteMenu.add(this.newSplMenuItem((short)2132, "edit.swapcell", 'X', 3));
        if (GMSplSE.isExcelXllEnabled() || GMSplSE.isOfficeAddinEnabled()) {
            this.copyMenu.insert(this.newSplMenuItem((short)2116, "edit.excelcopy", 'C', 8), 5);
            this.pasteMenu.add(this.newSplMenuItem((short)2129, "edit.excelpaste", 'V', 8));
        }
        return editMenu;
    }

    @Override
    protected JMenu getToolMenu() {
        JMenu toolMenu = super.getToolMenu();
        this.pswMenuItem = this.newCommonMenuItem((short)2141, "file.password", 'W', 64);
        if (!SplEditorSE.isEncrypt()) {
            this.pswMenuItem.setEnabled(false);
            this.pswMenuItem.setVisible(false);
        }
        toolMenu.insert(this.pswMenuItem, 2);
        JMenuItem miCmd = this.newSplMenuItem((short)2313, "tool.execcmd", 'C', 64, true);
        boolean isWin = GM.isWindowsOS();
        miCmd.setVisible(isWin);
        miCmd.setEnabled(isWin);
        toolMenu.insert(miCmd, 4);
        toolMenu.insert(this.newSplMenuItem((short)2321, "program.sqlgenerator", 'Q', 64, true), 5);
        JMenuItem miEnc = this.newSplMenuItem((short)2341, "tool.splxencrypt", 'T', 64, false);
        boolean isEncEnabled = SplEditorSE.isEncrypt() && !GVSplSE.isDesktop;
        miEnc.setVisible(isEncEnabled);
        miEnc.setEnabled(isEncEnabled);
        toolMenu.insert(miEnc, 6);
        if (GMSplSE.isExcelXllEnabled()) {
            toolMenu.insert(this.newSplMenuItem((short)2311, "tool.excelplugin", 'X', 64), 7);
        }
        if (GMSplSE.isOfficeAddinEnabled()) {
            toolMenu.insert(this.newSplMenuItem((short)2331, "tool.excelserver", 'E', 64), 7);
        }
        return toolMenu;
    }

    @Override
    public JMenu getHelpMenu() {
        if (helpMenu != null) {
            return helpMenu;
        }
        JMenu menu = this.getCommonMenuItem("help", 'H', true);
        List<Object> configMenus = this.buildMenuFromConfig();
        int i = 0;
        while (i < configMenus.size()) {
            Object o = configMenus.get(i);
            if (o instanceof JMenu) {
                menu.add((Component)((JMenu)o), i);
                ((JMenu)o).setIcon(GM.getMenuImageIcon("blank"));
            } else if (o instanceof JMenuItem) {
                menu.add((Component)((JMenuItem)o), i);
                ((JMenuItem)o).setIcon(GM.getMenuImageIcon("blank"));
            } else if (o instanceof JSeparator) {
                menu.add((Component)((JSeparator)o), i);
            }
            ++i;
        }
        menu.add(this.newCommonMenuItem((short)305, "help.about", 'A', 64, true));
        JMenuItem miSN = this.newCommonMenuItem((short)2451, "help.serialnumber", 'S', 64, false);
        menu.add(miSN);
        menu.add(this.newCommonMenuItem((short)310, "help.memorytidy", 'M', 64));
        helpMenu = menu;
        return helpMenu;
    }

    @Override
    public void executeCmd(short cmdId) {
        try {
            if (!GMSplSE.executeCmd(cmdId)) {
                super.executeCmd(cmdId);
            }
        }
        catch (Exception e) {
            GM.showException(GV.appFrame, e);
        }
    }

    @Override
    public short[] getMenuItems() {
        short[] menus = super.getMenuItems();
        return this.addCMenus(menus);
    }

    @Override
    public short[] getAllMenuItems() {
        short[] menus = super.getAllMenuItems();
        return this.addCMenus(menus);
    }

    public void resetPasswordMenu(boolean isFull) {
        String str = isFull ? "file.password" : "file.password1";
        this.pswMenuItem.setText(IdeCommonMessage.get().getMessage("menu." + str));
    }

    private short[] addCMenus(short[] menus) {
        short[] cmenus = new short[menus.length + 8];
        System.arraycopy(menus, 0, cmenus, 0, menus.length);
        cmenus[menus.length] = 2116;
        cmenus[menus.length + 1] = 2129;
        cmenus[menus.length + 2] = 2313;
        cmenus[menus.length + 3] = 2321;
        cmenus[menus.length + 4] = 2141;
        cmenus[menus.length + 5] = 2325;
        cmenus[menus.length + 6] = 2331;
        cmenus[menus.length + 7] = 2132;
        return cmenus;
    }
}

