/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.CellSet;
import com.scudata.cellset.datamodel.Command;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.ByteMap;
import com.scudata.common.CellLocation;
import com.scudata.common.Escape;
import com.scudata.common.IByteMap;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.common.UUID;
import com.scudata.dm.Context;
import com.scudata.dm.DfxManager;
import com.scudata.dm.Env;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.Node;
import com.scudata.expression.fn.Call;
import com.scudata.expression.fn.Eval;
import com.scudata.expression.fn.Func;
import com.scudata.expression.fn.PCSFunction;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IAtomicCmd;
import com.scudata.ide.common.IPrjxSheet;
import com.scudata.ide.common.control.CellRect;
import com.scudata.ide.common.control.IEditorListener;
import com.scudata.ide.common.control.PanelConsole;
import com.scudata.ide.common.dialog.DialogArgument;
import com.scudata.ide.common.dialog.DialogCellSetProperties;
import com.scudata.ide.common.dialog.DialogEditConst;
import com.scudata.ide.common.dialog.DialogInputArgument;
import com.scudata.ide.common.dialog.DialogRowHeight;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.spl.AtomicCell;
import com.scudata.ide.spl.AtomicSpl;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.IDEBase;
import com.scudata.ide.spl.MenuSpl;
import com.scudata.ide.spl.PopupSpl;
import com.scudata.ide.spl.StepInfo;
import com.scudata.ide.spl.ToolBarProperty;
import com.scudata.ide.spl.ToolBarSpl;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.EditControl;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplEditor;
import com.scudata.ide.spl.dialog.DialogFTP;
import com.scudata.ide.spl.dialog.DialogOptionPaste;
import com.scudata.ide.spl.dialog.DialogSearch;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CellSetUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class SheetSpl
extends IPrjxSheet
implements IEditorListener {
    private static final long serialVersionUID = 1L;
    public SplControl splControl = null;
    public SplEditor splEditor = null;
    protected PopupSpl popupSpl = null;
    protected String filePath = null;
    protected Context splCtx = new Context();
    private Map<String, Long[]> debugTimeMap = new HashMap<String, Long[]>();
    protected transient CellLocation exeLocation = null;
    public volatile byte selectState = 0;
    public StepInfo stepInfo = null;
    public boolean isStepStop = false;
    public boolean stepStopOther = false;
    protected Call stepCall = null;
    private ThreadGroup tg = null;
    private volatile int threadCount = 0;
    protected transient DebugThread debugThread = null;
    private JobSpace jobSpace;
    private boolean isInitSelect = true;
    private CalcCellThread calcCellThread = null;
    private boolean preventStoreBreak = false;
    protected volatile boolean isEnvPrepared = false;
    private volatile boolean subSheetOpened = false;
    public List<SheetSpl> sheets = null;
    protected Object runStateLock = new Object();
    private Object threadLock = new Object();
    private CellLocation lastLocation = null;
    public boolean scrollActiveCellToVisible = true;
    private static final String ERROR_NOT_SAVE = IdeSplMessage.get().getMessage("sheetdfx.savefilebefore");
    private volatile boolean isAdjustPaste = false;

    public SheetSpl(String filePath, PgmCellSet cs, StepInfo stepInfo) throws Exception {
        super(filePath);
        this.stepInfo = stepInfo;
        if (stepInfo != null) {
            this.sheets = stepInfo.sheets;
            this.sheets.add(this);
        }
        if (stepInfo != null && cs != null) {
            this.splCtx = cs.getContext();
        }
        try {
            ImageIcon image = GM.getLogoImage(true);
            int size = 20;
            image.setImage(image.getImage().getScaledInstance(20, 20, 1));
            this.setFrameIcon(image);
        }
        catch (Throwable image) {
            // empty catch block
        }
        this.filePath = filePath;
        this.splEditor = this.newSplEditor();
        this.splControl = this.splEditor.getComponent();
        this.splControl.setSplScrollBarListener();
        this.splEditor.addSplListener(this);
        if (stepInfo != null) {
            INormalCell currentCell = cs.getCurrent();
            if (currentCell == null) {
                this.setExeLocation(stepInfo.exeLocation);
            } else {
                this.setExeLocation(new CellLocation(currentCell.getRow(), currentCell.getCol()));
            }
            this.splControl.contentView.setEditable(false);
        }
        this.loadBreakPoints();
        if (cs != null) {
            this.splEditor.setCellSet(cs);
        }
        this.setTitle(this.filePath);
        this.newPopupSpl();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.splEditor.getComponent(), "Center");
        this.addInternalFrameListener(new Listener(this));
        this.setDefaultCloseOperation(0);
        if (!this.isSubSheet()) {
            this.resetCellSet();
        }
        new DropTarget(this.splControl.contentView, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(2);
                dtde.dropComplete(true);
            }
        });
    }

    protected void newPopupSpl() {
        this.popupSpl = new PopupSpl();
    }

    protected SplEditor newSplEditor() {
        return new SplEditor(this);
    }

    public Context getSplContext() {
        return this.splCtx;
    }

    public void selectFirstCell() {
        if (this.stepInfo != null) {
            return;
        }
        if (this.isInitSelect) {
            this.isInitSelect = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SheetSpl.this.splEditor.selectFirstCell();
                    SheetSpl.this.selectState = 1;
                    SheetSpl.this.refresh();
                }
            });
        }
    }

    public boolean autoSave() {
        if (this.isNewGrid()) {
            File backupDir = new File(GM.getAbsolutePath(ConfigOptions.sBackupDirectory));
            if (!backupDir.exists()) {
                backupDir.mkdirs();
            }
            File f = new File(backupDir, this.filePath);
            try {
                CellSetUtil.writePgmCellSet(f.getAbsolutePath(), this.splControl.cellSet);
            }
            catch (Exception e) {
                GM.showException(GV.appFrame, e);
                return false;
            }
            return true;
        }
        return this.save();
    }

    @Override
    public boolean save() {
        if (this.isNewGrid()) {
            boolean hasSaveAs = this.saveAs();
            if (hasSaveAs) {
                this.storeBreakPoints();
                if (this.stepInfo != null && this.isStepStop) {
                    this.stepInfo = null;
                    this.isStepStop = false;
                    this.stepStopOther = false;
                    if (this.sheets != null) {
                        this.sheets.remove(this);
                    }
                    this.sheets = null;
                    this.resetRunState();
                }
            }
            return hasSaveAs;
        }
        if (this.splControl == null || this.splControl.cellSet == null) {
            return false;
        }
        if (this.splControl.cellSet.isExecuteOnly()) {
            return false;
        }
        File f = new File(this.filePath);
        if (f.exists() && !f.canWrite()) {
            GM.messageDialog(GV.appFrame, IdeCommonMessage.get().getMessage("public.readonly", this.filePath));
            return false;
        }
        try {
            if (ConfigOptions.bAutoBackup.booleanValue()) {
                String saveFile = String.valueOf(this.filePath) + ".bak";
                File fb = new File(saveFile);
                fb.delete();
                f.renameTo(fb);
            }
            GVSpl.panelValue.setCellSet(this.splControl.cellSet);
            if (this.filePath.toLowerCase().endsWith(".spl")) {
                AppUtil.writeSPLFile(this.filePath, this.splControl.cellSet);
            } else {
                CellSetUtil.writePgmCellSet(this.filePath, this.splControl.cellSet);
            }
            if (this.splControl.cellSet != null) {
                this.splControl.cellSet.setName(this.filePath);
            }
            DfxManager.getInstance().clear();
            GV.appMenu.refreshRecentFile(this.filePath);
        }
        catch (Throwable e) {
            GM.showException(GV.appFrame, e);
            return false;
        }
        GM.setCurrentPath(this.filePath);
        this.splEditor.setDataChanged(false);
        this.splEditor.getSplListener().commandExcuted();
        return true;
    }

    @Override
    public boolean saveAs() {
        int index;
        boolean isSplFile = AppUtil.isSPLFile(this.filePath);
        boolean isNewFile = this.isNewGrid();
        String fileExt = "splx";
        if (isSplFile && (fileExt = this.filePath.substring((index = this.filePath.lastIndexOf(".")) + 1)).equalsIgnoreCase("dfx")) {
            fileExt = "splx";
        }
        String path = this.filePath;
        if (this.stepInfo != null && this.isStepStop && StringUtils.isValidString(this.stepInfo.filePath)) {
            path = this.stepInfo.filePath;
        }
        if (AppUtil.isSPLFile(path)) {
            int index2 = path.lastIndexOf(".");
            path = path.substring(0, index2);
        }
        GM.saveAsExt = fileExt;
        String fileExts = "splx,spl";
        File saveFile = GM.dialogSelectFile(GV.appFrame, fileExts, GV.lastDirectory, IdeCommonMessage.get().getMessage("public.saveas"), path);
        GM.saveAsExt = null;
        if (saveFile == null) {
            return false;
        }
        String sfile = saveFile.getAbsolutePath();
        GV.lastDirectory = saveFile.getParent();
        if (!AppUtil.isSPLFile(sfile)) {
            saveFile = new File(saveFile.getParent(), String.valueOf(saveFile.getName()) + "." + fileExt);
            sfile = saveFile.getAbsolutePath();
        }
        if (!GM.canSaveAsFile(sfile)) {
            return false;
        }
        if (!isNewFile) {
            this.storeBreakPoints(this.filePath, sfile);
        }
        this.changeFileName(sfile);
        return this.save();
    }

    private void saveFTP() {
        if (!this.save()) {
            return;
        }
        DialogFTP df = new DialogFTP();
        df.setFilePath(this.filePath);
        df.setVisible(true);
    }

    @Override
    public void changeFileName(String newName) {
        GV.appMenu.removeLiveMenu(this.filePath);
        GV.appMenu.addLiveMenu(newName);
        this.filePath = newName;
        this.setTitle(newName);
        GV.toolWin.changeFileName(this, newName);
        ((IDEBase)GV.appFrame).resetTitle();
    }

    @Override
    public void refresh() {
        this.refresh(false);
    }

    public void refreshParams() {
        this.refresh(false, true, true);
    }

    protected void refresh(boolean keyEvent) {
        this.refresh(keyEvent, true);
    }

    protected void refresh(boolean keyEvent, boolean isRefreshState) {
        this.refresh(keyEvent, isRefreshState, false);
    }

    protected void refresh(boolean keyEvent, boolean isRefreshState, boolean refreshParams) {
        if (this.splEditor == null) {
            return;
        }
        if (this.isClosed()) {
            return;
        }
        if (!(GV.appMenu instanceof MenuSpl)) {
            return;
        }
        if (this != GV.appSheet) {
            return;
        }
        try {
            MenuSpl md = (MenuSpl)GV.appMenu;
            md.setEnable(md.getMenuItems(), true);
            boolean isDataChanged = this.splEditor.isDataChanged();
            md.setMenuEnabled((short)50, isDataChanged);
            md.setMenuEnabled((short)55, true);
            md.setMenuEnabled((short)60, true);
            md.setMenuEnabled((short)1005, true);
            md.setMenuEnabled((short)1103, this.splEditor.canRedo());
            md.setMenuEnabled((short)1101, this.splEditor.canUndo());
            boolean canCopy = this.selectState != 0;
            md.setMenuEnabled((short)1111, canCopy);
            md.setMenuEnabled((short)1113, canCopy);
            md.setMenuEnabled((short)1115, canCopy);
            md.setMenuEnabled((short)1117, canCopy);
            md.setMenuEnabled((short)1121, canCopy);
            md.setMenuEnabled((short)1175, this.selectState != 0);
            md.setMenuEnabled((short)1176, this.selectState != 0);
            md.setMenuEnabled((short)1177, this.selectState != 0);
            md.setMenuEnabled((short)1178, this.selectState != 0);
            boolean canPaste = GMSpl.canPaste() && this.selectState != 0;
            md.setMenuEnabled((short)1123, canPaste);
            md.setMenuEnabled((short)1125, canPaste);
            md.setMenuEnabled((short)1127, canPaste);
            md.setMenuEnabled((short)1145, this.selectState != 0);
            md.setMenuEnabled((short)1141, this.selectState != 0);
            md.setMenuEnabled((short)1143, this.selectState != 0);
            md.setMenuEnabled((short)1151, this.selectState != 0);
            md.setMenuEnabled((short)1153, this.selectState != 0);
            md.setMenuEnabled((short)1160, this.selectState != 0);
            md.setMenuEnabled((short)1162, this.selectState != 0);
            md.setMenuEnabled((short)1251, this.selectState != 0);
            md.setMenuEnabled((short)1164, this.selectState != 0);
            md.setMenuEnabled((short)1165, this.selectState != 0);
            md.setMenuEnabled((short)1167, this.selectState != 0);
            md.setMenuEnabled((short)1169, this.selectState != 0);
            md.setMenuRowColEnabled(this.selectState == 3 || this.selectState == 4);
            md.setMenuVisible((short)1182, this.selectState == 3);
            md.setMenuVisible((short)1183, this.selectState == 3);
            md.setMenuVisible((short)1184, this.selectState == 3);
            md.setMenuVisible((short)1185, this.selectState == 3);
            md.setMenuVisible((short)1186, this.selectState == 4);
            md.setMenuVisible((short)1187, this.selectState == 4);
            md.setMenuVisible((short)1188, this.selectState == 4);
            md.setMenuVisible((short)1189, this.selectState == 4);
            md.setMenuEnabled((short)1171, this.selectState != 0);
            md.setMenuEnabled((short)1180, this.selectState != 0);
            md.setMenuEnabled((short)401, this.selectState != 0);
            md.setMenuEnabled((short)1195, this.selectState != 0);
            md.setMenuEnabled((short)1197, this.selectState != 0);
            md.setMenuEnabled((short)1191, this.selectState != 0);
            md.setMenuEnabled((short)1265, this.selectState != 0);
            md.setMenuEnabled((short)1267, this.selectState != 0);
            md.setMenuEnabled((short)1271, GVSpl.panelValue.tableValue.canDrawChart());
            md.setMenuVisible((short)1191, true);
            md.setMenuVisible((short)1271, true);
            GVSpl.appTool.setBarEnabled(true);
            GVSpl.appTool.setButtonEnabled((short)50, isDataChanged);
            GVSpl.appTool.setButtonEnabled((short)1160, this.selectState != 0);
            GVSpl.appTool.setButtonEnabled((short)1251, this.selectState != 0 && !this.isStepStop);
            GVSpl.appTool.setButtonEnabled((short)1101, this.splEditor.canUndo());
            GVSpl.appTool.setButtonEnabled((short)1103, this.splEditor.canRedo());
            if (this.splEditor != null && this.selectState != 0) {
                String cellId;
                NormalCell nc = this.splEditor.getDisplayCell();
                boolean lockOtherCell = false;
                if (nc != null) {
                    IByteMap values = this.splEditor.getProperty();
                    GV.toolBarProperty.refresh(this.selectState, values);
                    String oldId = GVSpl.panelValue.tableValue.getCellId();
                    if (nc.getCellId().equals(oldId)) {
                        this.setValue(nc, false, !refreshParams);
                    } else {
                        lockOtherCell = true;
                        this.setValue(nc, true, !refreshParams);
                    }
                    String cellId2 = nc.getCellId();
                    GVSpl.panelValue.tableValue.setCellId(cellId2);
                    GVSpl.panelValue.setDebugTime(cellId2, this.getCellDebugTime(cellId2));
                    Object[] cellInterval = this.getCellInterval();
                    if (cellInterval == null || cellInterval.length != 3) {
                        GVSpl.panelValue.setInterval(null, null, null);
                    } else {
                        GVSpl.panelValue.setInterval((String)cellInterval[0], (String)cellInterval[1], (Long)cellInterval[2]);
                    }
                }
                if (lockOtherCell && GVSpl.panelValue.tableValue.isLocked() && StringUtils.isValidString(cellId = GVSpl.panelValue.tableValue.getCellId())) {
                    try {
                        INormalCell lockCell = this.splControl.cellSet.getCell(cellId);
                        boolean isValChanged = this.isValueChanged(cellId);
                        if (isValChanged) {
                            this.setValue(lockCell, false, isRefreshState);
                        }
                    }
                    catch (Exception lockCell) {
                        // empty catch block
                    }
                }
            }
            GV.toolBarProperty.setEnabled(this.selectState != 0);
            if (refreshParams) {
                Object[] allParams = this.getAllParams();
                ParamList ctxParams = null;
                HashMap spaceParams = null;
                ParamList envParams = null;
                if (allParams != null) {
                    ctxParams = (ParamList)allParams[0];
                    spaceParams = (HashMap)allParams[1];
                    envParams = (ParamList)allParams[2];
                }
                GVSpl.tabParam.resetParamList(ctxParams, spaceParams, envParams);
            }
            if (GVSpl.panelValue.tableValue.isLocked1()) {
                GVSpl.panelValue.tableValue.setLocked1(false);
            }
            md.setMenuEnabled((short)253, (boolean)ConfigOptions.bIdeConsole);
            if (this.stepInfo != null && !this.isStepStopCall()) {
                md.setMenuEnabled(md.getAllMenuItems(), false);
                GVSpl.appTool.setButtonEnabled((short)1160, false);
                GVSpl.appTool.setButtonEnabled((short)1251, false);
                GV.toolBarProperty.setEnabled(false);
            }
            this.resetRunState(isRefreshState, false);
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private boolean isStepStopCall() {
        if (this.stepInfo == null) {
            return false;
        }
        return this.isStepStop && this.stepInfo.isCall();
    }

    @Override
    public String getSheetTitle() {
        return this.getFileName();
    }

    @Override
    public void setSheetTitle(String filePath) {
        this.filePath = filePath;
        this.setTitle(filePath);
        this.repaint();
    }

    @Override
    public String getFileName() {
        return this.filePath;
    }

    public void calcActiveCell() {
        this.calcActiveCell(true);
    }

    public void calcActiveCell(boolean lock) {
        PanelConsole pc;
        this.splControl.getContentPanel().submitEditor();
        this.splControl.getContentPanel().requestFocus();
        CellLocation cl = this.splControl.getActiveCell();
        if (cl == null) {
            return;
        }
        if (GVSpl.appFrame instanceof IDEBase && (pc = ((IDEBase)GVSpl.appFrame).getPanelConsole()) != null) {
            pc.autoClean();
        }
        if (!this.isEnvPrepared) {
            this.prepareStart();
        }
        this.calcCellThread = new CalcCellThread(cl);
        this.calcCellThread.start();
        if (lock) {
            GVSpl.panelValue.tableValue.setLocked(true);
        }
    }

    public Object calcExp(String expStr) {
        Object val = Eval.calc(expStr, new Sequence(), this.splControl.cellSet, this.splControl.cellSet.getContext());
        return val;
    }

    public List<NormalCell> moveRect(CellRect fromRect, CellRect toRect) {
        return null;
    }

    protected void runCell(int row, int col) {
        this.splControl.cellSet.runCell(row, col);
    }

    protected Sequence getSegmentValue(int row, int col, int from, int num) {
        INormalCell nc = this.splControl.cellSet.getCell(row, col);
        if (nc == null) {
            return null;
        }
        Object val = nc.getValue();
        if (val != null && val instanceof Sequence) {
            Sequence seq = (Sequence)val;
            return seq.get(from, from + num - 1);
        }
        return null;
    }

    protected void expChanged(int row, int col, String exp) {
    }

    protected void expChanged(Map<String, String> expMap) {
    }

    public void dialogSearch(boolean replace) {
        if (GVSpl.searchDialog == null) {
            GVSpl.searchDialog = new DialogSearch();
        }
        GVSpl.searchDialog.setConfig(replace);
        GVSpl.searchDialog.setVisible(true);
    }

    private String getBreakPointNodeName(String nodeName) {
        if (nodeName == null) {
            return "";
        }
        nodeName = nodeName.replaceAll("[^0-9a-zA-Z-._]", "_");
        return "_" + nodeName;
    }

    protected void loadBreakPoints() {
        ConfigFile cf = null;
        try {
            cf = ConfigFile.getConfigFile();
            String oldNode = cf.getConfigNode();
            cf.setConfigNode(ConfigFile.NODE_BREAKPOINTS);
            String breaks = cf.getAttrValue(this.getBreakPointNodeName(this.filePath));
            if (StringUtils.isValidString(breaks)) {
                StringTokenizer token = new StringTokenizer(breaks, ";");
                ArrayList<CellLocation> breakPoints = new ArrayList<CellLocation>();
                while (token.hasMoreElements()) {
                    String cellName = token.nextToken();
                    CellLocation cp = new CellLocation(cellName);
                    breakPoints.add(cp);
                }
                this.splEditor.getComponent().setBreakPoints(breakPoints);
                cf.setConfigNode(oldNode);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void storeBreakPoints() {
        this.storeBreakPoints(null, this.filePath);
    }

    private void storeBreakPoints(String oldName, String filePath) {
        if (this.preventStoreBreak) {
            return;
        }
        if (filePath.endsWith("*")) {
            return;
        }
        if (this.isNewGrid()) {
            return;
        }
        ConfigFile cf = null;
        String oldNode = null;
        try {
            try {
                cf = ConfigFile.getConfigFile();
                oldNode = cf.getConfigNode();
                cf.setConfigNode(ConfigFile.NODE_BREAKPOINTS);
                ArrayList<CellLocation> breaks = this.splEditor.getComponent().getBreakPoints();
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < breaks.size()) {
                    CellLocation cp = breaks.get(i);
                    if (i > 0) {
                        sb.append(";");
                    }
                    sb.append(cp.toString());
                    ++i;
                }
                if (oldName != null) {
                    cf.setAttrValue(this.getBreakPointNodeName(oldName), "");
                }
                cf.setAttrValue(this.getBreakPointNodeName(filePath), sb.toString());
                cf.save();
            }
            catch (Throwable throwable) {
                if (cf != null) {
                    cf.setConfigNode(oldNode);
                }
            }
        }
        finally {
            if (cf != null) {
                cf.setConfigNode(oldNode);
            }
        }
    }

    public void reset() {
        if (this.debugThread != null) {
            this.terminate();
        }
        this.closeRunThread();
        this.debugTimeMap.clear();
        if (!this.isSubSheet()) {
            this.setExeLocation(null);
            this.resetCellSet();
            this.closeSpace();
        }
        GVSpl.tabParam.resetParamList(null, this.listSpaceParams(), this.getEnvParamList());
        GVSpl.panelSplWatch.watch(null);
    }

    public void resetGlobal() {
        JInternalFrame[] sheets = ((IDEBase)GV.appFrame).getAllSheets();
        if (sheets != null) {
            JInternalFrame[] jInternalFrameArray = sheets;
            int n = sheets.length;
            int n2 = 0;
            while (n2 < n) {
                JInternalFrame sheet = jInternalFrameArray[n2];
                ((SheetSpl)sheet).reset();
                ++n2;
            }
        }
        this.resetGlobalEnv();
        GVSpl.tabParam.resetParamList(null, null, null);
        GVSpl.panelSplWatch.watch(null);
    }

    protected void resetGlobalEnv() {
        GM.doResetGlobalEnv();
    }

    public String getSpaceId() {
        if (this.jobSpace == null) {
            return null;
        }
        return this.jobSpace.getID();
    }

    public void run() {
        if (!this.prepareStart()) {
            return;
        }
        if (this.stepInfo == null && this.jobSpace == null) {
            return;
        }
        if (!this.beforeRun()) {
            return;
        }
        this.createDebugThread(false);
        this.debugThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDebugThread(boolean isDebugMode) {
        ++this.threadCount;
        Object object = this.threadLock;
        synchronized (object) {
            this.debugThread = isDebugMode ? new DebugThread(this.tg, "t" + this.threadCount) : new RunThread(this.tg, "t" + this.threadCount);
        }
    }

    protected void setContextParams(ParamList pl) {
    }

    private boolean isSubSheet() {
        return this.stepInfo != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(byte debugType) {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.debugThread == null) {
                if (!this.prepareStart()) {
                    return;
                }
                if (!this.isSubSheet() && this.jobSpace == null) {
                    return;
                }
                if (!this.beforeRun()) {
                    return;
                }
                this.createDebugThread(true);
                this.debugThread.setDebugType(debugType);
                this.debugThread.start();
            } else {
                this.preventRun();
                this.debugThread.continueRun(debugType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pause() {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.debugThread != null) {
                if (this.debugThread.getRunState() == 3) {
                    this.debugThread.continueRun();
                } else {
                    this.debugThread.pause();
                }
            }
        }
    }

    protected boolean prepareStart() {
        block4: {
            try {
                this.isEnvPrepared = true;
                this.preventRun();
                this.reset();
                if (this.isSubSheet() || this.prepareArg()) break block4;
                return false;
            }
            catch (Throwable e) {
                GM.showException(GV.appFrame, e);
                this.resetRunState();
                return false;
            }
        }
        if (this.stepInfo == null) {
            String uuid = UUID.randomUUID().toString();
            this.jobSpace = JobSpaceManager.getSpace(uuid);
            this.splCtx.setJobSpace(this.jobSpace);
        }
        this.tg = new ThreadGroup(this.filePath);
        this.threadCount = 0;
        return true;
    }

    protected boolean beforeRun() {
        PanelConsole pc;
        this.splControl.contentView.submitEditor();
        this.splControl.contentView.initEditor((byte)2);
        GVSpl.panelValue.tableValue.setValue(null);
        if (GVSpl.appFrame instanceof IDEBase && (pc = ((IDEBase)GVSpl.appFrame).getPanelConsole()) != null) {
            pc.autoClean();
        }
        return ConfigOptions.bAutoSave == false || this.autoSave();
    }

    protected boolean isValueChanged(String cellId) {
        INormalCell lockCell = this.splControl.cellSet.getCell(cellId);
        if (lockCell == null) {
            return false;
        }
        Object oldVal = GVSpl.panelValue.tableValue.getOriginalValue();
        Object newVal = null;
        try {
            newVal = lockCell.getValue();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
        boolean isValChanged = false;
        isValChanged = oldVal == null ? newVal != null : !oldVal.equals(newVal);
        return isValChanged;
    }

    protected void setValue(INormalCell nc, boolean caseLock, boolean isRefresh) {
        if (nc == null) {
            return;
        }
        Object value = nc.getValue();
        if (caseLock) {
            GVSpl.panelValue.tableValue.setValue(value, nc.getCellId());
        } else {
            GVSpl.panelValue.tableValue.setValue1(value, nc.getCellId(), isRefresh);
        }
    }

    protected Object getValue(INormalCell nc) {
        return nc.getValue();
    }

    private SheetSpl getParentSheet() {
        if (this.sheets == null) {
            return null;
        }
        int i = 0;
        while (i < this.sheets.size()) {
            if (this.sheets.get(i) == this) {
                if (i == 0) {
                    return null;
                }
                return this.sheets.get(i - 1);
            }
            ++i;
        }
        return null;
    }

    private SheetSpl getSubSheet() {
        if (this.sheets == null) {
            return null;
        }
        int i = 0;
        while (i < this.sheets.size()) {
            if (this.sheets.get(i) == this) {
                if (i == this.sheets.size() - 1) {
                    return null;
                }
                return this.sheets.get(i + 1);
            }
            ++i;
        }
        return null;
    }

    public void acceptResult(final Object returnVal, final boolean continueRun) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block14: {
                    try {
                        Object object;
                        SheetSpl subSheet = SheetSpl.this.getSubSheet();
                        if (subSheet != null) {
                            ((IDEBase)GV.appFrame).closeSheet(subSheet, false);
                        }
                        if (SheetSpl.this.exeLocation == null) {
                            return;
                        }
                        PgmNormalCell lastCell = (PgmNormalCell)SheetSpl.this.splControl.cellSet.getCell(SheetSpl.this.exeLocation.getRow(), SheetSpl.this.exeLocation.getCol());
                        lastCell.setValue(returnVal);
                        SheetSpl.this.splControl.cellSet.setCurrent(lastCell);
                        SheetSpl.this.splControl.cellSet.setNext(SheetSpl.this.exeLocation.getRow(), SheetSpl.this.exeLocation.getCol() + 1, false);
                        INormalCell nextCell = SheetSpl.this.splControl.cellSet.getCurrent();
                        if (nextCell != null) {
                            SheetSpl.this.setExeLocation(new CellLocation(nextCell.getRow(), nextCell.getCol()));
                        } else {
                            SheetSpl.this.setExeLocation(null);
                            object = SheetSpl.this.threadLock;
                            synchronized (object) {
                                if (SheetSpl.this.debugThread != null) {
                                    SheetSpl.this.debugThread.continueRun();
                                }
                            }
                        }
                        SheetSpl.this.splControl.contentView.repaint();
                        GV.appFrame.showSheet(SheetSpl.this);
                        SheetSpl.this.subSheetOpened = false;
                        if (!continueRun) break block14;
                        object = SheetSpl.this.threadLock;
                        synchronized (object) {
                            if (SheetSpl.this.debugThread != null) {
                                SheetSpl.this.debugThread.continueRun();
                            }
                        }
                    }
                    catch (Exception e) {
                        GM.showException(GV.appFrame, e);
                    }
                }
            }
        });
    }

    public void stepStop(boolean stopOther) {
        this.stepStopOther = stopOther;
        this.debug((byte)8);
    }

    protected void stepCursor() {
        CellLocation activeCell = this.splControl.getActiveCell();
        if (activeCell == null) {
            GM.messageDialog(GV.appFrame, IdeSplMessage.get().getMessage("sheetspl.noselectcell"));
            return;
        }
        this.debug((byte)2);
    }

    public ParamList getContextParamList() {
        return this.splCtx.getParamList();
    }

    public HashMap<String, Param[]> listSpaceParams() {
        return JobSpaceManager.listSpaceParams();
    }

    public ParamList getEnvParamList() {
        return Env.getParamList();
    }

    public Object[] getAllParams() {
        Object[] params = new Object[]{this.getContextParamList(), this.listSpaceParams(), this.getEnvParamList()};
        return params;
    }

    protected void resetCellSet() {
        ParamList pl;
        if (this.splCtx != null && (pl = this.splCtx.getParamList()) != null) {
            int i = 0;
            while (i < pl.count()) {
                Param p = pl.get(i);
                if (p != null) {
                    p.setValue(null);
                    p.setEditValue(null);
                }
                ++i;
            }
        }
        this.splCtx = new Context();
        Context pCtx = GMSpl.prepareParentContext();
        this.splCtx.setParent(pCtx);
        this.splControl.cellSet.setContext(this.splCtx);
        this.splControl.cellSet.reset();
    }

    protected CellLocation runNext(PgmCellSet cellSet) {
        return cellSet.runNext();
    }

    protected void stepReturn() {
        this.debug((byte)5);
    }

    protected CellLocation runCellSet(PgmCellSet cellSet) {
        cellSet.run();
        INormalCell cell = cellSet.getCurrent();
        if (cell == null) {
            return null;
        }
        return new CellLocation(cell.getRow(), cell.getCol());
    }

    protected void interruptRun(PgmCellSet cellSet) {
        cellSet.interrupt();
    }

    protected void stepInto(PgmNormalCell pnc) {
        Expression exp = pnc.getExpression();
        if (exp != null) {
            CellLocation exeCellLocation = null;
            CellLocation funcLocation = null;
            PgmCellSet subCellSet = null;
            int endRow = -1;
            Call call = null;
            Node home = exp.getHome();
            byte stepType = 0;
            String filePath = null;
            if (home instanceof Call) {
                this.stepCall = call = (Call)home;
                subCellSet = call.getCallPgmCellSet(this.splCtx);
                subCellSet.setCurrent(subCellSet.getPgmNormalCell(1, 1));
                subCellSet.setNext(1, 1, true);
                filePath = call.getDfxPathName(this.splCtx);
            } else if (home instanceof Func || home instanceof PCSFunction) {
                stepType = 1;
                IdeFuncInfo ideFuncInfo = this.getIdeFuncInfo(home, this.splCtx);
                PgmCellSet cellSet = ideFuncInfo.cellSet;
                PgmNormalCell cell = ideFuncInfo.cell;
                if (cell == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.callNeedSub"));
                }
                int row = cell.getRow();
                int col = cell.getCol();
                int rc = cellSet.getRowCount();
                int cc = cellSet.getColCount();
                if (row < 1 || row > rc || col < 1 || col > cc) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.callNeedSub"));
                }
                Command command = cell.getCommand();
                if (command == null || command.getType() != 8) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.callNeedSub"));
                }
                subCellSet = cellSet.newCalc();
                endRow = cellSet.getCodeBlockEndRow(row, col);
                int r = row;
                while (r <= endRow) {
                    int c = col;
                    while (c <= cc) {
                        INormalCell tmp = cellSet.getCell(r, c);
                        INormalCell cellClone = (INormalCell)tmp.deepClone();
                        cellClone.setCellSet(subCellSet);
                        subCellSet.setCell(r, c, cellClone);
                        ++c;
                    }
                    ++r;
                }
                this.setFuncArgs(ideFuncInfo, subCellSet);
                subCellSet.setCurrent(subCellSet.getPgmNormalCell(row, col));
                subCellSet.setNext(row, col + 1, false);
                exeCellLocation = new CellLocation(row, col + 1);
                funcLocation = new CellLocation(row, col);
                filePath = this.stepInfo == null ? this.filePath : this.stepInfo.filePath;
            } else {
                return;
            }
            CellLocation parentLocation = new CellLocation(pnc.getRow(), pnc.getCol());
            this.openSubSheet(parentLocation, stepType, subCellSet, funcLocation, exeCellLocation, endRow, filePath);
        }
    }

    protected IdeFuncInfo getIdeFuncInfo(Object home, Context ctx) {
        IdeFuncInfo ideFuncInfo = new IdeFuncInfo();
        if (home instanceof Func) {
            ideFuncInfo.type = 0;
            Func func = (Func)home;
            Func.CallInfo ci = func.getCallInfo(ctx);
            PgmCellSet cellSet = ci.getPgmCellSet();
            PgmNormalCell cell = (PgmNormalCell)ci.getCell();
            String funcName = ci.getFnName();
            ideFuncInfo.cellSet = cellSet;
            ideFuncInfo.cell = cell;
            ideFuncInfo.funcName = funcName;
            ideFuncInfo.args = ci.getArgs();
            if (ideFuncInfo.cell == null && StringUtils.isValidString(funcName)) {
                PgmCellSet.FuncInfo fi = ideFuncInfo.cellSet.getFuncInfo(funcName);
                if (fi == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(funcName) + mm.getMessage("Expression.unknownFunction"));
                }
                ideFuncInfo.cell = fi.getCell();
                ideFuncInfo.argNames = fi.getArgNames();
            }
        } else if (home instanceof PCSFunction) {
            ideFuncInfo.type = 1;
            PCSFunction func = (PCSFunction)home;
            PgmCellSet.FuncInfo fi = func.getFuncInfo();
            ideFuncInfo.cellSet = (PgmCellSet)func.getCellSet();
            ideFuncInfo.cell = fi.getCell();
            ideFuncInfo.funcName = fi.getFnName();
            ideFuncInfo.argNames = fi.getArgNames();
            ideFuncInfo.args = func.prepareArgs(ctx);
        } else {
            return null;
        }
        return ideFuncInfo;
    }

    protected void setFuncArgs(IdeFuncInfo ideFuncInfo, PgmCellSet subCellSet) {
        block4: {
            Object[] args;
            block5: {
                String[] argNames = ideFuncInfo.argNames;
                args = ideFuncInfo.args;
                if (argNames == null) break block5;
                int argCount = argNames.length;
                if (args == null || args.length != argCount) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(ideFuncInfo.funcName) + mm.getMessage("function.paramCountNotMatch"));
                }
                Context ctx = subCellSet.getContext();
                int i = 0;
                while (i < argCount) {
                    ctx.setParamValue(argNames[i], args[i]);
                    ++i;
                }
                break block4;
            }
            if (ideFuncInfo.type != 0 || args == null) break block4;
            PgmNormalCell cell = ideFuncInfo.cell;
            int colCount = subCellSet.getColCount();
            int paramRow = cell.getRow();
            int paramCol = cell.getCol();
            int i = 0;
            int pcount = args.length;
            while (i < pcount) {
                subCellSet.getPgmNormalCell(paramRow, paramCol).setValue(args[i]);
                if (paramCol < colCount) {
                    ++paramCol;
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    protected boolean isReturnCell(PgmNormalCell cell) {
        Command cmd = cell.getCommand();
        return cmd != null && cmd.getType() == 9;
    }

    protected Object calcReturnValue(PgmCellSet cellSet, PgmNormalCell cell, Context ctx) {
        Expression exp;
        Command cmd = cell.getCommand();
        if (cmd != null && (exp = cmd.getExpression(cellSet, ctx)) != null) {
            return exp.calculate(ctx);
        }
        return null;
    }

    public void openSubSheet(CellLocation parentLocation, byte stepType, final PgmCellSet subCellSet, CellLocation funcLocation, CellLocation exeLocation, int endRow, String filePath) {
        String newName = new File(filePath).getName();
        if (AppUtil.isSPLFile(newName)) {
            int index = newName.lastIndexOf(".");
            newName = newName.substring(0, index);
        }
        String cellId = CellLocation.getCellId(parentLocation.getRow(), parentLocation.getCol());
        final String nn = newName = String.valueOf(newName) + "(" + cellId + ")";
        List<SheetSpl> sheets = this.sheets;
        if (sheets == null) {
            sheets = new ArrayList<SheetSpl>();
            sheets.add(this);
            this.sheets = sheets;
        }
        final StepInfo stepInfo = new StepInfo(sheets, stepType);
        stepInfo.filePath = filePath;
        stepInfo.splCtx = this.splCtx;
        stepInfo.parentLocation = parentLocation;
        stepInfo.funcLocation = funcLocation;
        stepInfo.exeLocation = exeLocation;
        stepInfo.endRow = endRow;
        this.subSheetOpened = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SheetSpl subSheet = (SheetSpl)((IDEBase)GV.appFrame).openSheet(nn, subCellSet, false, stepInfo);
                try {
                    subSheet.debug((byte)6);
                }
                catch (Exception e) {
                    GM.showException(GV.appFrame, e);
                }
            }
        });
    }

    protected boolean runTo(CellLocation toCell) {
        return false;
    }

    protected boolean hasReturn(PgmCellSet cellSet) {
        boolean hasReturn = cellSet.hasReturn();
        if (hasReturn) {
            cellSet.runFinished();
        }
        return hasReturn;
    }

    protected void closeSpace() {
        if (this.jobSpace != null) {
            JobSpaceManager.closeSpace(this.jobSpace.getID());
        }
    }

    protected void closeResource() {
        if (this.jobSpace != null) {
            this.jobSpace.closeResource();
        }
    }

    private void showException(final Object ex) {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                if (ex != null) {
                    GM.showException(GV.appFrame, ex);
                }
            }
        });
    }

    private Long getCellDebugTime(String cellId) {
        Long[] times = this.debugTimeMap.get(cellId);
        if (times == null || times.length != 2) {
            return null;
        }
        Long start = times[0];
        Long end = times[1];
        if (start == null || end == null) {
            return null;
        }
        return end - start;
    }

    private Object[] getCellInterval() {
        Vector<CellRect> cellRects = this.splEditor.getSelectedRects();
        if (cellRects == null || cellRects.isEmpty()) {
            return null;
        }
        Long start = null;
        Long end = null;
        String cellId1 = null;
        String cellId2 = null;
        for (CellRect rect : cellRects) {
            int r = rect.getBeginRow();
            while (r <= rect.getEndRow()) {
                int c = rect.getBeginCol();
                while (c <= rect.getEndCol()) {
                    String cellId = CellLocation.getCellId(r, c);
                    Long[] times = this.debugTimeMap.get(cellId);
                    if (times != null && times.length == 2) {
                        Long tmpStart = times[0];
                        Long tmpEnd = times[1];
                        if (tmpStart != null && tmpEnd != null) {
                            if (start == null || end == null) {
                                cellId1 = cellId;
                                cellId2 = cellId;
                                start = tmpStart;
                                end = tmpEnd;
                            } else if (tmpStart < start) {
                                cellId1 = cellId;
                                start = tmpStart;
                            } else if (tmpEnd >= end) {
                                cellId2 = cellId;
                                end = tmpEnd;
                            }
                        }
                    }
                    ++c;
                }
                ++r;
            }
        }
        if (start == null || end == null || cellId1 == null || cellId2 == null) {
            return null;
        }
        if (cellId1.equals(cellId2)) {
            return null;
        }
        return new Object[]{cellId1, cellId2, end - start};
    }

    private void preventRun() {
        this.setMenuToolEnabled(new short[]{1221, 1223, 1225, 1231, 1263, 1261}, false);
    }

    public void resetRunState() {
        this.resetRunState(false, false);
    }

    private synchronized void resetRunState(final boolean isRefresh, final boolean afterRun) {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                SheetSpl.this.resetRunStateThread(isRefresh, afterRun);
            }
        });
    }

    public boolean isCellSetEditable() {
        return !this.splControl.cellSet.isExecuteOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resetRunStateThread(boolean isRefresh, boolean afterRun) {
        boolean isThreadNull;
        if (!(GV.appMenu instanceof MenuSpl)) {
            return;
        }
        MenuSpl md = (MenuSpl)GV.appMenu;
        if (this.isStepStop) {
            this.setMenuToolEnabled(new short[]{1221, 1223, 1225, 1231, 1233, 1263, 1261, 1235, 1237, 1241}, false);
            this.setMenuToolEnabled(new short[]{1243}, true);
            boolean editable = this.isCellSetEditable();
            if (!isRefresh) {
                this.splEditor.getComponent().getContentPanel().setEditable(editable);
                if (editable) {
                    this.splControl.contentView.initEditor((byte)2);
                }
            }
            if (afterRun) {
                this.setExeLocation(this.exeLocation);
                this.splControl.contentView.repaint();
                if (isRefresh) {
                    this.refresh();
                } else {
                    this.refreshParams();
                }
            }
            return;
        }
        boolean isPaused = false;
        boolean editable = true;
        boolean canStepInto = this.canStepInto();
        boolean isDebugMode = false;
        int runState = 0;
        Object object = this.threadLock;
        synchronized (object) {
            if (this.debugThread != null) {
                boolean bl = isThreadNull = this.debugThread == null;
                if (!isThreadNull) {
                    isDebugMode = this.debugThread.isDebugMode;
                    runState = this.debugThread.getRunState();
                }
            } else {
                isThreadNull = true;
            }
        }
        if (isThreadNull) {
            this.setMenuToolEnabled(new short[]{1221, 1223}, this.stepInfo == null);
            this.setMenuToolEnabled(new short[]{1225, 1231}, true);
            this.setMenuToolEnabled(new short[]{1241}, false);
            this.setMenuToolEnabled(new short[]{1243}, this.stepInfo != null);
            this.setMenuToolEnabled(new short[]{1233}, canStepInto && this.stepInfo != null);
            this.setMenuToolEnabled(new short[]{1235}, this.stepInfo != null);
            this.setMenuToolEnabled(new short[]{1237}, this.stepInfo != null && this.stepInfo.isCall());
            this.setMenuToolEnabled(new short[]{1263, 1261}, this.canRunCell() && (this.stepInfo == null || this.isStepStop));
        } else {
            switch (runState) {
                case 1: {
                    this.setMenuToolEnabled(new short[]{1221, 1223, 1225, 1231, 1233, 1263, 1261}, false);
                    this.setMenuToolEnabled(new short[]{1235}, this.stepInfo != null);
                    this.setMenuToolEnabled(new short[]{1237}, this.stepInfo != null && this.stepInfo.isCall());
                    this.setMenuToolEnabled(new short[]{1241, 1243}, true);
                    editable = false;
                    break;
                }
                case 2: {
                    this.setMenuToolEnabled(new short[]{1221, 1223, 1225, 1231, 1233, 1263, 1261, 1241}, false);
                    this.setMenuToolEnabled(new short[]{1235}, this.stepInfo != null);
                    this.setMenuToolEnabled(new short[]{1237}, this.stepInfo != null && this.stepInfo.isCall());
                    this.setMenuToolEnabled(new short[]{1243}, true);
                    break;
                }
                case 3: {
                    this.setMenuToolEnabled(new short[]{1221, 1223}, false);
                    this.setMenuToolEnabled(new short[]{1225, 1231}, isDebugMode);
                    this.setMenuToolEnabled(new short[]{1233}, canStepInto);
                    this.setMenuToolEnabled(new short[]{1235}, this.stepInfo != null);
                    this.setMenuToolEnabled(new short[]{1237}, this.stepInfo != null && this.stepInfo.isCall());
                    this.setMenuToolEnabled(new short[]{1241, 1243}, true);
                    isPaused = true;
                    break;
                }
                case 0: {
                    this.setMenuToolEnabled(new short[]{1221, 1223, 1225, 1231}, true);
                    this.setMenuToolEnabled(new short[]{1233, 1235, 1237}, false);
                    this.setMenuToolEnabled(new short[]{1241, 1243}, false);
                    this.setMenuToolEnabled(new short[]{1263, 1261}, this.canRunCell());
                }
            }
        }
        if (!this.isCellSetEditable()) {
            this.setMenuToolEnabled(new short[]{1223, 1225, 1231, 1233, 1235, 1237, 1241}, false);
            isPaused = false;
            editable = false;
        }
        if (this.stepInfo != null) {
            editable = false;
        }
        md.resetPauseMenu(isPaused);
        ((ToolBarSpl)GVSpl.appTool).resetPauseButton(isPaused);
        if (!isRefresh) {
            this.splEditor.getComponent().getContentPanel().setEditable(editable);
        }
        if (afterRun) {
            this.setExeLocation(this.exeLocation);
            this.splControl.contentView.repaint();
            if (isRefresh) {
                this.refresh();
            } else {
                this.refreshParams();
            }
        }
    }

    private boolean canStepInto() {
        INormalCell cell;
        block4: {
            cell = this.splControl.cellSet.getCurrent();
            if (cell instanceof PgmNormalCell) break block4;
            return false;
        }
        try {
            Node home;
            Expression exp;
            PgmNormalCell nc = (PgmNormalCell)cell;
            if (nc != null && (exp = nc.getExpression()) != null && ((home = exp.getHome()) instanceof Call || home instanceof Func || home instanceof PCSFunction)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRunThread() {
        Object object = this.threadLock;
        synchronized (object) {
            this.debugThread = null;
        }
    }

    private void setMenuToolEnabled(short[] ids, boolean enabled) {
        if (this != GV.appSheet) {
            return;
        }
        MenuSpl md = (MenuSpl)GV.appMenu;
        int i = 0;
        while (i < ids.length) {
            md.setMenuEnabled(ids[i], enabled);
            GVSpl.appTool.setButtonEnabled(ids[i], enabled);
            ++i;
        }
    }

    public synchronized void terminate() {
        if (this.sheets != null) {
            int count = this.sheets.size();
            int i = 0;
            while (i < count) {
                SheetSpl sheet = this.sheets.get(i);
                sheet.terminateSelf();
                if (sheet.stepInfo != null) {
                    GV.appFrame.closeSheet(sheet);
                    --i;
                    --count;
                }
                ++i;
            }
            SheetSpl sheetParent = this.sheets.get(0);
            if (sheetParent != null) {
                try {
                    sheetParent.stepInfo = null;
                    GV.appFrame.showSheet(sheetParent);
                }
                catch (Exception e) {
                    GM.showException(GV.appFrame, e);
                }
            }
            this.sheets = null;
        } else {
            this.terminateSelf();
        }
    }

    public synchronized void terminateSelf() {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = SheetSpl.this.threadLock;
                synchronized (object) {
                    block21: {
                        if (SheetSpl.this.debugThread != null) {
                            if (SheetSpl.this.debugThread != null) {
                                SheetSpl.this.debugThread.pause();
                            }
                            if (SheetSpl.this.debugThread != null && SheetSpl.this.debugThread.getRunState() != 0 && SheetSpl.this.tg != null) {
                                try {
                                    if (SheetSpl.this.tg != null) {
                                        SheetSpl.this.tg.interrupt();
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                try {
                                    if (SheetSpl.this.tg == null) break block21;
                                    int nthreads = SheetSpl.this.tg.activeCount();
                                    Thread[] threads = new Thread[nthreads];
                                    if (SheetSpl.this.tg != null) {
                                        SheetSpl.this.tg.enumerate(threads);
                                    }
                                    int i = 0;
                                    while (i < nthreads) {
                                        try {
                                            threads[i].stop();
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        ++i;
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                if (SheetSpl.this.tg != null) {
                    try {
                        if (SheetSpl.this.tg != null && SheetSpl.this.tg.activeCount() != 0) {
                            7.sleep(100L);
                        }
                        SheetSpl.this.tg.destroy();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                SheetSpl.this.tg = null;
                SheetSpl.this.closeRunThread();
                try {
                    SheetSpl.this.closeResource();
                }
                catch (Throwable t1) {
                    t1.printStackTrace();
                }
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        SheetSpl.this.setExeLocation(null);
                        SheetSpl.this.refresh(false, false);
                        if ((this).SheetSpl.this.isStepStop) {
                            (this).SheetSpl.this.isStepStop = !(this).SheetSpl.this.isStepStop;
                            (this).SheetSpl.this.stepInfo = null;
                            SheetSpl.this.subSheetClosed();
                            SheetSpl.this.resetRunState(false, true);
                        }
                        (this).SheetSpl.this.splControl.repaint();
                    }
                });
            }
        };
        t.setPriority(10);
        t.start();
    }

    public void setCellSetExps(Sequence exps) {
        ByteMap bm = this.splControl.cellSet.getCustomPropMap();
        if (bm == null) {
            bm = new ByteMap();
        }
        bm.put((byte)11, exps);
        this.splControl.cellSet.setCustomPropMap(bm);
        this.setChanged(true);
    }

    public void showCellValue() {
        this.splEditor.showCellValue();
    }

    private void setExeLocation(CellLocation cl) {
        this.exeLocation = cl;
        if (cl != null) {
            this.splControl.setStepPosition(new CellLocation(cl.getRow(), cl.getCol()));
            this.lastLocation = new CellLocation(cl.getRow(), cl.getCol());
        } else {
            this.splControl.setStepPosition(null);
        }
    }

    private boolean canRunCell() {
        if (this.splEditor == null || this.selectState == 0) {
            return false;
        }
        PgmNormalCell nc = (PgmNormalCell)this.splEditor.getDisplayCell();
        if (nc == null) {
            return false;
        }
        String expStr = nc.getExpString();
        if (!StringUtils.isValidString(expStr)) {
            return false;
        }
        if (nc.getType() == 16) {
            Command cmd = nc.getCommand();
            switch (cmd.getType()) {
                case 12: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean prepareArg() {
        PgmCellSet cellSet = this.splControl.cellSet;
        ParamList paras = cellSet.getParamList();
        if (paras == null || paras.count() == 0) {
            return true;
        }
        if (paras.isUserChangeable()) {
            DialogInputArgument dia;
            block6: {
                dia = new DialogInputArgument(this.splCtx);
                dia.setParam(paras);
                dia.setVisible(true);
                if (dia.getOption() == 0) break block6;
                return false;
            }
            try {
                HashMap<String, Object> values = dia.getParamValue();
                for (String paraName : values.keySet()) {
                    Object value = values.get(paraName);
                    this.splCtx.setParamValue(paraName, value, (byte)0);
                }
                this.setContextParams(this.splCtx.getParamList());
            }
            catch (Throwable t) {
                GM.showException(GV.appFrame, t);
            }
        }
        return true;
    }

    public void dialogParameter() {
        DialogArgument dp = this.newDialogArgument();
        dp.setParameter(this.splControl.cellSet);
        dp.setVisible(true);
        if (dp.getOption() == 0) {
            AtomicSpl ar = new AtomicSpl(this.splControl);
            ar.setType((byte)7);
            ar.setValue(dp.getParameter());
            this.splEditor.executeCmd(ar);
        }
    }

    protected DialogArgument newDialogArgument() {
        return new DialogArgument();
    }

    public boolean isNewGrid() {
        return GMSpl.isNewGrid(this.filePath, "p") || !AppUtil.isSPLFile(this.filePath);
    }

    @Override
    public boolean close() {
        return this.close(false);
    }

    public boolean close(boolean isQuit) {
        SheetSpl parentSheet;
        ((EditControl)this.splEditor.getComponent()).acceptText();
        boolean isChanged = this.splEditor.isDataChanged();
        if (this.stepInfo == null || this.isStepStopCall()) {
            if (ConfigOptions.bAutoSave.booleanValue() && isQuit) {
                if (!this.autoSave()) {
                    return false;
                }
            } else {
                boolean querySave = false;
                boolean isNew = this.isNewGrid();
                boolean removeBackup = false;
                if (isNew) {
                    String spl = CellSetUtil.toString(this.splControl.cellSet);
                    if (StringUtils.isValidString(spl)) {
                        querySave = true;
                    } else if (ConfigOptions.bAutoSave.booleanValue()) {
                        removeBackup = true;
                    }
                } else if (isChanged) {
                    querySave = true;
                }
                if (querySave) {
                    String t1 = IdeCommonMessage.get().getMessage("public.querysave", IdeCommonMessage.get().getMessage("public.file"), this.filePath);
                    String t2 = IdeCommonMessage.get().getMessage("public.save");
                    int option = GM.optionDialog(GV.appFrame, t1, t2, 1);
                    switch (option) {
                        case 0: {
                            if (this.save()) break;
                            return false;
                        }
                        case 1: {
                            if (!ConfigOptions.bAutoSave.booleanValue() || !isNew) break;
                            removeBackup = true;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (removeBackup) {
                    try {
                        File backupDir = new File(GM.getAbsolutePath(ConfigOptions.sBackupDirectory));
                        if (backupDir.exists()) {
                            File f = new File(backupDir, this.filePath);
                            GM.deleteFile(f);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.tg != null) {
            try {
                this.tg.interrupt();
                this.tg.destroy();
            }
            catch (Throwable querySave) {
                // empty catch block
            }
        }
        try {
            if (this.stepInfo != null && this.stepInfo.isCall()) {
                this.finishCall();
            }
            this.closeSpace();
            GVSpl.tabParam.resetParamList(null, this.listSpaceParams(), this.getEnvParamList());
        }
        catch (Throwable t) {
            GM.showException(GV.appFrame, t);
        }
        GVSpl.panelValue.tableValue.setLocked1(false);
        GVSpl.panelValue.tableValue.setCellId(null);
        GVSpl.panelValue.tableValue.setValue(null);
        GVSpl.panelValue.setCellSet(null);
        GVSpl.panelSplWatch.watch(null);
        this.storeBreakPoints();
        GM.setWindowDimension(this);
        this.dispose();
        if (this.stepInfo != null && (parentSheet = this.getParentSheet()) != null) {
            parentSheet.subSheetClosed();
        }
        if (this.sheets != null) {
            this.sheets.remove(this);
        }
        return true;
    }

    protected void finishCall() {
        try {
            if (this.stepCall != null) {
                this.stepCall.finish(this.splControl.cellSet);
            }
        }
        catch (Exception e) {
            GM.showException(GV.appFrame, e);
        }
    }

    public void subSheetClosed() {
        this.subSheetOpened = false;
    }

    @Override
    public void selectStateChanged(byte newState, boolean keyEvent) {
        this.selectState = newState;
        GVSpl.cmdSender = null;
        this.refresh(keyEvent);
    }

    public byte getSelectState() {
        return this.selectState;
    }

    @Override
    public void rightClicked(Component invoker, int x, int y) {
        this.popupSpl.getSplPop(this.selectState).show(invoker, x, y);
    }

    public void setDataChanged(boolean isChanged) {
        this.splEditor.setDataChanged(isChanged);
    }

    @Override
    public void commandExcuted() {
        try {
            this.splControl.getContentPanel().setPreventChange(true);
            this.splEditor.selectAreas(this.scrollActiveCellToVisible);
            this.scrollActiveCellToVisible = true;
            this.refresh();
            this.splControl.repaint();
            ControlUtils.clearWrapBuffer();
        }
        finally {
            this.splControl.getContentPanel().setPreventChange(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importSameNameTxt() {
        if (this.stepInfo != null) {
            return;
        }
        try {
            Vector<IAtomicCmd> setExpCmds;
            if (this.isNewGrid()) {
                GM.messageDialog(GV.appFrame, ERROR_NOT_SAVE);
                return;
            }
            File f = new File(this.filePath);
            if (!f.isFile() || !f.exists()) {
                GM.messageDialog(GV.appFrame, ERROR_NOT_SAVE);
                return;
            }
            Object object = this.threadLock;
            synchronized (object) {
                int option;
                if (this.debugThread != null && (option = GM.optionDialog(GV.appFrame, IdeSplMessage.get().getMessage("sheetdfx.queryclosethread"), IdeSplMessage.get().getMessage("sheetdfx.closethread"), 2)) == 0) {
                    this.debugThread.closeThread();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.terminate();
                }
            }
            this.tg = null;
            this.closeRunThread();
            this.setExeLocation(null);
            EditControl control = (EditControl)this.splEditor.getComponent();
            boolean isEditable = control.getContentPanel().isEditable();
            PgmCellSet cellSet = this.splControl.cellSet;
            int index = this.filePath.lastIndexOf(".");
            String txtPath = String.valueOf(this.filePath.substring(0, index)) + "." + "txt";
            CellRect rect = new CellRect(1, 1, cellSet.getRowCount(), cellSet.getColCount());
            Vector<IAtomicCmd> cmds = this.splEditor.getClearRectCmds(rect, (byte)0);
            if (cmds == null) {
                cmds = new Vector();
            }
            if ((setExpCmds = this.readCellSet(txtPath, cellSet)) != null) {
                cmds.addAll(setExpCmds);
            }
            this.splEditor.executeCmd(cmds);
            this.splEditor.setCellSet(cellSet);
            this.resetCellSet();
            this.resetRunState();
            this.refreshParams();
            this.splControl.repaint();
            this.splEditor.selectFirstCell();
            control.getContentPanel().setEditable(isEditable);
            control.getContentPanel().initEditor((byte)2);
            control.reloadEditorText();
        }
        catch (Exception e) {
            GM.showException(GV.appFrame, e);
        }
    }

    private Vector<IAtomicCmd> readCellSet(String txtFileName, CellSet cellSet) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            IAtomicCmd cmd;
            fis = new FileInputStream(txtFileName);
            isr = new InputStreamReader((InputStream)fis, Env.getDefaultCharsetName());
            br = new BufferedReader(isr);
            ArrayList datas = new ArrayList();
            int rowCount = 0;
            int colCount = 0;
            String rowStr = br.readLine();
            while (rowStr != null) {
                ++rowCount;
                ArrayList<String> rowDatas = new ArrayList<String>();
                ArgumentTokenizer at = new ArgumentTokenizer(rowStr, '\t');
                int c = 0;
                while (at.hasMoreTokens()) {
                    String exp = at.nextToken();
                    ++c;
                    rowDatas.add(exp);
                }
                datas.add(rowDatas);
                colCount = Math.max(c, colCount);
                rowStr = br.readLine();
            }
            Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
            if (rowCount > cellSet.getRowCount()) {
                cmd = this.splEditor.getAppendRows(rowCount - cellSet.getRowCount());
                cmds.add(cmd);
            }
            if (colCount > cellSet.getColCount()) {
                cmd = this.splEditor.getAppendCols(colCount - cellSet.getColCount());
                cmds.add(cmd);
            }
            this.splEditor.executeCmd(cmds);
            cmds.clear();
            int r = 0;
            while (r < datas.size()) {
                List rowDatas = (List)datas.get(r);
                int c = 0;
                while (c < rowDatas.size()) {
                    String exp = (String)rowDatas.get(c);
                    if (StringUtils.isValidString(exp)) {
                        INormalCell nc = cellSet.getCell(r + 1, c + 1);
                        exp = GM.getOptionTrimChar0String(exp);
                        AtomicCell ac = new AtomicCell(this.splEditor.getComponent(), nc);
                        ac.setProperty((byte)1);
                        ac.setValue(exp);
                        cmds.add(ac);
                    }
                    ++c;
                }
                ++r;
            }
            Vector<IAtomicCmd> vector = cmds;
            return vector;
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
            try {
                isr.close();
            }
            catch (Exception exception) {}
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    private Vector<IAtomicCmd> setRowString(CellSet cellSet, int r, String rowStr) {
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        if (r > cellSet.getRowCount()) {
            IAtomicCmd cmd = this.splEditor.getAppendRows(1);
            this.splEditor.executeCmd(cmd);
        }
        ArgumentTokenizer at = new ArgumentTokenizer(rowStr, '\t');
        int c = 0;
        while (at.hasMoreTokens()) {
            String exp = Escape.remove(at.nextToken());
            if ((c = (int)((short)(c + 1))) > cellSet.getColCount()) {
                IAtomicCmd cmd = this.splEditor.getAppendCols(1);
                this.splEditor.executeCmd(cmd);
            }
            if (!StringUtils.isValidString(exp)) continue;
            INormalCell nc = cellSet.getCell(r, c);
            exp = GM.getOptionTrimChar0String(exp);
            AtomicCell ac = new AtomicCell(this.splEditor.getComponent(), nc);
            ac.setProperty((byte)1);
            ac.setValue(exp);
            cmds.add(ac);
        }
        return cmds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadFile() {
        try {
            if (this.isNewGrid()) {
                GM.messageDialog(GV.appFrame, ERROR_NOT_SAVE);
                return;
            }
            File f = new File(this.filePath);
            if (!f.isFile() || !f.exists()) {
                GM.messageDialog(GV.appFrame, ERROR_NOT_SAVE);
                return;
            }
            Object object = this.threadLock;
            synchronized (object) {
                int option;
                if (this.debugThread != null && (option = GM.optionDialog(GV.appFrame, IdeSplMessage.get().getMessage("sheetdfx.queryclosethread"), IdeSplMessage.get().getMessage("sheetdfx.closethread"), 2)) == 0) {
                    this.debugThread.closeThread();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.terminate();
                }
            }
            this.tg = null;
            this.closeRunThread();
            this.setExeLocation(null);
            EditControl control = (EditControl)this.splEditor.getComponent();
            boolean isEditable = control.getContentPanel().isEditable();
            PgmCellSet cellSet = AppUtil.readCellSet(this.filePath);
            this.splEditor.setCellSet(cellSet);
            this.splCtx = new Context();
            Context pCtx = GMSpl.prepareParentContext();
            this.splCtx.setParent(pCtx);
            this.splControl.cellSet.setContext(this.splCtx);
            this.resetRunState();
            this.refreshParams();
            this.splControl.repaint();
            this.splEditor.selectFirstCell();
            control.getContentPanel().setEditable(isEditable);
            control.getContentPanel().initEditor((byte)2);
            control.reloadEditorText();
        }
        catch (Exception e) {
            GM.showException(GV.appFrame, e);
        }
    }

    @Override
    public void executeCmd(short cmd) {
        switch (cmd) {
            case 1031: {
                this.reloadFile();
                break;
            }
            case 1005: {
                this.saveFTP();
                break;
            }
            case 1210: {
                this.reset();
                this.refresh();
                this.splControl.repaint();
                break;
            }
            case 1213: {
                this.resetGlobal();
                this.refresh();
                this.splControl.repaint();
                break;
            }
            case 1221: {
                this.run();
                break;
            }
            case 1223: {
                this.debug((byte)1);
                break;
            }
            case 1241: {
                this.pause();
                break;
            }
            case 1261: {
                this.calcActiveCell(true);
                break;
            }
            case 1263: {
                this.calcActiveCell(false);
                break;
            }
            case 1265: {
                this.showCellValue();
                break;
            }
            case 1231: {
                this.debug((byte)3);
                break;
            }
            case 1233: {
                this.debug((byte)4);
                break;
            }
            case 1235: {
                this.stepReturn();
                break;
            }
            case 1237: {
                this.stepStop(true);
                break;
            }
            case 1225: {
                this.stepCursor();
                break;
            }
            case 1243: {
                this.terminate();
                break;
            }
            case 1251: {
                this.splControl.setBreakPoint();
                break;
            }
            case 1101: {
                this.splEditor.undo();
                break;
            }
            case 1103: {
                this.splEditor.redo();
                break;
            }
            case 1111: {
                if (!this.splEditor.copy()) break;
                this.refresh();
                break;
            }
            case 1113: {
                if (!this.splEditor.copy(false, true)) break;
                this.refresh();
                break;
            }
            case 1115: {
                if (!this.splEditor.codeCopy()) break;
                this.refresh();
                break;
            }
            case 1117: {
                if (!this.splEditor.canCopyPresent()) break;
                this.splEditor.copyPresent();
                this.refresh();
                break;
            }
            case 1119: {
                if (!this.splEditor.copyPresentDialog()) break;
                this.refresh();
                break;
            }
            case 1121: {
                if (!this.splEditor.cut()) break;
                this.refresh();
                break;
            }
            case 1123: {
                this.splEditor.paste(false);
                break;
            }
            case 1125: {
                this.splEditor.paste(true);
                break;
            }
            case 1127: {
                byte o = this.getPasteOption();
                if (o == 0) break;
                this.splEditor.paste(this.isAdjustPaste, o);
                break;
            }
            case 1267: {
                this.splEditor.clear((byte)2);
                break;
            }
            case 1201: {
                this.dialogParameter();
                break;
            }
            case 1167: {
                this.splEditor.ctrlBackSpace();
                break;
            }
            case 1160: {
                this.splEditor.clear((byte)1);
                break;
            }
            case 1162: {
                this.splEditor.clear((byte)0);
                break;
            }
            case 1169: {
                this.splEditor.ctrlDelete();
                break;
            }
            case 1164: 
            case 1165: {
                this.splEditor.delete(cmd);
                break;
            }
            case 1171: {
                this.splEditor.textEditor();
                break;
            }
            case 1180: {
                this.splEditor.note();
                break;
            }
            case 401: {
                this.splEditor.setTips();
                break;
            }
            case 1195: {
                this.dialogSearch(false);
                break;
            }
            case 1197: {
                this.dialogSearch(true);
                break;
            }
            case 1182: {
                CellRect cr = this.splEditor.getSelectedRect();
                int row = cr.getBeginRow();
                float height = this.splControl.cellSet.getRowCell(row).getHeight();
                DialogRowHeight drh = new DialogRowHeight(true, height);
                drh.setVisible(true);
                if (drh.getOption() != 0) break;
                height = drh.getRowHeight();
                this.splEditor.setRowHeight(height);
                break;
            }
            case 1186: {
                CellRect cr = this.splEditor.getSelectedRect();
                int col = cr.getBeginCol();
                float width = this.splControl.cellSet.getColCell(col).getWidth();
                DialogRowHeight drh = new DialogRowHeight(false, width);
                drh.setVisible(true);
                if (drh.getOption() != 0) break;
                width = drh.getRowHeight();
                this.splEditor.setColumnWidth(width);
                break;
            }
            case 1183: {
                this.splEditor.adjustRowHeight();
                break;
            }
            case 1187: {
                this.splEditor.adjustColWidth();
                break;
            }
            case 1184: {
                this.splEditor.setRowVisible(false);
                break;
            }
            case 1185: {
                this.splEditor.setRowVisible(true);
                break;
            }
            case 1188: {
                this.splEditor.setColumnVisible(false);
                break;
            }
            case 1189: {
                this.splEditor.setColumnVisible(true);
                break;
            }
            case 1191: {
                this.splEditor.dialogChartEditor();
                break;
            }
            case 1194: {
                this.splEditor.dialogZoom();
                break;
            }
            case 1271: {
                GVSpl.panelValue.tableValue.drawChart();
                break;
            }
            case 1145: {
                this.splEditor.hotKeyInsert((byte)0);
                break;
            }
            case 1151: {
                this.splEditor.hotKeyInsert((byte)2);
                break;
            }
            case 1153: {
                this.splEditor.hotKeyInsert((byte)3);
                break;
            }
            case 1175: 
            case 1176: 
            case 1177: 
            case 1178: {
                this.splEditor.moveCopy(cmd);
                break;
            }
            case 1131: {
                this.splEditor.insertCol(true);
                break;
            }
            case 1133: {
                this.splEditor.insertCol(false);
                break;
            }
            case 1141: {
                this.splEditor.dupRow(false);
                break;
            }
            case 1143: {
                this.splEditor.dupRow(true);
                break;
            }
            case 130: {
                PgmCellSet pcs = this.splEditor.getComponent().getCellSet();
                DialogCellSetProperties dcsp = new DialogCellSetProperties(this.isCellSetEditable());
                dcsp.setPropertyMap(pcs.getCustomPropMap());
                dcsp.setVisible(true);
                if (dcsp.getOption() != 0) break;
                pcs.setCustomPropMap(dcsp.getPropertyMap());
                this.splEditor.setDataChanged(true);
                break;
            }
            case 1301: {
                DialogEditConst dce = new DialogEditConst(false);
                ParamList pl = Env.getParamList();
                Vector<String> usedNames = new Vector<String>();
                if (pl != null) {
                    int j = 0;
                    while (j < pl.count()) {
                        usedNames.add(pl.get(j).getName());
                        ++j;
                    }
                }
                dce.setUsedNames(usedNames);
                dce.setParamList(this.splControl.cellSet.getParamList());
                dce.setVisible(true);
                if (dce.getOption() != 0) break;
                AtomicSpl ar = new AtomicSpl(this.splControl);
                ar.setType((byte)9);
                ar.setValue(dce.getParamList());
                this.splEditor.executeCmd(ar);
                this.refresh();
            }
        }
    }

    protected boolean canSave() {
        return true;
    }

    public boolean isDataChanged() {
        ((EditControl)this.splEditor.getComponent()).acceptText();
        return this.splEditor.isDataChanged();
    }

    public int querySave(int optionType) {
        ((EditControl)this.splEditor.getComponent()).acceptText();
        boolean isChanged = this.splEditor.isDataChanged();
        if (isChanged) {
            String t1 = IdeCommonMessage.get().getMessage("public.querysave", IdeCommonMessage.get().getMessage("public.file"), this.filePath);
            String t2 = IdeCommonMessage.get().getMessage("public.save");
            int option = GM.optionDialog(GV.appFrame, t1, t2, optionType);
            switch (option) {
                case 0: {
                    if (!this.save()) {
                        return 2;
                    }
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return 2;
        }
        return 0;
    }

    private byte getPasteOption() {
        int option = 0;
        if (GVSpl.cellSelection != null) {
            switch (GVSpl.cellSelection.selectState) {
                case 3: {
                    option = 1;
                    break;
                }
                case 4: {
                    option = 2;
                }
            }
        }
        if (option == 0) {
            DialogOptionPaste dop = new DialogOptionPaste();
            dop.setVisible(true);
            if (dop.getOption() == 0) {
                option = dop.getPasteOption();
                this.isAdjustPaste = dop.isAdjustExp();
            }
        }
        return (byte)option;
    }

    @Override
    public ICellSet getCellSet() {
        return this.splControl.getCellSet();
    }

    @Override
    public void setCellSet(Object cellSet) {
        try {
            this.splEditor.setCellSet((PgmCellSet)cellSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.splEditor.setDataChanged(isChanged);
    }

    protected void sheetDeactivated() {
    }

    @Override
    public boolean submitEditor() {
        try {
            this.splControl.contentView.submitEditor();
            return true;
        }
        catch (Exception ex) {
            GM.showException(GV.appFrame, ex);
            return false;
        }
    }

    public boolean saveOutStream(OutputStream os) {
        try {
            CellSetUtil.writePgmCellSet(os, this.splControl.cellSet);
            DfxManager.getInstance().clear();
            GV.appMenu.refreshRecentFile(this.filePath);
        }
        catch (Throwable e) {
            GM.showException(GV.appFrame, e);
            return false;
        }
        this.splEditor.setDataChanged(false);
        this.splEditor.getSplListener().commandExcuted();
        return true;
    }

    static /* synthetic */ SheetSpl access$5(SheetSpl sheetSpl) {
        return sheetSpl.getParentSheet();
    }

    static /* synthetic */ boolean access$6(SheetSpl sheetSpl) {
        return sheetSpl.subSheetOpened;
    }

    class CalcCellThread
    extends Thread {
        private CellLocation cl;

        public CalcCellThread(CellLocation cl) {
            this.cl = cl;
        }

        @Override
        public void run() {
            block6: {
                try {
                    try {
                        int row = this.cl.getRow();
                        int col = this.cl.getCol();
                        SheetSpl.this.splControl.setCalcPosition(new CellLocation(row, col));
                        long t1 = System.currentTimeMillis();
                        SheetSpl.this.runCell(row, col);
                        long t2 = System.currentTimeMillis();
                        String cellId = CellLocation.getCellId(row, col);
                        SheetSpl.this.debugTimeMap.put(cellId, new Long[]{t1, t2});
                        NormalCell nc = (NormalCell)SheetSpl.this.splControl.cellSet.getCell(row, col);
                        if (nc != null) {
                            SheetSpl.this.setValue(nc, false, false);
                        }
                    }
                    catch (Exception x) {
                        SheetSpl.this.showException(x);
                        SheetSpl.this.splControl.contentView.repaint();
                        SwingUtilities.invokeLater(new Thread(){

                            @Override
                            public void run() {
                                SheetSpl.this.refreshParams();
                            }
                        });
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    SheetSpl.this.splControl.contentView.repaint();
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                SheetSpl.this.splControl.contentView.repaint();
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }

    class DebugThread
    extends Thread {
        protected volatile boolean isDebugMode;
        static final byte FINISH = 0;
        static final byte RUN = 1;
        static final byte PAUSING = 2;
        static final byte PAUSED = 3;
        protected Byte runState;
        static final byte DEBUG = 1;
        static final byte CURSOR = 2;
        static final byte STEP_OVER = 3;
        static final byte STEP_INTO = 4;
        static final byte STEP_RETURN = 5;
        static final byte STEP_INTO_WAIT = 6;
        static final byte STEP_RETURN1 = 7;
        static final byte STEP_STOP = 8;
        protected volatile byte debugType;
        protected Boolean isPaused;
        protected CellLocation clCursor;
        protected PgmCellSet curCellSet;

        public DebugThread(ThreadGroup tg, String name) {
            super(tg, name);
            this.isDebugMode = true;
            this.runState = new Byte(0);
            this.debugType = 1;
            this.isPaused = Boolean.FALSE;
            this.clCursor = null;
            this.curCellSet = SheetSpl.this.splControl.cellSet;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [32[DOLOOP]], but top level block is 6[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stepFinish() {
            this.isPaused = Boolean.TRUE;
            Object object = SheetSpl.this.runStateLock;
            synchronized (object) {
                this.runState = new Byte(3);
            }
            SheetSpl.this.resetRunState(false, true);
        }

        protected boolean checkBreak() {
            if (SheetSpl.this.exeLocation == null) {
                return false;
            }
            if (this.debugType == 6 || this.debugType == 3 || this.debugType == 4) {
                this.stepFinish();
                if (ConfigOptions.bStepLastLocation.booleanValue() && SheetSpl.this.lastLocation != null) {
                    SwingUtilities.invokeLater(new Thread(){

                        @Override
                        public void run() {
                            ((DebugThread)DebugThread.this).SheetSpl.this.splEditor.selectCell(SheetSpl.this.lastLocation.getRow(), SheetSpl.this.lastLocation.getCol());
                        }
                    });
                }
                return true;
            }
            if (SheetSpl.this.splControl.isBreakPointCell(SheetSpl.this.exeLocation.getRow(), SheetSpl.this.exeLocation.getCol())) {
                this.stepFinish();
                return true;
            }
            if (this.debugType == 2 && this.clCursor != null && SheetSpl.this.exeLocation.equals(this.clCursor)) {
                this.stepFinish();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause() {
            Object object = SheetSpl.this.runStateLock;
            synchronized (object) {
                this.runState = new Byte(2);
            }
            SheetSpl.this.resetRunState(false, false);
        }

        public byte getRunState() {
            return this.runState;
        }

        public void setDebugType(byte debugType) {
            this.debugType = debugType;
            if (debugType == 2) {
                CellLocation activeCell = SheetSpl.this.splControl.getActiveCell();
                this.clCursor = activeCell != null ? new CellLocation(activeCell.getRow(), activeCell.getCol()) : null;
            }
        }

        public void continueRun() {
            this.continueRun((byte)1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void continueRun(byte debugType) {
            Object object = SheetSpl.this.runStateLock;
            synchronized (object) {
                this.runState = new Byte(1);
            }
            this.setDebugType(debugType);
            SheetSpl.this.resetRunState();
            this.isPaused = Boolean.FALSE;
        }

        public void closeThread() {
            this.pause();
            SheetSpl.this.closeResource();
        }
    }

    class IdeFuncInfo {
        public static final byte TYPE_FUNC = 0;
        public static final byte TYPE_PCS = 1;
        byte type = 0;
        PgmCellSet cellSet;
        PgmNormalCell cell;
        String funcName;
        String[] argNames;
        Object[] args;

        IdeFuncInfo() {
        }
    }

    class Listener
    extends InternalFrameAdapter {
        SheetSpl sheet;

        public Listener(SheetSpl sheet) {
            this.sheet = sheet;
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean isSheetChanged = false;
                    if (GV.appSheet == null || GV.appSheet != Listener.this.sheet) {
                        isSheetChanged = true;
                    }
                    GV.appSheet = Listener.this.sheet;
                    GVSpl.splEditor = Listener.this.sheet.splEditor;
                    if (Listener.this.sheet.splControl != null) {
                        Listener.this.sheet.splControl.repaint();
                    }
                    GV.appFrame.changeMenuAndToolBar(((IDEBase)GV.appFrame).newMenuSpl(), ((IDEBase)GV.appFrame).newToolBarSpl());
                    GV.appMenu.addLiveMenu(Listener.this.sheet.getSheetTitle());
                    GV.appMenu.resetPrivilegeMenu();
                    GM.setCurrentPath(Listener.this.sheet.getFileName());
                    if (Listener.this.sheet.splControl == null) {
                        GVSpl.panelValue.setCellSet(null);
                        GVSpl.panelValue.tableValue.setValue(null);
                        GVSpl.tabParam.resetParamList(null, SheetSpl.this.listSpaceParams(), SheetSpl.this.getEnvParamList());
                        return;
                    }
                    GV.toolBarProperty.init();
                    if (isSheetChanged) {
                        Listener.this.sheet.refreshParams();
                    } else {
                        Listener.this.sheet.refresh();
                    }
                    Listener.this.sheet.resetRunState();
                    ((IDEBase)GV.appFrame).resetTitle();
                    GV.toolWin.refreshSheet(Listener.this.sheet);
                    Listener.this.sheet.selectFirstCell();
                    GVSpl.panelSplWatch.setCellSet(Listener.this.sheet.splControl.cellSet);
                    GVSpl.panelSplWatch.watch();
                    GVSpl.panelValue.setCellSet(Listener.this.sheet.splControl.cellSet);
                    GVSpl.panelValue.tableValue.initScale(Listener.this.sheet.splControl.cellSet);
                }
            });
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            GVSpl.appFrame.closeSheet(this.sheet);
            GV.toolBarProperty.setEnabled(false);
            ((ToolBarProperty)GV.toolBarProperty).removeCellEditingListeners();
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
            GVSpl.splEditor = null;
            this.sheet.splControl.repaint();
            GV.toolBarProperty.setEnabled(false);
            ((ToolBarProperty)GV.toolBarProperty).removeCellEditingListeners();
            GVSpl.panelSplWatch.setCellSet(null);
            SheetSpl.this.sheetDeactivated();
        }
    }

    class RunThread
    extends DebugThread {
        public RunThread(ThreadGroup tg, String name) {
            super(tg, name);
            this.isDebugMode = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block33: {
                var1_1 = SheetSpl.this.runStateLock;
                synchronized (var1_1) {
                    this.runState = new Byte(1);
                }
                SheetSpl.this.resetRunState();
                isThreadDeath = false;
                try {
                    do {
                        var2_4 = SheetSpl.this.runStateLock;
                        synchronized (var2_4) {
                            if (this.runState == 2) {
                                this.stepFinish();
                            }
                            // MONITOREXIT @DISABLED, blocks:[1, 2, 3, 26, 11] lbl20 : MonitorExitStatement: MONITOREXIT : var2_4
                            if (true) ** GOTO lbl28
                        }
                        do {
                            try {
                                RunThread.sleep(5L);
                            }
                            catch (Exception var2_5) {
                                // empty catch block
                            }
lbl28:
                            // 3 sources

                        } while (this.isPaused.booleanValue());
                        SheetSpl.access$4(SheetSpl.this, null);
                        SheetSpl.this.splControl.contentView.repaint();
                        runStart = System.currentTimeMillis();
                        SheetSpl.this.exeLocation = SheetSpl.this.runCellSet(this.curCellSet);
                        runEnd = System.currentTimeMillis();
                        Logger.debug(IdeSplMessage.get().getMessage("sheetspl.runtime", SheetSpl.this.filePath, runEnd - runStart));
                    } while (SheetSpl.this.exeLocation != null);
                }
                catch (ThreadDeath td) {
                    isThreadDeath = true;
                    var7_9 = SheetSpl.this.runStateLock;
                    synchronized (var7_9) {
                        this.runState = new Byte(0);
                    }
                    if (!isThreadDeath) {
                        SheetSpl.access$2(SheetSpl.this, false, true);
                    }
                    GVSpl.panelSplWatch.watch();
                    SheetSpl.access$3(SheetSpl.this);
                    break block33;
                }
                catch (Throwable x) {
                    try {
                        SheetSpl.access$1(SheetSpl.this, x);
                        var7_10 = SheetSpl.this.runStateLock;
                    }
                    catch (Throwable var6_13) {
                        var7_11 = SheetSpl.this.runStateLock;
                        synchronized (var7_11) {
                            this.runState = new Byte(0);
                        }
                        if (!isThreadDeath) {
                            SheetSpl.access$2(SheetSpl.this, false, true);
                        }
                        GVSpl.panelSplWatch.watch();
                        SheetSpl.access$3(SheetSpl.this);
                        throw var6_13;
                    }
                    synchronized (var7_10) {
                        this.runState = new Byte(0);
                    }
                    if (!isThreadDeath) {
                        SheetSpl.access$2(SheetSpl.this, false, true);
                    }
                    GVSpl.panelSplWatch.watch();
                    SheetSpl.access$3(SheetSpl.this);
                    break block33;
                }
                var7_12 = SheetSpl.this.runStateLock;
                synchronized (var7_12) {
                    this.runState = new Byte(0);
                }
                if (!isThreadDeath) {
                    SheetSpl.access$2(SheetSpl.this, false, true);
                }
                GVSpl.panelSplWatch.watch();
                SheetSpl.access$3(SheetSpl.this);
            }
        }

        @Override
        public void pause() {
            super.pause();
            SheetSpl.this.interruptRun(this.curCellSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void continueRun() {
            Object object = SheetSpl.this.runStateLock;
            synchronized (object) {
                this.runState = new Byte(1);
            }
            SheetSpl.this.resetRunState();
            this.isPaused = Boolean.FALSE;
        }
    }
}

