/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.DialogArgument;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GMSplSE;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.MenuSplSE;
import com.scudata.ide.spl.PopupSplSE;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.StepInfo;
import com.scudata.ide.spl.control.JWindowNames;
import com.scudata.ide.spl.control.SplEditor;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.ide.spl.dialog.DialogArgumentSE;
import com.scudata.ide.spl.dialog.DialogExecCmd;
import com.scudata.ide.spl.dialog.DialogInputPassword;
import com.scudata.ide.spl.dialog.DialogPassword;
import javax.swing.JOptionPane;

public class SheetSplSE
extends SheetSpl {
    private static final long serialVersionUID = 1L;

    public SheetSplSE(String filePath, PgmCellSet cs, StepInfo stepInfo) throws Exception {
        super(filePath, cs, stepInfo);
    }

    @Override
    public void executeCmd(short cmd) {
        super.executeCmd(cmd);
        switch (cmd) {
            case 2116: {
                if (!((SplEditorSE)this.splEditor).excelCopy()) break;
                this.refresh();
                break;
            }
            case 2129: {
                ((SplEditorSE)this.splEditor).excelPaste();
                break;
            }
            case 2132: {
                ((SplEditorSE)this.splEditor).swapCell();
                break;
            }
            case 2313: {
                FileObject fo;
                int option = this.querySave(1);
                if (option == 2) {
                    return;
                }
                DialogExecCmd dec = new DialogExecCmd();
                if (StringUtils.isValidString(this.filePath) && (fo = new FileObject(this.filePath, "s", new Context())).isExists()) {
                    dec.setSplFile(this.filePath);
                }
                dec.setVisible(true);
                break;
            }
            case 2141: {
                try {
                    SplEditorSE.checkEncrypt();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(GVSpl.appFrame, e.getMessage());
                    return;
                }
                if (!this.splControl.cellSet.isExecuteOnly()) {
                    this.dialogPassword();
                    break;
                }
                this.dialogInputPassword();
                break;
            }
            case 2325: {
                this.splEditor.dialogFuncEditor();
            }
        }
    }

    @Override
    protected DialogArgument newDialogArgument() {
        if (GMSplSE.isExcelXllEnabled() || GMSplSE.isOfficeAddinEnabled()) {
            return new DialogArgumentSE();
        }
        return new DialogArgument();
    }

    @Override
    protected void newPopupSpl() {
        this.popupSpl = new PopupSplSE();
    }

    @Override
    protected SplEditor newSplEditor() {
        return new SplEditorSE(this);
    }

    @Override
    protected void refresh(boolean keyEvent, boolean isRefreshState) {
        super.refresh(keyEvent, isRefreshState);
        if (!(GV.appMenu instanceof MenuSplSE)) {
            return;
        }
        MenuSplSE md = (MenuSplSE)GV.appMenu;
        md.setMenuEnabled((short)2116, true);
        md.setMenuEnabled((short)2129, GMSpl.canPaste());
        md.setMenuEnabled((short)2325, this.selectState != 0);
        if (this.splControl.cellSet.isExecuteOnly()) {
            boolean isDataChanged = this.splEditor.isDataChanged();
            md.setEnable(md.getMenuItems(), false);
            md.setMenuEnabled((short)50, isDataChanged);
            md.setMenuEnabled((short)130, true);
            md.setMenuEnabled((short)1301, false);
            GVSpl.appTool.setBarEnabled(false);
            GVSpl.appTool.setButtonEnabled((short)50, isDataChanged);
            GV.toolBarProperty.setEnabled(false);
            md.setMenuEnabled((short)2141, SplEditorSE.isEncrypt());
            md.setMenuEnabled((short)2341, SplEditorSE.isEncrypt());
        }
        md.resetPasswordMenu(!this.hasPassword());
    }

    @Override
    protected void sheetDeactivated() {
        JWindowNames.stopMatch();
    }

    protected void dialogPassword() {
        DialogPassword dp = new DialogPassword(this.splControl.cellSet, this.hasPassword());
        dp.setVisible(true);
        if (dp.getOption() != 0) {
            return;
        }
        this.refresh();
        this.setChanged(true);
    }

    protected void dialogInputPassword() {
        DialogInputPassword dip = new DialogInputPassword(true);
        dip.setPassword(null);
        dip.setVisible(true);
        if (dip.getOption() == 0) {
            String psw = dip.getPassword();
            this.splControl.cellSet.setCurrentPassword(psw);
            boolean isFull = !this.hasPassword();
            ((MenuSplSE)GV.appMenu).resetPasswordMenu(isFull);
            boolean lastEditable = this.splControl.contentView.isEditable();
            if (lastEditable != isFull) {
                this.splControl.contentView.setEditable(isFull);
                if (isFull) {
                    this.splControl.contentView.initEditor((byte)1);
                }
            }
            this.refresh();
        }
    }

    protected boolean hasPassword() {
        return StringUtils.isValidString(this.splControl.cellSet.getPasswordHash());
    }
}

