/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.AppToolBar;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;

public class ToolBarSpl
extends AppToolBar {
    private static final long serialVersionUID = 1L;
    private JButton pauseButton;
    private ActionListener actionNormal = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String menuId = "";
            try {
                menuId = e.getActionCommand();
                short cmdId = Short.parseShort(menuId);
                GMSpl.executeCmd(cmdId);
            }
            catch (Exception ex) {
                GM.showException(GV.appFrame, ex);
            }
        }
    };
    private final String S_CONTINUE = IdeSplMessage.get().getMessage("menu.program.continue");
    private final String S_PAUSE = IdeSplMessage.get().getMessage("menu.program.pause");
    private final ImageIcon I_CONTINUE = GM.getMenuImageIcon("program.continue");
    private final ImageIcon I_PAUSE = GM.getMenuImageIcon("program.pause");

    public ToolBarSpl() {
        this.add(this.getCommonButton((short)5, "file.new"));
        this.add(this.getCommonButton((short)10, "file.open"));
        this.add(this.getCommonButton((short)50, "file.save"));
        this.addSeparator(this.seperator);
        this.add(this.getSplButton((short)1221, "program.exec"));
        JButton b = this.getSplButton((short)1223, "program.exe_debug");
        this.add(b);
        this.addSeparator(this.seperator);
        b = this.getSplButton((short)1225, "program.stepcursor");
        this.add(b);
        b = this.getSplButton((short)1231, "program.stepnext");
        this.add(b);
        b = this.getSplButton((short)1233, "program.stepinto");
        this.add(b);
        b = this.getSplButton((short)1235, "program.stepreturn");
        this.add(b);
        b = this.getSplButton((short)1237, "program.stepstop");
        this.add(b);
        this.pauseButton = this.getSplButton((short)1241, "program.pause");
        this.add(this.pauseButton);
        b = this.getSplButton((short)1243, "program.stop");
        this.add(b);
        b = this.getSplButton((short)1251, "program.breakpoints");
        this.add(b);
        this.addSeparator(this.seperator);
        this.add(this.getSplButton((short)1263, "program.execarea"));
        this.add(this.getSplButton((short)1160, "edit.clear"));
        this.add(this.getSplButton((short)1101, "edit.undo"));
        this.add(this.getSplButton((short)1103, "edit.redo"));
        this.setBarEnabled(false);
        this.setFocusable(false);
    }

    @Override
    public void setBarEnabled(boolean enabled) {
        this.setButtonEnabled((short)50, enabled);
        this.setButtonEnabled((short)1221, enabled);
        this.setButtonEnabled((short)1223, enabled);
        this.setButtonEnabled((short)1231, enabled);
        this.setButtonEnabled((short)1225, enabled);
        this.setButtonEnabled((short)1241, enabled);
        this.setButtonEnabled((short)1243, enabled);
        this.setButtonEnabled((short)1251, enabled);
        this.setButtonEnabled((short)1263, enabled);
        this.setButtonEnabled((short)1160, enabled);
        this.setButtonEnabled((short)1103, enabled);
        this.setButtonEnabled((short)1101, enabled);
    }

    private JButton getSplButton(short cmdId, String menuId) {
        JButton b = this.getButton(cmdId, menuId, IdeSplMessage.get().getMessage("menu." + menuId), this.actionNormal);
        buttonHolder.put(cmdId, b);
        b.setFocusable(false);
        return b;
    }

    public JToggleButton getToggleButton(short cmdId, String menuId, String toolTip) {
        int index;
        ImageIcon img = GM.getMenuImageIcon(menuId);
        JToggleButton b = new JToggleButton(img);
        b.setOpaque(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setContentAreaFilled(false);
        if (StringUtils.isValidString(toolTip) && (index = toolTip.indexOf("(")) > 0) {
            toolTip = toolTip.substring(0, index);
        }
        b.setToolTipText(toolTip);
        b.setActionCommand(Short.toString(cmdId));
        b.addActionListener(this.actionNormal);
        Dimension d = new Dimension(28, 28);
        b.setPreferredSize(d);
        b.setMaximumSize(d);
        b.setMinimumSize(d);
        buttonHolder.put(cmdId, b);
        b.setFocusable(false);
        return b;
    }

    @Override
    public void executeCmd(short cmdId) {
        try {
            GMSpl.executeCmd(cmdId);
        }
        catch (Exception e) {
            GM.showException(GV.appFrame, e);
        }
    }

    public void resetPauseButton(boolean isPause) {
        if (isPause) {
            this.pauseButton.setIcon(this.I_CONTINUE);
            this.pauseButton.setToolTipText(this.S_CONTINUE);
        } else {
            this.pauseButton.setIcon(this.I_PAUSE);
            this.pauseButton.setToolTipText(this.S_PAUSE);
        }
    }
}

