/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.common.LimitedStack;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.IAtomicCmd;
import com.scudata.ide.common.control.IEditorListener;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.EditControl;
import com.scudata.ide.spl.control.SplEditor;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class UndoManager {
    private LimitedStack undoContainer = new LimitedStack(ConfigOptions.iUndoCount);
    private LimitedStack redoContainer = new LimitedStack(ConfigOptions.iUndoCount);
    private SplEditor mEditor;
    private EditControl editControl;

    public UndoManager(SplEditor editor) {
        this.mEditor = editor;
        this.editControl = (EditControl)editor.getComponent();
    }

    public boolean canUndo() {
        return !this.undoContainer.empty();
    }

    public boolean canRedo() {
        return !this.redoContainer.empty();
    }

    public void undo() {
        if (this.undoContainer.empty()) {
            return;
        }
        Vector cmds = (Vector)this.undoContainer.pop();
        this.executeCommands(cmds, this.redoContainer);
    }

    public void redo() {
        if (this.redoContainer.empty()) {
            return;
        }
        Vector cmds = (Vector)this.redoContainer.pop();
        this.executeCommands(cmds, this.undoContainer);
    }

    public void doing(Vector<IAtomicCmd> microCmds) {
        if (microCmds == null || microCmds.size() == 0) {
            return;
        }
        this.redoContainer.clear();
        this.executeCommands(microCmds, this.undoContainer);
    }

    public void doing(IAtomicCmd cmd) {
        this.redoContainer.clear();
        Vector<IAtomicCmd> v = new Vector<IAtomicCmd>();
        v.add(cmd);
        this.executeCommands(v, this.undoContainer);
    }

    private Vector<IAtomicCmd> reverseVector(Vector<IAtomicCmd> v) {
        Vector<IAtomicCmd> rv = new Vector<IAtomicCmd>();
        int i = v.size() - 1;
        while (i >= 0) {
            rv.add(v.get(i));
            --i;
        }
        return rv;
    }

    private void executeCommands(Vector<IAtomicCmd> cmds, LimitedStack stack) {
        Vector<IAtomicCmd> vReverseCmds = new Vector<IAtomicCmd>();
        boolean needRedraw = false;
        int newScale = 0;
        int i = 0;
        while (i < cmds.size()) {
            IAtomicCmd cmd = cmds.get(i);
            IAtomicCmd revCmd = cmd.execute();
            vReverseCmds.add(revCmd);
            ++i;
        }
        this.editControl.resetCellSelection(null);
        SplEditor splEditor = ControlUtils.extractSplEditor(this.editControl);
        if (splEditor != null) {
            splEditor.resetSelectedAreas();
        }
        try {
            this.editControl.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (needRedraw) {
            this.editControl.setDisplayScale(newScale);
        }
        stack.push(this.reverseVector(vReverseCmds));
        this.mEditor.setDataChanged(true);
        IEditorListener rel = this.mEditor.getSplListener();
        if (rel != null) {
            final Runnable delayExecute = new Runnable(){

                @Override
                public void run() {
                    IEditorListener rel1 = UndoManager.this.mEditor.getSplListener();
                    rel1.commandExcuted();
                }
            };
            Thread appThread = new Thread(){

                @Override
                public void run() {
                    try {
                        SwingUtilities.invokeLater(delayExecute);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            Thread.yield();
            appThread.start();
        }
    }
}

