/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.app.common.Section;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.ISessionFactory;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.DfxManager;
import com.scudata.dm.Env;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.ide.common.AppFrame;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.Console;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.DialogInputText;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.ServerConsole;
import com.scudata.ide.spl.ServerConsole_jBClean_actionAdapter;
import com.scudata.ide.spl.ServerConsole_jBCopy_actionAdapter;
import com.scudata.ide.spl.ServerConsole_jBQuit_actionAdapter;
import com.scudata.ide.spl.dialog.DialogInputPort;
import com.scudata.ide.spl.dialog.DialogOdbcConfig;
import com.scudata.ide.spl.dialog.DialogOptions;
import com.scudata.ide.spl.dialog.DialogUnitConfig;
import com.scudata.parallel.HostManager;
import com.scudata.parallel.ITask;
import com.scudata.parallel.RemoteFileProxy;
import com.scudata.parallel.RemoteFileProxyManager;
import com.scudata.parallel.TaskManager;
import com.scudata.resources.ParallelMessage;
import com.scudata.server.IServer;
import com.scudata.server.StartUnitListener;
import com.scudata.server.http.SplxServerInIDE;
import com.scudata.server.odbc.OdbcServer;
import com.scudata.server.unit.UnitServer;
import com.scudata.util.Variant;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UnitServerConsole
extends AppFrame
implements StartUnitListener {
    private static final long serialVersionUID = 1L;
    JTabbedPane tabServer = new JTabbedPane();
    UnitServer unitServer = null;
    OdbcServer odbcServer = null;
    SplxServerInIDE httpServer = null;
    JPanel panelUnit = new JPanel();
    JPanel panelOdbc = new JPanel();
    JPanel panelHttp = new JPanel();
    JScrollPane publicConsole = null;
    IServer currentServer = null;
    String currentServerName = UNITSERVER;
    JPanel panelMain = new JPanel();
    JPanel jPanel1 = new JPanel();
    HostManager hm = HostManager.instance();
    BorderLayout borderLayout1 = new BorderLayout();
    VFlowLayout verticalFlowLayout1 = new VFlowLayout();
    JButton jBStart = new JButton("Start");
    JButton jBStop = new JButton("Stop");
    JButton jBReset = new JButton("Reset");
    JButton jBStatus = new JButton("Status");
    JButton jBCopy = new JButton();
    JButton jBClean = new JButton();
    JButton jBConfig = new JButton();
    JButton jBOptions = new JButton();
    JButton jBQuit = new JButton();
    Console console = null;
    JTextArea currentTA = null;
    private String specifyHost = null;
    private int specifyPort = 0;
    boolean startedByWeb = false;
    static String UNITSERVER;
    static String ODBCSERVER;
    static String HTTPSERVER;
    private transient boolean isServerStarting = false;
    Color stopColor = new Color(200, 0, 0);
    Color runColor = new Color(0, 168, 0);
    boolean disableStart = false;

    static {
        try {
            ImageIcon ii;
            if (GM.isMacOS() && (ii = UnitServerConsole.getImageIcon()) != null) {
                GM.setMacOSDockIcon(ii.getImage());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        UNITSERVER = " Unit Server ";
        ODBCSERVER = " Odbc Server ";
        HTTPSERVER = " Http Server ";
    }

    private synchronized void setServerStatus(boolean starting) {
        this.isServerStarting = starting;
    }

    private int indexBase() {
        if (this.isEE()) {
            return 0;
        }
        return 1;
    }

    boolean isEE() {
        return false;
    }

    UnitServer getUnitServerInstance(String host, int port) throws Exception {
        return null;
    }

    public static void initLang() {
        try {
            ServerConsole.loadRaqsoftConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
        UNITSERVER = ParallelMessage.get().getMessage("UnitServerConsole.UnitServer");
        ODBCSERVER = ParallelMessage.get().getMessage("UnitServerConsole.OdbcServer");
        HTTPSERVER = ParallelMessage.get().getMessage("UnitServerConsole.HttpServer");
    }

    public UnitServerConsole(String specifyHost, int specifyPort) {
        this.setTitle(UNITSERVER);
        this.specifyHost = specifyHost;
        this.specifyPort = specifyPort;
        ImageIcon ii = UnitServerConsole.getImageIcon();
        this.setIconImage(ii.getImage());
        GV.appFrame = this;
        this.rqInit();
        this.restLangText();
        this.refreshUI();
        this.publicConsole = this.generateConsole();
        this.autoStart();
        this.setSize(800, 600);
        GM.setDialogDefaultButton(this, this.jBQuit, this.jBQuit);
    }

    private JScrollPane generateConsole() {
        this.currentTA = new JTextArea();
        this.currentTA.setBackground(Color.black);
        this.currentTA.setForeground(Color.white);
        this.currentTA.setEditable(false);
        this.currentTA.setFont(new Font("Dialog", 0, ConfigOptions.iFontSize.intValue()));
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.getViewport().add((Component)this.currentTA, null);
        jScrollPane1.setAutoscrolls(true);
        this.panelUnit.add((Component)jScrollPane1, "Center");
        this.console = new Console(this.currentTA, null);
        return jScrollPane1;
    }

    private void autoStart() {
        ConfigFile sysConfig = ConfigFile.getSystemConfigFile();
        String nodeEnabled = null;
        String odbcEnabled = null;
        String httpEnabled = null;
        if (sysConfig != null) {
            nodeEnabled = sysConfig.getAttrValue("nodeEnabled");
            odbcEnabled = sysConfig.getAttrValue("odbcEnabled");
            httpEnabled = sysConfig.getAttrValue("httpEnabled");
        }
        boolean nb = true;
        boolean ob = true;
        boolean hb = true;
        if (StringUtils.isValidString(nodeEnabled)) {
            nb = Boolean.parseBoolean(nodeEnabled);
        }
        if (StringUtils.isValidString(odbcEnabled)) {
            ob = Boolean.parseBoolean(odbcEnabled);
        }
        if (StringUtils.isValidString(httpEnabled)) {
            hb = Boolean.parseBoolean(httpEnabled);
        }
        try {
            this.httpServer = SplxServerInIDE.getInstance();
            if (hb) {
                if (this.httpServer.isAutoStart()) {
                    this.doStart();
                }
                this.tabServer.setSelectedIndex(2 - this.indexBase());
            }
        }
        catch (Exception exception) {}
        try {
            while (this.isServerStarting) {
                Thread.yield();
            }
            if (this.isEE()) {
                this.unitServer = this.getUnitServerInstance(this.specifyHost, this.specifyPort);
                if (nb) {
                    if (this.unitServer.isAutoStart()) {
                        this.doStart();
                    }
                    this.tabServer.setSelectedIndex(this.indexBase());
                }
            }
        }
        catch (Exception exception) {}
        try {
            while (this.isServerStarting) {
                Thread.yield();
            }
            this.odbcServer = OdbcServer.getInstance();
            if (ob) {
                if (this.odbcServer.isAutoStart()) {
                    this.doStart();
                }
                this.tabServer.setSelectedIndex(1 - this.indexBase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isEE()) {
            this.tabServer.setEnabledAt(this.indexBase(), nb);
        }
        this.tabServer.setEnabledAt(1 - this.indexBase(), ob);
        this.tabServer.setEnabledAt(2 - this.indexBase(), hb);
        boolean b = nb || ob || hb;
        this.jBStart.setEnabled(b);
    }

    private static ImageIcon getImageIcon() {
        ImageIcon ii = GM.getImageIcon("com/scudata/ide/common/resources/unitserver.gif");
        return ii;
    }

    private void restLangText() {
        UNITSERVER = ParallelMessage.get().getMessage("UnitServerConsole.UnitServer");
        ODBCSERVER = ParallelMessage.get().getMessage("UnitServerConsole.OdbcServer");
        HTTPSERVER = ParallelMessage.get().getMessage("UnitServerConsole.HttpServer");
        if (this.isEE()) {
            this.tabServer.setTitleAt(this.indexBase(), UNITSERVER);
            this.tabServer.setToolTipTextAt(this.indexBase(), UNITSERVER);
        }
        this.tabServer.setTitleAt(1 - this.indexBase(), ODBCSERVER);
        this.tabServer.setToolTipTextAt(1 - this.indexBase(), ODBCSERVER);
        this.tabServer.setTitleAt(2 - this.indexBase(), HTTPSERVER);
        this.tabServer.setToolTipTextAt(2 - this.indexBase(), HTTPSERVER);
        this.setTitle(UNITSERVER);
        this.jBStart.setText(ParallelMessage.get().getMessage("UnitServerConsole.start"));
        this.jBReset.setText(ParallelMessage.get().getMessage("UnitServerConsole.reset"));
        this.jBStatus.setText(ParallelMessage.get().getMessage("UnitServerConsole.status"));
        this.jBStop.setText(ParallelMessage.get().getMessage("UnitServerConsole.stop"));
        this.jBQuit.setText(ParallelMessage.get().getMessage("UnitServerConsole.quit"));
        this.jBCopy.setText(ParallelMessage.get().getMessage("UnitServerConsole.copy"));
        this.jBClean.setText(ParallelMessage.get().getMessage("UnitServerConsole.clean"));
        this.jBConfig.setText(ParallelMessage.get().getMessage("UnitServerConsole.config"));
        MessageManager imm = IdeCommonMessage.get();
        this.jBOptions.setText(imm.getMessage("menu.configure.options"));
    }

    public synchronized void doStart() {
        this.setServerStatus(true);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    UnitServerConsole.this.enableStart(false);
                    UnitServerConsole.this.clickStart();
                }
                catch (Exception x) {
                    UnitServerConsole.this.enableStart(true);
                    UnitServerConsole.this.setServerStatus(false);
                    System.out.println(x.getMessage());
                }
            }
        };
        t.start();
    }

    private void autoHaltServer(final IServer server) {
        Thread t = new Thread(){

            @Override
            public void run() {
                server.shutDown();
                while (server.isRunning()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (server == UnitServerConsole.this.unitServer) {
                    Env.clearParam();
                }
            }
        };
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void shutDown() {
        IServer[] servers;
        IServer[] iServerArray = servers = new IServer[]{this.unitServer, this.odbcServer, this.httpServer};
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server != this.currentServer) {
                this.autoHaltServer(server);
            }
            ++n2;
        }
        this.doStop();
    }

    @Override
    public void doStop() {
        this.jBStop.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                UnitServerConsole.this.currentServer.shutDown();
                while (UnitServerConsole.this.currentServer.isRunning()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                UnitServerConsole.this.enableStart(true);
                UnitServerConsole.this.jBReset.setEnabled(false);
                UnitServerConsole.this.jBStatus.setEnabled(false);
                UnitServerConsole.this.resetStatus(0);
                if (UnitServerConsole.this.currentServer == UnitServerConsole.this.unitServer) {
                    Env.clearParam();
                }
            }
        }.start();
    }

    boolean webStartUnitServer() throws Exception {
        this.tabServer.setSelectedIndex(0);
        this.startedByWeb = true;
        return this.clickStart();
    }

    boolean isWebUnitServerRunning() {
        if (this.unitServer == null) {
            return false;
        }
        return this.unitServer.isRunning();
    }

    boolean webStopUnitServer() throws Exception {
        this.tabServer.setSelectedIndex(0);
        this.doStop();
        return true;
    }

    private int getSelectedIndex() {
        int index = this.tabServer.getSelectedIndex() + this.indexBase();
        return index;
    }

    public synchronized boolean clickStart() throws Exception {
        RaqsoftConfig rc = null;
        try {
            rc = ServerConsole.loadRaqsoftConfig();
        }
        catch (Exception x) {
            x.printStackTrace();
            return false;
        }
        int index = this.getSelectedIndex();
        this.enableStart(false);
        switch (index) {
            case 0: {
                try {
                    this.unitServer = this.getUnitServerInstance(this.specifyHost, this.specifyPort);
                    this.unitServer.setRaqsoftConfig(rc);
                }
                catch (Exception x) {
                    this.enableStart(true);
                    throw x;
                }
                this.currentServer = this.unitServer;
                break;
            }
            case 1: {
                try {
                    this.odbcServer = OdbcServer.getInstance();
                    this.odbcServer.setRaqsoftConfig(rc);
                }
                catch (Exception e) {
                    this.enableStart(true);
                    throw e;
                }
                this.currentServer = this.odbcServer;
                break;
            }
            default: {
                try {
                    this.httpServer = SplxServerInIDE.getInstance();
                    this.httpServer.setRaqsoftConfig(rc);
                }
                catch (Throwable e) {
                    this.enableStart(true);
                    throw new Exception(e.getMessage());
                }
                this.currentServer = this.httpServer;
            }
        }
        this.currentServer.setStartUnitListener(this);
        Thread t = new Thread(this.currentServer);
        t.start();
        return true;
    }

    private void resetStatus(int atPort) {
        String title;
        String tabTitle;
        boolean isLive = this.currentServer == null ? false : this.currentServer.isRunning();
        String status = isLive ? "[" + atPort + "] " : "";
        int index = this.getSelectedIndex();
        if (isLive) {
            tabTitle = String.valueOf(this.currentServerName.substring(0, 6)) + status;
            title = String.valueOf(this.currentServerName.substring(0, 6)) + this.currentServer.getHost();
        } else {
            title = tabTitle = this.currentServerName;
        }
        this.tabServer.setTitleAt(index - this.indexBase(), tabTitle);
        this.tabServer.setToolTipTextAt(index - this.indexBase(), title);
        this.setTitle(title);
        this.refreshUI();
    }

    private Color getStatusColor(IServer server) {
        return this.isServerRunning(server) ? this.runColor : this.stopColor;
    }

    private boolean isServerRunning(IServer server) {
        if (server == null) {
            return false;
        }
        return server.isRunning();
    }

    private void refreshUI() {
        if (this.isEE()) {
            this.tabServer.setForegroundAt(this.indexBase(), this.getStatusColor(this.unitServer));
        }
        this.tabServer.setForegroundAt(1 - this.indexBase(), this.getStatusColor(this.odbcServer));
        this.tabServer.setForegroundAt(2 - this.indexBase(), this.getStatusColor(this.httpServer));
        boolean isAllStoped = true;
        if (this.isServerRunning(this.unitServer)) {
            isAllStoped = false;
        }
        if (this.isServerRunning(this.odbcServer)) {
            isAllStoped = false;
        }
        if (this.isServerRunning(this.httpServer)) {
            isAllStoped = false;
        }
        this.jBQuit.setEnabled(isAllStoped);
    }

    private void resetButtons() {
        boolean isLive = this.currentServer == null ? false : this.currentServer.isRunning();
        this.enableStart(!isLive);
        this.jBReset.setEnabled(isLive);
        this.jBStatus.setEnabled(isLive);
        this.jBStop.setEnabled(isLive);
        ArrayList<IServer> servers = new ArrayList<IServer>();
        servers.add(this.unitServer);
        servers.add(this.odbcServer);
        servers.add(this.httpServer);
        this.jBQuit.setEnabled(!ServerConsole.isRunning(servers));
    }

    private void rqInit() {
        this.panelMain.setLayout(this.borderLayout1);
        this.jBStart.setMnemonic('S');
        this.jBStart.setText("Start");
        this.jBStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnitServerConsole.this.doStart();
            }
        });
        this.jBReset.setMnemonic('R');
        this.jBReset.setText("Reset");
        this.jBReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Env.clearParam();
                DfxManager.getInstance().clear();
                UnitServer.init(0, 0, null, false);
                System.gc();
            }
        });
        this.jBStatus.setMnemonic('U');
        this.jBStatus.setText("Status");
        final UnitServerConsole pFrame = this;
        this.jBStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuffer sb = new StringBuffer();
                sb.append("Release date:2025-08-01\r\n\r\n");
                sb.append("Databases:\r\n");
                Map<String, ISessionFactory> dbs = Env.getDBSessionFactories();
                if (dbs != null && dbs.size() > 0) {
                    Object[] dbList = dbs.keySet().toArray();
                    int dbCount = dbList.length;
                    int n = 0;
                    while (n < dbCount) {
                        String dbName = dbList[n].toString();
                        sb.append("\t");
                        sb.append(dbName);
                        sb.append("\r\n");
                        ++n;
                    }
                } else {
                    sb.append("\t");
                    sb.append("None");
                    sb.append("\r\n");
                }
                sb.append("\r\nMain path:\r\n");
                sb.append("\t" + Env.getMainPath());
                sb.append("\r\n");
                sb.append("\r\nDfx paths:\r\n");
                String[] paths = Env.getPaths();
                if (paths != null) {
                    int i = 0;
                    while (i < paths.length) {
                        sb.append("\t");
                        sb.append(paths[i]);
                        sb.append("\r\n");
                        ++i;
                    }
                } else {
                    sb.append("\t");
                    sb.append("None");
                    sb.append("\r\n");
                }
                sb.append("\r\nTemporary file path:\r\n");
                sb.append("\t");
                String buf = Env.getTempPath();
                if (StringUtils.isValidString(buf)) {
                    buf = "None";
                }
                sb.append(buf);
                sb.append("\r\n");
                if (UnitServerConsole.this.unitServer != null && UnitServerConsole.this.unitServer.getUnitContext() != null) {
                    sb.append("\r\nLog file path:\r\n");
                    sb.append("\t");
                    sb.append(UnitServerConsole.this.unitServer.getUnitContext().getLogFile());
                    sb.append("\r\n");
                }
                sb.append("\r\nLicense parallel:\r\n");
                sb.append("\t");
                sb.append(Env.getParallelNum());
                sb.append("\r\n");
                sb.append("\r\nMemory zone:\r\n");
                sb.append("\t");
                Map<String, Integer> areaNo = Env.getAreaNo();
                if (areaNo.isEmpty()) {
                    sb.append("None");
                } else {
                    for (String key : areaNo.keySet()) {
                        Integer val = areaNo.get(key);
                        sb.append(" " + key + "=" + val + "\r\n");
                    }
                }
                sb.append("\r\n");
                sb.append("\r\nJob spaces:\r\n");
                sb.append("\t");
                ArrayList<JobSpace> spaces = JobSpaceManager.currentSpaces();
                if (spaces.size() > 0) {
                    int i = 0;
                    while (i < spaces.size()) {
                        JobSpace js = spaces.get(i);
                        sb.append("\t");
                        sb.append(js.description());
                        sb.append("\r\n");
                        ++i;
                    }
                } else {
                    sb.append("\t");
                    sb.append("None");
                    sb.append("\r\n");
                }
                sb.append("\r\nTask ID:\r\n");
                sb.append("\t");
                List<ITask> tasks = TaskManager.getTaskList();
                if (tasks.size() > 0) {
                    int i = 0;
                    while (i < tasks.size()) {
                        ITask task = tasks.get(i);
                        sb.append("\t");
                        sb.append(task.toString());
                        sb.append("\r\n");
                        ++i;
                    }
                } else {
                    sb.append("\t");
                    sb.append("None");
                    sb.append("\r\n");
                }
                sb.append("\r\nOpened remote files:\r\n");
                sb.append("\t");
                ArrayList<RemoteFileProxy> remoteFiles = RemoteFileProxyManager.getFileProxys();
                if (remoteFiles.size() > 0) {
                    int i = 0;
                    while (i < remoteFiles.size()) {
                        RemoteFileProxy proxy = remoteFiles.get(i);
                        sb.append("\t");
                        sb.append(proxy.toString());
                        sb.append("\r\n");
                        ++i;
                    }
                } else {
                    sb.append("\t");
                    sb.append("None");
                    sb.append("\r\n");
                }
                sb.append("\r\nGlobal variants:\r\n");
                ParamList paras = Env.getParamList();
                if (paras != null && paras.count() > 0) {
                    int i = 0;
                    while (i < paras.count()) {
                        Param pa = paras.get(i);
                        sb.append("\t");
                        sb.append(pa.getName());
                        sb.append(" = ");
                        sb.append(Variant.toString(pa.getValue()));
                        sb.append("\r\n");
                        ++i;
                    }
                } else {
                    sb.append("\t");
                    sb.append("None");
                    sb.append("\r\n");
                }
                if (UnitServerConsole.this.httpServer != null) {
                    sb.append("\r\n[ HttpServer ] visit url:\r\n");
                    sb.append("\t");
                    String httpUrl = UnitServerConsole.this.httpServer.getContext().getDefaultUrl();
                    sb.append(httpUrl);
                    sb.append("\r\n");
                }
                sb.append("\r\nMemory status:\r\n");
                DecimalFormat df = new DecimalFormat("###,###");
                long unit = 1024L;
                long total = Runtime.getRuntime().totalMemory();
                sb.append("\tVM Memory:    " + df.format(total / unit) + " KB\r\n");
                long tmp = Runtime.getRuntime().freeMemory();
                sb.append("\tCurrent used: " + df.format(new Long((total - tmp) / unit)) + " KB\r\n");
                DialogInputText dit = new DialogInputText(pFrame, "Status", false);
                dit.setSize(500, 340);
                dit.setText(sb.toString());
                dit.setIconImage(UnitServerConsole.getImageIcon().getImage());
                dit.setVisible(true);
            }
        });
        this.jBStop.setMnemonic('T');
        this.jBStop.setText("Stop");
        this.jBStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnitServerConsole.this.doStop();
            }
        });
        this.jBReset.setEnabled(false);
        this.jBStatus.setEnabled(false);
        this.jBStop.setEnabled(false);
        this.jBQuit.setMnemonic('Q');
        this.jBQuit.setText("Quit");
        this.jBQuit.addActionListener(new ServerConsole_jBQuit_actionAdapter(this));
        this.jPanel1.setLayout(this.verticalFlowLayout1);
        this.jBCopy.setMnemonic('C');
        this.jBCopy.setText("Copy");
        this.jBCopy.addActionListener(new ServerConsole_jBCopy_actionAdapter(this));
        this.jBClean.setMnemonic('E');
        this.jBClean.setText("Clean");
        this.jBClean.setVerticalAlignment(0);
        this.jBClean.addActionListener(new ServerConsole_jBClean_actionAdapter(this));
        this.jBConfig.setMnemonic('F');
        this.jBConfig.setText("Config");
        this.jBConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnitServerConsole.this.editConfig();
            }
        });
        this.jBOptions.setMnemonic('O');
        this.jBOptions.setText("Options");
        this.jBOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnitServerConsole.this.editOption();
            }
        });
        this.panelUnit.setLayout(new BorderLayout());
        this.panelOdbc.setLayout(new BorderLayout());
        this.panelHttp.setLayout(new BorderLayout());
        if (this.isEE()) {
            this.tabServer.addTab(UNITSERVER, this.panelUnit);
            this.tabServer.setToolTipTextAt(this.indexBase(), UNITSERVER);
        }
        this.tabServer.addTab(ODBCSERVER, this.panelOdbc);
        this.tabServer.setToolTipTextAt(1 - this.indexBase(), ODBCSERVER);
        this.tabServer.addTab(HTTPSERVER, this.panelHttp);
        this.tabServer.setToolTipTextAt(2 - this.indexBase(), HTTPSERVER);
        this.tabServer.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = UnitServerConsole.this.getSelectedIndex();
                if (index == 0) {
                    UnitServerConsole.this.currentServer = UnitServerConsole.this.unitServer;
                    UnitServerConsole.this.currentServerName = UNITSERVER;
                    UnitServerConsole.this.panelUnit.add((Component)UnitServerConsole.this.publicConsole, "Center");
                } else if (index == 1) {
                    UnitServerConsole.this.currentServer = UnitServerConsole.this.odbcServer;
                    UnitServerConsole.this.currentServerName = ODBCSERVER;
                    UnitServerConsole.this.panelOdbc.add((Component)UnitServerConsole.this.publicConsole, "Center");
                } else {
                    UnitServerConsole.this.currentServer = UnitServerConsole.this.httpServer;
                    UnitServerConsole.this.currentServerName = HTTPSERVER;
                    UnitServerConsole.this.panelHttp.add((Component)UnitServerConsole.this.publicConsole, "Center");
                }
                UnitServerConsole.this.setTitle(UnitServerConsole.this.tabServer.getToolTipTextAt(index - UnitServerConsole.this.indexBase()));
                UnitServerConsole.this.resetButtons();
            }
        });
        this.panelMain.add((Component)this.tabServer, "Center");
        this.panelMain.add((Component)this.jPanel1, "East");
        this.jPanel1.add(this.jBStart);
        this.jPanel1.add(this.jBStop);
        this.jPanel1.add(new JLabel(" "));
        this.jPanel1.add(this.jBReset);
        this.jPanel1.add(this.jBStatus);
        this.jPanel1.add(this.jBCopy);
        this.jPanel1.add(this.jBClean);
        this.jPanel1.add(this.jBConfig);
        this.jPanel1.add(this.jBOptions);
        this.jPanel1.add(new JLabel(" "));
        this.jPanel1.add(this.jBQuit);
        this.getContentPane().add(this.panelMain);
        this.setDefaultCloseOperation(0);
    }

    private void editConfig() {
        try {
            int index = this.getSelectedIndex();
            if (index == 0) {
                DialogUnitConfig duc = new DialogUnitConfig(this, this.tabServer.getTitleAt(0));
                duc.setVisible(true);
            } else if (index == 1) {
                DialogOdbcConfig djc = new DialogOdbcConfig(this, this.tabServer.getTitleAt(1 - this.indexBase()));
                djc.setVisible(true);
            } else {
                DialogInputPort dip = new DialogInputPort(this, this.tabServer.getTitleAt(2 - this.indexBase()));
                dip.setVisible(true);
            }
        }
        catch (Throwable x) {
            GM.showException(GV.appFrame, x);
        }
    }

    private void editOption() {
        try {
            DialogOptions dialogOptions = new DialogOptions(this, true);
            dialogOptions.setVisible(true);
            if (dialogOptions.getOption() == 0) {
                this.currentTA.setFont(new Font("Dialog", 0, ConfigOptions.iFontSize.intValue()));
            }
        }
        catch (Throwable x) {
            GM.showException(GV.appFrame, x);
        }
    }

    @Override
    public void quit() {
    }

    void jBQuit_actionPerformed(ActionEvent e) {
        this.quit();
        this.dispose();
        if (!this.startedByWeb) {
            System.exit(0);
        }
    }

    void jBCopy_actionPerformed(ActionEvent e) {
        this.currentTA.copy();
    }

    void jBClean_actionPerformed(ActionEvent e) {
        this.console.clear();
    }

    public static Object[] prepareArgs(String[] args) {
        String buf;
        UnitServerConsole.initLang();
        Logger.info(ParallelMessage.get().getMessage("UnitServer.run2", UnitServer.getHome()));
        boolean isGraph = true;
        String specifyHost = null;
        int specifyPort = 0;
        Section sect = new Section();
        int i = 0;
        while (i < args.length) {
            buf = args[i];
            if (buf.indexOf(" ") > -1) {
                StringTokenizer st = new StringTokenizer(buf, " ");
                while (st.hasMoreTokens()) {
                    sect.addSection(st.nextToken());
                }
            } else {
                sect.addSection(buf);
            }
            ++i;
        }
        args = sect.toStringArray();
        i = 0;
        while (i < args.length) {
            buf = args[i];
            if ("-b".equalsIgnoreCase(buf)) {
                isGraph = false;
            } else {
                int index = buf.indexOf(58);
                if (index > 0 && specifyHost == null) {
                    specifyHost = buf.substring(0, index).trim();
                    specifyPort = Integer.parseInt(buf.substring(index + 1).trim());
                }
            }
            ++i;
        }
        return new Object[]{specifyHost, specifyPort, isGraph};
    }

    public static void main(String[] args) {
        Object[] obj = UnitServerConsole.prepareArgs(args);
        String specifyHost = (String)obj[0];
        int specifyPort = (Integer)obj[1];
        boolean isGraph = (Boolean)obj[2];
        if (isGraph) {
            ServerConsole.setDefaultLNF();
            try {
                ConfigOptions.load2(false, false);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            UnitServerConsole usc = new UnitServerConsole(specifyHost, specifyPort);
            usc.setVisible(true);
            if (specifyHost != null) {
                try {
                    usc.clickStart();
                }
                catch (Exception x) {
                    usc.jBQuit_actionPerformed(null);
                }
            }
        } else {
            try {
                throw new Exception("Current version does not support Node Server");
            }
            catch (Exception x) {
                x.printStackTrace();
                System.exit(0);
            }
        }
    }

    public void toTop() {
        this.setAlwaysOnTop(true);
    }

    @Override
    public synchronized void serverStarted(int atPort) {
        this.resetButtons();
        this.resetStatus(atPort);
        this.setServerStatus(false);
    }

    public void disableStart() {
        this.disableStart = true;
        this.jBStart.setEnabled(false);
    }

    private void enableStart(boolean en) {
        if (this.disableStart) {
            this.jBStart.setEnabled(false);
            return;
        }
        this.jBStart.setEnabled(en);
        this.jBConfig.setEnabled(en);
    }

    @Override
    public synchronized void serverStartFail() {
        this.enableStart(true);
        this.setServerStatus(false);
    }

    @Override
    public String getProductName() {
        return UNITSERVER;
    }

    @Override
    public boolean exit() {
        return false;
    }

    @Override
    public JInternalFrame openSheetFile(String fileName) throws Exception {
        return null;
    }

    @Override
    public void changeMenuAndToolBar(JMenuBar menu, JToolBar toolBar) {
    }

    @Override
    public boolean closeSheet(Object sheet) {
        return false;
    }

    @Override
    public boolean closeAll() {
        return false;
    }
}

