/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.CellLocation;
import com.scudata.common.Logger;
import com.scudata.dm.Context;
import com.scudata.dm.JobSpaceManager;
import com.scudata.ide.spl.Esprocx;
import com.scudata.resources.ParallelMessage;
import com.scudata.util.CellSetUtil;
import com.scudata.util.DatabaseUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;

class Worker
extends Thread {
    PgmCellSet pcs;
    String[] argArr = null;
    boolean printResult = false;

    public Worker(PgmCellSet pcs, ArrayList<String> argstr, boolean printResult) {
        this.pcs = (PgmCellSet)pcs.deepClone();
        if (!argstr.isEmpty()) {
            this.argArr = new String[argstr.size()];
            int i = 0;
            while (i < argstr.size()) {
                this.argArr[i] = argstr.get(i);
                ++i;
            }
        }
        this.printResult = printResult;
    }

    @Override
    public void run() {
        Context context = AppUtil.prepareEnv(null);
        this.pcs.setContext(context);
        try {
            try {
                CellSetUtil.putArgStringValue(this.pcs, this.argArr);
                long taskBegin = System.currentTimeMillis();
                Logger.debug(ParallelMessage.get().getMessage("Task.taskBegin", ""));
                if (this.printResult) {
                    this.pcs.calculateResult();
                    while (this.pcs.hasNextResult()) {
                        CellLocation cl = this.pcs.nextResultLocation();
                        System.out.println();
                        if (cl != null) {
                            String msg = cl + ":";
                            System.err.println(msg);
                        }
                        Object result = this.pcs.nextResult();
                        Esprocx.printResult(result);
                    }
                } else {
                    this.pcs.run();
                }
                long finishTime = System.currentTimeMillis();
                DecimalFormat df = new DecimalFormat("###,###");
                long lastTime = finishTime - taskBegin;
                Logger.debug(ParallelMessage.get().getMessage("Task.taskEnd", "", df.format(lastTime)));
                Esprocx.addFinish();
            }
            catch (Exception x) {
                String sid;
                Logger.severe(x);
                x.printStackTrace();
                if (context.getJobSpace() != null && (sid = context.getJobSpace().getID()) != null) {
                    JobSpaceManager.closeSpace(sid);
                }
                DatabaseUtil.closeAutoDBs(context);
            }
        }
        finally {
            String sid;
            if (context.getJobSpace() != null && (sid = context.getJobSpace().getID()) != null) {
                JobSpaceManager.closeSpace(sid);
            }
            DatabaseUtil.closeAutoDBs(context);
        }
    }
}

