/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.swing.TristateCheckBox;
import com.scudata.ide.spl.base.FileTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class FileTreeRender
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        FileTreeNode node = (FileTreeNode)value;
        if (node.isCheckNode()) {
            return this.getCheckNodePanel(tree, node, sel);
        }
        return this.setSelectBackgroundColor(tree, node, sel);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(d.width + 5, d.height);
    }

    private JPanel getCheckNodePanel(JTree tree, FileTreeNode node, boolean sel) {
        JPanel panel = new JPanel(new BorderLayout());
        TristateCheckBox check = new TristateCheckBox();
        switch (node.getSelectedState()) {
            case 0: {
                check.setState(TristateCheckBox.NOT_SELECTED);
                break;
            }
            case 1: {
                check.setState(TristateCheckBox.SELECTED);
                break;
            }
            case 2: {
                check.setState(TristateCheckBox.DONT_CARE);
            }
        }
        check.setForeground(tree.getForeground());
        check.setBackground(tree.getBackground());
        panel.add((Component)check, "West");
        JLabel labelIcon = new JLabel(node.getDispIcon());
        panel.add((Component)labelIcon, "Center");
        JLabel labelName = new JLabel("  " + node.getName());
        panel.add((Component)labelName, "East");
        if (sel) {
            Color backColor = ConfigOptions.getFileColor() != null ? ConfigOptions.getFileColor() : new DefaultTreeCellRenderer().getBackgroundSelectionColor();
            panel.setBackground(backColor);
            check.setBackground(backColor);
            labelIcon.setBackground(backColor);
            labelName.setBackground(backColor);
        } else {
            labelIcon.setBackground(tree.getBackground());
            labelName.setBackground(tree.getBackground());
            panel.setBackground(tree.getBackground());
            check.setBackground(tree.getBackground());
        }
        labelIcon.setForeground(tree.getForeground());
        labelName.setForeground(tree.getForeground());
        panel.setForeground(tree.getForeground());
        check.setForeground(tree.getForeground());
        return panel;
    }

    private JPanel setSelectBackgroundColor(JTree tree, FileTreeNode node, boolean sel) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel labelIcon = new JLabel(node.getDispIcon());
        panel.add((Component)labelIcon, "Center");
        JLabel labelName = new JLabel("  " + node.getName());
        panel.add((Component)labelName, "East");
        if (sel) {
            Color backColor;
            if (StringUtils.isValidString(ConfigOptions.fileColor)) {
                String bgColor = ConfigOptions.fileColor;
                int red = Integer.parseInt(bgColor.substring(1, 3), 16);
                int green = Integer.parseInt(bgColor.substring(3, 5), 16);
                int blue = Integer.parseInt(bgColor.substring(5, 7), 16);
                int opacity = StringUtils.isValidString(ConfigOptions.fileColorOpacity) ? Math.round(255.0f * Float.parseFloat(ConfigOptions.fileColorOpacity)) : 255;
                backColor = new Color(red, green, blue, opacity);
            } else {
                backColor = new DefaultTreeCellRenderer().getBackgroundSelectionColor();
            }
            panel.setBackground(backColor);
            labelIcon.setBackground(backColor);
            labelName.setBackground(backColor);
        } else {
            Color backColor = tree.getBackground();
            labelIcon.setBackground(backColor);
            labelName.setBackground(backColor);
            panel.setBackground(backColor);
        }
        labelIcon.setForeground(tree.getForeground());
        labelName.setForeground(tree.getForeground());
        panel.setForeground(tree.getForeground());
        return panel;
    }
}

