/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GVSplSE;
import com.scudata.ide.spl.base.FileTree;
import com.scudata.ide.spl.base.FileTreeNode;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class FileTreeSE
extends FileTree {
    private static final long serialVersionUID = 1L;
    public static final byte FILE_SEARCH = 21;

    @Override
    protected JMenuItem getMenuItem(byte action, ActionListener al) {
        String imgPath;
        String title;
        JMenuItem mi = super.getMenuItem(action, al);
        if (mi != null) {
            return mi;
        }
        switch (action) {
            case 21: {
                title = mm.getMessage("filetree.searchdir");
                imgPath = "m_search.gif";
                break;
            }
            default: {
                return null;
            }
        }
        mi = new JMenuItem(title);
        mi.setName(String.valueOf(action));
        if (imgPath != null) {
            mi.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/" + imgPath));
        }
        mi.addActionListener(al);
        return mi;
    }

    @Override
    protected void menuAction(FileTreeNode node, JMenuItem mi) {
        super.menuAction(node, mi);
        this.nodeSelected(node);
        String sAction = mi.getName();
        byte action = Byte.parseByte(sAction);
        switch (action) {
            case 21: {
                try {
                    if (!node.isLoaded()) {
                        this.treeNodeWillExpand(node);
                    }
                    GVSplSE.jSPFileTree.searchFiles(node);
                }
                catch (Throwable t) {
                    GMSpl.showException(GV.appFrame, t);
                }
                return;
            }
        }
    }

    @Override
    protected JPopupMenu getPopupMenu(FileTreeNode node) {
        FileTree.MenuListener menuListener = new FileTree.MenuListener(node);
        JPopupMenu popMenu = new JPopupMenu();
        if (node.isDir()) {
            popMenu.add(this.getMenuItem((byte)2, menuListener));
            popMenu.add(this.getMenuItem((byte)4, menuListener));
            popMenu.add(this.getMenuItem((byte)21, menuListener));
        } else {
            popMenu.add(this.getMenuItem((byte)1, menuListener));
            popMenu.add(this.getMenuItem((byte)3, menuListener));
        }
        popMenu.add(this.getMenuItem((byte)5, menuListener));
        return popMenu;
    }

    @Override
    public void showNode(FileTreeNode node) {
        if (node != null && node.isDir()) {
            try {
                if (!node.isLoaded()) {
                    this.treeNodeWillExpand(node);
                }
                GVSplSE.jSPFileTree.refreshFiles(node);
            }
            catch (Throwable t) {
                GMSpl.showException(GV.appFrame, t);
            }
        }
    }

    @Override
    protected void closeActiveNode() {
        GVSplSE.jSPFileTree.closeNode();
    }
}

