/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.common.DateFormatFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.custom.FileInfo;
import com.scudata.ide.spl.base.FileComparator;
import com.scudata.ide.spl.base.FileTreeNode;
import com.scudata.ide.spl.base.JTextFieldHint;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.ide.vdb.commonvdb.GM;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.JTableHeader;

public abstract class JPanelFileFilter
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<FileInfo> fileList;
    private Map<FileInfo, FileTreeNode> fileNodeMap;
    private FilterThread filterThread = null;
    private Map<Integer, Boolean> colOrderMap = new HashMap<Integer, Boolean>();
    private static MessageManager mm = IdeSplMessage.get();
    private static final String TYPE_SPLX = mm.getMessage("jpanelfilefilter.splfile", "SPLX");
    private static final String TYPE_SPL = mm.getMessage("jpanelfilefilter.splfile", "SPL");
    private static final String TYPE_DFX = mm.getMessage("jpanelfilefilter.splfile", "DFX");
    private static final String TYPE_DIR = mm.getMessage("jpanelfilefilter.typedir");
    private JTextFieldHint jTFFilter = new JTextFieldHint();
    private final int COL_INDEX = 0;
    private final int COL_NAME = 1;
    private final int COL_DATE = 2;
    private final int COL_TYPE = 3;
    private final int COL_FILE_INFO = 4;
    private boolean preventChange = false;
    private final String TITLE_INDEX = mm.getMessage("public.index");
    private final String TITLE_NAME = mm.getMessage("jpanelfilefilter.filename");
    private final String TITLE_DATE = mm.getMessage("jpanelfilefilter.lastmodify");
    private final String TITLE_TYPE = mm.getMessage("jpanelfilefilter.type");
    private final String TITLE_FILE_INFO = "TITLE_FILE_INFO";
    private final String TITLE_DIR = mm.getMessage("jpanelfilefilter.dir");
    private JCheckBox jCBSub = new JCheckBox(mm.getMessage("jpanelfilefilter.containsub"));
    private JTableEx jTableFile = new JTableEx(new String[]{this.TITLE_INDEX, this.TITLE_NAME, this.TITLE_DATE, this.TITLE_TYPE, "TITLE_FILE_INFO"}){
        private static final long serialVersionUID = 1L;

        @Override
        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            if (row < 0) {
                return;
            }
            FileInfo fi = (FileInfo)this.data.getValueAt(row, 4);
            FileTreeNode node = (FileTreeNode)JPanelFileFilter.this.fileNodeMap.get(fi);
            if (node != null && !node.isDir()) {
                JPanelFileFilter.this.openFile(node);
            }
        }
    };

    public JPanelFileFilter() {
        super(new GridBagLayout());
        this.initUI();
    }

    public void searchFiles(String dir, List<FileTreeNode> nodes) {
        this.setFiles(dir, nodes, true);
    }

    public void refreshFiles(String dir, List<FileTreeNode> nodes) {
        this.setFiles(dir, nodes, false);
    }

    public void closeNode() {
        try {
            this.preventChange = true;
            this.jTFFilter.setText(null);
            this.jTFFilter.setHintText(null);
            this.fileList = new ArrayList<FileInfo>();
            this.fileNodeMap = new HashMap<FileInfo, FileTreeNode>();
            this.colOrderMap.clear();
            this.jTableFile.acceptText();
            this.jTableFile.removeAllRows();
            this.jTableFile.clearSelection();
        }
        finally {
            this.preventChange = false;
        }
    }

    private void setFiles(String dir, List<FileTreeNode> nodes, boolean isSearch) {
        try {
            this.preventChange = true;
            if (isSearch) {
                this.jTFFilter.setText(null);
            }
            String dirName = new File(dir).getName();
            this.jTFFilter.setHintText(mm.getMessage("jpanelfilefilter.searchdirtip", dirName));
            if (isSearch) {
                this.jTFFilter.requestFocus();
            }
        }
        finally {
            this.preventChange = false;
        }
        if (!isSearch && StringUtils.isValidString(this.jTFFilter.getRealText())) {
            return;
        }
        this.colOrderMap.clear();
        this.initFileList(nodes);
        this.showFiles();
    }

    public abstract void openFile(FileTreeNode var1);

    private void initFileList(List<FileTreeNode> nodes) {
        this.fileList = new ArrayList<FileInfo>();
        this.fileNodeMap = new HashMap<FileInfo, FileTreeNode>();
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        for (FileTreeNode node : nodes) {
            FileInfo fi;
            Object data = node.getUserObject();
            if (data == null) continue;
            if (data instanceof FileInfo) {
                fi = (FileInfo)data;
            } else {
                if (!(data instanceof String)) continue;
                fi = new FileInfo();
                File file = new File((String)data);
                fi.setFilename(file.getName());
                fi.setLastModified(file.lastModified());
                fi.setType(file.isDirectory() ? 1 : 0);
            }
            this.fileList.add(fi);
            this.fileNodeMap.put(fi, node);
        }
    }

    private void showFiles() {
        if (this.filterThread != null) {
            this.filterThread.stopThread();
            try {
                this.filterThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.filterThread = new FilterThread();
        SwingUtilities.invokeLater(this.filterThread);
    }

    public static String getFileType(FileInfo fi) {
        if (fi.isDirectory()) {
            return TYPE_DIR;
        }
        String fileName = fi.getFilename();
        if (fileName.toLowerCase().endsWith("splx")) {
            return TYPE_SPLX;
        }
        if (fileName.toLowerCase().endsWith("spl")) {
            return TYPE_SPL;
        }
        if (fileName.toLowerCase().endsWith("dfx")) {
            return TYPE_DFX;
        }
        return null;
    }

    private void initUI() {
        this.setMinimumSize(new Dimension(1, 1));
        this.add((Component)this.jTFFilter, GM.getGBC(0, 0, true));
        this.add((Component)new JScrollPane(this.jTableFile), GM.getGBC(1, 0, true, true));
        this.jTableFile.setIndexCol(0);
        this.jTableFile.setColumnEditable(1, false);
        this.jTableFile.setColumnEditable(2, false);
        JTableHeader header = this.jTableFile.getTableHeader();
        header.setToolTipText(mm.getMessage("jpanelfilefilter.labelsort"));
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int col = JPanelFileFilter.this.jTableFile.columnAtPoint(e.getPoint());
                    JPanelFileFilter.this.sort(col);
                }
            }
        });
        this.jTableFile.setColumnVisible("TITLE_FILE_INFO", false);
        this.jTFFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filterChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filterChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.filterChanged();
            }

            private void filterChanged() {
                if (JPanelFileFilter.this.preventChange) {
                    return;
                }
                JPanelFileFilter.this.showFiles();
            }
        });
    }

    private void sort(int col) {
        byte sortType;
        switch (col) {
            case 1: {
                sortType = 1;
                break;
            }
            case 2: {
                sortType = 2;
                break;
            }
            case 3: {
                sortType = 3;
                break;
            }
            default: {
                return;
            }
        }
        Boolean orderObj = this.colOrderMap.get(col);
        boolean isDesc = false;
        if (orderObj != null) {
            isDesc = orderObj;
        }
        Collections.sort(this.fileList, new FileComparator(sortType, isDesc));
        this.showFiles();
        this.colOrderMap.put(col, !isDesc);
    }

    class FilterThread
    extends Thread {
        private volatile boolean isStopped = false;

        public void stopThread() {
            this.isStopped = true;
        }

        @Override
        public void run() {
            JPanelFileFilter.this.jTableFile.acceptText();
            JPanelFileFilter.this.jTableFile.removeAllRows();
            JPanelFileFilter.this.jTableFile.clearSelection();
            Pattern p = null;
            String filter = JPanelFileFilter.this.jTFFilter.getRealText();
            if (StringUtils.isValidString(filter)) {
                try {
                    p = Pattern.compile(filter, 2);
                }
                catch (Exception e) {
                    return;
                }
            }
            for (FileInfo fi : JPanelFileFilter.this.fileList) {
                Matcher m;
                if (this.isStopped) {
                    return;
                }
                if (p != null && !(m = p.matcher(fi.getFilename())).find()) continue;
                Object[] rowData = new Object[]{new Integer(0), fi.getFilename(), DateFormatFactory.get().getDateTimeFormat().format(new Date(fi.getLastModified())), JPanelFileFilter.getFileType(fi), fi};
                JPanelFileFilter.this.jTableFile.insertRow(-1, rowData, false);
            }
            JPanelFileFilter.this.jTableFile.resetIndex();
            if (JPanelFileFilter.this.jTableFile.getRowCount() > 0) {
                JPanelFileFilter.this.jTableFile.selectRow(0);
            }
        }
    }
}

