/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.custom.FileInfo;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.GVSplSE;
import com.scudata.ide.spl.base.FileTreeNode;
import com.scudata.ide.spl.base.FileTreeSE;
import com.scudata.ide.spl.base.JPanelFileFilter;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class JSplitPaneFile
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private int lastFileLocation = -1;
    private static int FILE_SPLIT_GAP = 35;
    private JPanelFileFilter jPFileFilter;

    public JSplitPaneFile() {
        super(0);
        this.initUI();
    }

    public void searchFiles(FileTreeNode node) {
        this.setFiles(node, true);
    }

    public void refreshFiles(FileTreeNode node) {
        this.setFiles(node, false);
    }

    public void closeNode() {
        this.jPFileFilter.closeNode();
    }

    private void setFiles(FileTreeNode node, boolean isSearch) {
        Object data;
        if (isSearch) {
            int pos = this.getDividerLocation();
            int height = this.getHeight();
            if (height - pos <= FILE_SPLIT_GAP) {
                this.lastFileLocation = this.lastFileLocation == -1 ? Math.round((float)height * 0.55f) : this.lastFileLocation;
                this.setDividerLocation(this.lastFileLocation);
            }
        }
        String dirName = (data = node.getUserObject()) instanceof FileInfo ? new File(((FileInfo)data).getFilename()).getName() : (data instanceof String ? (String)data : node.getTitle());
        ArrayList<FileTreeNode> subNodes = new ArrayList<FileTreeNode>();
        int i = 0;
        int count = node.getChildCount();
        while (i < count) {
            subNodes.add((FileTreeNode)node.getChildAt(i));
            ++i;
        }
        if (isSearch) {
            this.jPFileFilter.searchFiles(dirName, subNodes);
        } else {
            this.jPFileFilter.refreshFiles(dirName, subNodes);
        }
    }

    public int getRealDividerLocation() {
        int dl = this.getDividerLocation();
        if (dl >= this.getHeight() - 5) {
            return -1;
        }
        return dl;
    }

    private void initUI() {
        this.setOneTouchExpandable(true);
        this.setDividerSize(8);
        this.setTopComponent(new JScrollPane(GVSpl.fileTree));
        this.jPFileFilter = new JPanelFileFilter(){
            private static final long serialVersionUID = 1L;

            @Override
            public void openFile(FileTreeNode node) {
                try {
                    ((FileTreeSE)GVSplSE.fileTree).openFile(node);
                }
                catch (Exception e) {
                    GM.showException(GV.appFrame, e);
                }
            }
        };
        this.setBottomComponent(this.jPFileFilter);
        int screenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int dl = (int)(0.4 * (double)screenHeight);
        this.setDividerLocation(dl);
        this.setDividerLocation(screenHeight);
    }
}

