/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JTextFieldHint
extends JTextField {
    private static final long serialVersionUID = 1L;
    private boolean preventChange = false;
    private String hintText = null;
    private String realText = null;

    public JTextFieldHint() {
        this.init();
    }

    public void setHintText(String str) {
        this.hintText = str;
        if (!this.isFocusOwner()) {
            this.resetHintText();
        }
    }

    public String getRealText() {
        return this.realText;
    }

    private void init() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.docUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.docUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.docUpdate();
            }

            private void docUpdate() {
                if (JTextFieldHint.this.preventChange) {
                    return;
                }
                JTextFieldHint.this.realText = JTextFieldHint.this.getText();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextFieldHint.this.setForeground(Color.BLACK);
                if (JTextFieldHint.this.isEmptyText(JTextFieldHint.this.realText)) {
                    try {
                        JTextFieldHint.this.preventChange = true;
                        JTextFieldHint.this.setText("");
                    }
                    finally {
                        JTextFieldHint.this.preventChange = false;
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                JTextFieldHint.this.resetHintText();
            }
        });
    }

    private void resetHintText() {
        if (this.isEmptyText(this.realText)) {
            this.setForeground(Color.GRAY);
            try {
                this.preventChange = true;
                this.setText(this.hintText);
            }
            finally {
                this.preventChange = false;
            }
        } else {
            this.setForeground(Color.BLACK);
        }
    }

    private boolean isEmptyText(String realText) {
        return realText == null || realText.equals("");
    }
}

