/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.dm.cursor.ICursor;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.ConfigUtilIde;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.DialogInputText;
import com.scudata.ide.common.dialog.DialogMissingFormat;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.dialog.DialogExtLibs;
import com.scudata.ide.spl.dialog.DialogOptions;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public abstract class PanelEnv
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final byte TYPE_ESPROC = 0;
    public static final byte TYPE_UNIT = 1;
    public static final byte TYPE_DQL = 2;
    protected JDialog parent;
    public JPanel panelFile;
    protected RaqsoftConfig config = GV.config;
    protected MessageManager mm = IdeCommonMessage.get();
    protected JLabel jLabelLog = new JLabel(this.mm.getMessage("dialogoptions.logfile"));
    protected JLabel jLabelSplPath = new JLabel(this.mm.getMessage("dialogoptions.dfxpath"));
    protected JLabel labelDate = new JLabel(this.mm.getMessage("dialogoptions.date"));
    protected JLabel labelTime = new JLabel(this.mm.getMessage("dialogoptions.time"));
    protected JLabel labelDateTime = new JLabel(this.mm.getMessage("dialogoptions.datetime"));
    protected JLabel jLabelCharset = new JLabel(this.mm.getMessage("dialogoptions.defcharset"));
    protected JLabel jLabelFetchCount = new JLabel(this.mm.getMessage("dialogoptions.labelfc"));
    protected JLabel labelFileBuffer = new JLabel(this.mm.getMessage("dialogoptions.filebuffer"));
    protected JLabel labelNullStrings = new JLabel(this.mm.getMessage("dialogoptions.nullstrings"));
    protected JLabel labelMainPath = new JLabel(this.mm.getMessage("dialogoptions.mainpath"));
    protected JLabel labelPathNote = new JLabel(this.mm.getMessage("dialogoptions.pathnote"));
    protected JLabel labelBlockSize = new JLabel(IdeSplMessage.get().getMessage("dialogoptions.stbs"));
    protected JLabel labelTempPath = new JLabel(this.mm.getMessage("dialogoptions.temppath"));
    protected JLabel jLInitSpl = new JLabel(this.mm.getMessage("dialogoptions.initdfx"));
    protected JLabel jLExtLibsPath = new JLabel(this.mm.getMessage("dialogoptions.extlibspath"));
    protected JLabel jLCustomFunctionFile = new JLabel(this.mm.getMessage("dialogoptions.customfunction"));
    protected JComboBoxEx jCBDate = new JComboBoxEx();
    protected JComboBoxEx jCBTime = new JComboBoxEx();
    protected JComboBoxEx jCBDateTime = new JComboBoxEx();
    protected JComboBoxEx jCBCharset = new JComboBoxEx();
    protected JTextField textFileBuffer = new JTextField();
    protected JTextField textNullStrings = new JTextField();
    protected JTextField jTFLogFileName = new JTextField();
    protected JTextField jTFPath = new JTextField();
    protected JComboBoxEx jTFMainPath = new JComboBoxEx();
    protected JTextField jTFTempPath = new JTextField();
    protected JTextField jTFExtLibsPath = new JTextField();
    protected JTextField jTFInitSpl = new JTextField();
    protected JButton jBLogFile = new JButton();
    protected JButton jBPath = new JButton();
    protected JButton jBMainPath = new JButton();
    protected JButton jBTempPath = new JButton();
    protected JButton jBExtLibsPath = new JButton();
    protected JButton jBInitSpl = new JButton();
    protected JButton jBCustomFunctionFile = new JButton();
    protected JTextField textBlockSize = new JTextField();
    protected JTextField jTextFetchCount = new JTextField();
    protected JTextField jTextCustomFunctionFile = new JTextField();
    protected List<String> extLibs = new ArrayList<String>();
    protected JLabel labelParallelNum = new JLabel(this.mm.getMessage("dialogoptions.parnum"));
    protected JSpinner jSParallelNum = new JSpinner();
    protected JLabel labelCursorParallelNum = new JLabel(this.mm.getMessage("dialogoptions.curparnum"));
    protected JSpinner jSCursorParallelNum = new JSpinner();

    public PanelEnv(JDialog parent, byte type) {
        super(new GridBagLayout());
        this.parent = parent;
        this.init(type);
    }

    public abstract void selectEnvTab();

    protected boolean isExtLibsEnabled() {
        return true;
    }

    public boolean checkValid() {
        String sFetchCount = this.jTextFetchCount.getText();
        if (StringUtils.isValidString(sFetchCount)) {
            try {
                Integer.parseInt(sFetchCount);
            }
            catch (Exception ex) {
                throw new RQException(this.mm.getMessage("dialogoptions.invalidfetchcount"));
            }
        }
        if (!this.checkFileBuffer()) {
            return false;
        }
        return this.checkBlockSize();
    }

    public void save() {
        ConfigOptions.sLogFileName = this.jTFLogFileName.getText();
        ConfigOptions.sPaths = this.jTFPath.getText();
        ConfigOptions.sMainPath = this.jTFMainPath.getSelectedItem() == null ? null : (String)this.jTFMainPath.getSelectedItem();
        ConfigOptions.sTempPath = this.jTFTempPath.getText();
        ConfigOptions.sExtLibsPath = this.jTFExtLibsPath.getText();
        ConfigOptions.sInitSpl = this.jTFInitSpl.getText();
        ConfigOptions.sDateFormat = this.jCBDate.getSelectedItem() == null ? null : (String)this.jCBDate.getSelectedItem();
        ConfigOptions.sTimeFormat = this.jCBTime.getSelectedItem() == null ? null : (String)this.jCBTime.getSelectedItem();
        ConfigOptions.sDateTimeFormat = this.jCBDateTime.getSelectedItem() == null ? null : (String)this.jCBDateTime.getSelectedItem();
        ConfigOptions.sDefCharsetName = this.jCBCharset.getSelectedItem() == null ? null : (String)this.jCBCharset.getSelectedItem();
        String sFetchCount = this.jTextFetchCount.getText();
        if (StringUtils.isValidString(sFetchCount)) {
            try {
                ConfigOptions.iFetchCount = new Integer(Integer.parseInt(sFetchCount));
            }
            catch (Exception exception) {}
        } else {
            ConfigOptions.iFetchCount = new Integer(ICursor.FETCHCOUNT);
        }
        ConfigOptions.sFileBuffer = this.textFileBuffer.getText();
        ConfigOptions.sBlockSize = this.textBlockSize.getText();
        ConfigOptions.sNullStrings = this.textNullStrings.getText();
        ConfigOptions.sCustomFunctionFile = this.jTextCustomFunctionFile.getText();
        ConfigOptions.iParallelNum = (Integer)this.jSParallelNum.getValue();
        ConfigOptions.iCursorParallelNum = (Integer)this.jSCursorParallelNum.getValue();
        String[] paths = this.getPaths();
        ArrayList<String> pathList = null;
        if (paths != null) {
            pathList = new ArrayList<String>();
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                pathList.add(path);
                ++n2;
            }
        }
        this.config.setSplPathList(pathList);
        this.config.setMainPath(ConfigOptions.sMainPath);
        this.config.setTempPath(ConfigOptions.sTempPath);
        this.config.setParallelNum(ConfigOptions.iParallelNum == null ? null : ConfigOptions.iParallelNum.toString());
        this.config.setCursorParallelNum(ConfigOptions.iCursorParallelNum == null ? null : ConfigOptions.iCursorParallelNum.toString());
        this.config.setDateFormat(ConfigOptions.sDateFormat);
        this.config.setTimeFormat(ConfigOptions.sTimeFormat);
        this.config.setDateTimeFormat(ConfigOptions.sDateTimeFormat);
        this.config.setCharSet(ConfigOptions.sDefCharsetName);
        this.config.setFetchCount(ConfigOptions.iFetchCount == null ? String.valueOf(ICursor.FETCHCOUNT) : ConfigOptions.iFetchCount.toString());
        this.config.setBufSize(ConfigOptions.sFileBuffer);
        this.config.setBlockSize(ConfigOptions.sBlockSize);
        this.config.setNullStrings(ConfigOptions.sNullStrings);
        this.config.setExtLibsPath(ConfigOptions.sExtLibsPath);
        this.config.setInitSpl(ConfigOptions.sInitSpl);
        this.config.setImportLibs(this.extLibs);
        this.config.setCustomFunctionFile(ConfigOptions.sCustomFunctionFile);
    }

    public void load() {
        this.jTFLogFileName.setText(ConfigOptions.sLogFileName);
        this.jTFPath.setText(ConfigOptions.sPaths);
        try {
            List<String> mainPaths = ConfigFile.getConfigFile().getRecentMainPaths("dm");
            String[] paths = null;
            if (mainPaths != null && !mainPaths.isEmpty()) {
                paths = new String[mainPaths.size()];
                int i = 0;
                while (i < mainPaths.size()) {
                    paths[i] = mainPaths.get(i);
                    ++i;
                }
            }
            this.jTFMainPath.setListData(paths);
        }
        catch (Throwable t) {
            Logger.error(t);
        }
        this.jTFMainPath.setSelectedItem(ConfigOptions.sMainPath == null ? "" : ConfigOptions.sMainPath);
        this.jTFTempPath.setText(ConfigOptions.sTempPath);
        this.jTFExtLibsPath.setText(ConfigOptions.sExtLibsPath);
        this.jTFInitSpl.setText(ConfigOptions.sInitSpl);
        this.extLibs = this.config.getImportLibs();
        this.jCBDate.setSelectedItem(ConfigOptions.sDateFormat);
        this.jCBTime.setSelectedItem(ConfigOptions.sTimeFormat);
        this.jCBDateTime.setSelectedItem(ConfigOptions.sDateTimeFormat);
        this.jCBCharset.setSelectedItem(ConfigOptions.sDefCharsetName);
        if (ConfigOptions.iFetchCount != null) {
            this.jTextFetchCount.setText(String.valueOf(ConfigOptions.iFetchCount));
        }
        this.textFileBuffer.setText(ConfigOptions.sFileBuffer);
        this.textBlockSize.setText(ConfigOptions.sBlockSize);
        this.textNullStrings.setText(ConfigOptions.sNullStrings);
        this.jTextCustomFunctionFile.setText(ConfigOptions.sCustomFunctionFile);
        this.jSParallelNum.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        int parallelNum = ConfigOptions.iParallelNum;
        if (parallelNum < 1) {
            parallelNum = 1;
        }
        this.jSParallelNum.setValue(new Integer(parallelNum));
        this.jSCursorParallelNum.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        int cursorParallelNum = ConfigOptions.iCursorParallelNum;
        if (cursorParallelNum < 1) {
            cursorParallelNum = 1;
        }
        this.jSCursorParallelNum.setValue(cursorParallelNum);
    }

    public void setConfig(RaqsoftConfig config) {
        if (config == null) {
            GV.config = config = new RaqsoftConfig();
        }
        this.config = config;
        ConfigUtilIde.setConfigOptions(config);
        this.load();
    }

    public void setEditEnabled(boolean enabled) {
        this.jLabelLog.setEnabled(enabled);
        this.jLabelSplPath.setEnabled(enabled);
        this.labelDate.setEnabled(enabled);
        this.labelTime.setEnabled(enabled);
        this.labelDateTime.setEnabled(enabled);
        this.jLabelCharset.setEnabled(enabled);
        this.jLabelFetchCount.setEnabled(enabled);
        this.labelFileBuffer.setEnabled(enabled);
        this.labelNullStrings.setEnabled(enabled);
        this.labelMainPath.setEnabled(enabled);
        this.labelPathNote.setEnabled(enabled);
        this.labelBlockSize.setEnabled(enabled);
        this.labelTempPath.setEnabled(enabled);
        this.jLInitSpl.setEnabled(enabled);
        this.jLExtLibsPath.setEnabled(enabled);
        this.jCBDate.setEnabled(enabled);
        this.jCBTime.setEnabled(enabled);
        this.jCBDateTime.setEnabled(enabled);
        this.jCBCharset.setEnabled(enabled);
        this.textFileBuffer.setEnabled(enabled);
        this.textNullStrings.setEnabled(enabled);
        this.jTFLogFileName.setEnabled(enabled);
        this.jTFPath.setEnabled(enabled);
        this.jTFMainPath.setEnabled(enabled);
        this.jTFTempPath.setEnabled(enabled);
        this.jTFExtLibsPath.setEnabled(enabled);
        this.jTFInitSpl.setEnabled(enabled);
        this.textBlockSize.setEnabled(enabled);
        this.jTextFetchCount.setEnabled(enabled);
        this.jBLogFile.setEnabled(enabled);
        this.jBPath.setEnabled(enabled);
        this.jBMainPath.setEnabled(enabled);
        this.jBTempPath.setEnabled(enabled);
        this.jBExtLibsPath.setEnabled(enabled);
        this.jBInitSpl.setEnabled(enabled);
        this.jLCustomFunctionFile.setEnabled(enabled);
        this.jTextCustomFunctionFile.setEnabled(enabled);
        this.jBCustomFunctionFile.setEnabled(enabled);
    }

    protected void addOptComponents(JPanel panelOpt) {
    }

    protected void selectExtLibsPath() {
        DialogExtLibs dialog = new DialogExtLibs(this.config, this.parent, this.jTFExtLibsPath.getText(), this.extLibs);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            this.jTFExtLibsPath.setText(dialog.getExtLibsPath());
            this.extLibs = dialog.getExtLibs();
        }
    }

    protected boolean checkFileBuffer() {
        int buffer = ConfigUtil.parseBufferSize(this.textFileBuffer.getText());
        if (buffer == -1) {
            this.selectEnvTab();
            GM.messageDialog(this.parent, this.mm.getMessage("dialogoptions.emptyfilebuffer"));
            this.textFileBuffer.setText(String.valueOf(Env.getFileBufSize()));
            return false;
        }
        if (buffer == -2) {
            this.selectEnvTab();
            GM.messageDialog(this.parent, this.mm.getMessage("dialogoptions.invalidfilebuffer"));
            this.textFileBuffer.setText(String.valueOf(Env.getFileBufSize()));
            return false;
        }
        if (buffer < 4096) {
            this.selectEnvTab();
            GM.messageDialog(this.parent, this.mm.getMessage("dialogoptions.minfilebuffer"));
            this.textFileBuffer.setText("4096");
            return false;
        }
        return true;
    }

    protected boolean checkBlockSize() {
        if (!GMSpl.isBlockSizeEnabled()) {
            return true;
        }
        String sBlockSize = this.textBlockSize.getText();
        int blockSize = ConfigUtil.parseBufferSize(sBlockSize);
        if (blockSize == -1) {
            this.selectEnvTab();
            GM.messageDialog(this.parent, IdeSplMessage.get().getMessage("dialogoptions.emptyblocksize"));
            this.textBlockSize.setText(String.valueOf(Env.getBlockSize()));
            return false;
        }
        if (blockSize == -2) {
            this.selectEnvTab();
            GM.messageDialog(this.parent, IdeSplMessage.get().getMessage("dialogoptions.invalidblocksize"));
            this.textBlockSize.setText(String.valueOf(Env.getBlockSize()));
            return false;
        }
        if (blockSize < 4096) {
            this.selectEnvTab();
            GM.messageDialog(this.parent, IdeSplMessage.get().getMessage("dialogoptions.minblocksize"));
            this.textBlockSize.setText("4096");
            return false;
        }
        if (blockSize % 4096 != 0) {
            int size = blockSize / 4096;
            if (size < 1) {
                size = 1;
            }
            blockSize = (size + 1) * 4096;
            this.selectEnvTab();
            GM.messageDialog(this.parent, IdeSplMessage.get().getMessage("dialogoptions.invalidblocksize"));
            this.textBlockSize.setText(ConfigUtil.getUnitBlockSize(blockSize, sBlockSize));
            return false;
        }
        return true;
    }

    protected String[] getPaths() {
        String[] paths;
        String sPaths = ConfigOptions.sPaths;
        if (StringUtils.isValidString(sPaths) && (paths = sPaths.split(";")) != null) {
            return paths;
        }
        return null;
    }

    protected void setComponentsVisible() {
    }

    protected void init(byte type) {
        this.jBLogFile.setText(this.mm.getMessage("dialogoptions.select"));
        this.jBPath.setText(this.mm.getMessage("dialogoptions.select"));
        this.jBMainPath.setText(this.mm.getMessage("dialogoptions.select"));
        this.jBTempPath.setText(this.mm.getMessage("dialogoptions.edit"));
        this.jBExtLibsPath.setText(this.mm.getMessage("dialogoptions.select"));
        this.jBInitSpl.setText(this.mm.getMessage("dialogoptions.select"));
        this.jBCustomFunctionFile.setText(this.mm.getMessage("dialogoptions.select"));
        this.textNullStrings.setToolTipText(this.mm.getMessage("dialogoptions.nullstringstip"));
        this.jTFPath.setToolTipText(this.mm.getMessage("dialogoptions.pathtip"));
        this.jTFMainPath.setEditable(true);
        this.jTFMainPath.setToolTipText(this.mm.getMessage("dialogoptions.mainpathtip"));
        this.jTFTempPath.setToolTipText(this.mm.getMessage("dialogoptions.temppathtip"));
        this.labelPathNote.setForeground(DialogOptions.NOTE_COLOR);
        this.jLInitSpl.setForeground(Color.BLUE);
        this.jLCustomFunctionFile.setForeground(Color.BLUE);
        this.panelFile = new JPanel(new GridBagLayout());
        if (type == 0) {
            this.panelFile.add((Component)this.jLabelLog, GM.getGBC(1, 1));
            this.panelFile.add((Component)this.jTFLogFileName, GM.getGBC(1, 2, true));
            this.panelFile.add((Component)this.jBLogFile, GM.getGBC(1, 3));
        }
        this.panelFile.add((Component)this.jLabelSplPath, GM.getGBC(2, 1));
        this.panelFile.add((Component)this.jTFPath, GM.getGBC(2, 2, true));
        this.panelFile.add((Component)this.jBPath, GM.getGBC(2, 3));
        this.panelFile.add((Component)this.labelMainPath, GM.getGBC(3, 1));
        this.panelFile.add((Component)this.jTFMainPath, GM.getGBC(3, 2, true));
        this.panelFile.add((Component)this.jBMainPath, GM.getGBC(3, 3));
        GridBagConstraints gbc = GM.getGBC(4, 1, true, false);
        gbc.gridwidth = 3;
        this.panelFile.add((Component)this.labelPathNote, gbc);
        this.panelFile.add((Component)this.labelTempPath, GM.getGBC(5, 1));
        this.panelFile.add((Component)this.jTFTempPath, GM.getGBC(5, 2, true));
        this.panelFile.add((Component)this.jBTempPath, GM.getGBC(5, 3));
        this.panelFile.add((Component)this.jLInitSpl, GM.getGBC(6, 1));
        this.panelFile.add((Component)this.jTFInitSpl, GM.getGBC(6, 2, true));
        this.panelFile.add((Component)this.jBInitSpl, GM.getGBC(6, 3));
        if (this.isExtLibsEnabled()) {
            this.jLExtLibsPath.setForeground(Color.BLUE);
            this.panelFile.add((Component)this.jLExtLibsPath, GM.getGBC(7, 1));
            this.panelFile.add((Component)this.jTFExtLibsPath, GM.getGBC(7, 2, true));
            this.panelFile.add((Component)this.jBExtLibsPath, GM.getGBC(7, 3));
        }
        this.panelFile.add((Component)this.jLCustomFunctionFile, GM.getGBC(8, 1));
        this.panelFile.add((Component)this.jTextCustomFunctionFile, GM.getGBC(8, 2, true));
        this.panelFile.add((Component)this.jBCustomFunctionFile, GM.getGBC(8, 3));
        JPanel panelOpt = new JPanel(new GridBagLayout());
        panelOpt.add((Component)this.labelDate, GM.getGBC(1, 1));
        panelOpt.add((Component)this.jCBDate, GM.getGBC(1, 2, true));
        panelOpt.add((Component)this.labelTime, GM.getGBC(1, 3));
        panelOpt.add((Component)this.jCBTime, GM.getGBC(1, 4, true));
        panelOpt.add((Component)this.labelDateTime, GM.getGBC(2, 1));
        panelOpt.add((Component)this.jCBDateTime, GM.getGBC(2, 2, true));
        panelOpt.add((Component)this.jLabelCharset, GM.getGBC(2, 3));
        panelOpt.add((Component)this.jCBCharset, GM.getGBC(2, 4, true));
        panelOpt.add((Component)this.labelParallelNum, GM.getGBC(3, 1));
        panelOpt.add((Component)this.jSParallelNum, GM.getGBC(3, 2, true));
        panelOpt.add((Component)this.labelCursorParallelNum, GM.getGBC(3, 3));
        panelOpt.add((Component)this.jSCursorParallelNum, GM.getGBC(3, 4, true));
        panelOpt.add((Component)this.labelFileBuffer, GM.getGBC(5, 1));
        panelOpt.add((Component)this.textFileBuffer, GM.getGBC(5, 2, true));
        panelOpt.add((Component)this.labelNullStrings, GM.getGBC(5, 3));
        panelOpt.add((Component)this.textNullStrings, GM.getGBC(5, 4, true));
        panelOpt.add((Component)this.labelBlockSize, GM.getGBC(6, 1));
        panelOpt.add((Component)this.textBlockSize, GM.getGBC(6, 2, true));
        panelOpt.add((Component)this.jLabelFetchCount, GM.getGBC(6, 3));
        panelOpt.add((Component)this.jTextFetchCount, GM.getGBC(6, 4, true));
        this.addOptComponents(panelOpt);
        this.add((Component)this.panelFile, GM.getGBC(1, 1, true));
        this.add((Component)panelOpt, GM.getGBC(2, 1, true, false));
        this.add((Component)new JPanel(), GM.getGBC(3, 1, false, true));
        this.setComponentsVisible();
        this.textNullStrings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    DialogMissingFormat df = new DialogMissingFormat(PanelEnv.this.parent);
                    df.setMissingFormat(PanelEnv.this.textNullStrings.getText());
                    df.setVisible(true);
                    if (df.getOption() == 0) {
                        PanelEnv.this.textNullStrings.setText(df.getMissingFormat());
                    }
                }
            }
        });
        this.jCBDate.setListData(GC.DATE_FORMATS);
        this.jCBTime.setListData(GC.TIME_FORMATS);
        this.jCBDateTime.setListData(GC.DATE_TIME_FORMATS);
        this.jCBDate.setEditable(true);
        this.jCBTime.setEditable(true);
        this.jCBDateTime.setEditable(true);
        Vector<String> codes = new Vector<String>();
        try {
            SortedMap<String, Charset> map = Charset.availableCharsets();
            Iterator<String> it = map.keySet().iterator();
            while (it.hasNext()) {
                codes.add(it.next());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jCBCharset.x_setData(codes, codes);
        this.jCBCharset.setEditable(true);
        this.jBExtLibsPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelEnv.this.selectExtLibsPath();
            }
        });
        this.jBInitSpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = GM.dialogSelectFile(PanelEnv.this.parent, "\"splx,spl,dfx\"");
                if (f != null) {
                    PanelEnv.this.jTFInitSpl.setText(f.getAbsolutePath());
                }
            }
        });
        this.jTFExtLibsPath.setEditable(false);
        this.jTFExtLibsPath.setToolTipText(IdeSplMessage.get().getMessage("dialogoptions.dceditpath"));
        this.jTFExtLibsPath.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    PanelEnv.this.selectExtLibsPath();
                }
            }
        });
        this.jTextFetchCount.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String sFetchCount = PanelEnv.this.jTextFetchCount.getText();
                if (!StringUtils.isValidString(sFetchCount)) {
                    return true;
                }
                try {
                    int fetchCount = Integer.parseInt(sFetchCount);
                    if (fetchCount <= 0) {
                        PanelEnv.this.selectEnvTab();
                        GM.messageDialog(PanelEnv.this.parent, PanelEnv.this.mm.getMessage("dialogoptions.invalidfetchcount"));
                        return false;
                    }
                }
                catch (Exception ex) {
                    PanelEnv.this.selectEnvTab();
                    GM.messageDialog(PanelEnv.this.parent, PanelEnv.this.mm.getMessage("dialogoptions.invalidfetchcount"));
                    return false;
                }
                return true;
            }
        });
        this.textFileBuffer.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return PanelEnv.this.checkFileBuffer();
            }
        });
        this.textBlockSize.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return PanelEnv.this.checkBlockSize();
            }
        });
        this.jBLogFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = GM.dialogSelectFile(PanelEnv.this.parent, "log");
                if (f != null) {
                    PanelEnv.this.jTFLogFileName.setText(f.getAbsolutePath());
                }
            }
        });
        this.jBPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newPath;
                File f;
                String oldDir;
                String string = oldDir = PanelEnv.this.jTFMainPath.getSelectedItem() == null ? null : (String)PanelEnv.this.jTFMainPath.getSelectedItem();
                if (StringUtils.isValidString(oldDir) && (f = new File(oldDir)) != null && f.exists()) {
                    oldDir = f.getParent();
                }
                if (!StringUtils.isValidString(oldDir)) {
                    oldDir = GV.lastDirectory;
                }
                if (StringUtils.isValidString(newPath = GM.dialogSelectDirectory(PanelEnv.this.parent, oldDir))) {
                    String oldPath = PanelEnv.this.jTFPath.getText();
                    if (StringUtils.isValidString(oldPath)) {
                        if (!oldPath.endsWith(";")) {
                            oldPath = String.valueOf(oldPath) + ";";
                        }
                        newPath = String.valueOf(oldPath) + newPath;
                    }
                    PanelEnv.this.jTFPath.setText(newPath);
                }
            }
        });
        this.jBMainPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newPath;
                File f;
                String oldDir;
                String string = oldDir = PanelEnv.this.jTFMainPath.getSelectedItem() == null ? null : (String)PanelEnv.this.jTFMainPath.getSelectedItem();
                if (StringUtils.isValidString(oldDir) && (f = new File(oldDir)) != null && f.exists()) {
                    oldDir = f.getParent();
                }
                if (!StringUtils.isValidString(oldDir)) {
                    oldDir = GV.lastDirectory;
                }
                if ((newPath = GM.dialogSelectDirectory(PanelEnv.this.parent, oldDir)) != null) {
                    PanelEnv.this.jTFMainPath.setSelectedItem(newPath);
                }
            }
        });
        this.jBTempPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogInputText dit = new DialogInputText((Dialog)PanelEnv.this.parent, true);
                dit.setText(PanelEnv.this.jTFTempPath.getText());
                dit.setVisible(true);
                if (dit.getOption() == 0) {
                    PanelEnv.this.jTFTempPath.setText(dit.getText());
                }
            }
        });
        this.jBCustomFunctionFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = GM.dialogSelectFile(PanelEnv.this.parent, "properties");
                if (f != null) {
                    PanelEnv.this.jTextCustomFunctionFile.setText(f.getAbsolutePath());
                }
            }
        });
        this.jSParallelNum.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.jSCursorParallelNum.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
    }
}

