/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.TransferableObject;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.AllPurposeEditor;
import com.scudata.ide.common.swing.AllPurposeRenderer;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.util.Variant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;

public abstract class TableVar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private volatile boolean preventChange = false;
    private ParamList vl;
    private SetParamThread setParamThread = null;
    private final byte COL_INDEX = 0;
    private final byte COL_NAME = 1;
    private final byte COL_VALUE = (byte)2;
    private JTableEx tableVar = new JTableEx(this.mm.getMessage("jtabbedparam.tableconst")){
        private static final long serialVersionUID = 1L;

        @Override
        public void rowfocusChanged(int oldRow, int newRow) {
            if (TableVar.this.preventChange) {
                return;
            }
            if (newRow != -1) {
                TableVar.this.select(this.data.getValueAt(newRow, 2), this.data.getValueAt(newRow, 1) == null ? "" : (String)this.data.getValueAt(newRow, 1));
            }
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (!this.isItemDataChanged(row, col, value)) {
                return;
            }
            super.setValueAt(value, row, col);
            if (TableVar.this.preventChange) {
                return;
            }
            if (TableVar.this.vl != null) {
                Param p = TableVar.this.vl.get(row);
                if (col == 1) {
                    p.setName(value == null ? null : (String)value);
                } else if (value == null) {
                    p.setValue(null);
                } else if (StringUtils.isValidString(value)) {
                    String str = value.toString();
                    Object val = Variant.parse(str);
                    p.setValue(val);
                    TableVar.this.preventChange = true;
                    this.data.setValueAt(val, row, col);
                    TableVar.this.preventChange = false;
                } else {
                    p.setValue(value);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e == null) {
                return;
            }
            Point p = e.getPoint();
            if (p == null) {
                return;
            }
            int row = this.rowAtPoint(p);
            if (row != -1) {
                TableVar.this.select(this.data.getValueAt(row, 2), this.data.getValueAt(row, 1) == null ? "" : (String)this.data.getValueAt(row, 1));
            }
        }

        @Override
        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            if (row != -1) {
                TableVar.this.select(this.data.getValueAt(row, 2), this.data.getValueAt(row, 1) == null ? "" : (String)this.data.getValueAt(row, 1));
            }
        }
    };
    private JLabel jLDispRows1 = new JLabel(IdeSplMessage.get().getMessage("panelvalue.disprows1"));
    private JLabel jLDispRows2 = new JLabel(IdeSplMessage.get().getMessage("tablevar.dispvar"));
    private static final int DEFAULT_ROW_COUNT = 100;
    private JSpinner jSDispRows = new JSpinner(new SpinnerNumberModel(100, 1, Integer.MAX_VALUE, 1));
    private JPanel jPSouth = new JPanel(new GridBagLayout());

    public TableVar() {
        super(new BorderLayout());
        this.setMinimumSize(new Dimension(1, 1));
        this.init();
    }

    public abstract void select(Object var1, String var2);

    public synchronized void setParamList(ParamList pl) {
        this.setParamList(pl, false);
    }

    public synchronized void setParamList(ParamList pl, boolean isRefresh) {
        if (this.setParamThread != null) {
            this.setParamThread.stopThread();
            try {
                this.setParamThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setParamThread = null;
        if (!isRefresh) {
            this.vl = null;
        }
        try {
            this.preventChange = true;
            this.tableVar.acceptText();
            this.tableVar.removeAllRows();
            this.tableVar.clearSelection();
        }
        finally {
            this.preventChange = false;
        }
        if (pl == null) {
            if (this.jPSouth.isVisible()) {
                this.jPSouth.setVisible(false);
            }
            return;
        }
        if (isRefresh) {
            this.vl = pl;
        } else {
            this.vl = new ParamList();
            pl.getAllVarParams(this.vl);
        }
        int dispRows = this.getDispRows();
        if (this.vl.count() > 100) {
            if (!this.jPSouth.isVisible()) {
                this.jPSouth.setVisible(true);
            }
        } else if (this.jPSouth.isVisible()) {
            this.jPSouth.setVisible(false);
        }
        this.setParamThread = new SetParamThread(this.vl, dispRows);
        SwingUtilities.invokeLater(this.setParamThread);
    }

    private void init() {
        JScrollPane jSPTable = new JScrollPane(this.tableVar);
        this.add((Component)jSPTable, "Center");
        this.add((Component)this.jPSouth, "South");
        this.jPSouth.setVisible(false);
        this.jPSouth.add((Component)this.jLDispRows1, GM.getGBC(0, 2, false, false, 2));
        this.jPSouth.add((Component)this.jSDispRows, GM.getGBC(0, 3, false, false, 0));
        this.jPSouth.add((Component)this.jLDispRows2, GM.getGBC(0, 4, false, false, 2));
        this.jPSouth.add((Component)new JPanel(), GM.getGBC(0, 5, true));
        this.jSDispRows.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TableVar.this.setParamList(TableVar.this.vl, true);
            }
        });
        this.tableVar.setIndexCol(0);
        this.tableVar.setRowHeight(20);
        TableColumn tc = this.tableVar.getColumn(2);
        tc.setCellEditor(new AllPurposeEditor(new JTextField(), this.tableVar));
        tc.setCellRenderer(new AllPurposeRenderer());
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    int row = TableVar.this.tableVar.getSelectedRow();
                    if (!StringUtils.isValidString(((TableVar)TableVar.this).tableVar.data.getValueAt(row, 1))) {
                        return;
                    }
                    String name = (String)((TableVar)TableVar.this).tableVar.data.getValueAt(row, 1);
                    String data = null;
                    data = dge.getTriggerEvent().isControlDown() ? name : "=" + name;
                    TransferableObject tf = new TransferableObject(data);
                    if (tf != null) {
                        dge.startDrag(GM.getDndCursor(), tf);
                    }
                }
                catch (Exception x) {
                    GM.showException(GV.appFrame, x);
                }
            }
        };
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(this.tableVar, 1, dgl);
    }

    private int getDispRows() {
        if (!this.jPSouth.isVisible()) {
            return 100;
        }
        int dispRows = ((Number)this.jSDispRows.getValue()).intValue();
        return dispRows;
    }

    class SetParamThread
    extends Thread {
        private ParamList pl;
        private int dispRows;
        volatile boolean isStoped = false;

        public SetParamThread(ParamList pl, int dispRows) {
            this.pl = pl;
            this.dispRows = dispRows;
        }

        @Override
        public void run() {
            try {
                TableVar.this.preventChange = true;
                int count = this.pl.count();
                count = Math.min(count, this.dispRows);
                int i = 0;
                while (i < count) {
                    if (this.isStoped) {
                        break;
                    }
                    Param p = this.pl.get(i);
                    int r = TableVar.this.tableVar.addRow();
                    ((TableVar)TableVar.this).tableVar.data.setValueAt(p.getName(), r, 1);
                    ((TableVar)TableVar.this).tableVar.data.setValueAt(p.getValue(), r, 2);
                    ++i;
                }
            }
            finally {
                TableVar.this.preventChange = false;
            }
        }

        void stopThread() {
            this.isStoped = true;
        }
    }
}

