/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart;

import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.chart.ChartColor;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.DialogInputText;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.JTextAreaEditor;
import com.scudata.ide.spl.chart.ImageEditor;
import com.scudata.ide.spl.chart.ImageRenderer;
import com.scudata.ide.spl.chart.SeriesEditRender;
import com.scudata.ide.spl.chart.SeriesEditor;
import com.scudata.ide.spl.chart.TableInputSeries;
import com.scudata.ide.spl.chart.box.DefaultParamTableRender;
import com.scudata.ide.spl.chart.box.EachRowEditor;
import com.scudata.ide.spl.chart.box.EachRowRenderer;
import com.scudata.ide.spl.resources.ChartMessage;
import com.scudata.util.Variant;
import java.awt.Dialog;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.table.TableColumn;

public class TableParamEdit
extends JTableEx {
    private static final long serialVersionUID = 1L;
    private String FOLDERCOL = " ";
    public String NAMECOL = ChartMessage.get().getMessage("label.propname");
    public String VALUECOL = ChartMessage.get().getMessage("label.propvalue");
    public String EXPCOL = ChartMessage.get().getMessage("label.propexp");
    public String AXISCOL = ChartMessage.get().getMessage("label.axis");
    private String EDITSTYLECOL = "editstyle";
    private String OBJCOL = "objcol";
    private String ARROWCOL = new String(new char[1]);
    public static int iFOLDERCOL = 0;
    public static int iNAMECOL = 1;
    public static int iVALUECOL = 2;
    public static int iEXPCOL = 3;
    public static int iAXISCOL = 4;
    public static int iEDITSTYLECOL = 5;
    public static int iOBJCOL = 6;
    public static int iARROWCOL = 7;
    private int COLCOUNT = 8;
    private HashMap<String, ArrayList<Object[]>> hiddenMap = new HashMap();
    public TableInputSeries seriesTable;
    boolean isAutoHide = false;
    private Dialog owner;

    public TableParamEdit(Dialog owner, ParamInfoList list) {
        this.owner = owner;
        Object[] colNames = new String[]{this.FOLDERCOL, this.NAMECOL, this.VALUECOL, this.EXPCOL, this.AXISCOL, this.EDITSTYLECOL, this.OBJCOL, this.ARROWCOL};
        this.data.setColumnIdentifiers(colNames);
        ArrayList<ParamInfo> root = list.getRootParams();
        int i = 0;
        while (i < root.size()) {
            ParamInfo pi = root.get(i);
            Object[] row = new Object[this.COLCOUNT];
            row[TableParamEdit.iFOLDERCOL] = null;
            row[TableParamEdit.iNAMECOL] = pi.getTitle();
            Object value = pi.getValue();
            if (value instanceof String) {
                if (value.toString().startsWith("=")) {
                    row[TableParamEdit.iEXPCOL] = value.toString().substring(1);
                    row[TableParamEdit.iVALUECOL] = pi.getDefValue();
                } else {
                    row[TableParamEdit.iVALUECOL] = value;
                }
            } else if (value instanceof ArrayList) {
                row[TableParamEdit.iVALUECOL] = this.arrayList2Series((ArrayList)value);
                pi.setValue(row[iVALUECOL]);
            } else {
                row[TableParamEdit.iVALUECOL] = value;
            }
            row[TableParamEdit.iAXISCOL] = pi.getAxis();
            row[TableParamEdit.iEDITSTYLECOL] = new Integer(pi.getInputType());
            row[TableParamEdit.iOBJCOL] = pi;
            this.data.addRow(row);
            ++i;
        }
        ArrayList<String> groups = list.getGroupNames();
        if (groups != null) {
            int i2 = 0;
            while (i2 < groups.size()) {
                String groupName = (String)groups.get(i2);
                Object[] grow = new Object[this.COLCOUNT];
                grow[TableParamEdit.iFOLDERCOL] = i2 == groups.size() - 1 ? new Byte(4) : new Byte(1);
                grow[TableParamEdit.iNAMECOL] = groupName;
                grow[TableParamEdit.iEDITSTYLECOL] = new Integer(1);
                this.data.addRow(grow);
                ArrayList<Object[]> grows = new ArrayList<Object[]>();
                ArrayList<ParamInfo> glist = list.getParams(groupName);
                int j = 0;
                while (j < glist.size()) {
                    ParamInfo pi = glist.get(j);
                    Object[] row = new Object[this.COLCOUNT];
                    row[TableParamEdit.iFOLDERCOL] = j == glist.size() - 1 ? new Byte(5) : new Byte(2);
                    row[TableParamEdit.iNAMECOL] = pi.getTitle();
                    Object value = pi.getValue();
                    if (value instanceof String) {
                        if (value.toString().startsWith("=")) {
                            row[TableParamEdit.iEXPCOL] = value.toString().substring(1);
                            row[TableParamEdit.iVALUECOL] = pi.getDefValue();
                        } else {
                            row[TableParamEdit.iVALUECOL] = value;
                        }
                    } else if (value instanceof ArrayList) {
                        row[TableParamEdit.iVALUECOL] = this.arrayList2Series((ArrayList)value);
                        pi.setValue(row[iVALUECOL]);
                    } else {
                        row[TableParamEdit.iVALUECOL] = value;
                    }
                    row[TableParamEdit.iAXISCOL] = pi.getAxis();
                    row[TableParamEdit.iEDITSTYLECOL] = new Integer(pi.getInputType());
                    row[TableParamEdit.iOBJCOL] = pi;
                    this.data.addRow(row);
                    grows.add(row);
                    ++j;
                }
                this.hiddenMap.put(groupName, grows);
                ++i2;
            }
        }
        this.setRowHeight(25);
        DefaultParamTableRender render = new DefaultParamTableRender();
        TableColumn tc = this.getColumn(iFOLDERCOL);
        tc.setMaxWidth(20);
        tc.setMinWidth(20);
        tc.setCellEditor(new ImageEditor());
        tc.setCellRenderer(new ImageRenderer());
        tc = this.getColumn(iNAMECOL);
        tc.setCellRenderer(render);
        tc.setPreferredWidth(100);
        tc.setMaxWidth(200);
        tc = this.getColumn(iVALUECOL);
        tc.setCellEditor(new EachRowEditor(this, iEDITSTYLECOL, owner));
        tc.setCellRenderer(new EachRowRenderer(iEDITSTYLECOL));
        tc = this.getColumn(iEXPCOL);
        tc.setCellEditor(new JTextAreaEditor(this));
        tc.setCellRenderer(render);
        tc = this.getColumn(iAXISCOL);
        tc.setCellEditor(new JTextAreaEditor(this));
        tc.setCellRenderer(render);
        tc = this.getColumn(iARROWCOL);
        tc.setMaxWidth(25);
        tc.setMinWidth(25);
        tc.setCellEditor(new SeriesEditor(owner));
        tc.setCellRenderer(new SeriesEditRender());
        this.setColumnVisible(this.EDITSTYLECOL, false);
        this.setColumnVisible(this.OBJCOL, false);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (TableParamEdit.this.seriesTable != null) {
                    TableParamEdit.this.seriesTable.updateParams();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    public void autoHide() {
        this.isAutoHide = true;
        this.setColumnVisible(this.EXPCOL, false);
        this.setColumnVisible(this.AXISCOL, false);
        this.setColumnVisible(this.ARROWCOL, false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.getButton() == 1) {
            byte oldType;
            int row = this.getSelectedRow();
            int col = this.getSelectedColumn();
            if (col != iFOLDERCOL) {
                return;
            }
            if (this.data.getValueAt(row, col) == null || !(this.data.getValueAt(row, col) instanceof Byte)) {
                return;
            }
            byte newType = oldType = ((Byte)this.data.getValueAt(row, col)).byteValue();
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            String key = (String)this.data.getValueAt(row, iNAMECOL);
            this.acceptText();
            switch (oldType) {
                case 1: {
                    newType = 0;
                }
                case 4: {
                    newType = 3;
                    while (row + 1 < this.data.getRowCount() && this.data.getValueAt(row + 1, iOBJCOL) != null) {
                        Object[] rowData = new Object[this.data.getColumnCount()];
                        int c = 0;
                        while (c < this.data.getColumnCount()) {
                            rowData[c] = this.data.getValueAt(row + 1, c);
                            ++c;
                        }
                        list.add(rowData);
                        this.data.removeRow(row + 1);
                    }
                    this.hiddenMap.put(key, list);
                    break;
                }
                case 0: {
                    newType = 1;
                }
                case 3: {
                    newType = 4;
                    this.expand(key, row + 1);
                }
            }
            this.data.setValueAt(new Byte(newType), row, col);
            this.acceptText();
        }
    }

    public void expandAll() {
        int rowCount = this.data.getRowCount();
        int r = rowCount - 1;
        while (r >= 0) {
            byte oldType;
            Object obj = this.data.getValueAt(r, iFOLDERCOL);
            if (obj != null && (oldType = ((Byte)obj).byteValue()) == 3) {
                String key = (String)this.data.getValueAt(r, iNAMECOL);
                this.expand(key, r + 1);
                this.data.setValueAt(new Byte(4), r, iFOLDERCOL);
            }
            --r;
        }
        this.acceptText();
    }

    private void collapse(String key, int row) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        while (row + 1 < this.data.getRowCount() && this.data.getValueAt(row + 1, iOBJCOL) != null) {
            Object[] rowData = new Object[this.data.getColumnCount()];
            int c = 0;
            while (c < this.data.getColumnCount()) {
                rowData[c] = this.data.getValueAt(row + 1, c);
                ++c;
            }
            list.add(rowData);
            this.data.removeRow(row + 1);
        }
        this.hiddenMap.put(key, list);
    }

    public void collapseAll() {
        int rowCount = this.data.getRowCount();
        int r = rowCount - 1;
        while (r >= 0) {
            byte oldType;
            Object obj = this.data.getValueAt(r, iFOLDERCOL);
            if (obj != null && ((oldType = ((Byte)obj).byteValue()) == 1 || oldType == 4)) {
                String key = (String)this.data.getValueAt(r, iNAMECOL);
                this.collapse(key, r);
                this.data.setValueAt(new Byte(3), r, iFOLDERCOL);
            }
            --r;
        }
        this.acceptText();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        ParamInfo info = (ParamInfo)this.data.getValueAt(row, iOBJCOL);
        if (info == null) {
            return false;
        }
        if (!this.isAutoHide && column == iAXISCOL && !info.isAxisEnable()) {
            return false;
        }
        return column != iNAMECOL;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        Object oldValue = this.getValueAt(row, column);
        if (oldValue == null) {
            oldValue = "";
        }
        if (column == iEXPCOL && !StringUtils.isValidExpression((String)(aValue = aValue.toString().trim()))) {
            JOptionPane.showMessageDialog(GV.appFrame, ChartMessage.get().getMessage("TableParamEdit.invalidexp", aValue));
            return;
        }
        if (Variant.isEquals(aValue, oldValue)) {
            return;
        }
        super.setValueAt(aValue, row, column);
        ParamInfo info = (ParamInfo)this.data.getValueAt(row, iOBJCOL);
        if (info != null) {
            if (this.isAutoHide) {
                info.setValue(aValue);
                return;
            }
            if (column == iAXISCOL) {
                info.setAxis((String)aValue);
                return;
            }
            if (column == iVALUECOL) {
                super.setValueAt(TableParamEdit.toExpString(info, aValue), row, iEXPCOL);
                super.setValueAt("", row, iAXISCOL);
            } else if (column == iEXPCOL) {
                super.setValueAt(TableParamEdit.toValueObject(info, aValue.toString()), row, iVALUECOL);
                if (aValue.toString().trim().length() == iFOLDERCOL) {
                    aValue = info.getDefValue();
                    super.setValueAt("", row, iAXISCOL);
                } else {
                    aValue = "=" + aValue.toString();
                }
            } else {
                return;
            }
            info.setValue(aValue);
        }
    }

    private void expand(String groupName, int row) {
        ArrayList<Object[]> list = this.hiddenMap.get(groupName);
        int i = 0;
        while (i < list.size()) {
            this.data.insertRow(row + i, list.get(i));
            ++i;
        }
    }

    @Override
    public void acceptText() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    public static String toExpString(ParamInfo info, Object value) {
        int inputType = info.getInputType();
        switch (inputType) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 50: {
                return value == null ? "" : value.toString();
            }
        }
        return "";
    }

    public static Object toValueObject(ParamInfo info, String exp) {
        int inputType = info.getInputType();
        switch (inputType) {
            case 1: {
                return Variant.parse(exp, true);
            }
            case 2: 
            case 13: 
            case 51: {
                return "";
            }
            case 12: {
                Object value1 = PgmNormalCell.parseConstValue(exp);
                if (TableInputSeries.isChartColor(value1)) {
                    return ChartColor.getInstance((Sequence)value1);
                }
                return info.getDefValue();
            }
        }
        Object value = PgmNormalCell.parseConstValue(exp);
        if (TableParamEdit.isRightType(inputType, value)) {
            return value;
        }
        return info.getDefValue();
    }

    public static boolean isRightType(int type, Object value) {
        switch (type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return value instanceof Integer;
            }
            case 25: {
                return value instanceof Double;
            }
            case 1: 
            case 5: 
            case 28: {
                return value instanceof String;
            }
            case 10: {
                return value instanceof Boolean;
            }
            case 12: {
                return TableInputSeries.isChartColor(value);
            }
        }
        return false;
    }

    public void setSeriesTable(TableInputSeries table) {
        this.seriesTable = table;
    }

    private Sequence arrayList2Series(ArrayList<Object> list) {
        Sequence series = new Sequence();
        int i = 0;
        while (i < list.size()) {
            Object o = list.get(i);
            if (o instanceof ArrayList) {
                series.add(this.arrayList2Series((ArrayList)o));
            } else {
                series.add(o);
            }
            ++i;
        }
        return series;
    }

    @Override
    public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
        if (!this.isCellEditable(row, col)) {
            return;
        }
        if (row > -1 && col == iEXPCOL) {
            DialogInputText dit = new DialogInputText(this.owner, true);
            String exp = (String)this.data.getValueAt(row, col);
            dit.setText(exp);
            dit.setVisible(true);
            if (dit.getOption() == 0) {
                this.acceptText();
                this.setValueAt(dit.getText(), row, col);
                this.acceptText();
            }
        }
    }
}

