/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart.auto;

import com.scudata.chart.edit.ElementInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.ide.spl.chart.TableParamEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;

public abstract class PanelParams
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TableParamEdit table;
    ParamInfoList infoList;
    private Dialog owner;

    public void setElementInfo(ElementInfo info) {
        this.init(this.owner, info.getParamInfoList());
    }

    public void setParamInfoList(Dialog owner, ParamInfoList list) {
        this.init(owner, list);
    }

    public PanelParams(Dialog owner) {
        this.owner = owner;
    }

    public abstract void refresh();

    public void expandAll() {
        this.table.expandAll();
    }

    public void collapseAll() {
        this.table.collapseAll();
    }

    private void init(Dialog owner, ParamInfoList list) {
        this.infoList = list;
        this.setLayout(new BorderLayout());
        list.delete("categories");
        list.delete("values");
        this.table = new TableParamEdit(owner, list){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof JTextField) {
                    JTextField tf = (JTextField)e.getSource();
                    String txt = tf.getText();
                    PanelParams.this.table.setValueAt(txt, PanelParams.this.table.getEditingRow(), PanelParams.this.table.getEditingColumn());
                } else if (e.getSource() instanceof JSpinner) {
                    JSpinner sp = (JSpinner)e.getSource();
                    Object obj = sp.getValue();
                    PanelParams.this.table.setValueAt(obj, PanelParams.this.table.getEditingRow(), PanelParams.this.table.getEditingColumn());
                }
            }
        };
        this.table.autoHide();
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    public TableParamEdit getParamTable() {
        return this.table;
    }

    public ParamInfoList getParamInfoList() {
        this.table.acceptText();
        return this.infoList;
    }
}

