/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart.auto;

import com.scudata.ide.common.GM;
import java.awt.Image;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class TypeItem {
    private JLabel label;
    private byte type;

    public TypeItem(String title, byte type) {
        ImageIcon icon;
        String graphIcon = this.getGraphIcon(type);
        InputStream is = this.getClass().getResourceAsStream(graphIcon);
        try {
            byte[] b = GM.inputStream2Bytes(is);
            icon = new ImageIcon(b);
        }
        catch (Exception exc) {
            return;
        }
        Image image = icon.getImage().getScaledInstance(30, 20, 4);
        icon.setImage(image);
        this.label = new JLabel(title, icon, 0);
        this.label.setHorizontalAlignment(2);
        this.type = type;
    }

    public JLabel getItem() {
        return this.label;
    }

    public byte getType() {
        return this.type;
    }

    public String getGraphIcon(byte graphType) {
        String name = "";
        switch (graphType) {
            case 1: {
                name = "area";
                break;
            }
            case 15: {
                name = "area3d";
                break;
            }
            case 2: {
                name = "bar";
                break;
            }
            case 3: {
                name = "bar3d";
                break;
            }
            case 4: {
                name = "bar3dobj";
                break;
            }
            case 5: {
                name = "barstacked";
                break;
            }
            case 6: {
                name = "barstacked3dobj";
                break;
            }
            case 7: {
                name = "col";
                break;
            }
            case 8: {
                name = "col3d";
                break;
            }
            case 9: {
                name = "col3dobj";
                break;
            }
            case 10: {
                name = "colstacked";
                break;
            }
            case 11: {
                name = "colstacked3dobj";
                break;
            }
            case 12: {
                name = "line";
                break;
            }
            case 29: {
                name = "curve";
                break;
            }
            case 16: {
                name = "line3d";
                break;
            }
            case 13: {
                name = "pie";
                break;
            }
            case 17: {
                name = "pie3d";
                break;
            }
            case 14: {
                name = "scatter";
                break;
            }
            case 31: {
                name = "dot3d";
                break;
            }
            case 18: {
                name = "timestate";
                break;
            }
            case 19: {
                name = "timetrend";
                break;
            }
            case 21: {
                name = "2ycolline";
                break;
            }
            case 30: {
                name = "2ycolstackedline";
                break;
            }
            case 20: {
                name = "2y2line";
                break;
            }
            case 22: {
                name = "radar";
                break;
            }
            case 23: {
                name = "gantt";
                break;
            }
            case 24: {
                name = "meter";
                break;
            }
            case 28: {
                name = "meter3d";
                break;
            }
            case 25: {
                name = "milepost";
                break;
            }
            case 26: {
                name = "range";
                break;
            }
            case 27: {
                name = "gongzi";
            }
        }
        return "/com/scudata/ide/spl/chart/image/graph_" + name + ".gif";
    }
}

