/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart.box;

import com.scudata.chart.ChartColor;
import com.scudata.ide.spl.chart.box.ChartColorDialog;
import com.scudata.ide.spl.chart.box.ChartColorIcon;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public class ChartColorEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 6687705686119328614L;
    protected Object editingVal = null;
    private Dialog owner;
    private JButton button = new JButton();
    private ChartColorIcon icon = new ChartColorIcon();

    public ChartColorEditor(Dialog owner) {
        super(new JCheckBox());
        this.owner = owner;
        this.button.setIcon(this.icon);
        this.button.setHorizontalAlignment(0);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartColorEditor.this.clicked();
            }
        });
    }

    protected void clicked() {
        this.icon.setSize(this.button.getWidth(), this.button.getHeight());
        ChartColor cc = (ChartColor)this.editingVal;
        ChartColorDialog dialog = new ChartColorDialog(this.owner);
        dialog.setChartColor(cc);
        Point p = this.button.getLocationOnScreen();
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            this.editingVal = dialog.getChartColor();
            this.icon.setChartColor(dialog.getChartColor());
            this.stopCellEditing();
        }
        dialog.dispose();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value != null && !(value instanceof ChartColor)) {
            value = new ChartColor();
            table.setValueAt(value, row, column);
        }
        this.editingVal = value;
        if (isSelected) {
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setBackground(table.getBackground());
        }
        ChartColor cc = null;
        if (this.editingVal != null) {
            cc = (ChartColor)this.editingVal;
        }
        this.icon.setChartColor(cc);
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editingVal;
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

