/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart.box;

import com.scudata.ide.spl.chart.box.DialogDateChooser;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public class DateEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 485983837004904965L;
    protected Object editingVal = null;
    private Dialog owner;
    private JButton button = new JButton();

    public DateEditor(Dialog owner) {
        super(new JCheckBox());
        this.owner = owner;
        this.button.setHorizontalAlignment(0);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateEditor.this.clicked();
            }
        });
    }

    protected void clicked() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DialogDateChooser dc = new DialogDateChooser(this.owner, true);
        Point p = this.button.getLocationOnScreen();
        dc.setLocation(p.x, p.y + this.button.getHeight());
        Calendar cal = Calendar.getInstance();
        try {
            if (this.editingVal != null && this.editingVal.toString().length() > 0) {
                String ss = this.editingVal.toString();
                if (ss.indexOf(" ") < 0) {
                    ss = String.valueOf(ss) + " 00:00:00";
                }
                cal.setTime(formatter.parse(ss));
            }
            dc.initDate(cal);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dc.setVisible(true);
        cal = dc.getSelectedDate();
        if (cal != null) {
            this.editingVal = formatter.format(cal.getTime());
            this.button.setText(this.editingVal.toString());
            this.stopCellEditing();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editingVal = value;
        if (isSelected) {
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setBackground(table.getBackground());
        }
        if (value == null) {
            this.button.setText("");
        } else {
            this.button.setText(value.toString());
        }
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editingVal;
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

